/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.knn;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 \u000b2\u00020\u0001:\u0003\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u00a6\u0002J\b\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "", "<init>", "()V", "equals", "", "obj", "hashCode", "", "Hnsw", "Seeded", "Companion", "core"})
public abstract class KnnSearchStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DEFAULT_FILTERED_SEARCH_THRESHOLD = 60;

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy$Companion;", "", "<init>", "()V", "DEFAULT_FILTERED_SEARCH_THRESHOLD", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0013\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy$Hnsw;", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "filteredSearchThreshold", "", "<init>", "(I)V", "useFilteredSearch", "", "ratioPassingFilter", "", "equals", "o", "", "hashCode", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nKnnSearchStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KnnSearchStrategy.kt\norg/gnit/lucenekmp/search/knn/KnnSearchStrategy$Hnsw\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
    public static final class Hnsw
    extends KnnSearchStrategy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int filteredSearchThreshold;
        @NotNull
        private static final Hnsw DEFAULT = new Hnsw(60);

        public Hnsw(int filteredSearchThreshold) {
            if (!(filteredSearchThreshold >= 0 && filteredSearchThreshold <= 100)) {
                boolean bl = false;
                String string = "filteredSearchThreshold must be >= 0 and <= 100";
                throw new IllegalArgumentException(string.toString());
            }
            this.filteredSearchThreshold = filteredSearchThreshold;
        }

        public final int filteredSearchThreshold() {
            return this.filteredSearchThreshold;
        }

        public final boolean useFilteredSearch(float ratioPassingFilter) {
            if (!(ratioPassingFilter >= 0.0f && ratioPassingFilter <= 1.0f)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return ratioPassingFilter * (float)100 < (float)this.filteredSearchThreshold;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hnsw hnsw = (Hnsw)o;
            return this.filteredSearchThreshold == hnsw.filteredSearchThreshold;
        }

        @Override
        public int hashCode() {
            return Objects.INSTANCE.hashCode(this.filteredSearchThreshold);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy$Hnsw$Companion;", "", "<init>", "()V", "DEFAULT", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy$Hnsw;", "getDEFAULT", "()Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy$Hnsw;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Hnsw getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy$Seeded;", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "entryPoints", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "numberOfEntryPoints", "", "originalStrategy", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;ILorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;)V", "equals", "", "o", "", "hashCode", "core"})
    @SourceDebugExtension(value={"SMAP\nKnnSearchStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KnnSearchStrategy.kt\norg/gnit/lucenekmp/search/knn/KnnSearchStrategy$Seeded\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
    public static final class Seeded
    extends KnnSearchStrategy {
        @NotNull
        private final DocIdSetIterator entryPoints;
        private final int numberOfEntryPoints;
        @NotNull
        private final KnnSearchStrategy originalStrategy;

        public Seeded(@Nullable DocIdSetIterator entryPoints, int numberOfEntryPoints, @NotNull KnnSearchStrategy originalStrategy) {
            Intrinsics.checkNotNullParameter((Object)originalStrategy, (String)"originalStrategy");
            if (!(numberOfEntryPoints >= 0)) {
                boolean $i$a$-require-KnnSearchStrategy$Seeded$32 = false;
                String $i$a$-require-KnnSearchStrategy$Seeded$32 = "numberOfEntryPoints must be >= 0";
                throw new IllegalArgumentException($i$a$-require-KnnSearchStrategy$Seeded$32.toString());
            }
            this.numberOfEntryPoints = numberOfEntryPoints;
            if (!(numberOfEntryPoints <= 0 || entryPoints != null)) {
                boolean bl = false;
                String string = "entryPoints must not be null";
                throw new IllegalArgumentException(string.toString());
            }
            DocIdSetIterator docIdSetIterator = entryPoints;
            if (docIdSetIterator == null) {
                docIdSetIterator = DocIdSetIterator.Companion.empty();
            }
            this.entryPoints = docIdSetIterator;
            this.originalStrategy = originalStrategy;
        }

        @NotNull
        public final DocIdSetIterator entryPoints() {
            return this.entryPoints;
        }

        public final int numberOfEntryPoints() {
            return this.numberOfEntryPoints;
        }

        @NotNull
        public final KnnSearchStrategy originalStrategy() {
            return this.originalStrategy;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Seeded seeded = (Seeded)o;
            return this.numberOfEntryPoints == seeded.numberOfEntryPoints && Intrinsics.areEqual((Object)this.entryPoints, (Object)seeded.entryPoints) && Intrinsics.areEqual((Object)this.originalStrategy, (Object)seeded.originalStrategy);
        }

        @Override
        public int hashCode() {
            Object[] objectArray = new Object[]{this.entryPoints, this.numberOfEntryPoints, this.originalStrategy};
            return Objects.INSTANCE.hash(objectArray);
        }
    }
}

