/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.similarities;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.search.CollectionStatistics;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.TermStatistics;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.SmallFloat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002 !B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0004J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J#\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0018\u00a2\u0006\u0002\u0010\u0019J1\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0018\"\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/search/similarities/BM25Similarity;", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "k1", "", "b", "discountOverlaps", "", "<init>", "(FFZ)V", "(Z)V", "getK1", "()F", "getB", "idf", "docFreq", "", "docCount", "avgFieldLength", "collectionStats", "Lorg/gnit/lucenekmp/search/CollectionStatistics;", "idfExplain", "Lorg/gnit/lucenekmp/search/Explanation;", "termStats", "Lorg/gnit/lucenekmp/search/TermStatistics;", "", "(Lorg/gnit/lucenekmp/search/CollectionStatistics;[Lorg/gnit/lucenekmp/search/TermStatistics;)Lorg/gnit/lucenekmp/search/Explanation;", "scorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "boost", "(FLorg/gnit/lucenekmp/search/CollectionStatistics;[Lorg/gnit/lucenekmp/search/TermStatistics;)Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "toString", "", "BM25Scorer", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBM25Similarity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BM25Similarity.kt\norg/gnit/lucenekmp/search/similarities/BM25Similarity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
public final class BM25Similarity
extends Similarity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float k1;
    private final float b;
    @NotNull
    private static final float[] LENGTH_TABLE = new float[256];

    public BM25Similarity(float k1, float b, boolean discountOverlaps) {
        super(discountOverlaps);
        if (!(FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, k1) && !(k1 < 0.0f))) {
            boolean $i$a$-require-BM25Similarity$32 = false;
            String $i$a$-require-BM25Similarity$32 = "illegal k1 value: " + k1 + ", must be a non-negative finite value";
            throw new IllegalArgumentException($i$a$-require-BM25Similarity$32.toString());
        }
        if (!(!FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, b) && !(b < 0.0f) && !(b > 1.0f))) {
            boolean bl = false;
            String string = "illegal b value: " + b + ", must be between 0 and 1";
            throw new IllegalArgumentException(string.toString());
        }
        this.k1 = k1;
        this.b = b;
    }

    public /* synthetic */ BM25Similarity(float f, float f2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.2f;
        }
        if ((n & 2) != 0) {
            f2 = 0.75f;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(f, f2, bl);
    }

    public final float getK1() {
        return this.k1;
    }

    public final float getB() {
        return this.b;
    }

    public BM25Similarity(boolean discountOverlaps) {
        this(1.2f, 0.75f, discountOverlaps);
    }

    protected final float idf(long docFreq, long docCount) {
        return (float)Math.log(1.0 + ((double)(docCount - docFreq) + 0.5) / ((double)docFreq + 0.5));
    }

    protected final float avgFieldLength(@NotNull CollectionStatistics collectionStats) {
        Intrinsics.checkNotNullParameter((Object)collectionStats, (String)"collectionStats");
        return (float)((double)collectionStats.getSumTotalTermFreq() / (double)collectionStats.getDocCount());
    }

    @NotNull
    public final Explanation idfExplain(@NotNull CollectionStatistics collectionStats, @NotNull TermStatistics termStats) {
        Intrinsics.checkNotNullParameter((Object)collectionStats, (String)"collectionStats");
        Intrinsics.checkNotNullParameter((Object)termStats, (String)"termStats");
        long df = termStats.getDocFreq();
        long docCount = collectionStats.getDocCount();
        float idf = this.idf(df, docCount);
        Explanation[] explanationArray = new Explanation[]{Explanation.Companion.match((Number)df, "n, number of documents containing term", new Explanation[0]), Explanation.Companion.match((Number)docCount, "N, total number of documents with field", new Explanation[0])};
        return Explanation.Companion.match((Number)Float.valueOf(idf), "idf, computed as log(1 + (N - n + 0.5) / (n + 0.5)) from:", explanationArray);
    }

    @NotNull
    public final Explanation idfExplain(@NotNull CollectionStatistics collectionStats, @NotNull TermStatistics[] termStats) {
        Intrinsics.checkNotNullParameter((Object)collectionStats, (String)"collectionStats");
        Intrinsics.checkNotNullParameter((Object)termStats, (String)"termStats");
        double idf = 0.0;
        List details = new ArrayList();
        for (TermStatistics stat : termStats) {
            Explanation idfExplain = this.idfExplain(collectionStats, stat);
            details.add(idfExplain);
            idf += (double)idfExplain.getValue().floatValue();
        }
        return Explanation.Companion.match((Number)Float.valueOf((float)idf), "idf, sum of:", details);
    }

    @Override
    @NotNull
    public Similarity.SimScorer scorer(float boost, @NotNull CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Intrinsics.checkNotNullParameter((Object)collectionStats, (String)"collectionStats");
        Intrinsics.checkNotNullParameter((Object)termStats, (String)"termStats");
        Explanation idf = termStats.length == 1 ? this.idfExplain(collectionStats, termStats[0]) : this.idfExplain(collectionStats, termStats);
        float avgdl = this.avgFieldLength(collectionStats);
        float[] cache = new float[256];
        int n = cache.length;
        for (int i = 0; i < n; ++i) {
            cache[i] = 1.0f / (this.k1 * (1.0f - this.b + this.b * LENGTH_TABLE[i] / avgdl));
        }
        return new BM25Scorer(boost, this.k1, this.b, idf, avgdl, cache);
    }

    @NotNull
    public String toString() {
        return "BM25(k1=" + this.k1 + ",b=" + this.b + ")";
    }

    public BM25Similarity() {
        this(0.0f, 0.0f, false, 7, null);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            BM25Similarity.LENGTH_TABLE[i] = SmallFloat.INSTANCE.byte4ToInt((byte)i);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/search/similarities/BM25Similarity$BM25Scorer;", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "boost", "", "k1", "b", "idf", "Lorg/gnit/lucenekmp/search/Explanation;", "avgdl", "cache", "", "<init>", "(FFFLorg/gnit/lucenekmp/search/Explanation;F[F)V", "weight", "score", "freq", "norm", "", "explain", "explainTF", "explainConstantFactors", "", "core"})
    private static final class BM25Scorer
    extends Similarity.SimScorer {
        private final float boost;
        private final float k1;
        private final float b;
        @NotNull
        private final Explanation idf;
        private final float avgdl;
        @NotNull
        private final float[] cache;
        private final float weight;

        public BM25Scorer(float boost, float k1, float b, @NotNull Explanation idf, float avgdl, @NotNull float[] cache) {
            Intrinsics.checkNotNullParameter((Object)idf, (String)"idf");
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            this.boost = boost;
            this.k1 = k1;
            this.b = b;
            this.idf = idf;
            this.avgdl = avgdl;
            this.cache = cache;
            this.weight = this.boost * this.idf.getValue().floatValue();
        }

        @Override
        public float score(float freq, long norm) {
            float normInverse = this.cache[(byte)norm & 0xFF];
            return this.weight - this.weight / (1.0f + freq * normInverse);
        }

        @Override
        @NotNull
        public Explanation explain(@NotNull Explanation freq, long norm) {
            Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
            List subs = new ArrayList(this.explainConstantFactors());
            Explanation tfExpl = this.explainTF(freq, norm);
            subs.add(tfExpl);
            float normInverse = this.cache[(byte)norm & 0xFF];
            return Explanation.Companion.match((Number)Float.valueOf(this.weight - this.weight / (1.0f + freq.getValue().floatValue() * normInverse)), "score(freq=" + freq.getValue() + "), computed as boost * idf * tf from:", subs);
        }

        @NotNull
        public final Explanation explainTF(@NotNull Explanation freq, long norm) {
            Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
            List subs = new ArrayList();
            subs.add(freq);
            subs.add(Explanation.Companion.match((Number)Float.valueOf(this.k1), "k1, term saturation parameter", new Explanation[0]));
            float doclen = LENGTH_TABLE[(byte)norm & 0xFF];
            subs.add(Explanation.Companion.match((Number)Float.valueOf(this.b), "b, length normalization parameter", new Explanation[0]));
            boolean bl = (norm & 0xFFL) > 39L ? subs.add(Explanation.Companion.match((Number)Float.valueOf(doclen), "dl, length of field (approximate)", new Explanation[0])) : subs.add(Explanation.Companion.match((Number)Float.valueOf(doclen), "dl, length of field", new Explanation[0]));
            subs.add(Explanation.Companion.match((Number)Float.valueOf(this.avgdl), "avgdl, average length of field", new Explanation[0]));
            float normInverse = 1.0f / (this.k1 * (1.0f - this.b + this.b * doclen / this.avgdl));
            return Explanation.Companion.match((Number)Float.valueOf(1.0f - 1.0f / (1.0f + freq.getValue().floatValue() * normInverse)), "tf, computed as freq / (freq + k1 * (1 - b + b * dl / avgdl)) from:", subs);
        }

        @NotNull
        public final List<Explanation> explainConstantFactors() {
            List subs = new ArrayList();
            if (!(this.boost == 1.0f)) {
                subs.add(Explanation.Companion.match((Number)Float.valueOf(this.boost), "boost", new Explanation[0]));
            }
            subs.add(this.idf);
            return subs;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/similarities/BM25Similarity$Companion;", "", "<init>", "()V", "LENGTH_TABLE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

