/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.jdkport.Checksum;
import org.gnit.lucenekmp.jdkport.LongBuffer;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/store/BufferedChecksum;", "Lorg/gnit/lucenekmp/jdkport/Checksum;", "in", "bufferSize", "", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Checksum;I)V", "buffer", "", "upto", "update", "", "b", "off", "len", "updateShort", "value", "", "updateInt", "updateLong", "", "updateLongs", "vals", "", "offset", "getValue", "reset", "flush", "Companion", "core"})
public final class BufferedChecksum
implements Checksum {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Checksum in;
    @NotNull
    private final byte[] buffer;
    private int upto;
    public static final int DEFAULT_BUFFERSIZE = 1024;

    @JvmOverloads
    public BufferedChecksum(@NotNull Checksum in, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.in = in;
        this.buffer = new byte[bufferSize];
    }

    public /* synthetic */ BufferedChecksum(Checksum checksum, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1024;
        }
        this(checksum, n);
    }

    @Override
    public void update(int b) {
        if (this.upto == this.buffer.length) {
            this.flush();
        }
        int n = this.upto;
        this.upto = n + 1;
        this.buffer[n] = (byte)b;
    }

    @Override
    public void update(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (len >= this.buffer.length) {
            this.flush();
            this.in.update(b, off, len);
        } else {
            if (this.upto + len > this.buffer.length) {
                this.flush();
            }
            ArraysKt.copyInto((byte[])b, (byte[])this.buffer, (int)this.upto, (int)off, (int)(off + len));
            this.upto += len;
        }
    }

    public final void updateShort(short value) {
        if (this.upto + 2 > this.buffer.length) {
            this.flush();
        }
        BitUtilKt.putShortLE(this.buffer, this.upto, value);
        this.upto += 2;
    }

    public final void updateInt(int value) {
        if (this.upto + 4 > this.buffer.length) {
            this.flush();
        }
        BitUtilKt.putIntLE(this.buffer, this.upto, value);
        this.upto += 4;
    }

    public final void updateLong(long value) {
        if (this.upto + 8 > this.buffer.length) {
            this.flush();
        }
        BitUtilKt.putLongLE(this.buffer, this.upto, value);
        this.upto += 8;
    }

    public final void updateLongs(@NotNull long[] vals, int offset, int len) {
        int capacityInLong;
        int remaining;
        Intrinsics.checkNotNullParameter((Object)vals, (String)"vals");
        int off = offset;
        if (this.upto > 0) {
            for (remaining = len; remaining > 0; --remaining) {
                this.updateLong(vals[off]);
                ++off;
                if (this.upto != 0) continue;
            }
            if (remaining == 0) {
                return;
            }
        }
        if ((capacityInLong = this.buffer.length / 8) > 0) {
            LongBuffer longBuffer = ByteBuffer.Companion.wrap$default(ByteBuffer.Companion, this.buffer, 0, 0, 6, null).order(ByteOrder.Companion.getLITTLE_ENDIAN()).asLongBuffer();
            while (remaining >= capacityInLong) {
                longBuffer.position(0);
                for (int i = 0; i < capacityInLong; ++i) {
                    longBuffer.put(vals[off + i]);
                }
                this.in.update(this.buffer, 0, capacityInLong * 8);
                off += capacityInLong;
                remaining -= capacityInLong;
            }
        }
        int n = remaining;
        for (int i = 0; i < n; ++i) {
            this.updateLong(vals[off + i]);
        }
    }

    @Override
    public long getValue() {
        this.flush();
        return this.in.getValue();
    }

    @Override
    public void reset() {
        this.upto = 0;
        this.in.reset();
    }

    private final void flush() {
        if (this.upto > 0) {
            this.in.update(this.buffer, 0, this.upto);
        }
        this.upto = 0;
    }

    @Override
    public void update(@NotNull byte[] b) {
        Checksum.super.update(b);
    }

    @Override
    public void update(@NotNull Buffer buffer) {
        Checksum.super.update(buffer);
    }

    @Override
    public void update(@NotNull ByteBuffer byteBuffer) {
        Checksum.super.update(byteBuffer);
    }

    @JvmOverloads
    public BufferedChecksum(@NotNull Checksum in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this(in, 0, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/store/BufferedChecksum$Companion;", "", "<init>", "()V", "DEFAULT_BUFFERSIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

