/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.CRC32;
import org.gnit.lucenekmp.store.BufferedChecksum;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020\u0003H\u0016J \u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u001e\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010 \u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/store/BufferedChecksumIndexInput;", "Lorg/gnit/lucenekmp/store/ChecksumIndexInput;", "main", "Lorg/gnit/lucenekmp/store/IndexInput;", "<init>", "(Lorg/gnit/lucenekmp/store/IndexInput;)V", "getMain", "()Lorg/gnit/lucenekmp/store/IndexInput;", "digest", "Lorg/gnit/lucenekmp/store/BufferedChecksum;", "getDigest", "()Lorg/gnit/lucenekmp/store/BufferedChecksum;", "readByte", "", "readBytes", "", "b", "", "offset", "", "len", "readShort", "", "readInt", "readLong", "", "readLongs", "dst", "", "length", "checksum", "getChecksum", "()J", "close", "filePointer", "getFilePointer", "clone", "slice", "sliceDescription", "", "core"})
public final class BufferedChecksumIndexInput
extends ChecksumIndexInput {
    @NotNull
    private final IndexInput main;
    @NotNull
    private final BufferedChecksum digest;

    public BufferedChecksumIndexInput(@NotNull IndexInput main) {
        Intrinsics.checkNotNullParameter((Object)main, (String)"main");
        super("BufferedChecksumIndexInput(" + main + ")");
        this.main = main;
        this.digest = new BufferedChecksum(new CRC32(), 0, 2, null);
    }

    @NotNull
    public final IndexInput getMain() {
        return this.main;
    }

    @NotNull
    public final BufferedChecksum getDigest() {
        return this.digest;
    }

    @Override
    public byte readByte() throws IOException {
        byte b = this.main.readByte();
        this.digest.update(b);
        return b;
    }

    @Override
    public void readBytes(@NotNull byte[] b, int offset, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.main.readBytes(b, offset, len);
        this.digest.update(b, offset, len);
    }

    @Override
    public short readShort() throws IOException {
        short v = this.main.readShort();
        this.digest.updateShort(v);
        return v;
    }

    @Override
    public int readInt() throws IOException {
        int v = this.main.readInt();
        this.digest.updateInt(v);
        return v;
    }

    @Override
    public long readLong() throws IOException {
        long v = this.main.readLong();
        this.digest.updateLong(v);
        return v;
    }

    @Override
    public void readLongs(@NotNull long[] dst, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        this.main.readLongs(dst, offset, length);
        this.digest.updateLongs(dst, offset, length);
    }

    @Override
    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public void close() throws IOException {
        this.main.close();
    }

    @Override
    public long getFilePointer() {
        return this.main.getFilePointer();
    }

    @Override
    public long length() {
        return this.main.length();
    }

    @Override
    @NotNull
    public IndexInput clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public IndexInput slice(@NotNull String sliceDescription, long offset, long length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
        throw new UnsupportedOperationException();
    }
}

