/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.util.GroupVIntUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0014\b&\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u00029:B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J(\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010#\u001a\u00020\u0011H\u0016J \u0010$\u001a\u00020\u00152\u0006\u0010!\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J \u0010&\u001a\u00020\u00152\u0006\u0010!\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J \u0010(\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0011H\u0016J(\u0010\u0016\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0011H\u0016J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0011H\u0016J\b\u0010-\u001a\u00020\u0015H\u0002J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH$J\u0010\u00102\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0011H\u0016J\u0010\u00103\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0011H$J\b\u00104\u001a\u00020\u0000H\u0016J \u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u0011H\u0016J\u0018\u00108\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006;"}, d2={"Lorg/gnit/lucenekmp/store/BufferedIndexInput;", "Lorg/gnit/lucenekmp/store/IndexInput;", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "resourceDesc", "", "bufferSize", "", "<init>", "(Ljava/lang/String;I)V", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/store/IOContext;)V", "getBufferSize", "()I", "buffer", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "bufferStart", "", "readByte", "", "checkBufferSize", "", "readBytes", "b", "", "offset", "len", "useBuffer", "", "readShort", "", "readInt", "readGroupVInt", "dst", "", "readLong", "readFloats", "", "readLongs", "", "readInts", "resolvePositionInBuffer", "pos", "width", "bytes", "refill", "readInternal", "filePointer", "getFilePointer", "()J", "seek", "seekInternal", "clone", "slice", "sliceDescription", "length", "prefetch", "SlicedIndexInput", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBufferedIndexInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedIndexInput.kt\norg/gnit/lucenekmp/store/BufferedIndexInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,428:1\n1#2:429\n8#3,2:430\n8#3,2:432\n3#3,8:434\n10#4:442\n*S KotlinDebug\n*F\n+ 1 BufferedIndexInput.kt\norg/gnit/lucenekmp/store/BufferedIndexInput\n*L\n278#1:430,2\n279#1:432,2\n280#1:434,8\n280#1:442\n*E\n"})
public abstract class BufferedIndexInput
extends IndexInput
implements RandomAccessInput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int bufferSize;
    @NotNull
    private ByteBuffer buffer;
    private long bufferStart;
    @NotNull
    private static final ByteBuffer EMPTY_BYTEBUFFER = ByteBuffer.Companion.allocate(0).order(ByteOrder.Companion.getLITTLE_ENDIAN());
    public static final int BUFFER_SIZE = 1024;
    public static final int MIN_BUFFER_SIZE = 8;
    public static final int MERGE_BUFFER_SIZE = 4096;

    public BufferedIndexInput(@NotNull String resourceDesc, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)resourceDesc, (String)"resourceDesc");
        super(resourceDesc);
        this.buffer = EMPTY_BYTEBUFFER;
        this.checkBufferSize(bufferSize);
        this.bufferSize = bufferSize;
    }

    public /* synthetic */ BufferedIndexInput(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1024;
        }
        this(string, n);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public byte readByte() {
        if (!this.buffer.hasRemaining()) {
            this.refill();
        }
        return this.buffer.get();
    }

    public BufferedIndexInput(@NotNull String resourceDesc, @NotNull IOContext context) {
        Intrinsics.checkNotNullParameter((Object)resourceDesc, (String)"resourceDesc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(resourceDesc, Companion.bufferSize(context));
    }

    private final void checkBufferSize(int bufferSize) {
        if (!(bufferSize >= 8)) {
            boolean bl = false;
            String string = "bufferSize must be at least MIN_BUFFER_SIZE (got " + bufferSize + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void readBytes(@NotNull byte[] b, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.readBytes(b, offset, len, true);
    }

    @Override
    public void readBytes(@NotNull byte[] b, int offset, int len, boolean useBuffer) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int offset2 = offset;
        int len2 = len;
        int available = this.buffer.remaining();
        if (len2 <= available) {
            if (len2 > 0) {
                this.buffer.get(b, offset2, len2);
            }
            v0 = Unit.INSTANCE;
        } else {
            if (available > 0) {
                this.buffer.get(b, offset2, available);
                offset2 += available;
                len2 -= available;
            }
            if (useBuffer && len2 < this.bufferSize) {
                this.refill();
                if (this.buffer.remaining() < len2) {
                    this.buffer.get(b, offset2, this.buffer.remaining());
                    throw new EOFException("read past EOF: " + this);
                }
                v0 = this.buffer.get(b, offset2, len2);
            } else {
                long after = this.bufferStart + (long)this.buffer.getPosition() + (long)len2;
                if (after > this.length()) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.readInternal(ByteBuffer.Companion.wrap(b, offset2, len2));
                this.bufferStart = after;
                v0 = this.buffer.limit(0);
            }
        }
    }

    @Override
    public short readShort() {
        if (2 <= this.buffer.remaining()) {
            return this.buffer.getShort();
        }
        return super.readShort();
    }

    @Override
    public int readInt() {
        if (4 <= this.buffer.remaining()) {
            return this.buffer.getInt();
        }
        return super.readInt();
    }

    @Override
    public void readGroupVInt(@NotNull int[] dst, int offset) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int len = GroupVIntUtil.INSTANCE.readGroupVInt((DataInput)this, (long)this.buffer.remaining(), arg_0 -> BufferedIndexInput.readGroupVInt$lambda$1(this, arg_0), (long)this.buffer.getPosition(), dst, offset);
        if (len > 0) {
            this.buffer.position(this.buffer.getPosition() + len);
        }
    }

    @Override
    public long readLong() {
        if (8 <= this.buffer.remaining()) {
            return this.buffer.getLong();
        }
        return super.readLong();
    }

    @Override
    public void readFloats(@NotNull float[] dst, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int remainingDst = len;
        while (remainingDst > 0) {
            int cnt = Math.min(this.buffer.remaining() / 4, remainingDst);
            this.buffer.asFloatBuffer().get(dst, offset + len - remainingDst, cnt);
            this.buffer.position(this.buffer.getPosition() + 4 * cnt);
            if ((remainingDst -= cnt) <= 0) continue;
            if (this.buffer.hasRemaining()) {
                dst[offset + len - remainingDst] = FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, this.readInt());
                --remainingDst;
                continue;
            }
            this.refill();
        }
    }

    @Override
    public void readLongs(@NotNull long[] dst, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int remainingDst = len;
        while (remainingDst > 0) {
            int cnt = Math.min(this.buffer.remaining() / 8, remainingDst);
            this.buffer.asLongBuffer().get(dst, offset + len - remainingDst, cnt);
            this.buffer.position(this.buffer.getPosition() + 8 * cnt);
            if ((remainingDst -= cnt) <= 0) continue;
            if (this.buffer.hasRemaining()) {
                dst[offset + len - remainingDst] = this.readLong();
                --remainingDst;
                continue;
            }
            this.refill();
        }
    }

    @Override
    public void readInts(@NotNull int[] dst, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int remainingDst = len;
        while (remainingDst > 0) {
            int cnt = Math.min(this.buffer.remaining() / 4, remainingDst);
            this.buffer.asIntBuffer().get(dst, offset + len - remainingDst, cnt);
            this.buffer.position(this.buffer.getPosition() + 4 * cnt);
            if ((remainingDst -= cnt) <= 0) continue;
            if (this.buffer.hasRemaining()) {
                dst[offset + len - remainingDst] = this.readInt();
                --remainingDst;
                continue;
            }
            this.refill();
        }
    }

    private final long resolvePositionInBuffer(long pos, int width) throws IOException {
        long index = pos - this.bufferStart;
        if (index >= 0L && index <= (long)(this.buffer.getLimit() - width)) {
            return index;
        }
        if (index < 0L) {
            this.bufferStart = Math.max(this.bufferStart - (long)this.bufferSize, pos + (long)width - (long)this.bufferSize);
            this.bufferStart = Math.max(this.bufferStart, 0L);
            this.bufferStart = Math.min(this.bufferStart, pos);
        } else {
            this.bufferStart = pos;
        }
        this.buffer.limit(0);
        this.seekInternal(this.bufferStart);
        this.refill();
        return pos - this.bufferStart;
    }

    @Override
    public byte readByte(long pos) {
        long index = this.resolvePositionInBuffer(pos, 1);
        return this.buffer.get((int)index);
    }

    @Override
    public void readBytes(long pos, @NotNull byte[] bytes, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        long pos2 = pos;
        int offset2 = offset;
        int len2 = len;
        if (len2 <= this.bufferSize) {
            if (len2 > 0) {
                long index = this.resolvePositionInBuffer(pos2, len2);
                this.buffer.get((int)index, bytes, offset2, len2);
            }
        } else {
            long index;
            while (len2 > this.bufferSize) {
                index = this.resolvePositionInBuffer(pos2, this.bufferSize);
                this.buffer.get((int)index, bytes, offset2, this.bufferSize);
                len2 -= this.bufferSize;
                offset2 += this.bufferSize;
                pos2 += (long)this.bufferSize;
            }
            index = this.resolvePositionInBuffer(pos2, len2);
            this.buffer.get((int)index, bytes, offset2, len2);
        }
    }

    @Override
    public short readShort(long pos) {
        long index = this.resolvePositionInBuffer(pos, 2);
        return this.buffer.getShort((int)index);
    }

    @Override
    public int readInt(long pos) {
        long index = this.resolvePositionInBuffer(pos, 4);
        return this.buffer.getInt((int)index);
    }

    @Override
    public long readLong(long pos) {
        long index = this.resolvePositionInBuffer(pos, 8);
        return this.buffer.getLong((int)index);
    }

    private final void refill() throws IOException {
        int newLength;
        long start = this.bufferStart + (long)this.buffer.getPosition();
        long end = start + (long)this.bufferSize;
        if (end > this.length()) {
            end = this.length();
        }
        if ((newLength = (int)(end - start)) <= 0) {
            throw new EOFException("read past EOF: " + this);
        }
        if (this.buffer == EMPTY_BYTEBUFFER) {
            this.buffer = ByteBuffer.Companion.allocate(this.bufferSize).order(ByteOrder.Companion.getLITTLE_ENDIAN());
            this.seekInternal(this.bufferStart);
        }
        this.buffer.position(0);
        this.buffer.limit(newLength);
        this.bufferStart = start;
        this.readInternal(this.buffer);
        boolean condition$iv = Intrinsics.areEqual((Object)this.buffer.order(), (Object)ByteOrder.Companion.getLITTLE_ENDIAN());
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            ByteOrder byteOrder = this.buffer.order();
            throw new AssertionError(byteOrder);
        }
        condition$iv = this.buffer.remaining() == 0;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-BufferedIndexInput$refill$32 = false;
            String $i$a$-assert-BufferedIndexInput$refill$32 = "should have thrown EOFException";
            throw new AssertionError((Object)$i$a$-assert-BufferedIndexInput$refill$32);
        }
        condition$iv = this.buffer.getPosition() == newLength;
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.buffer.flip();
    }

    protected abstract void readInternal(@NotNull ByteBuffer var1) throws IOException;

    @Override
    public long getFilePointer() {
        return this.bufferStart + (long)this.buffer.getPosition();
    }

    @Override
    public void seek(long pos) {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.buffer.getLimit()) {
            this.buffer.position((int)(pos - this.bufferStart));
        } else {
            this.bufferStart = pos;
            this.buffer.limit(0);
            this.seekInternal(pos);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    @Override
    @NotNull
    public BufferedIndexInput clone() {
        IndexInput indexInput = super.clone();
        Intrinsics.checkNotNull((Object)indexInput, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.store.BufferedIndexInput");
        BufferedIndexInput clone = (BufferedIndexInput)indexInput;
        clone.buffer = EMPTY_BYTEBUFFER;
        clone.bufferStart = this.getFilePointer();
        return clone;
    }

    @Override
    @NotNull
    public IndexInput slice(@NotNull String sliceDescription, long offset, long length) {
        Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
        return Companion.wrap(sliceDescription, this, offset, length);
    }

    @Override
    public void prefetch(long offset, long length) throws IOException {
        super.prefetch(offset, length);
    }

    private static final int readGroupVInt$lambda$1(BufferedIndexInput this$0, long p) {
        return this$0.buffer.getInt((int)p);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/store/BufferedIndexInput$Companion;", "", "<init>", "()V", "EMPTY_BYTEBUFFER", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "BUFFER_SIZE", "", "MIN_BUFFER_SIZE", "MERGE_BUFFER_SIZE", "bufferSize", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "wrap", "Lorg/gnit/lucenekmp/store/BufferedIndexInput;", "sliceDescription", "", "other", "Lorg/gnit/lucenekmp/store/IndexInput;", "offset", "", "length", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int bufferSize(@NotNull IOContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            switch (WhenMappings.$EnumSwitchMapping$0[context.getContext().ordinal()]) {
                case 1: {
                    return 4096;
                }
                case 2: 
                case 3: {
                    return 1024;
                }
            }
            return 1024;
        }

        @NotNull
        public final BufferedIndexInput wrap(@NotNull String sliceDescription, @NotNull IndexInput other, long offset, long length) {
            Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new SlicedIndexInput(sliceDescription, other, offset, length);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IOContext.Context.values().length];
                try {
                    nArray[IOContext.Context.MERGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IOContext.Context.DEFAULT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IOContext.Context.FLUSH.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0016\u001a\u00020\u0000H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/store/BufferedIndexInput$SlicedIndexInput;", "Lorg/gnit/lucenekmp/store/BufferedIndexInput;", "sliceDescription", "", "base", "Lorg/gnit/lucenekmp/store/IndexInput;", "offset", "", "length", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/store/IndexInput;JJ)V", "getBase", "()Lorg/gnit/lucenekmp/store/IndexInput;", "setBase", "(Lorg/gnit/lucenekmp/store/IndexInput;)V", "fileOffset", "getFileOffset", "()J", "setFileOffset", "(J)V", "getLength", "setLength", "clone", "readInternal", "", "b", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "seekInternal", "pos", "close", "core"})
    @SourceDebugExtension(value={"SMAP\nBufferedIndexInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedIndexInput.kt\norg/gnit/lucenekmp/store/BufferedIndexInput$SlicedIndexInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1#2:429\n*E\n"})
    private static final class SlicedIndexInput
    extends BufferedIndexInput {
        @NotNull
        private IndexInput base;
        private long fileOffset;
        private long length;

        public SlicedIndexInput(@NotNull String sliceDescription, @NotNull IndexInput base, long offset, long length) {
            Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            super(base + " [slice=" + sliceDescription + "]", 1024);
            if (!((length | offset) >= 0L && length <= base.length() - offset)) {
                boolean bl = false;
                String string = "slice() " + sliceDescription + " out of bounds: " + base;
                throw new IllegalArgumentException(string.toString());
            }
            this.base = base.clone();
            this.fileOffset = offset;
            this.length = length;
        }

        @NotNull
        public final IndexInput getBase() {
            return this.base;
        }

        public final void setBase(@NotNull IndexInput indexInput) {
            Intrinsics.checkNotNullParameter((Object)indexInput, (String)"<set-?>");
            this.base = indexInput;
        }

        public final long getFileOffset() {
            return this.fileOffset;
        }

        public final void setFileOffset(long l) {
            this.fileOffset = l;
        }

        public final long getLength() {
            return this.length;
        }

        public final void setLength(long l) {
            this.length = l;
        }

        @Override
        @NotNull
        public SlicedIndexInput clone() {
            BufferedIndexInput bufferedIndexInput = super.clone();
            Intrinsics.checkNotNull((Object)bufferedIndexInput, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.store.BufferedIndexInput.SlicedIndexInput");
            SlicedIndexInput clone = (SlicedIndexInput)bufferedIndexInput;
            clone.base = this.base.clone();
            clone.fileOffset = this.fileOffset;
            clone.length = this.length;
            return clone;
        }

        @Override
        protected void readInternal(@NotNull ByteBuffer b) throws IOException {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            long start = this.getFilePointer();
            if (start + (long)b.remaining() > this.length) {
                throw new EOFException("read past EOF: " + this);
            }
            this.base.seek(this.fileOffset + start);
            this.base.readBytes(b.array(), b.getPosition(), b.remaining());
            b.position(b.getPosition() + b.remaining());
        }

        @Override
        protected void seekInternal(long pos) {
        }

        @Override
        public void close() throws IOException {
            this.base.close();
        }

        @Override
        public long length() {
            return this.length;
        }
    }
}

