/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0007J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "Lorg/gnit/lucenekmp/store/DataInput;", "bytes", "", "<init>", "([B)V", "offset", "", "len", "([BII)V", "()V", "position", "getPosition", "()I", "setPosition", "(I)V", "limit", "rewind", "", "reset", "length", "eof", "", "skipBytes", "count", "", "readShort", "", "readInt", "readLong", "readVInt", "readVLong", "readByte", "", "readBytes", "b", "core"})
public final class ByteArrayDataInput
extends DataInput {
    private byte[] bytes;
    private int position;
    private int limit;

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    public ByteArrayDataInput(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteArrayDataInput.reset$default(this, bytes, 0, 0, 6, null);
    }

    public ByteArrayDataInput(@NotNull byte[] bytes, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.reset(bytes, offset, len);
    }

    public ByteArrayDataInput() {
        ByteArrayDataInput.reset$default(this, BytesRef.Companion.getEMPTY_BYTES(), 0, 0, 6, null);
    }

    public final void rewind() {
        this.position = 0;
    }

    @JvmOverloads
    public final void reset(@NotNull byte[] bytes, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.position = offset;
        this.limit = offset + len;
    }

    public static /* synthetic */ void reset$default(ByteArrayDataInput byteArrayDataInput, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteArrayDataInput.reset(byArray, n, n2);
    }

    public final int length() {
        return this.limit;
    }

    public final boolean eof() {
        return this.position == this.limit;
    }

    @Override
    public void skipBytes(long count) {
        this.position += (int)count;
    }

    @Override
    public short readShort() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        short result = BitUtilKt.getShortLE(byArray, this.position);
        this.position += 2;
        return result;
    }

    @Override
    public int readInt() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int result = BitUtilKt.getIntLE(byArray, this.position);
        this.position += 4;
        return result;
    }

    @Override
    public long readLong() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        long result = BitUtilKt.getLongLE(byArray, this.position);
        this.position += 8;
        return result;
    }

    @Override
    public int readVInt() {
        try {
            return super.readVInt();
        }
        catch (IOException e) {
            throw new AssertionError((Object)"ByteArrayDataInput#readByte should not throw IOException");
        }
    }

    @Override
    public long readVLong() {
        try {
            return super.readVLong();
        }
        catch (IOException e) {
            throw new AssertionError((Object)"ByteArrayDataInput#readByte should not throw IOException");
        }
    }

    @Override
    public byte readByte() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        return byArray[n];
    }

    @Override
    public void readBytes(@NotNull byte[] b, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        ArraysKt.copyInto((byte[])byArray, (byte[])b, (int)offset, (int)this.position, (int)(this.position + len));
        this.position += len;
    }

    @JvmOverloads
    public final void reset(@NotNull byte[] bytes, int offset) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteArrayDataInput.reset$default(this, bytes, offset, 0, 4, null);
    }

    @JvmOverloads
    public final void reset(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteArrayDataInput.reset$default(this, bytes, 0, 0, 6, null);
    }
}

