/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.BufferUnderflowException;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.jdkport.FloatBuffer;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongBuffer;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.GroupVIntUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0016\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 =2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001=B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0013J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0013H\u0016J\b\u0010&\u001a\u00020\u0016H\u0016J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010*\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J \u0010+\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020,2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J \u0010-\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020.2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010/\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u00100\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u00101\u001a\u00020\u0016J\u000e\u00102\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0016J\u0010\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u0016H\u0016J\u0016\u00105\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u00109\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010:\u001a\u00020\u0013H\u0002J\u0006\u0010;\u001a\u00020<R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "Lorg/gnit/lucenekmp/store/DataInput;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "buffers", "", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "<init>", "(Ljava/util/List;)V", "blocks", "", "[Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "floatBuffers", "Lorg/gnit/lucenekmp/jdkport/FloatBuffer;", "[Lorg/gnit/lucenekmp/jdkport/FloatBuffer;", "longBuffers", "Lorg/gnit/lucenekmp/jdkport/LongBuffer;", "[Lorg/gnit/lucenekmp/jdkport/LongBuffer;", "blockBits", "", "blockMask", "length", "", "offset", "pos", "ramBytesUsed", "readByte", "", "readBytes", "", "buffer", "len", "arr", "", "off", "readShort", "", "readInt", "readLong", "readGroupVInt", "dst", "", "bytes", "readFloats", "", "readLongs", "", "getFloatBuffer", "getLongBuffer", "position", "seek", "skipBytes", "numBytes", "slice", "toString", "", "blockIndex", "blockOffset", "blockSize", "isLoaded", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nByteBuffersDataInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBuffersDataInput.kt\norg/gnit/lucenekmp/store/ByteBuffersDataInput\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,558:1\n37#2:559\n36#2,3:560\n1#3:563\n*S KotlinDebug\n*F\n+ 1 ByteBuffersDataInput.kt\norg/gnit/lucenekmp/store/ByteBuffersDataInput\n*L\n43#1:559\n43#1:560,3\n*E\n"})
public final class ByteBuffersDataInput
extends DataInput
implements Accountable,
RandomAccessInput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer[] blocks;
    @NotNull
    private final FloatBuffer[] floatBuffers;
    @NotNull
    private final LongBuffer[] longBuffers;
    private int blockBits;
    private int blockMask;
    private final long length;
    private final long offset;
    private long pos;

    public ByteBuffersDataInput(@NotNull List<ByteBuffer> buffers) {
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        ByteBuffersDataInput.Companion.ensureAssumptions(buffers);
        Collection $this$toTypedArray$iv = buffers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.blocks = thisCollection$iv.toArray(new ByteBuffer[0]);
        int n = this.blocks.length;
        for (int i = 0; i < n; ++i) {
            this.blocks[i] = this.blocks[i].asReadOnlyBuffer().order(ByteOrder.Companion.getLITTLE_ENDIAN());
        }
        this.floatBuffers = new FloatBuffer[this.blocks.length * 4];
        this.longBuffers = new LongBuffer[this.blocks.length * 8];
        if (this.blocks.length == 1) {
            this.blockBits = 32;
            this.blockMask = -1;
        } else {
            int blockBytes = Companion.determineBlockPage(buffers);
            this.blockBits = IntExtKt.numberOfTrailingZeros(IntCompanionObject.INSTANCE, blockBytes);
            this.blockMask = (1 << this.blockBits) - 1;
        }
        long length = 0L;
        for (ByteBuffer block2 : this.blocks) {
            length += (long)block2.remaining();
        }
        this.length = length;
        this.pos = this.offset = (long)this.blocks[0].getPosition();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long ramBytesUsed() {
        long l;
        ByteBuffer[] byteBufferArray = this.blocks;
        long l2 = 4L * (long)this.blocks.length;
        long l3 = 0L;
        int n = byteBufferArray.length;
        for (int i = 0; i < n; ++i) {
            void buf;
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = byteBufferArray[i];
            l = l3;
            boolean bl = false;
            long l4 = buf.getCapacity();
            l3 = l + l4;
        }
        l = l3;
        return l2 + l;
    }

    @Override
    public byte readByte() {
        try {
            ByteBuffer block2 = this.blocks[this.blockIndex(this.pos)];
            byte v = block2.get(this.blockOffset(this.pos));
            long l = this.pos;
            this.pos = l + 1L;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            if (this.pos >= this.length()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    public final void readBytes(@NotNull ByteBuffer buffer, int len) throws EOFException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            int chunk;
            for (int len2 = len; len2 > 0; len2 -= chunk) {
                ByteBuffer block2 = this.blocks[this.blockIndex(this.pos)].duplicate();
                int blockOffset = this.blockOffset(this.pos);
                block2.position(blockOffset);
                chunk = java.lang.Math.min(len2, block2.remaining());
                if (chunk == 0) {
                    throw new EOFException();
                }
                this.pos += (long)chunk;
                block2.limit(blockOffset + chunk);
                buffer.put(block2);
            }
        }
        catch (BufferUnderflowException e) {
            if (this.pos >= this.length()) {
                throw new EOFException();
            }
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            if (this.pos >= this.length()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    @Override
    public void readBytes(@NotNull byte[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        int off2 = off;
        int len2 = len;
        try {
            while (len2 > 0) {
                ByteBuffer block2 = this.blocks[this.blockIndex(this.pos)].duplicate();
                block2.position(this.blockOffset(this.pos));
                int chunk = java.lang.Math.min(len2, block2.remaining());
                if (chunk == 0) {
                    throw new EOFException();
                }
                this.pos += (long)chunk;
                block2.get(arr, off2, chunk);
                len2 -= chunk;
                off2 += chunk;
            }
        }
        catch (BufferUnderflowException e) {
            if (this.pos >= this.length()) {
                throw new EOFException();
            }
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            if (this.pos >= this.length()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    @Override
    public short readShort() throws IOException {
        int blockOffset = this.blockOffset(this.pos);
        if (blockOffset + 2 <= this.blockMask) {
            short v = this.blocks[this.blockIndex(this.pos)].getShort(blockOffset);
            this.pos += 2L;
            return v;
        }
        return super.readShort();
    }

    @Override
    public int readInt() throws IOException {
        int blockOffset = this.blockOffset(this.pos);
        if (blockOffset + 4 <= this.blockMask) {
            int v = this.blocks[this.blockIndex(this.pos)].getInt(blockOffset);
            this.pos += 4L;
            return v;
        }
        return super.readInt();
    }

    @Override
    public long readLong() throws IOException {
        int blockOffset = this.blockOffset(this.pos);
        if (blockOffset + 8 <= this.blockMask) {
            long v = this.blocks[this.blockIndex(this.pos)].getLong(blockOffset);
            this.pos += 8L;
            return v;
        }
        return super.readLong();
    }

    @Override
    public void readGroupVInt(@NotNull int[] dst, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        ByteBuffer block2 = this.blocks[this.blockIndex(this.pos)];
        int blockOffset = this.blockOffset(this.pos);
        int len = GroupVIntUtil.INSTANCE.readGroupVInt((DataInput)this, (long)(block2.getLimit() - blockOffset), arg_0 -> ByteBuffersDataInput.readGroupVInt$lambda$1(block2, arg_0), (long)blockOffset, dst, offset);
        this.pos += (long)len;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte readByte(long pos) {
        long pos2 = pos;
        return this.blocks[this.blockIndex(pos2 += this.offset)].get(this.blockOffset(pos2));
    }

    @Override
    public void readBytes(long pos, @NotNull byte[] bytes, int offset, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int offset2 = offset;
        int len2 = len;
        long absPos = this.offset + pos;
        try {
            while (len2 > 0) {
                ByteBuffer block2 = this.blocks[this.blockIndex(absPos)];
                int blockPosition = this.blockOffset(absPos);
                int chunk = java.lang.Math.min(len2, block2.getCapacity() - blockPosition);
                if (chunk == 0) {
                    throw new EOFException();
                }
                block2.get(blockPosition, bytes, offset2, chunk);
                absPos += (long)chunk;
                len2 -= chunk;
                offset2 += chunk;
            }
        }
        catch (BufferUnderflowException e) {
            if (absPos >= this.length()) {
                throw new EOFException();
            }
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            if (absPos >= this.length()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    @Override
    public short readShort(long pos) {
        long absPos = this.offset + pos;
        int blockOffset = this.blockOffset(absPos);
        return blockOffset + 2 <= this.blockMask ? this.blocks[this.blockIndex(absPos)].getShort(blockOffset) : (short)(this.readByte(pos) & 0xFF | (this.readByte(pos + 1L) & 0xFF) << 8);
    }

    @Override
    public int readInt(long pos) {
        long absPos = this.offset + pos;
        int blockOffset = this.blockOffset(absPos);
        return blockOffset + 4 <= this.blockMask ? this.blocks[this.blockIndex(absPos)].getInt(blockOffset) : this.readByte(pos) & 0xFF | (this.readByte(pos + 1L) & 0xFF) << 8 | (this.readByte(pos + (long)2) & 0xFF) << 16 | this.readByte(pos + (long)3) << 24;
    }

    @Override
    public long readLong(long pos) {
        long absPos = this.offset + pos;
        int blockOffset = this.blockOffset(absPos);
        if (blockOffset + 8 <= this.blockMask) {
            return this.blocks[this.blockIndex(absPos)].getLong(blockOffset);
        }
        byte b1 = this.readByte(pos);
        byte b2 = this.readByte(pos + 1L);
        byte b3 = this.readByte(pos + (long)2);
        byte b4 = this.readByte(pos + (long)3);
        byte b5 = this.readByte(pos + (long)4);
        byte b6 = this.readByte(pos + (long)5);
        byte b7 = this.readByte(pos + (long)6);
        byte b8 = this.readByte(pos + (long)7);
        return ((long)b8 & 0xFFL) << 56 | ((long)b7 & 0xFFL) << 48 | ((long)b6 & 0xFFL) << 40 | ((long)b5 & 0xFFL) << 32 | ((long)b4 & 0xFFL) << 24 | ((long)b3 & 0xFFL) << 16 | ((long)b2 & 0xFFL) << 8 | (long)b1 & 0xFFL;
    }

    @Override
    public void readFloats(@NotNull float[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        int off2 = off;
        int len2 = len;
        try {
            while (len2 > 0) {
                FloatBuffer floatBuffer = this.getFloatBuffer(this.pos);
                floatBuffer.position(this.blockOffset(this.pos) >> 2);
                int chunk = java.lang.Math.min(len2, floatBuffer.remaining());
                if (chunk == 0) {
                    arr[off2] = FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, this.readInt(this.pos - this.offset));
                    ++off2;
                    --len2;
                    this.pos += 4L;
                    continue;
                }
                this.pos += (long)(chunk << 2);
                floatBuffer.get(arr, off2, chunk);
                len2 -= chunk;
                off2 += chunk;
            }
        }
        catch (BufferUnderflowException e) {
            if (this.pos - this.offset + (long)4 > this.length()) {
                throw new EOFException();
            }
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            if (this.pos - this.offset + (long)4 > this.length()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    @Override
    public void readLongs(@NotNull long[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        int off2 = off;
        int len2 = len;
        try {
            while (len2 > 0) {
                LongBuffer longBuffer = this.getLongBuffer(this.pos);
                longBuffer.position(this.blockOffset(this.pos) >> 3);
                int chunk = java.lang.Math.min(len2, longBuffer.remaining());
                if (chunk == 0) {
                    arr[off2] = this.readLong(this.pos - this.offset);
                    ++off2;
                    --len2;
                    this.pos += 8L;
                    continue;
                }
                this.pos += (long)(chunk << 3);
                longBuffer.get(arr, off2, chunk);
                len2 -= chunk;
                off2 += chunk;
            }
        }
        catch (BufferUnderflowException e) {
            if (this.pos - this.offset + (long)8 > this.length()) {
                throw new EOFException();
            }
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            if (this.pos - this.offset + (long)8 > this.length()) {
                throw new EOFException();
            }
            throw e;
        }
    }

    private final FloatBuffer getFloatBuffer(long pos) {
        int alignment;
        int bufferIndex = this.blockIndex(pos);
        int floatBufferIndex = bufferIndex * 4 + (alignment = (int)pos & 3);
        if (this.floatBuffers[floatBufferIndex] == null) {
            ByteBuffer dup = this.blocks[bufferIndex].duplicate();
            dup.position(alignment);
            this.floatBuffers[floatBufferIndex] = dup.order(ByteOrder.Companion.getLITTLE_ENDIAN()).asFloatBuffer();
        }
        FloatBuffer floatBuffer = this.floatBuffers[floatBufferIndex];
        Intrinsics.checkNotNull((Object)floatBuffer);
        return floatBuffer;
    }

    private final LongBuffer getLongBuffer(long pos) {
        int alignment;
        int bufferIndex = this.blockIndex(pos);
        int longBufferIndex = bufferIndex * 8 + (alignment = (int)pos & 7);
        if (this.longBuffers[longBufferIndex] == null) {
            ByteBuffer dup = this.blocks[bufferIndex].duplicate();
            dup.position(alignment);
            this.longBuffers[longBufferIndex] = dup.order(ByteOrder.Companion.getLITTLE_ENDIAN()).asLongBuffer();
        }
        LongBuffer longBuffer = this.longBuffers[longBufferIndex];
        Intrinsics.checkNotNull((Object)longBuffer);
        return longBuffer;
    }

    public final long position() {
        return this.pos - this.offset;
    }

    public final void seek(long position) throws EOFException {
        this.pos = position + this.offset;
        if (position > this.length()) {
            this.pos = this.length();
            throw new EOFException();
        }
    }

    @Override
    public void skipBytes(long numBytes) throws IOException {
        if (!(numBytes >= 0L)) {
            boolean bl = false;
            String string = "numBytes must be >= 0, got " + numBytes;
            throw new IllegalArgumentException(string.toString());
        }
        long skipTo = this.position() + numBytes;
        this.seek(skipTo);
    }

    @NotNull
    public final ByteBuffersDataInput slice(long offset, long length) {
        if (!((length | offset) >= 0L && length <= this.length - offset)) {
            boolean bl = false;
            String string = "slice(offset=" + offset + ", length=" + length + ") is out of bounds: " + this;
            throw new IllegalArgumentException(string.toString());
        }
        return new ByteBuffersDataInput(ByteBuffersDataInput.Companion.sliceBufferList(ArraysKt.toMutableList((Object[])this.blocks), offset, length));
    }

    @NotNull
    public String toString() {
        String offsetInfo = this.offset == 0L ? "" : " [offset: " + this.offset + "]";
        return this.length() + " bytes, block size: " + this.blockSize() + ", blocks: " + this.blocks.length + ", position: " + this.position() + offsetInfo;
    }

    private final int blockIndex(long pos) {
        return Math.INSTANCE.toIntExact(pos >> this.blockBits);
    }

    private final int blockOffset(long pos) {
        return (int)pos & this.blockMask;
    }

    private final int blockSize() {
        return 1 << this.blockBits;
    }

    public final boolean isLoaded() {
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Override
    public void prefetch(long offset, long length) throws IOException {
        RandomAccessInput.super.prefetch(offset, length);
    }

    private static final int readGroupVInt$lambda$1(ByteBuffer $block, long p) {
        return $block.getInt((int)p);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0014\u0010\r\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersDataInput$Companion;", "", "<init>", "()V", "isPowerOfTwo", "", "v", "", "ensureAssumptions", "", "buffers", "", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "determineBlockPage", "sliceBufferList", "offset", "", "length", "core"})
    @SourceDebugExtension(value={"SMAP\nByteBuffersDataInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBuffersDataInput.kt\norg/gnit/lucenekmp/store/ByteBuffersDataInput$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,558:1\n1#2:559\n1563#3:560\n1634#3,3:561\n*S KotlinDebug\n*F\n+ 1 ByteBuffersDataInput.kt\norg/gnit/lucenekmp/store/ByteBuffersDataInput$Companion\n*L\n542#1:560\n542#1:561,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isPowerOfTwo(int v) {
            return (v & v - 1) == 0;
        }

        private final void ensureAssumptions(List<ByteBuffer> buffers) {
            if (!(!buffers.isEmpty())) {
                boolean $i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$52 = false;
                String $i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$52 = "Buffer list must not be empty.";
                throw new IllegalArgumentException($i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$52.toString());
            }
            if (buffers.size() != 1) {
                int blockPage = this.determineBlockPage(buffers);
                if (!this.isPowerOfTwo(blockPage)) {
                    boolean $i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$62 = false;
                    String $i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$62 = "The first buffer must have power-of-two position() + remaining(): 0x" + IntExtKt.toHexString(IntCompanionObject.INSTANCE, blockPage);
                    throw new IllegalArgumentException($i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$62.toString());
                }
                int last = buffers.size() - 1;
                for (int i = 1; i < last; ++i) {
                    ByteBuffer buffer = buffers.get(i);
                    if (!(buffer.getPosition() == 0)) {
                        boolean $i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$72 = false;
                        String $i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$72 = "All buffers except for the first one must have position() == 0: " + buffer;
                        throw new IllegalArgumentException($i$a$-require-ByteBuffersDataInput$Companion$ensureAssumptions$72.toString());
                    }
                    if (i == last || buffer.remaining() == blockPage) continue;
                    boolean bl = false;
                    String string = "Intermediate buffers must share an identical remaining() power-of-two block size: 0x" + IntExtKt.toHexString(IntCompanionObject.INSTANCE, blockPage);
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        public final int determineBlockPage(@NotNull List<ByteBuffer> buffers) {
            Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
            ByteBuffer first = buffers.get(0);
            int blockPage = Math.INSTANCE.toIntExact((long)first.getPosition() + (long)first.remaining());
            return blockPage;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ByteBuffer> sliceBufferList(List<ByteBuffer> buffers, long offset, long length) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.ensureAssumptions(buffers);
            if (buffers.size() == 1) {
                ByteBuffer cloned = buffers.get(0).asReadOnlyBuffer().order(ByteOrder.Companion.getLITTLE_ENDIAN());
                cloned.position(Math.INSTANCE.toIntExact((long)cloned.getPosition() + offset));
                cloned.limit(Math.INSTANCE.toIntExact((long)cloned.getPosition() + length));
                Object[] objectArray = new ByteBuffer[]{cloned};
                return CollectionsKt.mutableListOf((Object[])objectArray);
            }
            long absStart = (long)buffers.get(0).getPosition() + offset;
            long absEnd = absStart + length;
            int blockBytes = this.determineBlockPage(buffers);
            int blockBits = IntExtKt.numberOfTrailingZeros(IntCompanionObject.INSTANCE, blockBytes);
            long blockMask = (1L << blockBits) - 1L;
            int endOffset = Math.INSTANCE.toIntExact(absEnd & blockMask);
            Iterable iterable = buffers.subList(Math.INSTANCE.toIntExact(absStart / (long)blockBytes), Math.INSTANCE.toIntExact(absEnd / (long)blockBytes + (long)(endOffset == 0 ? 0 : 1)));
            boolean $i$f$map = false;
            void var18_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void buf;
                ByteBuffer byteBuffer = (ByteBuffer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(buf.asReadOnlyBuffer().order(ByteOrder.Companion.getLITTLE_ENDIAN()));
            }
            List cloned = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            if (endOffset == 0) {
                cloned.add(ByteBuffer.Companion.allocate(0).order(ByteOrder.Companion.getLITTLE_ENDIAN()));
            }
            ((ByteBuffer)cloned.get(0)).position(Math.INSTANCE.toIntExact(absStart & blockMask));
            ((ByteBuffer)cloned.get(cloned.size() - 1)).limit(endOffset);
            return cloned;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

