/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\n\n\u0002\b\t\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J \u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J(\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\fH\u0016J(\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J \u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J \u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u001aH\u0016J\u0018\u0010-\u001a\u00020\n2\u0006\u0010+\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0018\u0010/\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020\u0000H\u0016J\b\u00101\u001a\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersIndexInput;", "Lorg/gnit/lucenekmp/store/IndexInput;", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "input", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "resourceDescription", "", "<init>", "(Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;Ljava/lang/String;)V", "close", "", "filePointer", "", "getFilePointer", "()J", "seek", "pos", "length", "slice", "sliceDescription", "offset", "readByte", "", "readBytes", "b", "", "", "len", "useBuffer", "", "readShort", "", "readInt", "readVInt", "readLong", "readVLong", "skipBytes", "numBytes", "bytes", "readFloats", "floats", "", "readLongs", "dst", "", "readGroupVInt", "", "prefetch", "clone", "ensureOpen", "core"})
public final class ByteBuffersIndexInput
extends IndexInput
implements RandomAccessInput {
    @Nullable
    private ByteBuffersDataInput input;

    public ByteBuffersIndexInput(@Nullable ByteBuffersDataInput input, @NotNull String resourceDescription) {
        Intrinsics.checkNotNullParameter((Object)resourceDescription, (String)"resourceDescription");
        super(resourceDescription);
        this.input = input;
    }

    @Override
    public void close() {
        this.input = null;
    }

    @Override
    public long getFilePointer() {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        byteBuffersDataInput.seek(pos);
    }

    @Override
    public long length() {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.length();
    }

    @Override
    @NotNull
    public ByteBuffersIndexInput slice(@NotNull String sliceDescription, long offset, long length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return new ByteBuffersIndexInput(byteBuffersDataInput.slice(offset, length), "(sliced) offset=" + offset + ", length=" + length + " " + this + " [slice=" + sliceDescription + "]");
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readByte();
    }

    @Override
    public void readBytes(@NotNull byte[] b, int offset, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        byteBuffersDataInput.readBytes(b, offset, len);
    }

    @Override
    public void readBytes(@NotNull byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        byteBuffersDataInput.readBytes(b, offset, len, useBuffer);
    }

    @Override
    public short readShort() throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readShort();
    }

    @Override
    public int readInt() throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readInt();
    }

    @Override
    public int readVInt() throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readVInt();
    }

    @Override
    public long readLong() throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readLong();
    }

    @Override
    public long readVLong() throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readVLong();
    }

    @Override
    public void skipBytes(long numBytes) throws IOException {
        this.ensureOpen();
        super.skipBytes(numBytes);
    }

    @Override
    public byte readByte(long pos) throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readByte(pos);
    }

    @Override
    public void readBytes(long pos, @NotNull byte[] bytes, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        byteBuffersDataInput.readBytes(pos, bytes, offset, length);
    }

    @Override
    public short readShort(long pos) throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readShort(pos);
    }

    @Override
    public int readInt(long pos) throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readInt(pos);
    }

    @Override
    public long readLong(long pos) throws IOException {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        return byteBuffersDataInput.readLong(pos);
    }

    @Override
    public void readFloats(@NotNull float[] floats, int offset, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)floats, (String)"floats");
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        byteBuffersDataInput.readFloats(floats, offset, len);
    }

    @Override
    public void readLongs(@NotNull long[] dst, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        byteBuffersDataInput.readLongs(dst, offset, length);
    }

    @Override
    public void readGroupVInt(@NotNull int[] dst, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        byteBuffersDataInput.readGroupVInt(dst, offset);
    }

    @Override
    public void prefetch(long offset, long length) throws IOException {
    }

    @Override
    @NotNull
    public ByteBuffersIndexInput clone() {
        this.ensureOpen();
        ByteBuffersDataInput byteBuffersDataInput = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput);
        ByteBuffersDataInput byteBuffersDataInput2 = this.input;
        Intrinsics.checkNotNull((Object)byteBuffersDataInput2);
        ByteBuffersIndexInput cloned = new ByteBuffersIndexInput(byteBuffersDataInput.slice(0L, byteBuffersDataInput2.length()), "(clone of) " + this);
        try {
            cloned.seek(this.getFilePointer());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return cloned;
    }

    private final void ensureOpen() {
        if (this.input == null) {
            throw new AlreadyClosedException("Already closed.");
        }
    }
}

