/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CRC32;
import org.gnit.lucenekmp.jdkport.Checksum;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\u000eJ\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0012H\u0016J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0012H\u0016J\u001c\u0010+\u001a\u00020\u000b2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050-H\u0016J\u0016\u0010.\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000500H\u0016J\b\u00101\u001a\u00020\u000bH\u0002J\u0006\u00102\u001a\u00020\u001cR\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersIndexOutput;", "Lorg/gnit/lucenekmp/store/IndexOutput;", "delegate", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "resourceDescription", "", "name", "checksum", "Lorg/gnit/lucenekmp/jdkport/Checksum;", "onClose", "Lkotlin/Function1;", "", "<init>", "(Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;Ljava/lang/String;Ljava/lang/String;Lorg/gnit/lucenekmp/jdkport/Checksum;Lkotlin/jvm/functions/Function1;)V", "(Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;Ljava/lang/String;Ljava/lang/String;)V", "getChecksum", "()Lorg/gnit/lucenekmp/jdkport/Checksum;", "lastChecksumPosition", "", "lastChecksum", "close", "filePointer", "getFilePointer", "()J", "writeByte", "b", "", "writeBytes", "", "offset", "", "length", "writeInt", "i", "writeShort", "", "writeLong", "writeString", "s", "copyBytes", "input", "Lorg/gnit/lucenekmp/store/DataInput;", "numBytes", "writeMapOfStrings", "map", "", "writeSetOfStrings", "set", "", "ensureOpen", "toArrayCopy", "core"})
public final class ByteBuffersIndexOutput
extends IndexOutput {
    @Nullable
    private final Function1<ByteBuffersDataOutput, Unit> onClose;
    @NotNull
    private final Checksum checksum;
    private long lastChecksumPosition;
    private long lastChecksum;
    @Nullable
    private ByteBuffersDataOutput delegate;

    public ByteBuffersIndexOutput(@NotNull ByteBuffersDataOutput delegate, @NotNull String resourceDescription, @NotNull String name, @NotNull Checksum checksum, @Nullable Function1<? super ByteBuffersDataOutput, Unit> onClose) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)resourceDescription, (String)"resourceDescription");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        super(resourceDescription, name);
        this.delegate = delegate;
        this.checksum = checksum;
        this.onClose = onClose;
    }

    @NotNull
    public final Checksum getChecksum() {
        return this.checksum;
    }

    public ByteBuffersIndexOutput(@NotNull ByteBuffersDataOutput delegate, @NotNull String resourceDescription, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)resourceDescription, (String)"resourceDescription");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(delegate, resourceDescription, name, new CRC32(), null);
    }

    @Override
    public void close() {
        ByteBuffersDataOutput local = this.delegate;
        this.delegate = null;
        if (local != null && this.onClose != null) {
            this.onClose.invoke((Object)local);
        }
    }

    @Override
    public long getFilePointer() {
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        return byteBuffersDataOutput.size();
    }

    @Override
    public long getChecksum() {
        this.ensureOpen();
        if (this.checksum == null) {
            throw new IOException("This index output has no checksum computing ability: " + this);
        }
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        if (this.lastChecksumPosition != byteBuffersDataOutput.size()) {
            ByteBuffersDataOutput byteBuffersDataOutput2 = this.delegate;
            Intrinsics.checkNotNull((Object)byteBuffersDataOutput2);
            this.lastChecksumPosition = byteBuffersDataOutput2.size();
            this.checksum.reset();
            ByteBuffersDataOutput byteBuffersDataOutput3 = this.delegate;
            Intrinsics.checkNotNull((Object)byteBuffersDataOutput3);
            for (ByteBuffer bb : byteBuffersDataOutput3.toBufferList()) {
                this.checksum.update(bb);
            }
            this.lastChecksum = this.checksum.getValue();
        }
        return this.lastChecksum;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeByte(b);
    }

    @Override
    public void writeBytes(@NotNull byte[] b, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeBytes(b, offset, length);
    }

    @Override
    public void writeBytes(@NotNull byte[] b, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeBytes(b, length);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeInt(i);
    }

    @Override
    public void writeShort(short i) throws IOException {
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeShort(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeLong(i);
    }

    @Override
    public void writeString(@NotNull String s) throws IOException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeString(s);
    }

    @Override
    public void copyBytes(@NotNull DataInput input, long numBytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.copyBytes(input, numBytes);
    }

    @Override
    public void writeMapOfStrings(@NotNull Map<String, String> map2) throws IOException {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeMapOfStrings(map2);
    }

    @Override
    public void writeSetOfStrings(@NotNull Set<String> set) throws IOException {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this.ensureOpen();
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        byteBuffersDataOutput.writeSetOfStrings(set);
    }

    private final void ensureOpen() {
        if (this.delegate == null) {
            throw new AlreadyClosedException("Already closed.");
        }
    }

    @NotNull
    public final byte[] toArrayCopy() {
        ByteBuffersDataOutput byteBuffersDataOutput = this.delegate;
        Intrinsics.checkNotNull((Object)byteBuffersDataOutput);
        return byteBuffersDataOutput.toArrayCopy();
    }
}

