/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.GroupVIntUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH&J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0006\u0010\u0016\u001a\u00020\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\u0006\u0010!\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0000H\u0016J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0&J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0018H&\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/store/DataInput;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "<init>", "()V", "readByte", "", "readBytes", "", "b", "", "offset", "", "len", "useBuffer", "", "readShort", "", "readInt", "readGroupVInt", "dst", "", "readVInt", "readZInt", "readLong", "", "readLongs", "", "length", "readInts", "readFloats", "floats", "", "readVLong", "readZLong", "readString", "", "clone", "readMapOfStrings", "", "readSetOfStrings", "", "skipBytes", "numBytes", "core"})
public abstract class DataInput
implements Cloneable<DataInput> {
    public abstract byte readByte() throws IOException;

    public abstract void readBytes(@NotNull byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(@NotNull byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.readBytes(b, offset, len);
    }

    public short readShort() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public int readInt() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public void readGroupVInt(@NotNull int[] dst, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        GroupVIntUtil.INSTANCE.readGroupVInt(this, dst, offset);
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public final int readZInt() throws IOException {
        return BitUtil.INSTANCE.zigZagDecode(this.readVInt());
    }

    public long readLong() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL | (long)this.readInt() << 32;
    }

    public void readLongs(@NotNull long[] dst, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Objects.INSTANCE.checkFromIndexSize(offset, length, dst.length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this.readLong();
        }
    }

    public void readInts(@NotNull int[] dst, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Objects.INSTANCE.checkFromIndexSize(offset, length, dst.length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this.readInt();
        }
    }

    public void readFloats(@NotNull float[] floats, int offset, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)floats, (String)"floats");
        Objects.INSTANCE.checkFromIndexSize(offset, len, floats.length);
        for (int i = 0; i < len; ++i) {
            floats[offset + i] = Float.intBitsToFloat(this.readInt());
        }
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public final long readZLong() throws IOException {
        return BitUtil.INSTANCE.zigZagDecode(this.readVLong());
    }

    @NotNull
    public final String readString() throws IOException {
        int length = this.readVInt();
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return StringsKt.decodeToString$default((byte[])bytes, (int)0, (int)length, (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public DataInput clone() {
        throw new UnsupportedOperationException("Subclasses of DataInput must implement clone()");
    }

    @NotNull
    public final Map<String, String> readMapOfStrings() throws IOException {
        int count = this.readVInt();
        switch (count) {
            case 0: {
                return new LinkedHashMap();
            }
            case 1: {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.readString(), (Object)this.readString())};
                return MapsKt.mutableMapOf((Pair[])pairArray);
            }
        }
        Map map2 = count > 10 ? (Map)new HashMap() : (Map)new LinkedHashMap();
        for (int i = 0; i < count; ++i) {
            String key = this.readString();
            String val = this.readString();
            map2.put(key, val);
        }
        return map2;
    }

    @NotNull
    public final Set<String> readSetOfStrings() throws IOException {
        int count = this.readVInt();
        switch (count) {
            case 0: {
                return new LinkedHashSet();
            }
            case 1: {
                Object[] objectArray = new String[]{this.readString()};
                return SetsKt.mutableSetOf((Object[])objectArray);
            }
        }
        Set set = count > 10 ? (Set)new HashSet() : (Set)new LinkedHashSet();
        for (int i = 0; i < count; ++i) {
            set.add(this.readString());
        }
        return set;
    }

    public abstract void skipBytes(long var1) throws IOException;
}

