/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.FilterDirectory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.Lock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001f\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\u0016\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/store/LockValidatingDirectoryWrapper;", "Lorg/gnit/lucenekmp/store/FilterDirectory;", "in", "Lorg/gnit/lucenekmp/store/Directory;", "writeLock", "Lorg/gnit/lucenekmp/store/Lock;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/store/Lock;)V", "deleteFile", "", "name", "", "createOutput", "Lorg/gnit/lucenekmp/store/IndexOutput;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "copyFrom", "from", "src", "dest", "rename", "source", "syncMetaData", "sync", "names", "", "core"})
public final class LockValidatingDirectoryWrapper
extends FilterDirectory {
    @NotNull
    private final Lock writeLock;

    public LockValidatingDirectoryWrapper(@NotNull Directory in, @NotNull Lock writeLock) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)writeLock, (String)"writeLock");
        super(in);
        this.writeLock = writeLock;
    }

    @Override
    public void deleteFile(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.writeLock.ensureValid();
        this.getIn().deleteFile(name);
    }

    @Override
    @NotNull
    public IndexOutput createOutput(@NotNull String name, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.writeLock.ensureValid();
        return this.getIn().createOutput(name, context);
    }

    @Override
    public void copyFrom(@NotNull Directory from, @NotNull String src, @NotNull String dest, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.writeLock.ensureValid();
        this.getIn().copyFrom(from, src, dest, context);
    }

    @Override
    public void rename(@NotNull String source, @NotNull String dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.writeLock.ensureValid();
        this.getIn().rename(source, dest);
    }

    @Override
    public void syncMetaData() throws IOException {
        this.writeLock.ensureValid();
        this.getIn().syncMetaData();
    }

    @Override
    public void sync(@NotNull Collection<String> names) throws IOException {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        this.writeLock.ensureValid();
        this.getIn().sync(names);
    }
}

