/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.FileHandle;
import okio.FileSystem;
import okio.Path;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.Files;
import org.gnit.lucenekmp.store.BufferedIndexInput;
import org.gnit.lucenekmp.store.FSDirectory;
import org.gnit.lucenekmp.store.FSLockFactory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.LockFactory;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/store/NIOFSDirectory;", "Lorg/gnit/lucenekmp/store/FSDirectory;", "path", "Lokio/Path;", "lockFactory", "Lorg/gnit/lucenekmp/store/LockFactory;", "<init>", "(Lokio/Path;Lorg/gnit/lucenekmp/store/LockFactory;)V", "fileSystem", "Lokio/FileSystem;", "openInput", "Lorg/gnit/lucenekmp/store/IndexInput;", "name", "", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "NIOFSIndexInput", "core"})
public final class NIOFSDirectory
extends FSDirectory {
    @NotNull
    private final FileSystem fileSystem;

    public NIOFSDirectory(@NotNull Path path, @NotNull LockFactory lockFactory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)lockFactory, (String)"lockFactory");
        super(path, lockFactory);
        this.fileSystem = Files.INSTANCE.getFileSystem();
    }

    public /* synthetic */ NIOFSDirectory(Path path, LockFactory lockFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lockFactory = FSLockFactory.Companion.getDefault();
        }
        this(path, lockFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IndexInput openInput(@NotNull String name, @NotNull IOContext context) {
        IndexInput indexInput;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = Path.resolve$default((Path)this.getDirectory(), (String)name, (boolean)false, (int)2, null);
        FileHandle fh = this.fileSystem.openReadOnly(path);
        boolean success = false;
        try {
            NIOFSIndexInput indexInput2 = new NIOFSIndexInput("NIOFSIndexInput(path=\"" + path + "\")", fh, context);
            success = true;
            indexInput = indexInput2;
        }
        catch (Throwable throwable) {
            if (!success) {
                IOUtils.INSTANCE.closeWhileHandlingException((Closeable)fh);
            }
            throw throwable;
        }
        return indexInput;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u000bH\u0014R\u0014\u0010\u0010\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/store/NIOFSDirectory$NIOFSIndexInput;", "Lorg/gnit/lucenekmp/store/BufferedIndexInput;", "resourceDesc", "", "fh", "Lokio/FileHandle;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "<init>", "(Ljava/lang/String;Lokio/FileHandle;Lorg/gnit/lucenekmp/store/IOContext;)V", "off", "", "length", "bufferSize", "", "(Ljava/lang/String;Lokio/FileHandle;JJI)V", "handle", "getHandle", "()Lokio/FileHandle;", "isClone", "", "()Z", "setClone", "(Z)V", "getOff", "()J", "end", "getEnd", "close", "", "clone", "slice", "Lorg/gnit/lucenekmp/store/IndexInput;", "sliceDescription", "offset", "readInternal", "b", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "seekInternal", "pos", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nNIOFSDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NIOFSDirectory.kt\norg/gnit/lucenekmp/store/NIOFSDirectory$NIOFSIndexInput\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,234:1\n3#2,8:235\n8#2,2:244\n3#2,8:246\n10#3:243\n10#3:254\n*S KotlinDebug\n*F\n+ 1 NIOFSDirectory.kt\norg/gnit/lucenekmp/store/NIOFSDirectory$NIOFSIndexInput\n*L\n167#1:235,8\n204#1:244,2\n213#1:246,8\n167#1:243\n213#1:254\n*E\n"})
    public static final class NIOFSIndexInput
    extends BufferedIndexInput {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FileHandle handle;
        private boolean isClone;
        private final long off;
        private final long end;
        private static final int CHUNK_SIZE = 16384;

        @NotNull
        protected final FileHandle getHandle() {
            return this.handle;
        }

        public final boolean isClone() {
            return this.isClone;
        }

        public final void setClone(boolean bl) {
            this.isClone = bl;
        }

        protected final long getOff() {
            return this.off;
        }

        protected final long getEnd() {
            return this.end;
        }

        public NIOFSIndexInput(@NotNull String resourceDesc, @NotNull FileHandle fh, @NotNull IOContext context) {
            Intrinsics.checkNotNullParameter((Object)resourceDesc, (String)"resourceDesc");
            Intrinsics.checkNotNullParameter((Object)fh, (String)"fh");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(resourceDesc, context);
            this.handle = fh;
            this.off = 0L;
            this.end = fh.size();
        }

        public NIOFSIndexInput(@NotNull String resourceDesc, @NotNull FileHandle fh, long off, long length, int bufferSize) {
            Intrinsics.checkNotNullParameter((Object)resourceDesc, (String)"resourceDesc");
            Intrinsics.checkNotNullParameter((Object)fh, (String)"fh");
            super(resourceDesc, bufferSize);
            this.handle = fh;
            this.off = off;
            this.end = off + length;
            this.isClone = true;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.handle.close();
            }
        }

        @Override
        @NotNull
        public NIOFSIndexInput clone() {
            BufferedIndexInput bufferedIndexInput = super.clone();
            Intrinsics.checkNotNull((Object)bufferedIndexInput, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.store.NIOFSDirectory.NIOFSIndexInput");
            NIOFSIndexInput clone = (NIOFSIndexInput)bufferedIndexInput;
            clone.isClone = true;
            return clone;
        }

        @Override
        @NotNull
        public IndexInput slice(@NotNull String sliceDescription, long offset, long length) {
            Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
            if (!((length | offset) >= 0L && length <= this.length() - offset)) {
                boolean bl = false;
                String string = "slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + this;
                throw new IllegalArgumentException(string.toString());
            }
            return new NIOFSIndexInput(this.getFullSliceDescription(sliceDescription), this.handle, this.off + offset, length, this.getBufferSize());
        }

        @Override
        public long length() {
            return this.end - this.off;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void readInternal(@NotNull ByteBuffer b) throws IOException {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            long pos = this.getFilePointer() + this.off;
            if (pos + (long)b.remaining() > this.end) {
                throw new EOFException("read past EOF: " + this);
            }
            try {
                int readLength;
                int i;
                for (readLength = b.remaining(); readLength > 0; readLength -= i) {
                    void condition$iv;
                    int actualByteCount;
                    int toRead = Math.min(16384, readLength);
                    b.limit(b.getPosition() + toRead);
                    boolean condition$iv2 = b.remaining() == toRead;
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv2) {
                        boolean $i$a$-assert-AssertKt$assert$22 = false;
                        String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                    }
                    Buffer tempOkioBuffer = new Buffer();
                    long numBytesReadFromHandle = this.handle.read(pos, tempOkioBuffer, (long)toRead);
                    i = 0;
                    if (numBytesReadFromHandle == -1L) {
                        i = -1;
                    } else {
                        actualByteCount = (int)numBytesReadFromHandle;
                        if (actualByteCount > 0) {
                            byte[] dataToTransfer = tempOkioBuffer.readByteArray((long)actualByteCount);
                            ByteBuffer.put$default(b, dataToTransfer, 0, 0, 6, null);
                        }
                        i = actualByteCount;
                    }
                    if (i < 0) {
                        throw new EOFException("read past EOF: " + this + " buffer: " + b + " chunkLen: " + toRead + " end: " + this.end);
                    }
                    actualByteCount = i > 0 ? 1 : 0;
                    boolean $i$f$assert2 = false;
                    if (_Assertions.ENABLED && condition$iv == false) {
                        boolean bl = false;
                        String string = "FileChannel.read with non zero-length bb.remaining() must always read at least one byte (FileChannel is in blocking mode, see spec of ReadableByteChannel)";
                        throw new AssertionError((Object)string);
                    }
                    pos += (long)i;
                }
                boolean condition$iv = readLength == 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            catch (IOException ioe) {
                throw new IOException(ioe.getMessage() + ": " + this, ioe);
            }
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
            if (pos > this.length()) {
                throw new EOFException("read past EOF: pos=" + pos + " vs length=" + this.length() + ": " + this);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/store/NIOFSDirectory$NIOFSIndexInput$Companion;", "", "<init>", "()V", "CHUNK_SIZE", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

