/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.gnit.lucenekmp.jdkport.Files;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.FSDirectory;
import org.gnit.lucenekmp.store.FSLockFactory;
import org.gnit.lucenekmp.store.Lock;
import org.gnit.lucenekmp.store.LockObtainFailedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/store/NativeFSLockFactory;", "Lorg/gnit/lucenekmp/store/FSLockFactory;", "fs", "Lokio/FileSystem;", "<init>", "(Lokio/FileSystem;)V", "getFs", "()Lokio/FileSystem;", "obtainFSLock", "Lorg/gnit/lucenekmp/store/Lock;", "dir", "Lorg/gnit/lucenekmp/store/FSDirectory;", "lockName", "", "NativeFSLock", "Companion", "core"})
public final class NativeFSLockFactory
extends FSLockFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fs;
    @NotNull
    private static final NativeFSLockFactory INSTANCE = new NativeFSLockFactory(null, 1, null);
    @NotNull
    private static final Set<String> LOCK_HELD = new LinkedHashSet();

    public NativeFSLockFactory(@NotNull FileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.fs = fs;
    }

    public /* synthetic */ NativeFSLockFactory(FileSystem fileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileSystem = FileSystem.SYSTEM;
        }
        this(fileSystem);
    }

    @NotNull
    public final FileSystem getFs() {
        return this.fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Lock obtainFSLock(@NotNull FSDirectory dir, @NotNull String lockName) {
        Path realPath;
        block9: {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
            Path lockDir = dir.getDirectory();
            Files.INSTANCE.createDirectories(lockDir);
            Path lockFile = Path.resolve$default((Path)lockDir, (String)lockName, (boolean)false, (int)2, null);
            IOException creationException = null;
            try {
                Files.INSTANCE.createFile(lockFile);
            }
            catch (IOException ignore) {
                creationException = ignore;
            }
            realPath = null;
            try {
                realPath = lockFile.normalized();
            }
            catch (IOException e) {
                if (creationException != null) {
                    ExceptionsKt.addSuppressed((Throwable)e, (Throwable)creationException);
                }
                throw e;
            }
            Long creationTime = Files.INSTANCE.creationTime(realPath);
            if (!LOCK_HELD.add(realPath.toString())) break block9;
            NativeFSLock lock2 = null;
            try {
                lock2 = new NativeFSLock(this.fs, realPath, creationTime);
            }
            catch (IOException ioe) {
                try {
                    throw new LockObtainFailedException("Unable to obtain lock on " + realPath + ", IOException: " + ioe.getMessage(), ioe);
                }
                catch (Throwable throwable) {
                    NativeFSLockFactory.Companion.clearLockHeld(realPath);
                    throw throwable;
                }
            }
            return lock2;
        }
        throw new LockObtainFailedException("Lock held by this virtual machine: " + realPath);
    }

    public NativeFSLockFactory() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/store/NativeFSLockFactory$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/gnit/lucenekmp/store/NativeFSLockFactory;", "getINSTANCE", "()Lorg/gnit/lucenekmp/store/NativeFSLockFactory;", "LOCK_HELD", "", "", "clearLockHeld", "", "path", "Lokio/Path;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeFSLockFactory getINSTANCE() {
            return INSTANCE;
        }

        private final void clearLockHeld(Path path) throws IOException {
            boolean remove2 = LOCK_HELD.remove(path.toString());
            if (!remove2) {
                throw new AlreadyClosedException("Lock path was cleared but never marked as held: " + path);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/store/NativeFSLockFactory$NativeFSLock;", "Lorg/gnit/lucenekmp/store/Lock;", "fs", "Lokio/FileSystem;", "path", "Lokio/Path;", "creationTime", "", "<init>", "(Lokio/FileSystem;Lokio/Path;Ljava/lang/Long;)V", "getPath", "()Lokio/Path;", "getCreationTime", "()Ljava/lang/Long;", "Ljava/lang/Long;", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "ensureValid", "", "close", "toString", "", "core"})
    public static final class NativeFSLock
    extends Lock {
        @NotNull
        private final FileSystem fs;
        @NotNull
        private final Path path;
        @Nullable
        private final Long creationTime;
        private volatile boolean closed;

        public NativeFSLock(@NotNull FileSystem fs, @NotNull Path path, @Nullable Long creationTime) {
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.fs = fs;
            this.path = path;
            this.creationTime = creationTime;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @Nullable
        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        public final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        public void ensureValid() {
            if (this.closed) {
                throw new AlreadyClosedException("Lock instance already released: " + this);
            }
            if (!LOCK_HELD.contains(this.path.toString())) {
                throw new AlreadyClosedException("Lock path unexpectedly cleared from map: " + this);
            }
            Long ctime = Files.INSTANCE.creationTime(this.path);
            if (!Intrinsics.areEqual((Object)this.creationTime, (Object)ctime)) {
                throw new AlreadyClosedException("Underlying file changed by an external force at " + ctime + ", (lock=" + this + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            try {
                this.fs.delete(this.path);
            }
            finally {
                this.closed = true;
                Companion.clearLockHeld(this.path);
            }
        }

        @NotNull
        public String toString() {
            return "NativeFSLock(path=" + this.path + ",creationTime=" + this.creationTime + ")";
        }
    }
}

