/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.gnit.lucenekmp.store.FilterIndexOutput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.RateLimiter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/store/RateLimitedIndexOutput;", "Lorg/gnit/lucenekmp/store/FilterIndexOutput;", "rateLimiter", "Lorg/gnit/lucenekmp/store/RateLimiter;", "out", "Lorg/gnit/lucenekmp/store/IndexOutput;", "<init>", "(Lorg/gnit/lucenekmp/store/RateLimiter;Lorg/gnit/lucenekmp/store/IndexOutput;)V", "bytesSinceLastPause", "", "currentMinPauseCheckBytes", "writeByte", "", "b", "", "writeBytes", "", "offset", "", "length", "writeInt", "i", "writeShort", "", "writeLong", "checkRate", "core"})
public final class RateLimitedIndexOutput
extends FilterIndexOutput {
    @NotNull
    private final RateLimiter rateLimiter;
    private long bytesSinceLastPause;
    private long currentMinPauseCheckBytes;

    public RateLimitedIndexOutput(@NotNull RateLimiter rateLimiter, @NotNull IndexOutput out) {
        Intrinsics.checkNotNullParameter((Object)rateLimiter, (String)"rateLimiter");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super("RateLimitedIndexOutput(" + out + ")", out.getName(), out);
        this.rateLimiter = rateLimiter;
        this.currentMinPauseCheckBytes = this.rateLimiter.getMinPauseCheckBytes();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        long l = this.bytesSinceLastPause;
        this.bytesSinceLastPause = l + 1L;
        this.checkRate();
        this.getOut().writeByte(b);
    }

    @Override
    public void writeBytes(@NotNull byte[] b, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.bytesSinceLastPause += (long)length;
        this.checkRate();
        this.getOut().writeBytes(b, offset, length);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.bytesSinceLastPause += 4L;
        this.checkRate();
        this.getOut().writeInt(i);
    }

    @Override
    public void writeShort(short i) throws IOException {
        this.bytesSinceLastPause += 2L;
        this.checkRate();
        this.getOut().writeShort(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.bytesSinceLastPause += 8L;
        this.checkRate();
        this.getOut().writeLong(i);
    }

    private final void checkRate() throws IOException {
        if (this.bytesSinceLastPause > this.currentMinPauseCheckBytes) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(this, null){
                int label;
                final /* synthetic */ RateLimitedIndexOutput this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = RateLimitedIndexOutput.access$getRateLimiter$p(this.this$0).pause(RateLimitedIndexOutput.access$getBytesSinceLastPause$p(this.this$0), (Continuation<? super Long>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Long> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            this.bytesSinceLastPause = 0L;
            this.currentMinPauseCheckBytes = this.rateLimiter.getMinPauseCheckBytes();
        }
    }

    public static final /* synthetic */ RateLimiter access$getRateLimiter$p(RateLimitedIndexOutput $this) {
        return $this.rateLimiter;
    }

    public static final /* synthetic */ long access$getBytesSinceLastPause$p(RateLimitedIndexOutput $this) {
        return $this.bytesSinceLastPause;
    }
}

