/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\u0004\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00070\u0015J$\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/Accountables;", "", "<init>", "()V", "toString", "", "a", "Lorg/gnit/lucenekmp/util/Accountable;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "dest", "depth", "", "namedAccountable", "description", "in", "bytes", "", "namedAccountables", "", "prefix", "", "children", "core"})
public final class Accountables {
    @NotNull
    public static final Accountables INSTANCE = new Accountables();

    private Accountables() {
    }

    @NotNull
    public final String toString(@NotNull Accountable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        StringBuilder sb = new StringBuilder();
        this.toString(sb, a, 0);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final StringBuilder toString(StringBuilder dest, Accountable a, int depth) {
        for (int i = 1; i < depth; ++i) {
            dest.append("    ");
        }
        if (depth > 0) {
            dest.append("|-- ");
        }
        dest.append(a.toString());
        dest.append(": ");
        dest.append(RamUsageEstimator.Companion.humanReadableUnits(a.ramBytesUsed()));
        dest.append('\n');
        for (Accountable child : a.getChildResources()) {
            this.toString(dest, child, depth + 1);
        }
        return dest;
    }

    @NotNull
    public final Accountable namedAccountable(@NotNull String description, @NotNull Accountable in) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        return INSTANCE.namedAccountable(description + " [" + in + "]", in.getChildResources(), in.ramBytesUsed());
    }

    @NotNull
    public final Accountable namedAccountable(@NotNull String description, long bytes) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return this.namedAccountable(description, new ArrayList(), bytes);
    }

    @NotNull
    public final Collection<Accountable> namedAccountables(@NotNull String prefix, @NotNull Map<?, ? extends Accountable> in) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(in, (String)"in");
        List resources = new ArrayList();
        for (Map.Entry<?, Accountable> kv : in.entrySet()) {
            String string = prefix + " '" + kv.getKey() + "'";
            Accountable accountable = kv.getValue();
            Intrinsics.checkNotNull((Object)accountable);
            resources.add(this.namedAccountable(string, accountable));
        }
        CollectionsKt.sortWith((List)resources, (arg_0, arg_1) -> Accountables.namedAccountables$lambda$1(Accountables::namedAccountables$lambda$0, arg_0, arg_1));
        return resources;
    }

    @NotNull
    public final Accountable namedAccountable(@NotNull String description, @NotNull Collection<Accountable> children, long bytes) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new Accountable(bytes, children, description){
            final /* synthetic */ long $bytes;
            final /* synthetic */ Collection<Accountable> $children;
            final /* synthetic */ String $description;
            {
                this.$bytes = $bytes;
                this.$children = $children;
                this.$description = $description;
            }

            public long ramBytesUsed() {
                return this.$bytes;
            }

            public Collection<Accountable> getChildResources() {
                return this.$children;
            }

            public String toString() {
                return this.$description;
            }
        };
    }

    private static final int namedAccountables$lambda$0(Accountable o1, Accountable o2) {
        return o1.toString().compareTo(o2.toString());
    }

    private static final int namedAccountables$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

