/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.TimSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B9\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0014J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0014J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0014J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0014R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\"\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/ArrayTimSorter;", "T", "Lorg/gnit/lucenekmp/util/TimSorter;", "arr", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "maxTempSlots", "", "<init>", "([Ljava/lang/Object;Ljava/util/Comparator;I)V", "[Ljava/lang/Object;", "tmp", "compare", "i", "j", "swap", "", "copy", "src", "dest", "save", "start", "len", "restore", "compareSaved", "core"})
public final class ArrayTimSorter<T>
extends TimSorter {
    @NotNull
    private final T[] arr;
    @NotNull
    private final Comparator<? super T> comparator;
    @Nullable
    private final T[] tmp;

    public ArrayTimSorter(@NotNull T[] arr, @NotNull Comparator<? super T> comparator2, int maxTempSlots) {
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
        super(maxTempSlots);
        this.arr = arr;
        this.comparator = comparator2;
        if (maxTempSlots > 0) {
            Object[] tmp = new Object[maxTempSlots];
            this.tmp = tmp;
        } else {
            this.tmp = null;
        }
    }

    @Override
    protected int compare(int i, int j) {
        return this.comparator.compare(this.arr[i], this.arr[j]);
    }

    @Override
    protected void swap(int i, int j) {
        ArrayUtil.Companion.swap(this.arr, i, j);
    }

    @Override
    protected void copy(int src, int dest) {
        this.arr[dest] = this.arr[src];
    }

    @Override
    protected void save(int start, int len) {
        Intrinsics.checkNotNull(this.tmp);
        ArraysKt.copyInto((Object[])this.arr, (Object[])this.tmp, (int)0, (int)start, (int)(start + len));
    }

    @Override
    protected void restore(int src, int dest) {
        Intrinsics.checkNotNull(this.tmp);
        this.arr[dest] = this.tmp[src];
    }

    @Override
    protected int compareSaved(int i, int j) {
        Intrinsics.checkNotNull(this.tmp);
        return this.comparator.compare(this.tmp[i], this.arr[j]);
    }
}

