/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.util.ArrayIntroSorter;
import org.gnit.lucenekmp.util.ArrayTimSorter;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.gnit.lucenekmp.util.Constants;
import org.gnit.lucenekmp.util.IntroSelector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/gnit/lucenekmp/util/ArrayUtil;", "", "<init>", "()V", "Companion", "core"})
public final class ArrayUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u0017\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001UB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J2\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0006\b\u0000\u0010\u0016\u0018\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0019J8\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00160\u0015\"\u0006\b\u0000\u0010\u0016\u0018\u00012\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u0005H\u0087\b\u00a2\u0006\u0004\b\u001a\u0010\u0019J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0006\b\u0000\u0010\u0016\u0018\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u001cJ2\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0006\b\u0000\u0010\u0016\u0018\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u0010\u001d\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0019J8\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00160\u0015\"\u0006\b\u0000\u0010\u0016\u0018\u00012\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00160\u00152\u0006\u0010\u001d\u001a\u00020\u0005H\u0087\b\u00a2\u0006\u0004\b\u001e\u0010\u0019J\u0016\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u001fJ\u0016\u0010\u0014\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020 J\u0016\u0010\u0014\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!J\u0016\u0010\u0014\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0005J\u001e\u0010#\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0005J\u0016\u0010&\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\"J\u0016\u0010\u0014\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u0005J\u0016\u0010&\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020'J\u0016\u0010\u0014\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u0005J\u0016\u0010&\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020(J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ\u001e\u0010)\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005J/\u0010,\u001a\u00020-\"\u0004\b\u0000\u0010\u00162\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005\u00a2\u0006\u0002\u00101JK\u00102\u001a\u00020-\"\u0004\b\u0000\u0010\u00162\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u001a\u00106\u001a\u0016\u0012\u0006\b\u0000\u0012\u0002H\u001607j\n\u0012\u0006\b\u0000\u0012\u0002H\u0016`8\u00a2\u0006\u0002\u00109J;\u00102\u001a\u00020-\"\u0004\b\u0000\u0010\u00162\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u001a\u00106\u001a\u0016\u0012\u0006\b\u0000\u0012\u0002H\u001607j\n\u0012\u0006\b\u0000\u0012\u0002H\u0016`8\u00a2\u0006\u0002\u0010:J9\u00102\u001a\u00020-\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160;2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005\u00a2\u0006\u0002\u0010<J)\u00102\u001a\u00020-\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160;2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\u00a2\u0006\u0002\u0010=JK\u0010>\u001a\u00020-\"\u0004\b\u0000\u0010\u00162\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u001a\u00106\u001a\u0016\u0012\u0006\b\u0000\u0012\u0002H\u001607j\n\u0012\u0006\b\u0000\u0012\u0002H\u0016`8\u00a2\u0006\u0002\u00109J;\u0010>\u001a\u00020-\"\u0004\b\u0000\u0010\u00162\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u001a\u00106\u001a\u0016\u0012\u0006\b\u0000\u0012\u0002H\u001607j\n\u0012\u0006\b\u0000\u0012\u0002H\u0016`8\u00a2\u0006\u0002\u0010:J9\u0010>\u001a\u00020-\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160;2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005\u00a2\u0006\u0002\u0010<J)\u0010>\u001a\u00020-\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160;2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\u00a2\u0006\u0002\u0010=JS\u0010?\u001a\u00020-\"\u0004\b\u0000\u0010\u00162\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u00052\u001a\u0010C\u001a\u0016\u0012\u0006\b\u0000\u0012\u0002H\u001607j\n\u0012\u0006\b\u0000\u0012\u0002H\u0016`8\u00a2\u0006\u0002\u0010DJ\u000e\u0010E\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020(J\u001e\u0010F\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020(2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ\u001e\u0010F\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u001fJ\u001e\u0010F\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\"J\u001e\u0010F\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020'J\u001e\u0010F\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020 J\u001e\u0010F\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!J\u001e\u0010F\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005J*\u0010E\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0006\b\u0000\u0010\u0016\u0018\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u001cJ:\u0010F\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0006\b\u0000\u0010\u0016\u0018\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0005J&\u0010K\u001a\u00020\u00052\u0006\u00103\u001a\u00020(2\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020(2\u0006\u0010N\u001a\u00020\u0005J&\u0010O\u001a\u00020\u00052\u0006\u00103\u001a\u00020(2\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020(2\u0006\u0010N\u001a\u00020\u0005J6\u0010P\u001a\u00020\u00052\u0006\u00103\u001a\u00020(2\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u00052\u0006\u0010M\u001a\u00020(2\u0006\u0010S\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006V"}, d2={"Lorg/gnit/lucenekmp/util/ArrayUtil$Companion;", "", "<init>", "()V", "MAX_ARRAY_LENGTH", "", "getMAX_ARRAY_LENGTH", "()I", "parseInt", "chars", "", "offset", "len", "radix", "parse", "negative", "", "oversize", "minTargetSize", "bytesPerElement", "growExact", "", "T", "array", "newLength", "([Ljava/lang/Object;I)[Ljava/lang/Object;", "growExactNullable", "grow", "([Ljava/lang/Object;)[Ljava/lang/Object;", "minSize", "growNullable", "", "", "", "", "growInRange", "minLength", "maxLength", "growNoCopy", "", "", "hashCode", "start", "end", "swap", "", "arr", "i", "j", "([Ljava/lang/Object;II)V", "introSort", "a", "fromIndex", "toIndex", "comp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "([Ljava/lang/Object;IILjava/util/Comparator;)V", "([Ljava/lang/Object;Ljava/util/Comparator;)V", "", "([Ljava/lang/Comparable;II)V", "([Ljava/lang/Comparable;)V", "timSort", "select", "from", "to", "k", "comparator", "([Ljava/lang/Object;IIILjava/util/Comparator;)V", "copyArray", "copyOfSubArray", "([Ljava/lang/Object;II)[Ljava/lang/Object;", "getUnsignedComparator", "Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "numBytes", "compareUnsigned8", "aOffset", "b", "bOffset", "compareUnsigned4", "compareUnsigned", "aFromIndex", "aToIndex", "bFromIndex", "bToIndex", "ByteArrayComparator", "core"})
    @SourceDebugExtension(value={"SMAP\nArrayUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n*L\n1#1,878:1\n207#1,5:880\n180#1,5:885\n212#1:890\n180#1,5:891\n189#1,2:896\n759#1,2:900\n1#2:879\n8#3,2:898\n*S KotlinDebug\n*F\n+ 1 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n199#1:880,5\n199#1:885,5\n199#1:890\n211#1:891,5\n221#1:896,2\n748#1:900,2\n318#1:898,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_ARRAY_LENGTH() {
            return MAX_ARRAY_LENGTH;
        }

        public final int parseInt(@NotNull char[] chars, int offset, int len) throws NumberFormatException {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            return this.parseInt(chars, offset, len, 10);
        }

        public final int parseInt(@NotNull char[] chars, int offset, int len, int radix) throws NumberFormatException {
            boolean negative;
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            int offset2 = offset;
            int len2 = len;
            if (radix < 2 || radix > 36) {
                throw new NumberFormatException();
            }
            int i = 0;
            if (len2 == 0) {
                throw new NumberFormatException("chars length is 0");
            }
            boolean bl = negative = chars[offset2 + i] == '-';
            if (negative && ++i == len2) {
                throw new NumberFormatException("can't convert to an int");
            }
            if (negative) {
                ++offset2;
                --len2;
            }
            return this.parse(chars, offset2, len2, radix, negative);
        }

        private final int parse(char[] chars, int offset, int len, int radix, boolean negative) throws NumberFormatException {
            int max = Integer.MIN_VALUE / radix;
            int result = 0;
            for (int i = 0; i < len; ++i) {
                int digit;
                Integer n = CharsKt.digitToIntOrNull((char)chars[i + offset], (int)radix);
                int n2 = digit = n != null ? n : -1;
                if (digit == -1) {
                    throw new NumberFormatException("Unable to parse");
                }
                if (max > result) {
                    throw new NumberFormatException("Unable to parse");
                }
                int next = result * radix - digit;
                if (next > result) {
                    throw new NumberFormatException("Unable to parse");
                }
                result = next;
            }
            if (!negative && (result = -result) < 0) {
                throw new NumberFormatException("Unable to parse");
            }
            return result;
        }

        public final int oversize(int minTargetSize, int bytesPerElement) {
            int n;
            int newSize;
            if (!(minTargetSize >= 0)) {
                boolean $i$a$-require-ArrayUtil$Companion$oversize$32 = false;
                String $i$a$-require-ArrayUtil$Companion$oversize$32 = "invalid array size " + minTargetSize;
                throw new IllegalArgumentException($i$a$-require-ArrayUtil$Companion$oversize$32.toString());
            }
            if (minTargetSize == 0) {
                return 0;
            }
            if (!(minTargetSize <= this.getMAX_ARRAY_LENGTH())) {
                boolean $i$a$-require-ArrayUtil$Companion$oversize$42 = false;
                String $i$a$-require-ArrayUtil$Companion$oversize$42 = "requested array size " + minTargetSize + " exceeds maximum array in java (" + Companion.getMAX_ARRAY_LENGTH() + ")";
                throw new IllegalArgumentException($i$a$-require-ArrayUtil$Companion$oversize$42.toString());
            }
            int extra = minTargetSize >> 3;
            if (extra < 3) {
                extra = 3;
            }
            if ((newSize = minTargetSize + extra) + 7 < 0 || newSize + 7 > this.getMAX_ARRAY_LENGTH()) {
                return this.getMAX_ARRAY_LENGTH();
            }
            if (Constants.INSTANCE.getJRE_IS_64BIT()) {
                switch (bytesPerElement) {
                    case 4: {
                        n = newSize + 1 & 0x7FFFFFFE;
                        break;
                    }
                    case 2: {
                        n = newSize + 3 & 0x7FFFFFFC;
                        break;
                    }
                    case 1: {
                        n = newSize + 7 & 0x7FFFFFF8;
                        break;
                    }
                    case 8: {
                        n = newSize;
                        break;
                    }
                    default: {
                        n = newSize;
                        break;
                    }
                }
            } else {
                switch (bytesPerElement) {
                    case 1: {
                        n = (newSize + 3 & 0x7FFFFFF8) + 4;
                        break;
                    }
                    case 2: {
                        n = (newSize + 1 & 0x7FFFFFFC) + 2;
                        break;
                    }
                    case 4: {
                        n = (newSize & 0x7FFFFFFE) + 1;
                        break;
                    }
                    case 8: {
                        n = newSize;
                        break;
                    }
                    default: {
                        n = newSize;
                    }
                }
            }
            return n;
        }

        public final /* synthetic */ <T> T[] growExact(T[] array, int newLength) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            boolean $i$f$growExact = false;
            if (newLength < array.length) {
                throw new IndexOutOfBoundsException("newLength (" + newLength + ") < array.size (" + array.length + ")");
            }
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] objectArray = new Object[newLength];
            for (int i = 0; i < newLength; ++i) {
                int n = i;
                objectArray[n] = n < array.length ? array[n] : null;
            }
            Object[] newArray = objectArray;
            return newArray;
        }

        @JvmName(name="growExactNullable")
        public final /* synthetic */ <T> T[] growExactNullable(T[] array, int newLength) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            boolean $i$f$growExactNullable = false;
            if (newLength < array.length) {
                throw new IndexOutOfBoundsException("newLength (" + newLength + ") < array.size (" + array.length + ")");
            }
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] objectArray = new Object[newLength];
            for (int i = 0; i < newLength; ++i) {
                int n = i;
                objectArray[n] = n < array.length ? array[n] : null;
            }
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T> T[] grow(T[] array) {
            Object[] objectArray;
            void array$iv;
            Intrinsics.checkNotNullParameter(array, (String)"array");
            boolean $i$f$grow = false;
            Companion companion = this;
            T[] TArray = array;
            int minSize$iv = 1 + array.length;
            boolean $i$f$grow2 = false;
            if (minSize$iv < 0) {
                throw new Exception("size must be positive (got " + minSize$iv + "): likely integer overflow?");
            }
            if (((void)array$iv).length < minSize$iv) {
                Object[] newArray$iv$iv;
                void array$iv$iv;
                void this_$iv;
                int newLength$iv = this_$iv.oversize(minSize$iv, 4);
                void var8_8 = this_$iv;
                void var9_9 = array$iv;
                int newLength$iv$iv = newLength$iv;
                boolean $i$f$growExact = false;
                if (newLength$iv$iv < ((void)array$iv$iv).length) {
                    throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
                }
                Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
                Object[] objectArray2 = new Object[newLength$iv$iv];
                for (int i = 0; i < newLength$iv$iv; ++i) {
                    int n = i;
                    objectArray2[n] = n < ((void)array$iv$iv).length ? array$iv$iv[n] : null;
                }
                objectArray = newArray$iv$iv = objectArray2;
            } else {
                objectArray = array$iv;
            }
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T> T[] grow(T[] array, int minSize) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            boolean $i$f$grow = false;
            if (minSize < 0) {
                throw new Exception("size must be positive (got " + minSize + "): likely integer overflow?");
            }
            if (array.length < minSize) {
                void array$iv;
                int newLength = this.oversize(minSize, 4);
                Companion companion = this;
                T[] TArray = array;
                int newLength$iv = newLength;
                boolean $i$f$growExact = false;
                if (newLength$iv < ((void)array$iv).length) {
                    throw new IndexOutOfBoundsException("newLength (" + newLength$iv + ") < array.size (" + ((void)array$iv).length + ")");
                }
                Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
                Object[] objectArray = new Object[newLength$iv];
                for (int i = 0; i < newLength$iv; ++i) {
                    int n = i;
                    objectArray[n] = n < ((void)array$iv).length ? array$iv[n] : null;
                }
                Object[] newArray$iv = objectArray;
                return newArray$iv;
            }
            return array;
        }

        /*
         * WARNING - void declaration
         */
        @JvmName(name="growNullable")
        public final /* synthetic */ <T> T[] growNullable(T[] array, int minSize) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            boolean $i$f$growNullable = false;
            if (minSize < 0) {
                throw new Exception("size must be positive (got " + minSize + "): likely integer overflow?");
            }
            if (array.length < minSize) {
                void array$iv;
                int newLength = this.oversize(minSize, 4);
                Companion companion = this;
                T[] TArray = array;
                int newLength$iv = newLength;
                boolean $i$f$growExactNullable = false;
                if (newLength$iv < ((void)array$iv).length) {
                    throw new IndexOutOfBoundsException("newLength (" + newLength$iv + ") < array.size (" + ((void)array$iv).length + ")");
                }
                Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
                Object[] objectArray = new Object[newLength$iv];
                for (int i = 0; i < newLength$iv; ++i) {
                    int n = i;
                    objectArray[n] = n < ((void)array$iv).length ? array$iv[n] : null;
                }
                return objectArray;
            }
            return array;
        }

        @NotNull
        public final short[] growExact(@NotNull short[] array, int newLength) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            short[] copy = new short[newLength];
            ArraysKt.copyInto((short[])array, (short[])copy, (int)0, (int)0, (int)array.length);
            return copy;
        }

        @NotNull
        public final short[] grow(@NotNull short[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (minSize < 0) {
                throw new IllegalArgumentException("size must be positive (got " + minSize + "): likely integer overflow?");
            }
            return array.length < minSize ? this.growExact(array, this.oversize(minSize, 2)) : array;
        }

        @NotNull
        public final short[] grow(@NotNull short[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.grow(array, 1 + array.length);
        }

        @NotNull
        public final float[] growExact(@NotNull float[] array, int newLength) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            float[] copy = new float[newLength];
            ArraysKt.copyInto((float[])array, (float[])copy, (int)0, (int)0, (int)array.length);
            return copy;
        }

        @NotNull
        public final float[] grow(@NotNull float[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (minSize < 0) {
                throw new Exception("size must be positive (got " + minSize + "): likely integer overflow?");
            }
            if (array.length < minSize) {
                float[] copy = new float[this.oversize(minSize, 4)];
                ArraysKt.copyInto((float[])array, (float[])copy, (int)0, (int)0, (int)array.length);
                return copy;
            }
            return array;
        }

        @NotNull
        public final float[] grow(@NotNull float[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.grow(array, 1 + array.length);
        }

        @NotNull
        public final double[] growExact(@NotNull double[] array, int newLength) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            double[] copy = new double[newLength];
            ArraysKt.copyInto((double[])array, (double[])copy, (int)0, (int)0, (int)array.length);
            return copy;
        }

        @NotNull
        public final double[] grow(@NotNull double[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(minSize >= 0)) {
                boolean bl = false;
                String string = "size must be positive (got " + minSize + "): likely integer overflow?";
                throw new IllegalArgumentException(string.toString());
            }
            return array.length < minSize ? this.growExact(array, this.oversize(minSize, 8)) : array;
        }

        @NotNull
        public final double[] grow(@NotNull double[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.grow(array, 1 + array.length);
        }

        @NotNull
        public final int[] growExact(@NotNull int[] array, int newLength) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int[] copy = new int[newLength];
            ArraysKt.copyInto((int[])array, (int[])copy, (int)0, (int)0, (int)array.length);
            return copy;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final int[] growInRange(@NotNull int[] array, int minLength, int maxLength) {
            void condition$iv;
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            boolean bl = minLength >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && condition$iv == false) {
                boolean bl2 = false;
                String string = "length must be positive (got " + minLength + "): likely integer overflow?";
                throw new AssertionError((Object)string);
            }
            if (!(minLength <= maxLength)) {
                boolean bl3 = false;
                String string = "requested minimum array length " + minLength + " is larger than requested maximum array length " + maxLength;
                throw new IllegalArgumentException(string.toString());
            }
            if (array.length >= minLength) {
                return array;
            }
            int potentialLength = this.oversize(minLength, 4);
            return this.growExact(array, Math.min(maxLength, potentialLength));
        }

        @NotNull
        public final int[] grow(@NotNull int[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.growInRange(array, minSize, Integer.MAX_VALUE);
        }

        @NotNull
        public final int[] growNoCopy(@NotNull int[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(minSize >= 0)) {
                boolean bl = false;
                String string = "size must be positive (got " + minSize + "): likely integer overflow?";
                throw new IllegalArgumentException(string.toString());
            }
            return array.length < minSize ? new int[this.oversize(minSize, 4)] : array;
        }

        @NotNull
        public final int[] grow(@NotNull int[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.grow(array, 1 + array.length);
        }

        @NotNull
        public final long[] growExact(@NotNull long[] array, int newLength) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            long[] copy = new long[newLength];
            ArraysKt.copyInto((long[])array, (long[])copy, (int)0, (int)0, (int)array.length);
            return copy;
        }

        @NotNull
        public final long[] grow(@NotNull long[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(minSize >= 0)) {
                boolean bl = false;
                String string = "size must be positive (got " + minSize + "): likely integer overflow?";
                throw new IllegalArgumentException(string.toString());
            }
            return array.length < minSize ? this.growExact(array, this.oversize(minSize, 8)) : array;
        }

        @NotNull
        public final long[] growNoCopy(@NotNull long[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(minSize >= 0)) {
                boolean bl = false;
                String string = "size must be positive (got " + minSize + "): likely integer overflow?";
                throw new IllegalArgumentException(string.toString());
            }
            return array.length < minSize ? new long[this.oversize(minSize, 8)] : array;
        }

        @NotNull
        public final long[] grow(@NotNull long[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.grow(array, 1 + array.length);
        }

        @NotNull
        public final byte[] growExact(@NotNull byte[] array, int newLength) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            byte[] copy = new byte[newLength];
            ArraysKt.copyInto((byte[])array, (byte[])copy, (int)0, (int)0, (int)array.length);
            return copy;
        }

        @NotNull
        public final byte[] grow(@NotNull byte[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(minSize >= 0)) {
                boolean bl = false;
                String string = "size must be positive (got " + minSize + "): likely integer overflow?";
                throw new IllegalArgumentException(string.toString());
            }
            return array.length < minSize ? this.growExact(array, this.oversize(minSize, 1)) : array;
        }

        @NotNull
        public final byte[] growNoCopy(@NotNull byte[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(minSize >= 0)) {
                boolean bl = false;
                String string = "size must be positive (got " + minSize + "): likely integer overflow?";
                throw new IllegalArgumentException(string.toString());
            }
            return array.length < minSize ? new byte[this.oversize(minSize, 1)] : array;
        }

        @NotNull
        public final byte[] grow(@NotNull byte[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.grow(array, 1 + array.length);
        }

        @NotNull
        public final char[] growExact(@NotNull char[] array, int newLength) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            char[] copy = new char[newLength];
            ArraysKt.copyInto((char[])array, (char[])copy, (int)0, (int)0, (int)array.length);
            return copy;
        }

        @NotNull
        public final char[] grow(@NotNull char[] array, int minSize) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(minSize >= 0)) {
                boolean bl = false;
                String string = "size must be positive (got " + minSize + "): likely integer overflow?";
                throw new IllegalArgumentException(string.toString());
            }
            return array.length < minSize ? this.growExact(array, this.oversize(minSize, 2)) : array;
        }

        @NotNull
        public final char[] grow(@NotNull char[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.grow(array, 1 + array.length);
        }

        public final int hashCode(@NotNull char[] array, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int code = 0;
            int i = end - 1;
            if (start <= i) {
                while (true) {
                    code = code * 31 + array[i];
                    if (i == start) break;
                    --i;
                }
            }
            return code;
        }

        public final <T> void swap(@NotNull T[] arr, int i, int j) {
            Intrinsics.checkNotNullParameter(arr, (String)"arr");
            T tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
        }

        public final <T> void introSort(@NotNull T[] a, int fromIndex, int toIndex, @NotNull Comparator<? super T> comp) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            if (toIndex - fromIndex <= 1) {
                return;
            }
            new ArrayIntroSorter<T>(a, comp).sort(fromIndex, toIndex);
        }

        public final <T> void introSort(@NotNull T[] a, @NotNull Comparator<? super T> comp) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            this.introSort(a, 0, a.length, comp);
        }

        public final <T extends Comparable<? super T>> void introSort(@NotNull T[] a, int fromIndex, int toIndex) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            if (toIndex - fromIndex <= 1) {
                return;
            }
            this.introSort(a, fromIndex, toIndex, ComparisonsKt.naturalOrder());
        }

        public final <T extends Comparable<? super T>> void introSort(@NotNull T[] a) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            this.introSort((Comparable[])a, 0, a.length);
        }

        public final <T> void timSort(@NotNull T[] a, int fromIndex, int toIndex, @NotNull Comparator<? super T> comp) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            if (toIndex - fromIndex <= 1) {
                return;
            }
            new ArrayTimSorter<T>(a, comp, a.length / 64).sort(fromIndex, toIndex);
        }

        public final <T> void timSort(@NotNull T[] a, @NotNull Comparator<? super T> comp) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            this.timSort(a, 0, a.length, comp);
        }

        public final <T extends Comparable<? super T>> void timSort(@NotNull T[] a, int fromIndex, int toIndex) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            if (toIndex - fromIndex <= 1) {
                return;
            }
            this.timSort(a, fromIndex, toIndex, ComparisonsKt.naturalOrder());
        }

        public final <T extends Comparable<? super T>> void timSort(@NotNull T[] a) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            this.timSort((Comparable[])a, 0, a.length);
        }

        public final <T> void select(@NotNull T[] arr, int from, int to, int k, @NotNull Comparator<? super T> comparator2) {
            Intrinsics.checkNotNullParameter(arr, (String)"arr");
            Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
            new IntroSelector(arr, comparator2){
                private T pivot;
                final /* synthetic */ T[] $arr;
                final /* synthetic */ Comparator<? super T> $comparator;
                {
                    this.$arr = $arr;
                    this.$comparator = $comparator;
                }

                public final T getPivot() {
                    return this.pivot;
                }

                public final void setPivot(T t) {
                    this.pivot = t;
                }

                protected void swap(int i, int j) {
                    ArrayUtil.Companion.swap(this.$arr, i, j);
                }

                protected void setPivot(int i) {
                    this.pivot = this.$arr[i];
                }

                protected int comparePivot(int j) {
                    T t = this.pivot;
                    Intrinsics.checkNotNull(t);
                    return this.$comparator.compare(t, this.$arr[j]);
                }
            }.select(from, to, k);
        }

        @NotNull
        public final byte[] copyArray(@NotNull byte[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.copyOfSubArray(array, 0, array.length);
        }

        @NotNull
        public final byte[] copyOfSubArray(@NotNull byte[] array, int from, int to) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            byte[] copy = new byte[to - from];
            ArraysKt.copyInto((byte[])array, (byte[])copy, (int)0, (int)from, (int)to);
            return copy;
        }

        @NotNull
        public final char[] copyArray(@NotNull char[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.copyOfSubArray(array, 0, array.length);
        }

        @NotNull
        public final char[] copyOfSubArray(@NotNull char[] array, int from, int to) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            char[] copy = new char[to - from];
            ArraysKt.copyInto((char[])array, (char[])copy, (int)0, (int)from, (int)to);
            return copy;
        }

        @NotNull
        public final short[] copyArray(@NotNull short[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.copyOfSubArray(array, 0, array.length);
        }

        @NotNull
        public final short[] copyOfSubArray(@NotNull short[] array, int from, int to) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            short[] copy = new short[to - from];
            ArraysKt.copyInto((short[])array, (short[])copy, (int)0, (int)from, (int)to);
            return copy;
        }

        @NotNull
        public final int[] copyArray(@NotNull int[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.copyOfSubArray(array, 0, array.length);
        }

        @NotNull
        public final int[] copyOfSubArray(@NotNull int[] array, int from, int to) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int[] copy = new int[to - from];
            ArraysKt.copyInto((int[])array, (int[])copy, (int)0, (int)from, (int)to);
            return copy;
        }

        @NotNull
        public final long[] copyArray(@NotNull long[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.copyOfSubArray(array, 0, array.length);
        }

        @NotNull
        public final long[] copyOfSubArray(@NotNull long[] array, int from, int to) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            long[] copy = new long[to - from];
            ArraysKt.copyInto((long[])array, (long[])copy, (int)0, (int)from, (int)to);
            return copy;
        }

        @NotNull
        public final float[] copyArray(@NotNull float[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.copyOfSubArray(array, 0, array.length);
        }

        @NotNull
        public final float[] copyOfSubArray(@NotNull float[] array, int from, int to) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            float[] copy = new float[to - from];
            ArraysKt.copyInto((float[])array, (float[])copy, (int)0, (int)from, (int)to);
            return copy;
        }

        @NotNull
        public final double[] copyArray(@NotNull double[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return this.copyOfSubArray(array, 0, array.length);
        }

        @NotNull
        public final double[] copyOfSubArray(@NotNull double[] array, int from, int to) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            double[] copy = new double[to - from];
            ArraysKt.copyInto((double[])array, (double[])copy, (int)0, (int)from, (int)to);
            return copy;
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T> T[] copyArray(T[] array) {
            void from$iv;
            Intrinsics.checkNotNullParameter(array, (String)"array");
            boolean $i$f$copyArray = false;
            Companion companion = this;
            T[] TArray = array;
            boolean bl = false;
            int to$iv = array.length;
            boolean $i$f$copyOfSubArray = false;
            int subLength$iv = to$iv - from$iv;
            int n = 0;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T");
            Object[] objectArray = new Object[subLength$iv];
            while (n < subLength$iv) {
                void array$iv;
                int n2 = n++;
                objectArray[n2] = array$iv[from$iv + n2];
            }
            return objectArray;
        }

        public final /* synthetic */ <T> T[] copyOfSubArray(T[] array, int from, int to) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            boolean $i$f$copyOfSubArray = false;
            int subLength = to - from;
            int n = 0;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T");
            Object[] objectArray = new Object[subLength];
            while (n < subLength) {
                int n2 = n++;
                objectArray[n2] = array[from + n2];
            }
            return objectArray;
        }

        @NotNull
        public final ByteArrayComparator getUnsignedComparator(int numBytes) {
            return switch (numBytes) {
                case 8 -> Companion::getUnsignedComparator$lambda$11;
                case 4 -> Companion::getUnsignedComparator$lambda$12;
                default -> (arg_0, arg_1, arg_2, arg_3) -> Companion.getUnsignedComparator$lambda$13(numBytes, arg_0, arg_1, arg_2, arg_3);
            };
        }

        public final int compareUnsigned8(@NotNull byte[] a, int aOffset, @NotNull byte[] b, int bOffset) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            long valueA = ULong.constructor-impl((long)BitUtilKt.getLongBE(a, aOffset));
            long valueB = ULong.constructor-impl((long)BitUtilKt.getLongBE(b, bOffset));
            return Long.compareUnsigned(valueA, valueB);
        }

        public final int compareUnsigned4(@NotNull byte[] a, int aOffset, @NotNull byte[] b, int bOffset) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int intA = UInt.constructor-impl((int)BitUtilKt.getIntBE(a, aOffset));
            int intB = UInt.constructor-impl((int)BitUtilKt.getIntBE(b, bOffset));
            return Integer.compareUnsigned(intA, intB);
        }

        public final int compareUnsigned(@NotNull byte[] a, int aFromIndex, int aToIndex, @NotNull byte[] b, int bFromIndex, int bToIndex) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Arrays.INSTANCE.rangeCheck(a.length, aFromIndex, aToIndex);
            Arrays.INSTANCE.rangeCheck(b.length, bFromIndex, bToIndex);
            int aLength = aToIndex - aFromIndex;
            int bLength = bToIndex - bFromIndex;
            int len = Math.min(aLength, bLength);
            int i = Arrays.INSTANCE.mismatch(a, aFromIndex, b, bFromIndex, len);
            return i >= 0 ? Intrinsics.compare((int)(UByte.constructor-impl((byte)a[aFromIndex + i]) & 0xFF), (int)(UByte.constructor-impl((byte)b[bFromIndex + i]) & 0xFF)) : aLength - bLength;
        }

        private static final int getUnsignedComparator$lambda$11(byte[] a, int aOffset, byte[] b, int bOffset) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return Companion.compareUnsigned8(a, aOffset, b, bOffset);
        }

        private static final int getUnsignedComparator$lambda$12(byte[] a, int aOffset, byte[] b, int bOffset) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return Companion.compareUnsigned4(a, aOffset, b, bOffset);
        }

        private static final int getUnsignedComparator$lambda$13(int $numBytes, byte[] a, int aOffset, byte[] b, int bOffset) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return Companion.compareUnsigned(a, aOffset, aOffset + $numBytes, b, bOffset, bOffset + $numBytes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003H&\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "", "compare", "", "a", "", "aI", "b", "bI", "core"})
        public static interface ByteArrayComparator {
            public int compare(@NotNull byte[] var1, int var2, @NotNull byte[] var3, int var4);
        }
    }
}

