/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.SparseFixedBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\fH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/util/BitSetIterator;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "bits", "Lorg/gnit/lucenekmp/util/BitSet;", "cost", "", "<init>", "(Lorg/gnit/lucenekmp/util/BitSet;J)V", "bitSet", "getBitSet", "()Lorg/gnit/lucenekmp/util/BitSet;", "length", "", "doc", "docID", "setDocId", "", "docId", "nextDoc", "advance", "target", "intoBitSet", "upTo", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "offset", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBitSetIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitSetIterator.kt\norg/gnit/lucenekmp/util/BitSetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class BitSetIterator
extends DocIdSetIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitSet bitSet;
    private final int length;
    private final long cost;
    private int doc;

    public BitSetIterator(@NotNull BitSet bits, long cost) {
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        this.doc = -1;
        if (!(cost >= 0L)) {
            boolean bl = false;
            String string = "cost must be >= 0, got " + cost;
            throw new IllegalArgumentException(string.toString());
        }
        this.bitSet = bits;
        this.length = bits.length();
        this.cost = cost;
    }

    @NotNull
    public final BitSet getBitSet() {
        return this.bitSet;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    public final void setDocId(int docId) {
        this.doc = docId;
    }

    @Override
    public int nextDoc() {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) {
        int n;
        if (target >= this.length) {
            int n2;
            int it = n2 = Integer.MAX_VALUE;
            boolean bl = false;
            this.doc = it;
            return n2;
        }
        int it = n = this.bitSet.nextSetBit(target);
        boolean bl = false;
        this.doc = it;
        return n;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public void intoBitSet(int upTo, @NotNull FixedBitSet bitSet, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
        if (upTo > this.doc && this.bitSet instanceof FixedBitSet) {
            int actualUpto = Math.min(upTo, this.length);
            actualUpto = Math.min(actualUpto, offset + bitSet.length());
            FixedBitSet.Companion.orRange((FixedBitSet)this.bitSet, this.doc, bitSet, this.doc - offset, actualUpto - this.doc);
            this.advance(actualUpto);
        }
        super.intoBitSet(upTo, bitSet, offset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/BitSetIterator$Companion;", "", "<init>", "()V", "getBitSet", "T", "Lorg/gnit/lucenekmp/util/BitSet;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "clazz", "Lkotlin/reflect/KClass;", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;Lkotlin/reflect/KClass;)Lorg/gnit/lucenekmp/util/BitSet;", "getFixedBitSetOrNull", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "getSparseFixedBitSetOrNull", "Lorg/gnit/lucenekmp/util/SparseFixedBitSet;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final <T extends BitSet> T getBitSet(DocIdSetIterator iterator2, KClass<? extends T> clazz) {
            if (iterator2 instanceof BitSetIterator) {
                BitSet bitSet = ((BitSetIterator)iterator2).getBitSet();
                if (bitSet == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                BitSet bits = bitSet;
                if (clazz.isInstance((Object)bits)) {
                    return (T)((BitSet)KClasses.cast(clazz, (Object)bits));
                }
            }
            return null;
        }

        @Nullable
        public final FixedBitSet getFixedBitSetOrNull(@NotNull DocIdSetIterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            return (FixedBitSet)this.getBitSet(iterator2, Reflection.getOrCreateKotlinClass(FixedBitSet.class));
        }

        @Nullable
        public final SparseFixedBitSet getSparseFixedBitSetOrNull(@NotNull DocIdSetIterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            return (SparseFixedBitSet)this.getBitSet(iterator2, Reflection.getOrCreateKotlinClass(SparseFixedBitSet.class));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

