/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.UnicodeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000e\n\u0002\u0010\r\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rJ\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0000J&\u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\tH\u0007J \u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\u0005J\u0006\u0010\u001f\u001a\u00020\u0005J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010#\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "", "<init>", "()V", "ref", "Lorg/gnit/lucenekmp/util/BytesRef;", "bytes", "", "length", "", "setLength", "", "byteAt", "", "offset", "setByteAt", "b", "grow", "capacity", "growNoCopy", "append", "off", "len", "builder", "clear", "copyBytes", "copyChars", "text", "", "", "get", "toBytesRef", "equals", "", "obj", "hashCode", "core"})
@SourceDebugExtension(value={"SMAP\nBytesRefBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytesRefBuilder.kt\norg/gnit/lucenekmp/util/BytesRefBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class BytesRefBuilder {
    @NotNull
    private final BytesRef ref = new BytesRef();

    @NotNull
    public final byte[] bytes() {
        return this.ref.getBytes();
    }

    public final int length() {
        return this.ref.getLength();
    }

    public final void setLength(int length) {
        this.ref.setLength(length);
    }

    public final byte byteAt(int offset) {
        return this.ref.getBytes()[offset];
    }

    public final void setByteAt(int offset, byte b) {
        this.ref.getBytes()[offset] = b;
    }

    public final void grow(int capacity) {
        this.ref.setBytes(ArrayUtil.Companion.grow(this.ref.getBytes(), capacity));
    }

    public final void growNoCopy(int capacity) {
        this.ref.setBytes(ArrayUtil.Companion.growNoCopy(this.ref.getBytes(), capacity));
    }

    public final void append(byte b) {
        this.grow(this.ref.getLength() + 1);
        byte[] byArray = this.ref.getBytes();
        BytesRef bytesRef = this.ref;
        int n = bytesRef.getLength();
        bytesRef.setLength(n + 1);
        byArray[n] = b;
    }

    public final void append(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.grow(this.ref.getLength() + len);
        ArraysKt.copyInto((byte[])b, (byte[])this.ref.getBytes(), (int)this.ref.getLength(), (int)off, (int)(off + len));
        BytesRef bytesRef = this.ref;
        bytesRef.setLength(bytesRef.getLength() + len);
    }

    public final void append(@NotNull BytesRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.append(ref.getBytes(), ref.getOffset(), ref.getLength());
    }

    public final void append(@NotNull BytesRefBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.append(builder.get());
    }

    public final void clear() {
        this.setLength(0);
    }

    public final void copyBytes(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(this.ref.getOffset() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.ref.setLength(len);
        this.growNoCopy(len);
        ArraysKt.copyInto((byte[])b, (byte[])this.ref.getBytes(), (int)0, (int)off, (int)(off + len));
    }

    public final void copyBytes(@NotNull BytesRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.copyBytes(ref.getBytes(), ref.getOffset(), ref.getLength());
    }

    public final void copyBytes(@NotNull BytesRefBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.copyBytes(builder.get());
    }

    @JvmOverloads
    public final void copyChars(@Nullable CharSequence text, int off, int len) {
        this.growNoCopy(UnicodeUtil.INSTANCE.maxUTF8Length(len));
        CharSequence charSequence = text;
        Intrinsics.checkNotNull((Object)charSequence);
        this.ref.setLength(UnicodeUtil.INSTANCE.UTF16toUTF8(charSequence, off, len, this.ref.getBytes()));
    }

    public static /* synthetic */ void copyChars$default(BytesRefBuilder bytesRefBuilder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            CharSequence charSequence2 = charSequence;
            Intrinsics.checkNotNull((Object)charSequence2);
            n2 = charSequence2.length();
        }
        bytesRefBuilder.copyChars(charSequence, n, n2);
    }

    public final void copyChars(@Nullable char[] text, int off, int len) {
        this.growNoCopy(UnicodeUtil.INSTANCE.maxUTF8Length(len));
        Intrinsics.checkNotNull((Object)text);
        this.ref.setLength(UnicodeUtil.INSTANCE.UTF16toUTF8(text, off, len, this.ref.getBytes()));
    }

    @NotNull
    public final BytesRef get() {
        if (!(this.ref.getOffset() == 0)) {
            boolean bl = false;
            String string = "Modifying the offset of the returned ref is illegal";
            throw new IllegalArgumentException(string.toString());
        }
        return this.ref;
    }

    @NotNull
    public final BytesRef toBytesRef() {
        return new BytesRef(ArrayUtil.Companion.copyOfSubArray(this.ref.getBytes(), 0, this.ref.getLength()));
    }

    public boolean equals(@Nullable Object obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @JvmOverloads
    public final void copyChars(@Nullable CharSequence text, int off) {
        BytesRefBuilder.copyChars$default(this, text, off, 0, 4, null);
    }

    @JvmOverloads
    public final void copyChars(@Nullable CharSequence text) {
        BytesRefBuilder.copyChars$default(this, text, 0, 0, 6, null);
    }
}

