/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBlockPool;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.BytesRefComparator;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.Sorter;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.StringSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 :2\u00020\u0001:\u0004789:B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0013\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u0006\u0010\u001c\u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\u000fJ\u0006\u0010\"\u001a\u00020\u000fJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0012\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020$H\u0007J\u0006\u0010)\u001a\u00020'J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u001eJ\u000e\u0010,\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u001eJ\u0010\u0010-\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u001eH\u0002J\u000e\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005J\u0018\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020$H\u0002J\u0006\u00103\u001a\u00020'J\u000e\u00104\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J\b\u00105\u001a\u000206H\u0016R\u0011\u0010\u0002\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefHash;", "Lorg/gnit/lucenekmp/util/Accountable;", "pool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "capacity", "", "bytesStartArray", "Lorg/gnit/lucenekmp/util/BytesRefHash$BytesStartArray;", "<init>", "(Lorg/gnit/lucenekmp/util/ByteBlockPool;ILorg/gnit/lucenekmp/util/BytesRefHash$BytesStartArray;)V", "(Lorg/gnit/lucenekmp/util/ByteBlockPool;)V", "Lorg/gnit/lucenekmp/util/BytesRefBlockPool;", "getPool", "()Lorg/gnit/lucenekmp/util/BytesRefBlockPool;", "bytesStart", "", "getBytesStart", "()[I", "setBytesStart", "([I)V", "hashSize", "hashHalfSize", "hashMask", "count", "lastCount", "ids", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "size", "get", "Lorg/gnit/lucenekmp/util/BytesRef;", "bytesID", "ref", "compact", "sort", "shrink", "", "targetSize", "clear", "", "resetPool", "close", "add", "bytes", "find", "findHash", "addByPoolOffset", "offset", "rehash", "newSize", "hashOnData", "reinit", "byteStart", "ramBytesUsed", "", "MaxBytesLengthExceededException", "BytesStartArray", "DirectBytesStartArray", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBytesRefHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytesRefHash.kt\norg/gnit/lucenekmp/util/BytesRefHash\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,503:1\n1#2:504\n*E\n"})
public final class BytesRefHash
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BytesRefBlockPool pool;
    @Nullable
    private int[] bytesStart;
    private int hashSize;
    private int hashHalfSize;
    private int hashMask;
    private int count;
    private int lastCount;
    @Nullable
    private int[] ids;
    @NotNull
    private final BytesStartArray bytesStartArray;
    @NotNull
    private final Counter bytesUsed;
    private static final long BASE_RAM_BYTES;
    public static final int DEFAULT_CAPACITY = 16;

    public BytesRefHash(@NotNull ByteBlockPool pool, int capacity, @NotNull BytesStartArray bytesStartArray) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)bytesStartArray, (String)"bytesStartArray");
        this.lastCount = -1;
        this.hashSize = capacity;
        this.hashHalfSize = this.hashSize >> 1;
        this.hashMask = this.hashSize - 1;
        this.pool = new BytesRefBlockPool(pool);
        this.ids = new int[this.hashSize];
        Intrinsics.checkNotNull((Object)this.ids);
        Arrays.INSTANCE.fill(this.ids, -1);
        this.bytesStartArray = bytesStartArray;
        this.bytesStart = bytesStartArray.init();
        Counter bytesUsed = bytesStartArray.bytesUsed();
        Counter counter = bytesUsed;
        if (counter == null) {
            counter = Counter.Companion.newCounter$default(Counter.Companion, false, 1, null);
        }
        this.bytesUsed = counter;
        Counter counter2 = bytesUsed;
        Intrinsics.checkNotNull((Object)counter2);
        counter2.addAndGet((long)this.hashSize * 4L);
    }

    @NotNull
    public final BytesRefBlockPool getPool() {
        return this.pool;
    }

    @Nullable
    public final int[] getBytesStart() {
        return this.bytesStart;
    }

    public final void setBytesStart(@Nullable int[] nArray) {
        this.bytesStart = nArray;
    }

    @JvmOverloads
    public BytesRefHash(@NotNull ByteBlockPool pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this(pool, 16, new DirectBytesStartArray(16, null, 2, null));
    }

    public /* synthetic */ BytesRefHash(ByteBlockPool byteBlockPool, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            byteBlockPool = new ByteBlockPool(new ByteBlockPool.DirectAllocator());
        }
        this(byteBlockPool);
    }

    public final int size() {
        return this.count;
    }

    @NotNull
    public final BytesRef get(int bytesID, @NotNull BytesRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        int[] nArray = this.bytesStart;
        if (this.bytesStart == null) {
            boolean $i$a$-checkNotNull-BytesRefHash$get$22 = false;
            String $i$a$-checkNotNull-BytesRefHash$get$22 = "bytesStart is null - not initialized";
            throw new IllegalStateException($i$a$-checkNotNull-BytesRefHash$get$22.toString());
        }
        Intrinsics.checkNotNull((Object)this.bytesStart);
        if (!(bytesID < this.bytesStart.length)) {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)this.bytesStart);
            String string = "bytesID exceeds byteStart len: " + this.bytesStart.length;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.bytesStart);
        this.pool.fillBytesRef(ref, this.bytesStart[bytesID]);
        return ref;
    }

    @NotNull
    public final int[] compact() {
        int[] nArray = this.bytesStart;
        if (this.bytesStart == null) {
            boolean $i$a$-checkNotNull-BytesRefHash$compact$22 = false;
            String $i$a$-checkNotNull-BytesRefHash$compact$22 = "bytesStart is null - not initialized";
            throw new IllegalStateException($i$a$-checkNotNull-BytesRefHash$compact$22.toString());
        }
        int upto = 0;
        int n = this.hashSize;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.ids);
            if (this.ids[i] == -1) continue;
            if (upto < i) {
                Intrinsics.checkNotNull((Object)this.ids);
                Intrinsics.checkNotNull((Object)this.ids);
                this.ids[upto] = this.ids[i];
                Intrinsics.checkNotNull((Object)this.ids);
                this.ids[i] = -1;
            }
            ++upto;
        }
        if (!(upto == this.count)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.lastCount = this.count;
        Intrinsics.checkNotNull((Object)this.ids);
        return this.ids;
    }

    @NotNull
    public final int[] sort() {
        int[] compact = this.compact();
        if (!(this.count * 2 <= compact.length)) {
            boolean bl = false;
            String string = "We need load factor <= 0.5f to speed up this sort";
            throw new IllegalArgumentException(string.toString());
        }
        int tmpOffset = this.count;
        BytesRefComparator bytesRefComparator = BytesRefComparator.Companion.getNATURAL();
        new StringSorter(compact, tmpOffset, this, bytesRefComparator){
            final /* synthetic */ int[] $compact;
            final /* synthetic */ int $tmpOffset;
            final /* synthetic */ BytesRefHash this$0;
            {
                this.$compact = $compact;
                this.$tmpOffset = $tmpOffset;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected Sorter radixSorter(BytesRefComparator cmp) {
                Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
                return new StringSorter.MSBStringRadixSorter(this, cmp, this.$compact, this.$tmpOffset){
                    private int k;
                    final /* synthetic */ int[] $compact;
                    final /* synthetic */ int $tmpOffset;
                    {
                        this.$compact = $compact;
                        this.$tmpOffset = $tmpOffset;
                        super($receiver, $cmp);
                    }

                    protected void buildHistogram(int prefixCommonBucket, int prefixCommonLen, int from, int to, int k, int[] histogram) {
                        Intrinsics.checkNotNullParameter((Object)histogram, (String)"histogram");
                        this.k = k;
                        histogram[prefixCommonBucket] = prefixCommonLen;
                        Arrays.INSTANCE.fill(this.$compact, this.$tmpOffset + from - prefixCommonLen, this.$tmpOffset + from, prefixCommonBucket);
                        for (int i = from; i < to; ++i) {
                            int b;
                            this.$compact[this.$tmpOffset + i] = b = this.getBucket(i, k);
                            int n = histogram[b];
                            histogram[b] = n + 1;
                        }
                    }

                    protected boolean shouldFallback(int from, int to, int l) {
                        return to - from <= 50 || l >= 8;
                    }

                    public final void swapBucketCache(int i, int j) {
                        this.swap(i, j);
                        int tmp = this.$compact[this.$tmpOffset + i];
                        this.$compact[this.$tmpOffset + i] = this.$compact[this.$tmpOffset + j];
                        this.$compact[this.$tmpOffset + j] = tmp;
                    }

                    protected void reorder(int from, int to, int[] startOffsets, int[] endOffsets, int k) {
                        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
                        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
                        if (!(this.k == k)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        for (int i = 0; i < 257; ++i) {
                            int limit = endOffsets[i];
                            int h1 = startOffsets[i];
                            while (h1 < limit) {
                                int b = this.$compact[this.$tmpOffset + from + h1];
                                int n = startOffsets[b];
                                startOffsets[b] = n + 1;
                                int h2 = n;
                                this.swapBucketCache(from + h1, from + h2);
                                h1 = startOffsets[i];
                            }
                        }
                    }
                };
            }

            protected void swap(int i, int j) {
                int tmp = this.$compact[i];
                this.$compact[i] = this.$compact[j];
                this.$compact[j] = tmp;
            }

            protected void get(BytesRefBuilder builder, BytesRef result, int i) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                BytesRefBlockPool bytesRefBlockPool = this.this$0.getPool();
                int[] nArray = this.this$0.getBytesStart();
                Intrinsics.checkNotNull((Object)nArray);
                bytesRefBlockPool.fillBytesRef(result, nArray[this.$compact[i]]);
            }
        }.sort(0, this.count);
        Arrays.INSTANCE.fill(compact, tmpOffset, compact.length, -1);
        return compact;
    }

    private final boolean shrink(int targetSize) {
        int newSize;
        for (newSize = this.hashSize; newSize >= 8 && newSize / 4 > targetSize; newSize /= 2) {
        }
        if (newSize != this.hashSize) {
            this.bytesUsed.addAndGet((long)4 * -((long)(this.hashSize - newSize)));
            this.hashSize = newSize;
            this.ids = new int[this.hashSize];
            Intrinsics.checkNotNull((Object)this.ids);
            Arrays.INSTANCE.fill(this.ids, -1);
            this.hashHalfSize = newSize / 2;
            this.hashMask = newSize - 1;
            return true;
        }
        return false;
    }

    @JvmOverloads
    public final void clear(boolean resetPool) {
        this.lastCount = this.count;
        this.count = 0;
        if (resetPool) {
            this.pool.reset();
        }
        this.bytesStart = this.bytesStartArray.clear();
        if (this.lastCount != -1 && this.shrink(this.lastCount)) {
            return;
        }
        Intrinsics.checkNotNull((Object)this.ids);
        Arrays.INSTANCE.fill(this.ids, -1);
    }

    public static /* synthetic */ void clear$default(BytesRefHash bytesRefHash, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        bytesRefHash.clear(bl);
    }

    public final void close() {
        this.clear(true);
        this.ids = null;
        this.bytesUsed.addAndGet((long)4 * -((long)this.hashSize));
    }

    public final int add(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int[] nArray = this.bytesStart;
        if (this.bytesStart == null) {
            boolean $i$a$-checkNotNull-BytesRefHash$add$22 = false;
            String $i$a$-checkNotNull-BytesRefHash$add$22 = "Bytesstart is null - not initialized";
            throw new IllegalStateException($i$a$-checkNotNull-BytesRefHash$add$22.toString());
        }
        int hashPos = this.findHash(bytes);
        Intrinsics.checkNotNull((Object)this.ids);
        int e = this.ids[hashPos];
        if (e == -1) {
            Intrinsics.checkNotNull((Object)this.bytesStart);
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                Intrinsics.checkNotNull((Object)this.bytesStart);
                if (!(this.count < this.bytesStart.length + 1)) {
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)this.bytesStart);
                    String string = "count: " + this.count + " len: " + this.bytesStart.length;
                    throw new IllegalArgumentException(string.toString());
                }
            }
            Intrinsics.checkNotNull((Object)this.bytesStart);
            this.bytesStart[this.count] = this.pool.addBytesRef(bytes);
            int n = this.count;
            this.count = n + 1;
            e = n;
            Intrinsics.checkNotNull((Object)this.ids);
            if (!(this.ids[hashPos] == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.ids);
            this.ids[hashPos] = e;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, true);
            }
            return e;
        }
        return -(e + 1);
    }

    public final int find(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNull((Object)this.ids);
        return this.ids[this.findHash(bytes)];
    }

    private final int findHash(BytesRef bytes) {
        int[] nArray = this.bytesStart;
        if (this.bytesStart == null) {
            boolean $i$a$-checkNotNull-BytesRefHash$findHash$22 = false;
            String $i$a$-checkNotNull-BytesRefHash$findHash$22 = "bytesStart is null - not initialized";
            throw new IllegalStateException($i$a$-checkNotNull-BytesRefHash$findHash$22.toString());
        }
        int code = Companion.doHash(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
        int hashPos = code & this.hashMask;
        Intrinsics.checkNotNull((Object)this.ids);
        int e = this.ids[hashPos];
        if (e != -1) {
            Intrinsics.checkNotNull((Object)this.bytesStart);
            if (!this.pool.equals(this.bytesStart[e], bytes)) {
                do {
                    hashPos = ++code & this.hashMask;
                    Intrinsics.checkNotNull((Object)this.ids);
                    e = this.ids[hashPos];
                    if (e == -1) break;
                    Intrinsics.checkNotNull((Object)this.bytesStart);
                } while (!this.pool.equals(this.bytesStart[e], bytes));
            }
        }
        return hashPos;
    }

    public final int addByPoolOffset(int offset) {
        int[] nArray = this.bytesStart;
        if (this.bytesStart == null) {
            boolean $i$a$-checkNotNull-BytesRefHash$addByPoolOffset$22 = false;
            String $i$a$-checkNotNull-BytesRefHash$addByPoolOffset$22 = "Bytesstart is null - not initialized";
            throw new IllegalStateException($i$a$-checkNotNull-BytesRefHash$addByPoolOffset$22.toString());
        }
        int code = offset;
        int hashPos = offset & this.hashMask;
        Intrinsics.checkNotNull((Object)this.ids);
        int e = this.ids[hashPos];
        if (e != -1) {
            Intrinsics.checkNotNull((Object)this.bytesStart);
            if (this.bytesStart[e] != offset) {
                do {
                    hashPos = ++code & this.hashMask;
                    Intrinsics.checkNotNull((Object)this.ids);
                    e = this.ids[hashPos];
                    if (e == -1) break;
                    Intrinsics.checkNotNull((Object)this.bytesStart);
                } while (this.bytesStart[e] != offset);
            }
        }
        if (e == -1) {
            Intrinsics.checkNotNull((Object)this.bytesStart);
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                Intrinsics.checkNotNull((Object)this.bytesStart);
                if (!(this.count < this.bytesStart.length + 1)) {
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)this.bytesStart);
                    String string = "count: " + this.count + " len: " + this.bytesStart.length;
                    throw new IllegalArgumentException(string.toString());
                }
            }
            int n = this.count;
            this.count = n + 1;
            e = n;
            Intrinsics.checkNotNull((Object)this.bytesStart);
            this.bytesStart[e] = offset;
            Intrinsics.checkNotNull((Object)this.ids);
            if (!(this.ids[hashPos] == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.ids);
            this.ids[hashPos] = e;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, false);
            }
            return e;
        }
        return -(e + 1);
    }

    private final void rehash(int newSize, boolean hashOnData) {
        int newMask = newSize - 1;
        this.bytesUsed.addAndGet((long)4 * (long)newSize);
        int[] newHash = new int[newSize];
        Arrays.INSTANCE.fill(newHash, -1);
        int n = this.hashSize;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.ids);
            int e0 = this.ids[i];
            if (e0 == -1) continue;
            int code = 0;
            if (hashOnData) {
                Intrinsics.checkNotNull((Object)this.bytesStart);
                code = this.pool.hash(this.bytesStart[e0]);
            } else {
                Intrinsics.checkNotNull((Object)this.bytesStart);
                code = this.bytesStart[e0];
            }
            int hashPos = code & newMask;
            if (!(hashPos >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (newHash[hashPos] != -1) {
                while (newHash[hashPos = ++code & newMask] != -1) {
                }
            }
            newHash[hashPos] = e0;
        }
        this.hashMask = newMask;
        long l = 4;
        Intrinsics.checkNotNull((Object)this.ids);
        this.bytesUsed.addAndGet(l * -((long)this.ids.length));
        this.ids = newHash;
        this.hashSize = newSize;
        this.hashHalfSize = newSize / 2;
    }

    public final void reinit() {
        if (this.bytesStart == null) {
            this.bytesStart = this.bytesStartArray.init();
        }
        if (this.ids == null) {
            this.ids = new int[this.hashSize];
            this.bytesUsed.addAndGet((long)4 * (long)this.hashSize);
        }
    }

    public final int byteStart(int bytesID) {
        int[] nArray = this.bytesStart;
        if (this.bytesStart == null) {
            boolean $i$a$-checkNotNull-BytesRefHash$byteStart$22 = false;
            String $i$a$-checkNotNull-BytesRefHash$byteStart$22 = "bytesStart is null - not initialized";
            throw new IllegalStateException($i$a$-checkNotNull-BytesRefHash$byteStart$22.toString());
        }
        if (!(bytesID >= 0 && bytesID < this.count)) {
            boolean bl = false;
            Integer n = bytesID;
            throw new IllegalArgumentException(((Object)n).toString());
        }
        Intrinsics.checkNotNull((Object)this.bytesStart);
        return this.bytesStart[bytesID];
    }

    @Override
    public long ramBytesUsed() {
        long size2 = BASE_RAM_BYTES + RamUsageEstimator.Companion.sizeOfObject(this.bytesStart) + RamUsageEstimator.Companion.sizeOfObject(this.ids) + RamUsageEstimator.Companion.sizeOfObject(this.pool);
        return size2;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public BytesRefHash() {
        this((ByteBlockPool)null, 1, (DefaultConstructorMarker)null);
    }

    @JvmOverloads
    public final void clear() {
        BytesRefHash.clear$default(this, false, 1, null);
    }

    static {
        long l = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(BytesRefHash.class));
        Integer n = RamUsageEstimator.Companion.getPrimitiveSizes().get(Reflection.getOrCreateKotlinClass(Long.TYPE));
        Intrinsics.checkNotNull((Object)n);
        BASE_RAM_BYTES = l + ((Number)n).longValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H&J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefHash$BytesStartArray;", "", "<init>", "()V", "init", "", "grow", "clear", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "core"})
    public static abstract class BytesStartArray {
        @Nullable
        public abstract int[] init();

        @Nullable
        public abstract int[] grow();

        @Nullable
        public abstract int[] clear();

        @NotNull
        public abstract Counter bytesUsed();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefHash$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "DEFAULT_CAPACITY", "", "doHash", "bytes", "", "offset", "length", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int doHash(@Nullable byte[] bytes, int offset, int length) {
            Intrinsics.checkNotNull((Object)bytes);
            return StringHelper.INSTANCE.murmurhash3_x86_32(bytes, offset, length, StringHelper.INSTANCE.getGOOD_FAST_HASH_SEED());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefHash$DirectBytesStartArray;", "Lorg/gnit/lucenekmp/util/BytesRefHash$BytesStartArray;", "initSize", "", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(ILorg/gnit/lucenekmp/util/Counter;)V", "getInitSize", "()I", "bytesStart", "", "clear", "grow", "init", "core"})
    @SourceDebugExtension(value={"SMAP\nBytesRefHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytesRefHash.kt\norg/gnit/lucenekmp/util/BytesRefHash$DirectBytesStartArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,503:1\n1#2:504\n*E\n"})
    public static class DirectBytesStartArray
    extends BytesStartArray {
        private final int initSize;
        @NotNull
        private final Counter bytesUsed;
        @Nullable
        private int[] bytesStart;

        @JvmOverloads
        public DirectBytesStartArray(int initSize, @NotNull Counter bytesUsed) {
            Intrinsics.checkNotNullParameter((Object)bytesUsed, (String)"bytesUsed");
            this.initSize = initSize;
            this.bytesUsed = bytesUsed;
            this.bytesStart = new int[0];
        }

        public /* synthetic */ DirectBytesStartArray(int n, Counter counter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                counter = Counter.Companion.newCounter$default(Counter.Companion, false, 1, null);
            }
            this(n, counter);
        }

        protected final int getInitSize() {
            return this.initSize;
        }

        @Override
        @Nullable
        public int[] clear() {
            int[] nArray;
            int[] it = nArray = null;
            boolean bl = false;
            this.bytesStart = it;
            return nArray;
        }

        @Override
        @NotNull
        public int[] grow() {
            int[] nArray;
            int[] nArray2 = this.bytesStart;
            if (this.bytesStart == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.bytesStart);
            Intrinsics.checkNotNull((Object)this.bytesStart);
            int[] it = nArray = ArrayUtil.Companion.grow(this.bytesStart, this.bytesStart.length + 1);
            boolean bl = false;
            this.bytesStart = it;
            return nArray;
        }

        @Override
        @NotNull
        public int[] init() {
            int[] nArray;
            int[] it = nArray = new int[ArrayUtil.Companion.oversize(this.initSize, 4)];
            boolean bl = false;
            this.bytesStart = it;
            return nArray;
        }

        @Override
        @NotNull
        public Counter bytesUsed() {
            return this.bytesUsed;
        }

        @JvmOverloads
        public DirectBytesStartArray(int initSize) {
            this(initSize, null, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefHash$MaxBytesLengthExceededException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "core"})
    public static final class MaxBytesLengthExceededException
    extends RuntimeException {
        public MaxBytesLengthExceededException(@Nullable String message) {
            super(message);
        }
    }
}

