/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Comparator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.StringExtKt;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\r\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0002,-B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B'\b\u0017\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0000H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000J\u0011\u0010#\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002J\b\u0010$\u001a\u00020\u000eH\u0016J\u0015\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0007R\u0011\u0010*\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/util/CharsRef;", "", "", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "capacity", "", "<init>", "(I)V", "chars", "", "offset", "length", "([CII)V", "string", "", "(Ljava/lang/String;)V", "getChars", "()[C", "setChars", "([C)V", "getOffset", "()I", "setOffset", "getLength", "setLength", "get", "", "index", "clone", "hashCode", "equals", "", "other", "", "charsEquals", "compareTo", "toString", "charAt", "chatAtKt", "subSequence", "start", "end", "isValid", "()Z", "UTF16SortedAsUTF8Comparator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCharsRef.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharsRef.kt\norg/gnit/lucenekmp/util/CharsRef\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class CharsRef
implements Comparable<CharsRef>,
CharSequence,
Cloneable<CharsRef> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private char[] chars;
    private int offset;
    private int length;
    @NotNull
    private static final char[] EMPTY_CHARS = new char[0];
    @NotNull
    private static final Comparator<CharsRef> utf16SortedAsUTF8SortOrder = new UTF16SortedAsUTF8Comparator();

    @NotNull
    public final char[] getChars() {
        return this.chars;
    }

    public final void setChars(@NotNull char[] cArray) {
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"<set-?>");
        this.chars = cArray;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public char get(int index) {
        throw new UnsupportedOperationException("get() is not supported. Use charAt() instead.");
    }

    public CharsRef(int capacity) {
        this.chars = new char[capacity];
    }

    @JvmOverloads
    public CharsRef(@NotNull char[] chars, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        this.chars = chars;
        this.offset = offset;
        this.setLength(length);
        if (!this.isValid()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ CharsRef(char[] cArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            cArray = EMPTY_CHARS;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(cArray, n, n2);
    }

    public CharsRef(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this.chars = cArray;
        this.offset = 0;
        this.setLength(this.chars.length);
    }

    @Override
    @NotNull
    public CharsRef clone() {
        return new CharsRef(this.chars, this.offset, this.length());
    }

    public int hashCode() {
        return Companion.stringHashCode(this.chars, this.offset, this.length());
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof CharsRef) {
            return this.charsEquals((CharsRef)other);
        }
        return false;
    }

    public final boolean charsEquals(@NotNull CharsRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Arrays.INSTANCE.equals(this.chars, this.offset, this.offset + this.length(), other.chars, other.offset, other.offset + other.length());
    }

    @Override
    public int compareTo(@NotNull CharsRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Arrays.INSTANCE.compare(this.chars, this.offset, this.offset + this.length(), other.chars, other.offset, other.offset + other.length());
    }

    @Override
    @NotNull
    public String toString() {
        return StringExtKt.fromCharArray(StringCompanionObject.INSTANCE, this.chars, this.offset, this.length());
    }

    @JvmName(name="chatAtKt")
    public final char chatAtKt(int index) {
        Objects.INSTANCE.checkIndex(index, this.length());
        return this.chars[this.offset + index];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        Objects.INSTANCE.checkFromToIndex(start, end, this.length());
        return new CharsRef(this.chars, this.offset + start, end - start);
    }

    public final boolean isValid() {
        char[] cArray = this.chars;
        if (this.chars == null) {
            boolean $i$a$-checkNotNull-CharsRef$isValid$22 = false;
            String $i$a$-checkNotNull-CharsRef$isValid$22 = "chars is null";
            throw new IllegalStateException($i$a$-checkNotNull-CharsRef$isValid$22.toString());
        }
        if (!(this.length() >= 0)) {
            boolean $i$a$-check-CharsRef$isValid$82 = false;
            String $i$a$-check-CharsRef$isValid$82 = "length is negative: " + this.length();
            throw new IllegalStateException($i$a$-check-CharsRef$isValid$82.toString());
        }
        if (!(this.length() <= this.chars.length)) {
            boolean $i$a$-check-CharsRef$isValid$92 = false;
            String $i$a$-check-CharsRef$isValid$92 = "length is out of bounds: " + this.length() + ",chars.length=" + this.chars.length;
            throw new IllegalStateException($i$a$-check-CharsRef$isValid$92.toString());
        }
        if (!(this.offset >= 0)) {
            boolean $i$a$-check-CharsRef$isValid$102 = false;
            String $i$a$-check-CharsRef$isValid$102 = "offset is negative: " + this.offset;
            throw new IllegalStateException($i$a$-check-CharsRef$isValid$102.toString());
        }
        if (!(this.offset <= this.chars.length)) {
            boolean $i$a$-check-CharsRef$isValid$112 = false;
            String $i$a$-check-CharsRef$isValid$112 = "offset out of bounds: " + this.offset + ",chars.length=" + this.chars.length;
            throw new IllegalStateException($i$a$-check-CharsRef$isValid$112.toString());
        }
        if (!(this.offset + this.length() >= 0)) {
            boolean $i$a$-check-CharsRef$isValid$122 = false;
            String $i$a$-check-CharsRef$isValid$122 = "offset+length is negative: offset=" + this.offset + ",length=" + this.length();
            throw new IllegalStateException($i$a$-check-CharsRef$isValid$122.toString());
        }
        if (!(this.offset + this.length() <= this.chars.length)) {
            boolean bl = false;
            String string = "offset+length out of bounds: offset=" + this.offset + ",length=" + this.length() + ",chars.length=" + this.chars.length;
            throw new IllegalStateException(string.toString());
        }
        return true;
    }

    @JvmOverloads
    public CharsRef(@NotNull char[] chars, int offset) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        this(chars, offset, 0, 4, null);
    }

    @JvmOverloads
    public CharsRef(@NotNull char[] chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        this(chars, 0, 0, 6, null);
    }

    @JvmOverloads
    public CharsRef() {
        this(null, 0, 0, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u00108\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0003R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/CharsRef$Companion;", "", "<init>", "()V", "EMPTY_CHARS", "", "getEMPTY_CHARS", "()[C", "stringHashCode", "", "chars", "offset", "length", "utf16SortedAsUTF8SortOrder", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/util/CharsRef;", "Lkotlin/Comparator;", "getUtf16SortedAsUTF8SortOrder$annotations", "uTF16SortedAsUTF8Comparator", "getUTF16SortedAsUTF8Comparator", "()Ljava/util/Comparator;", "deepCopyOf", "other", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final char[] getEMPTY_CHARS() {
            return EMPTY_CHARS;
        }

        public final int stringHashCode(@NotNull char[] chars, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            int end = offset + length;
            int result = 0;
            for (int i = offset; i < end; ++i) {
                result = 31 * result + chars[i];
            }
            return result;
        }

        @Deprecated(message="This comparator is only a transition mechanism")
        private static /* synthetic */ void getUtf16SortedAsUTF8SortOrder$annotations() {
        }

        @Deprecated(message="This comparator is only a transition mechanism")
        @NotNull
        public final Comparator<CharsRef> getUTF16SortedAsUTF8Comparator() {
            return utf16SortedAsUTF8SortOrder;
        }

        @NotNull
        public final CharsRef deepCopyOf(@NotNull CharsRef other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new CharsRef(ArrayUtil.Companion.copyOfSubArray(other.getChars(), other.getOffset(), other.getOffset() + other.length()), 0, other.length());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Deprecated(message="This comparator is only a transition mechanism")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0003\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/util/CharsRef$UTF16SortedAsUTF8Comparator;", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/util/CharsRef;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "a", "b", "core"})
    private static final class UTF16SortedAsUTF8Comparator
    implements Comparator<CharsRef> {
        @Override
        public int compare(@NotNull CharsRef a, @NotNull CharsRef b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int aEnd = a.getOffset() + a.length();
            int bEnd = b.getOffset() + b.length();
            int i = Arrays.INSTANCE.mismatch(a.getChars(), a.getOffset(), aEnd, b.getChars(), b.getOffset(), bEnd);
            if (i >= 0 && i < Math.min(a.length(), b.length())) {
                char aChar = a.getChars()[a.getOffset() + i];
                char bChar = b.getChars()[b.getOffset() + i];
                if (aChar >= '\ud800' && bChar >= '\ud800') {
                    aChar = aChar >= '\ue000' ? (char)(aChar - 2048) : (char)(aChar + 8192);
                    bChar = bChar >= '\ue000' ? (char)(bChar - 2048) : (char)(bChar + 8192);
                }
                return aChar - bChar;
            }
            return a.length() - b.length();
        }
    }
}

