/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.CharsRef;
import org.gnit.lucenekmp.util.UnicodeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 +2\u00060\u0001j\u0002`\u0002:\u0001+B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\fJ\u0012\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\"\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\nJ\u001e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001fJ\u001e\u0010\u0018\u001a\u00020\f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u001e\u0010\u0013\u001a\u00020\f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u0006\u0010#\u001a\u00020\u0006J\u0006\u0010$\u001a\u00020\u0006J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\nH\u0016J\u0013\u0010(\u001a\u00020)2\b\u0010\u0019\u001a\u0004\u0018\u00010*H\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/util/CharsRefBuilder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "<init>", "()V", "ref", "Lorg/gnit/lucenekmp/util/CharsRef;", "chars", "", "length", "", "setLength", "", "charAt", "", "offset", "setCharAt", "c", "clear", "append", "csq", "", "start", "end", "copyChars", "other", "grow", "newLength", "copyUTF8Bytes", "bytes", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "otherChars", "otherOffset", "otherLength", "get", "toCharsRef", "toString", "", "hashCode", "equals", "", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCharsRefBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharsRefBuilder.kt\norg/gnit/lucenekmp/util/CharsRefBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class CharsRefBuilder
implements Appendable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharsRef ref = new CharsRef(null, 0, 0, 7, null);
    @NotNull
    private static final String NULL_STRING = "null";

    @NotNull
    public final char[] chars() {
        return this.ref.getChars();
    }

    public final int length() {
        return this.ref.length();
    }

    public final void setLength(int length) {
        this.ref.setLength(length);
    }

    public final char charAt(int offset) {
        return this.ref.getChars()[offset];
    }

    public final void setCharAt(int offset, char c) {
        this.ref.getChars()[offset] = c;
    }

    public final void clear() {
        this.ref.setLength(0);
    }

    @Override
    @NotNull
    public CharsRefBuilder append(@Nullable CharSequence csq) {
        CharSequence charSequence = csq;
        if (charSequence == null) {
            charSequence = NULL_STRING;
        }
        CharSequence s = charSequence;
        return this.append(s, 0, s.length());
    }

    @Override
    @NotNull
    public CharsRefBuilder append(@Nullable CharSequence csq, int start, int end) {
        CharSequence charSequence = csq;
        if (charSequence == null) {
            charSequence = NULL_STRING;
        }
        CharSequence s = charSequence;
        this.grow(this.ref.length() + end - start);
        for (int i = start; i < end; ++i) {
            CharsRef charsRef = this.ref;
            int n = charsRef.length();
            charsRef.setLength(n + 1);
            this.setCharAt(n, s.charAt(i));
        }
        return this;
    }

    @Override
    @NotNull
    public CharsRefBuilder append(char c) {
        this.grow(this.ref.length() + 1);
        CharsRef charsRef = this.ref;
        int n = charsRef.length();
        charsRef.setLength(n + 1);
        this.setCharAt(n, c);
        return this;
    }

    public final void copyChars(@NotNull CharsRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.copyChars(other.getChars(), other.getOffset(), other.length());
    }

    public final void grow(int newLength) {
        this.ref.setChars(ArrayUtil.Companion.grow(this.ref.getChars(), newLength));
    }

    public final void copyUTF8Bytes(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.grow(length);
        this.ref.setLength(UnicodeUtil.INSTANCE.UTF8toUTF16(bytes, offset, length, this.ref.getChars()));
    }

    public final void copyUTF8Bytes(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.copyUTF8Bytes(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
    }

    public final void copyChars(@NotNull char[] otherChars, int otherOffset, int otherLength) {
        Intrinsics.checkNotNullParameter((Object)otherChars, (String)"otherChars");
        this.grow(otherLength);
        ArraysKt.copyInto((char[])otherChars, (char[])this.ref.getChars(), (int)0, (int)otherOffset, (int)(otherOffset + otherLength));
        this.ref.setLength(otherLength);
    }

    public final void append(@NotNull char[] otherChars, int otherOffset, int otherLength) {
        Intrinsics.checkNotNullParameter((Object)otherChars, (String)"otherChars");
        int newLen = this.ref.length() + otherLength;
        this.grow(newLen);
        ArraysKt.copyInto((char[])otherChars, (char[])this.ref.getChars(), (int)this.ref.length(), (int)otherOffset, (int)(otherOffset + otherLength));
        this.ref.setLength(newLen);
    }

    @NotNull
    public final CharsRef get() {
        if (!(this.ref.getOffset() == 0)) {
            boolean bl = false;
            String string = "Modifying the offset of the returned ref is illegal";
            throw new IllegalArgumentException(string.toString());
        }
        return this.ref;
    }

    @NotNull
    public final CharsRef toCharsRef() {
        return new CharsRef(ArrayUtil.Companion.copyOfSubArray(this.ref.getChars(), 0, this.ref.length()), 0, this.ref.length());
    }

    @NotNull
    public String toString() {
        return this.get().toString();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object other) {
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/CharsRefBuilder$Companion;", "", "<init>", "()V", "NULL_STRING", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

