/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.jdkport.NoSuchFileException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.util.Constants;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u000f\u0018\u0000 '2\u00020\u0001:\u0003%&'B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007J\u0014\u0010\u0012\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0007J\u0014\u0010\u001f\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u000e\u0010!\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010#\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001b\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/util/FileDeleter;", "", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "messenger", "Lkotlin/Function2;", "Lorg/gnit/lucenekmp/util/FileDeleter$MsgType;", "", "", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Lkotlin/jvm/functions/Function2;)V", "refCounts", "", "Lorg/gnit/lucenekmp/util/FileDeleter$RefCount;", "incRef", "fileNames", "", "fileName", "decRef", "", "getRefCountInternal", "initRefCount", "getRefCount", "", "allFiles", "", "getAllFiles", "()Ljava/util/Set;", "exists", "unrefedFiles", "getUnrefedFiles", "deleteFilesIfNoRef", "files", "forceDelete", "deleteFileIfNoRef", "delete", "toDelete", "MsgType", "RefCount", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFileDeleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileDeleter.kt\norg/gnit/lucenekmp/util/FileDeleter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,280:1\n1#2:281\n3#3,8:282\n3#3,8:291\n10#4:290\n10#4:299\n*S KotlinDebug\n*F\n+ 1 FileDeleter.kt\norg/gnit/lucenekmp/util/FileDeleter\n*L\n196#1:282,8\n205#1:291,8\n196#1:290\n205#1:299\n*E\n"})
public final class FileDeleter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, RefCount> refCounts;
    @NotNull
    private final Directory directory;
    @NotNull
    private final Function2<MsgType, String, Unit> messenger;
    @NotNull
    private static final RefCount ZERO_REF = new RefCount("");

    public FileDeleter(@NotNull Directory directory, @NotNull Function2<? super MsgType, ? super String, Unit> messenger) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(messenger, (String)"messenger");
        this.refCounts = new HashMap();
        this.directory = directory;
        this.messenger = messenger;
    }

    public final void incRef(@NotNull Collection<String> fileNames) {
        Intrinsics.checkNotNullParameter(fileNames, (String)"fileNames");
        for (String file : fileNames) {
            this.incRef(file);
        }
    }

    public final void incRef(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        RefCount refCount = this.getRefCountInternal(fileName);
        Intrinsics.checkNotNull((Object)refCount);
        RefCount rc = refCount;
        if (this.messenger != null) {
            this.messenger.invoke((Object)MsgType.REF, (Object)("IncRef \"" + fileName + "\": pre-incr count is " + rc.getCount()));
        }
        rc.incRef();
    }

    public final void decRef(@NotNull Collection<String> fileNames) throws IOException {
        Intrinsics.checkNotNullParameter(fileNames, (String)"fileNames");
        Set toDelete = new HashSet();
        Throwable firstThrowable = null;
        for (String fileName : fileNames) {
            try {
                if (!this.decRef(fileName)) continue;
                String string = fileName;
                Intrinsics.checkNotNull((Object)string);
                toDelete.add(string);
            }
            catch (Throwable t) {
                firstThrowable = IOUtils.INSTANCE.useOrSuppress(firstThrowable, t);
            }
        }
        try {
            this.delete(toDelete);
        }
        catch (Throwable t) {
            firstThrowable = IOUtils.INSTANCE.useOrSuppress(firstThrowable, t);
        }
        if (firstThrowable != null) {
            IOUtils.INSTANCE.rethrowAlways(firstThrowable);
            throw new KotlinNothingValueException();
        }
    }

    private final boolean decRef(String fileName) {
        RefCount refCount = this.getRefCountInternal(fileName);
        Intrinsics.checkNotNull((Object)refCount);
        RefCount rc = refCount;
        if (this.messenger != null) {
            this.messenger.invoke((Object)MsgType.REF, (Object)("DecRef \"" + fileName + "\": pre-decr count is " + rc.getCount()));
        }
        if (rc.decRef() == 0) {
            this.refCounts.remove(fileName);
            return true;
        }
        return false;
    }

    private final RefCount getRefCountInternal(String fileName) {
        return this.refCounts.computeIfAbsent(fileName, arg_0 -> FileDeleter.getRefCountInternal$lambda$1(FileDeleter::getRefCountInternal$lambda$0, arg_0));
    }

    public final void initRefCount(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.refCounts.computeIfAbsent(fileName, arg_0 -> FileDeleter.initRefCount$lambda$3(FileDeleter::initRefCount$lambda$2, arg_0));
    }

    public final int getRefCount(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        RefCount refCount = this.refCounts.get(fileName);
        if (refCount == null) {
            boolean bl = false;
            refCount = ZERO_REF;
        }
        return refCount.getCount();
    }

    @NotNull
    public final Set<String> getAllFiles() {
        return this.refCounts.keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean exists(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!this.refCounts.containsKey(fileName)) return false;
        RefCount refCount = this.refCounts.get(fileName);
        Intrinsics.checkNotNull((Object)refCount);
        if (refCount.getCount() <= 0) return false;
        return true;
    }

    @NotNull
    public final Set<String> getUnrefedFiles() {
        Set unrefed = new HashSet();
        for (Map.Entry<String, RefCount> entry : this.refCounts.entrySet()) {
            RefCount rc = entry.getValue();
            String fileName = entry.getKey();
            if (rc.getCount() != 0) continue;
            this.messenger.invoke((Object)MsgType.FILE, (Object)("removing unreferenced file \"" + fileName + "\""));
            unrefed.add(fileName);
        }
        return unrefed;
    }

    public final void deleteFilesIfNoRef(@NotNull Collection<String> files) throws IOException {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Set toDelete = new HashSet();
        for (String fileName : files) {
            if (this.exists(fileName)) continue;
            if (this.messenger != null) {
                this.messenger.invoke((Object)MsgType.FILE, (Object)("will delete new file \"" + fileName + "\""));
            }
            String string = fileName;
            Intrinsics.checkNotNull((Object)string);
            toDelete.add(string);
        }
        this.delete(toDelete);
    }

    public final void forceDelete(@NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.refCounts.remove(fileName);
        this.delete(fileName);
    }

    public final void deleteFileIfNoRef(@NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!this.exists(fileName)) {
            if (this.messenger != null) {
                this.messenger.invoke((Object)MsgType.FILE, (Object)("will delete new file \"" + fileName + "\""));
            }
            this.delete(fileName);
        }
    }

    private final void delete(Collection<String> toDelete) throws IOException {
        boolean $i$f$assert;
        boolean condition$iv;
        if (this.messenger != null) {
            this.messenger.invoke((Object)MsgType.FILE, (Object)("now delete " + toDelete.size() + " files: " + toDelete));
        }
        for (String fileName : toDelete) {
            condition$iv = !this.exists(fileName);
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            if (!StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null)) continue;
            this.delete(fileName);
        }
        for (String fileName : toDelete) {
            condition$iv = !this.exists(fileName);
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            if (StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null)) continue;
            this.delete(fileName);
        }
    }

    private final void delete(String fileName) throws IOException {
        block4: {
            try {
                this.directory.deleteFile(fileName);
            }
            catch (NoSuchFileException e) {
                if (!Constants.INSTANCE.getWINDOWS()) {
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                if (Constants.INSTANCE.getWINDOWS()) break block4;
                throw e;
            }
        }
    }

    private static final RefCount getRefCountInternal$lambda$0(String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new RefCount(fileName);
    }

    private static final RefCount getRefCountInternal$lambda$1(Function1 $tmp0, Object p0) {
        return (RefCount)$tmp0.invoke(p0);
    }

    private static final RefCount initRefCount$lambda$2(String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new RefCount(fileName);
    }

    private static final RefCount initRefCount$lambda$3(Function1 $tmp0, Object p0) {
        return (RefCount)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/FileDeleter$Companion;", "", "<init>", "()V", "ZERO_REF", "Lorg/gnit/lucenekmp/util/FileDeleter$RefCount;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/FileDeleter$MsgType;", "", "<init>", "(Ljava/lang/String;I)V", "REF", "FILE", "core"})
    public static final class MsgType
    extends Enum<MsgType> {
        public static final /* enum */ MsgType REF = new MsgType();
        public static final /* enum */ MsgType FILE = new MsgType();
        private static final /* synthetic */ MsgType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MsgType[] values() {
            return (MsgType[])$VALUES.clone();
        }

        public static MsgType valueOf(String value) {
            return Enum.valueOf(MsgType.class, value);
        }

        @NotNull
        public static EnumEntries<MsgType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = msgTypeArray = new MsgType[]{MsgType.REF, MsgType.FILE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/FileDeleter$RefCount;", "", "fileName", "", "<init>", "(Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "initDone", "", "getInitDone", "()Z", "setInitDone", "(Z)V", "count", "", "getCount", "()I", "setCount", "(I)V", "incRef", "decRef", "core"})
    @SourceDebugExtension(value={"SMAP\nFileDeleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileDeleter.kt\norg/gnit/lucenekmp/util/FileDeleter$RefCount\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n*L\n1#1,280:1\n8#2,2:281\n8#2,2:283\n*S KotlinDebug\n*F\n+ 1 FileDeleter.kt\norg/gnit/lucenekmp/util/FileDeleter$RefCount\n*L\n248#1:281,2\n261#1:283,2\n*E\n"})
    public static final class RefCount {
        @NotNull
        private final String fileName;
        private boolean initDone;
        private int count;

        public RefCount(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            this.fileName = fileName;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public final boolean getInitDone() {
            return this.initDone;
        }

        public final void setInitDone(boolean bl) {
            this.initDone = bl;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final int incRef() {
            if (!this.initDone) {
                this.initDone = true;
            } else {
                boolean condition$iv = this.count > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = ": RefCount is 0 pre-increment for file \"" + this.fileName + "\"";
                    throw new AssertionError((Object)string);
                }
            }
            ++this.count;
            return this.count;
        }

        public final int decRef() {
            boolean condition$iv = this.count > 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = ": RefCount is 0 pre-decrement for file \"" + this.fileName + "\"";
                throw new AssertionError((Object)string);
            }
            this.count += -1;
            return this.count;
        }
    }
}

