/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.DocBaseBitSetIterator;
import org.gnit.lucenekmp.util.FixedBits;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 :2\u00020\u0001:\u0001:B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0003H\u0002J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0000J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0003H\u0002J\u000e\u0010*\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"J\u000e\u0010*\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0000J\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0000H\u0002J \u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0006\u0010,\u001a\u00020\u0010J\u0016\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0003J\u0016\u0010\u0018\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0006\u00100\u001a\u00020\u0000J\u0013\u00101\u001a\u00020\u00102\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\b\u00104\u001a\u00020\u0003H\u0016J\u0006\u00105\u001a\u000206J\u0018\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/gnit/lucenekmp/util/FixedBitSet;", "Lorg/gnit/lucenekmp/util/BitSet;", "numBits", "", "<init>", "(I)V", "storedBits", "", "([JI)V", "bits", "getBits", "()[J", "numWords", "clear", "", "verifyGhostBitsClear", "", "length", "ramBytesUsed", "", "cardinality", "approximateCardinality", "get", "index", "set", "getAndSet", "getAndClear", "nextSetBit", "start", "upperBound", "nextSetBitInRange", "prevSetBit", "or", "iter", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "other", "xor", "otherBits", "otherNumWords", "intersects", "and", "otherArr", "andNot", "otherOffsetWords", "scanIsEmpty", "flip", "startIndex", "endIndex", "clone", "equals", "o", "", "hashCode", "asReadOnlyBits", "Lorg/gnit/lucenekmp/util/Bits;", "applyMask", "bitSet", "offset", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFixedBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedBitSet.kt\norg/gnit/lucenekmp/util/FixedBitSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,791:1\n1#2:792\n*E\n"})
public final class FixedBitSet
extends BitSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] bits;
    private final int numBits;
    private final int numWords;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(FixedBitSet.class));
    @NotNull
    private static final long[] ZEROES = new long[32];

    @NotNull
    public final long[] getBits() {
        return this.bits;
    }

    public FixedBitSet(int numBits) {
        this.numBits = numBits;
        this.bits = new long[Companion.bits2words(numBits)];
        this.numWords = this.bits.length;
    }

    public FixedBitSet(@NotNull long[] storedBits, int numBits) {
        Intrinsics.checkNotNullParameter((Object)storedBits, (String)"storedBits");
        this.numWords = Companion.bits2words(numBits);
        if (!(this.numWords <= storedBits.length)) {
            boolean bl = false;
            String string = "The given long array is too small  to hold " + numBits + " bits";
            throw new IllegalArgumentException(string.toString());
        }
        this.numBits = numBits;
        this.bits = storedBits;
        if (!this.verifyGhostBitsClear()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void clear() {
        ArraysKt.fill$default((long[])this.bits, (long)0L, (int)0, (int)0, (int)6, null);
    }

    private final boolean verifyGhostBitsClear() {
        int n = this.bits.length;
        for (int i = this.numWords; i < n; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        if ((this.numBits & 0x3F) == 0) {
            return true;
        }
        long mask = -1L << this.numBits;
        return (this.bits[this.numWords - 1] & mask) == 0L;
    }

    @Override
    public int length() {
        return this.numBits;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.bits);
    }

    @Override
    public int cardinality() {
        long tot = 0L;
        int n = this.numWords;
        for (int i = 0; i < n; ++i) {
            tot += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.bits[i]);
        }
        return Math.INSTANCE.toIntExact(tot);
    }

    @Override
    public int approximateCardinality() {
        int rangeLength = 16;
        int interval = 1024;
        if (this.numWords <= interval) {
            return this.cardinality();
        }
        long popCount = 0L;
        int maxWord = 0;
        while (maxWord + interval < this.numWords) {
            for (int i = 0; i < rangeLength; ++i) {
                popCount += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.bits[maxWord + i]);
            }
            maxWord += interval;
        }
        return (int)(popCount *= (long)(interval / rangeLength * this.numWords / maxWord));
    }

    @Override
    public boolean get(int index) {
        if (!(index >= 0 && index < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$get$22 = false;
            String $i$a$-require-FixedBitSet$get$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$get$22.toString());
        }
        int i = index >> 6;
        long bitmask = 1L << index;
        return (this.bits[i] & bitmask) != 0L;
    }

    @Override
    public void set(int index) {
        if (!(index >= 0 && index < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$set$22 = false;
            String $i$a$-require-FixedBitSet$set$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$set$22.toString());
        }
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        this.bits[wordNum] = this.bits[wordNum] | bitmask;
    }

    @Override
    public boolean getAndSet(int index) {
        if (!(index >= 0 && index < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$getAndSet$22 = false;
            String $i$a$-require-FixedBitSet$getAndSet$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$getAndSet$22.toString());
        }
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        this.bits[wordNum] = this.bits[wordNum] | bitmask;
        return val;
    }

    @Override
    public void clear(int index) {
        if (!(index >= 0 && index < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$clear$22 = false;
            String $i$a$-require-FixedBitSet$clear$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$clear$22.toString());
        }
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        this.bits[wordNum] = this.bits[wordNum] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final boolean getAndClear(int index) {
        if (!(index >= 0 && index < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$getAndClear$22 = false;
            String $i$a$-require-FixedBitSet$getAndClear$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$getAndClear$22.toString());
        }
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        this.bits[wordNum] = this.bits[wordNum] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    @Override
    public int nextSetBit(int index) {
        return this.nextSetBitInRange(index, this.numBits);
    }

    @Override
    public int nextSetBit(int start, int upperBound) {
        int res = this.nextSetBitInRange(start, upperBound);
        return res < upperBound ? res : Integer.MAX_VALUE;
    }

    private final int nextSetBitInRange(int start, int upperBound) {
        int limit;
        if (!(start >= 0 && start < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$nextSetBitInRange$42 = false;
            String $i$a$-require-FixedBitSet$nextSetBitInRange$42 = "index=" + start + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$nextSetBitInRange$42.toString());
        }
        if (!(start < upperBound)) {
            boolean $i$a$-require-FixedBitSet$nextSetBitInRange$52 = false;
            String $i$a$-require-FixedBitSet$nextSetBitInRange$52 = "index=" + start + ", upperBound=" + upperBound;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$nextSetBitInRange$52.toString());
        }
        if (!(upperBound <= this.numBits)) {
            boolean $i$a$-require-FixedBitSet$nextSetBitInRange$62 = false;
            String $i$a$-require-FixedBitSet$nextSetBitInRange$62 = "upperBound=" + upperBound + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$nextSetBitInRange$62.toString());
        }
        int i = start >> 6;
        long word = this.bits[i] >> start;
        if (word != 0L) {
            return start + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
        }
        int n = limit = upperBound == this.numBits ? this.numWords : Companion.bits2words(upperBound);
        while (++i < limit) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int prevSetBit(int index) {
        if (!(index >= 0 && index < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$prevSetBit$22 = false;
            String $i$a$-require-FixedBitSet$prevSetBit$22 = "index=" + index + " numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$prevSetBit$22.toString());
        }
        int i = index >> 6;
        int subIndex = index & 0x3F;
        long word = this.bits[i] << 63 - subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, word);
        }
        while (--i >= 0) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + 63 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, word);
        }
        return -1;
    }

    @Override
    public void or(@NotNull DocIdSetIterator iter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)iter, (String)"iter");
        this.checkUnpositioned(iter);
        iter.nextDoc();
        iter.intoBitSet(Integer.MAX_VALUE, this, 0);
    }

    public final void or(@NotNull FixedBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Companion.orRange(other, 0, this, 0, other.length());
    }

    public final void xor(@NotNull FixedBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.xor(other.bits, other.numWords);
    }

    public final void xor(@NotNull DocIdSetIterator iter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)iter, (String)"iter");
        this.checkUnpositioned(iter);
        FixedBitSet fixedBitSet = BitSetIterator.Companion.getFixedBitSetOrNull(iter);
        if (fixedBitSet != null) {
            FixedBitSet bits = fixedBitSet;
            this.xor(bits);
        } else {
            int doc = 0;
            while (true) {
                int n;
                int it = n = iter.nextDoc();
                boolean bl = false;
                doc = it;
                if (n >= this.numBits) break;
                this.flip(doc);
            }
        }
    }

    private final void xor(long[] otherBits, int otherNumWords) {
        if (!(otherNumWords <= this.numWords)) {
            boolean $i$a$-require-FixedBitSet$xor$32 = false;
            String $i$a$-require-FixedBitSet$xor$32 = "numWords=" + this.numWords + ", other.numWords=" + otherNumWords;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$xor$32.toString());
        }
        long[] thisBits = this.bits;
        int pos = java.lang.Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            thisBits[pos] = thisBits[pos] ^ otherBits[pos];
        }
    }

    public final boolean intersects(@NotNull FixedBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int pos = java.lang.Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            if ((this.bits[pos] & other.bits[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public final void and(@NotNull FixedBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.and(other.bits, other.numWords);
    }

    private final void and(long[] otherArr, int otherNumWords) {
        long[] thisArr = this.bits;
        int pos = java.lang.Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            thisArr[pos] = thisArr[pos] & otherArr[pos];
        }
        if (this.numWords > otherNumWords) {
            ArraysKt.fill((long[])thisArr, (long)0L, (int)otherNumWords, (int)this.numWords);
        }
    }

    public final void andNot(@NotNull DocIdSetIterator iter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)iter, (String)"iter");
        if (BitSetIterator.Companion.getFixedBitSetOrNull(iter) != null) {
            this.checkUnpositioned(iter);
            FixedBitSet fixedBitSet = BitSetIterator.Companion.getFixedBitSetOrNull(iter);
            if (fixedBitSet == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            FixedBitSet bits = fixedBitSet;
            this.andNot(bits);
        } else if (iter instanceof DocBaseBitSetIterator) {
            this.checkUnpositioned(iter);
            DocBaseBitSetIterator baseIter = (DocBaseBitSetIterator)iter;
            this.andNot(baseIter.getDocBase() >> 6, baseIter.getBitSet());
        } else {
            this.checkUnpositioned(iter);
            int doc = iter.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                this.clear(doc);
                doc = iter.nextDoc();
            }
        }
    }

    public final void andNot(@NotNull FixedBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.andNot(0, other.bits, other.numWords);
    }

    private final void andNot(int otherOffsetWords, FixedBitSet other) {
        this.andNot(otherOffsetWords, other.bits, other.numWords);
    }

    private final void andNot(int otherOffsetWords, long[] otherArr, int otherNumWords) {
        int pos = java.lang.Math.min(this.numWords - otherOffsetWords, otherNumWords);
        long[] thisArr = this.bits;
        while (--pos >= 0) {
            thisArr[pos + otherOffsetWords] = thisArr[pos + otherOffsetWords] & (otherArr[pos] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public final boolean scanIsEmpty() {
        int count = this.numWords;
        for (int i = 0; i < count; i += ZEROES.length) {
            int cmpLen = java.lang.Math.min(ZEROES.length, this.bits.length - i);
            if (org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.equals(this.bits, i, i + cmpLen, ZEROES, 0, cmpLen)) continue;
            return false;
        }
        return true;
    }

    public final void flip(int startIndex, int endIndex) {
        if (!(startIndex >= 0 && startIndex < this.numBits)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(endIndex >= 0 && endIndex <= this.numBits)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        if (startWord == endWord) {
            this.bits[startWord] = this.bits[startWord] ^ startmask & endmask;
            return;
        }
        this.bits[startWord] = this.bits[startWord] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.bits[endWord] = this.bits[endWord] ^ endmask;
    }

    public final void flip(int index) {
        if (!(index >= 0 && index < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$flip$22 = false;
            String $i$a$-require-FixedBitSet$flip$22 = "index=" + index + " numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$flip$22.toString());
        }
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        this.bits[wordNum] = this.bits[wordNum] ^ bitmask;
    }

    public final void set(int startIndex, int endIndex) {
        if (!(startIndex >= 0 && startIndex < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$set$42 = false;
            String $i$a$-require-FixedBitSet$set$42 = "startIndex=" + startIndex + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$set$42.toString());
        }
        if (!(endIndex >= 0 && endIndex <= this.numBits)) {
            boolean $i$a$-require-FixedBitSet$set$52 = false;
            String $i$a$-require-FixedBitSet$set$52 = "endIndex=" + endIndex + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$set$52.toString());
        }
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        if (startWord == endWord) {
            this.bits[startWord] = this.bits[startWord] | startmask & endmask;
            return;
        }
        this.bits[startWord] = this.bits[startWord] | startmask;
        ArraysKt.fill((long[])this.bits, (long)-1L, (int)(startWord + 1), (int)endWord);
        this.bits[endWord] = this.bits[endWord] | endmask;
    }

    @Override
    public void clear(int startIndex, int endIndex) {
        if (!(startIndex >= 0 && startIndex < this.numBits)) {
            boolean $i$a$-require-FixedBitSet$clear$42 = false;
            String $i$a$-require-FixedBitSet$clear$42 = "startIndex=" + startIndex + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$clear$42.toString());
        }
        if (!(endIndex >= 0 && endIndex <= this.numBits)) {
            boolean $i$a$-require-FixedBitSet$clear$52 = false;
            String $i$a$-require-FixedBitSet$clear$52 = "endIndex=" + endIndex + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-FixedBitSet$clear$52.toString());
        }
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            this.bits[startWord] = this.bits[startWord] & (startmask | endmask);
            return;
        }
        this.bits[startWord] = this.bits[startWord] & startmask;
        ArraysKt.fill((long[])this.bits, (long)0L, (int)(startWord + 1), (int)endWord);
        this.bits[endWord] = this.bits[endWord] & endmask;
    }

    @NotNull
    public final FixedBitSet clone() {
        long[] bits = new long[this.bits.length];
        ArraysKt.copyInto((long[])this.bits, (long[])bits, (int)0, (int)0, (int)this.numWords);
        return new FixedBitSet(bits, this.numBits);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedBitSet)) {
            return false;
        }
        Object other = o;
        if (this.numBits != ((FixedBitSet)other).numBits) {
            return false;
        }
        return Arrays.equals(this.bits, ((FixedBitSet)other).bits);
    }

    public int hashCode() {
        long h = 0L;
        int i = this.numWords;
        while (--i >= 0) {
            h ^= this.bits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    @NotNull
    public final Bits asReadOnlyBits() {
        return new FixedBits(this.bits, this.numBits);
    }

    @Override
    public void applyMask(@NotNull FixedBitSet bitSet, int offset) {
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
        int length = java.lang.Math.min(bitSet.length(), this.length() - offset);
        if (length >= 0) {
            Companion.andRange(this, offset, bitSet, 0, length);
        }
        if (!(length >= bitSet.length() || bitSet.nextSetBit(java.lang.Math.max(0, length)) == Integer.MAX_VALUE)) {
            boolean bl = false;
            String string = "Some bits are set beyond the end of live docs";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fJ.\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/util/FixedBitSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "ZEROES", "", "ensureCapacity", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "bits", "numBits", "", "bits2words", "intersectionCount", "a", "b", "unionCount", "andNotCount", "readNBits", "bitSet", "from", "orRange", "", "source", "sourceFrom", "dest", "destFrom", "length", "andRange", "copyOf", "Lorg/gnit/lucenekmp/util/Bits;", "core"})
    @SourceDebugExtension(value={"SMAP\nFixedBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedBitSet.kt\norg/gnit/lucenekmp/util/FixedBitSet$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,791:1\n1#2:792\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FixedBitSet ensureCapacity(@NotNull FixedBitSet bits, int numBits) {
            long[] arr;
            Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
            if (numBits < bits.numBits) {
                return bits;
            }
            int numWords = this.bits2words(numBits);
            if (numWords >= (arr = bits.getBits()).length) {
                arr = ArrayUtil.Companion.grow(arr, numWords + 1);
            }
            return new FixedBitSet(arr, arr.length << 6);
        }

        public final int bits2words(int numBits) {
            return (numBits - 1 >> 6) + 1;
        }

        public final long intersectionCount(@NotNull FixedBitSet a, @NotNull FixedBitSet b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            long tot = 0L;
            int numCommonWords = java.lang.Math.min(a.numWords, b.numWords);
            for (int i = 0; i < numCommonWords; ++i) {
                tot += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, a.getBits()[i] & b.getBits()[i]);
            }
            return tot;
        }

        public final long unionCount(@NotNull FixedBitSet a, @NotNull FixedBitSet b) {
            int i;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            long tot = 0L;
            int numCommonWords = java.lang.Math.min(a.numWords, b.numWords);
            for (i = 0; i < numCommonWords; ++i) {
                tot += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, a.getBits()[i] | b.getBits()[i]);
            }
            int n = a.numWords;
            for (i = numCommonWords; i < n; ++i) {
                tot += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, a.getBits()[i]);
            }
            n = b.numWords;
            for (i = numCommonWords; i < n; ++i) {
                tot += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, b.getBits()[i]);
            }
            return tot;
        }

        public final long andNotCount(@NotNull FixedBitSet a, @NotNull FixedBitSet b) {
            int i;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            long tot = 0L;
            int numCommonWords = java.lang.Math.min(a.numWords, b.numWords);
            for (i = 0; i < numCommonWords; ++i) {
                tot += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, a.getBits()[i] & (b.getBits()[i] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            int n = a.numWords;
            for (i = numCommonWords; i < n; ++i) {
                tot += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, a.getBits()[i]);
            }
            return tot;
        }

        private final long readNBits(long[] bitSet, int from, int numBits) {
            if (!(numBits > 0 && numBits < 64)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long bits = bitSet[from >> 6] >>> from;
            int numBitsSoFar = 64 - (from & 0x3F);
            if (numBitsSoFar < numBits) {
                bits |= bitSet[(from >> 6) + 1] << -from;
            }
            return bits & (1L << numBits) - 1L;
        }

        public final void orRange(@NotNull FixedBitSet source, int sourceFrom, @NotNull FixedBitSet dest, int destFrom, int length) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            int sourceFrom2 = sourceFrom;
            int destFrom2 = destFrom;
            int length2 = length;
            if (!(length2 >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Objects.INSTANCE.checkFromIndexSize(sourceFrom2, length2, source.length());
            Objects.INSTANCE.checkFromIndexSize(destFrom2, length2, dest.length());
            if (length2 == 0) {
                return;
            }
            long[] sourceBits = source.getBits();
            long[] destBits = dest.getBits();
            if ((destFrom2 & 0x3F) != 0) {
                int numBitsNeeded = java.lang.Math.min(-destFrom2 & 0x3F, length2);
                long bits = this.readNBits(sourceBits, sourceFrom2, numBitsNeeded) << destFrom2;
                destBits[destFrom2 >> 6] = destBits[destFrom2 >> 6] | bits;
                sourceFrom2 += numBitsNeeded;
                destFrom2 += numBitsNeeded;
                length2 -= numBitsNeeded;
            }
            if (length2 == 0) {
                return;
            }
            if (!((destFrom2 & 0x3F) == 0)) {
                String bits = "Failed requirement.";
                throw new IllegalArgumentException(bits.toString());
            }
            int numFullWords = length2 >> 6;
            int sourceWordFrom = sourceFrom2 >> 6;
            int destWordFrom = destFrom2 >> 6;
            if ((sourceFrom2 & 0x3F) == 0) {
                for (i = 0; i < numFullWords; ++i) {
                    destBits[destWordFrom + i] = destBits[destWordFrom + i] | sourceBits[sourceWordFrom + i];
                }
            } else {
                for (i = 0; i < numFullWords; ++i) {
                    destBits[destWordFrom + i] = destBits[destWordFrom + i] | (sourceBits[sourceWordFrom + i] >>> sourceFrom2 | sourceBits[sourceWordFrom + i + 1] << -sourceFrom2);
                }
            }
            sourceFrom2 += numFullWords << 6;
            destFrom2 += numFullWords << 6;
            if ((length2 -= numFullWords << 6) > 0) {
                long bits = this.readNBits(sourceBits, sourceFrom2, length2);
                destBits[destFrom2 >> 6] = destBits[destFrom2 >> 6] | bits;
            }
        }

        public final void andRange(@NotNull FixedBitSet source, int sourceFrom, @NotNull FixedBitSet dest, int destFrom, int length) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            int sourceFrom2 = sourceFrom;
            int destFrom2 = destFrom;
            int length2 = 0;
            length2 = length;
            if (!(length2 >= 0)) {
                boolean $i$a$-require-FixedBitSet$Companion$andRange$22 = false;
                Integer $i$a$-require-FixedBitSet$Companion$andRange$22 = length2;
                throw new IllegalArgumentException(((Object)$i$a$-require-FixedBitSet$Companion$andRange$22).toString());
            }
            Objects.INSTANCE.checkFromIndexSize(sourceFrom2, length2, source.length());
            Objects.INSTANCE.checkFromIndexSize(destFrom2, length2, dest.length());
            if (length2 == 0) {
                return;
            }
            long[] sourceBits = source.getBits();
            long[] destBits = dest.getBits();
            if ((destFrom2 & 0x3F) != 0) {
                int numBitsNeeded = java.lang.Math.min(-destFrom2 & 0x3F, length2);
                long bits = this.readNBits(sourceBits, sourceFrom2, numBitsNeeded) << destFrom2;
                destBits[destFrom2 >> 6] = destBits[destFrom2 >> 6] & (bits |= (1L << numBitsNeeded) - 1L << destFrom2 ^ 0xFFFFFFFFFFFFFFFFL);
                sourceFrom2 += numBitsNeeded;
                destFrom2 += numBitsNeeded;
                length2 -= numBitsNeeded;
            }
            if (length2 == 0) {
                return;
            }
            if (!((destFrom2 & 0x3F) == 0)) {
                String bits = "Failed requirement.";
                throw new IllegalArgumentException(bits.toString());
            }
            int numFullWords = length2 >> 6;
            int sourceWordFrom = sourceFrom2 >> 6;
            int destWordFrom = destFrom2 >> 6;
            if ((sourceFrom2 & 0x3F) == 0) {
                for (i = 0; i < numFullWords; ++i) {
                    destBits[destWordFrom + i] = destBits[destWordFrom + i] & sourceBits[sourceWordFrom + i];
                }
            } else {
                for (i = 0; i < numFullWords; ++i) {
                    destBits[destWordFrom + i] = destBits[destWordFrom + i] & (sourceBits[sourceWordFrom + i] >>> sourceFrom2 | sourceBits[sourceWordFrom + i + 1] << -sourceFrom2);
                }
            }
            sourceFrom2 += numFullWords << 6;
            destFrom2 += numFullWords << 6;
            if ((length2 -= numFullWords << 6) > 0) {
                long bits = this.readNBits(sourceBits, sourceFrom2, length2);
                destBits[destFrom2 >> 6] = destBits[destFrom2 >> 6] & (bits |= -1L << length2);
            }
        }

        @NotNull
        public final FixedBitSet copyOf(@NotNull Bits bits) {
            Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
            Bits bits2 = bits;
            if (bits2 instanceof FixedBits) {
                bits2 = ((FixedBits)bits2).getBitSet();
            }
            if (bits2 instanceof FixedBitSet) {
                return ((FixedBitSet)bits2).clone();
            }
            int length = bits2.length();
            FixedBitSet bitSet = new FixedBitSet(length);
            bitSet.set(0, length);
            for (int i = 0; i < length; ++i) {
                if (bits2.get(i)) continue;
                bitSet.clear(i);
            }
            return bitSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

