/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J6\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005J6\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0015H\u0002J&\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005J&\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/util/GroupVIntUtil;", "", "<init>", "()V", "MAX_LENGTH_PER_GROUP", "", "LONG_MASKS", "", "INT_MASKS", "", "readGroupVInts", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "dst", "limit", "readGroupVInt", "offset", "readIntInGroup", "numBytesMinus1", "remaining", "", "reader", "Lorg/gnit/lucenekmp/util/GroupVIntUtil$IntReader;", "pos", "numBytes", "v", "compare", "x", "y", "compareUnsigned", "toInt", "value", "writeGroupVInts", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "scratch", "", "values", "IntReader", "core"})
public final class GroupVIntUtil {
    @NotNull
    public static final GroupVIntUtil INSTANCE = new GroupVIntUtil();
    public static final int MAX_LENGTH_PER_GROUP = 17;
    @NotNull
    private static final long[] LONG_MASKS;
    @NotNull
    private static final int[] INT_MASKS;

    private GroupVIntUtil() {
    }

    public final void readGroupVInts(@NotNull DataInput in, @NotNull long[] dst, int limit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int i = 0;
        for (i = 0; i <= limit - 4; i += 4) {
            this.readGroupVInt(in, dst, i);
        }
        while (i < limit) {
            dst[i] = (long)in.readVInt() & 0xFFFFFFFFL;
            ++i;
        }
    }

    public final void readGroupVInts(@NotNull DataInput in, @NotNull int[] dst, int limit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int i = 0;
        for (i = 0; i <= limit - 4; i += 4) {
            in.readGroupVInt(dst, i);
        }
        while (i < limit) {
            dst[i] = in.readVInt();
            ++i;
        }
    }

    public final void readGroupVInt(@NotNull DataInput in, @NotNull long[] dst, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int flag = in.readByte() & 0xFF;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = (long)this.readIntInGroup(in, n1Minus1) & 0xFFFFFFFFL;
        dst[offset + 1] = (long)this.readIntInGroup(in, n2Minus1) & 0xFFFFFFFFL;
        dst[offset + 2] = (long)this.readIntInGroup(in, n3Minus1) & 0xFFFFFFFFL;
        dst[offset + 3] = (long)this.readIntInGroup(in, n4Minus1) & 0xFFFFFFFFL;
    }

    public final void readGroupVInt(@NotNull DataInput in, @NotNull int[] dst, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int flag = in.readByte() & 0xFF;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = this.readIntInGroup(in, n1Minus1);
        dst[offset + 1] = this.readIntInGroup(in, n2Minus1);
        dst[offset + 2] = this.readIntInGroup(in, n3Minus1);
        dst[offset + 3] = this.readIntInGroup(in, n4Minus1);
    }

    private final int readIntInGroup(DataInput in, int numBytesMinus1) throws IOException {
        switch (numBytesMinus1) {
            case 0: {
                return in.readByte() & 0xFF;
            }
            case 1: {
                return in.readShort() & 0xFFFF;
            }
            case 2: {
                return in.readShort() & 0xFFFF | (in.readByte() & 0xFF) << 16;
            }
        }
        return in.readInt();
    }

    public final int readGroupVInt(@NotNull DataInput in, long remaining, @NotNull IntReader reader2, long pos, @NotNull long[] dst, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        long pos2 = pos;
        if (remaining < 17L) {
            this.readGroupVInt(in, dst, offset);
            return 0;
        }
        int flag = in.readByte() & 0xFF;
        long posStart = ++pos2;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = (long)reader2.read(pos2) & LONG_MASKS[n1Minus1];
        dst[offset + 1] = (long)reader2.read(pos2 += (long)(1 + n1Minus1)) & LONG_MASKS[n2Minus1];
        dst[offset + 2] = (long)reader2.read(pos2 += (long)(1 + n2Minus1)) & LONG_MASKS[n3Minus1];
        dst[offset + 3] = (long)reader2.read(pos2 += (long)(1 + n3Minus1)) & LONG_MASKS[n4Minus1];
        return (int)((pos2 += (long)(1 + n4Minus1)) - posStart);
    }

    public final int readGroupVInt(@NotNull DataInput in, long remaining, @NotNull IntReader reader2, long pos, @NotNull int[] dst, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        long pos2 = pos;
        if (remaining < 17L) {
            this.readGroupVInt(in, dst, offset);
            return 0;
        }
        int flag = in.readByte() & 0xFF;
        long posStart = ++pos2;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = reader2.read(pos2) & INT_MASKS[n1Minus1];
        dst[offset + 1] = reader2.read(pos2 += (long)(1 + n1Minus1)) & INT_MASKS[n2Minus1];
        dst[offset + 2] = reader2.read(pos2 += (long)(1 + n2Minus1)) & INT_MASKS[n3Minus1];
        dst[offset + 3] = reader2.read(pos2 += (long)(1 + n3Minus1)) & INT_MASKS[n4Minus1];
        return (int)((pos2 += (long)(1 + n4Minus1)) - posStart);
    }

    private final int numBytes(int v) {
        return 4 - (IntExtKt.numberOfLeadingZeros(IntCompanionObject.INSTANCE, v | 1) >> 3);
    }

    private final int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private final int compareUnsigned(long x, long y) {
        return this.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    private final int toInt(long value) {
        if (this.compareUnsigned(value, 0xFFFFFFFFL) > 0) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public final void writeGroupVInts(@NotNull DataOutput out, @NotNull byte[] scratch, @NotNull long[] values2, int limit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)scratch, (String)"scratch");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        int readPos = 0;
        while (limit - readPos >= 4) {
            int writePos = 0;
            int v1 = this.toInt(values2[readPos]);
            int v2 = this.toInt(values2[readPos + 1]);
            int v3 = this.toInt(values2[readPos + 2]);
            int v4 = this.toInt(values2[readPos + 3]);
            int n1Minus1 = this.numBytes(v1) - 1;
            int n2Minus1 = this.numBytes(v2) - 1;
            int n3Minus1 = this.numBytes(v3) - 1;
            int n4Minus1 = this.numBytes(v4) - 1;
            int flag = n1Minus1 << 6 | n2Minus1 << 4 | n3Minus1 << 2 | n4Minus1;
            scratch[writePos++] = (byte)flag;
            BitUtilKt.putIntLE(scratch, writePos, v1);
            ++readPos;
            BitUtilKt.putIntLE(scratch, writePos += n1Minus1 + 1, v2);
            ++readPos;
            BitUtilKt.putIntLE(scratch, writePos += n2Minus1 + 1, v3);
            ++readPos;
            BitUtilKt.putIntLE(scratch, writePos += n3Minus1 + 1, v4);
            ++readPos;
            out.writeBytes(scratch, writePos += n4Minus1 + 1);
        }
        while (readPos < limit) {
            out.writeVInt(this.toInt(values2[readPos]));
            ++readPos;
        }
    }

    public final void writeGroupVInts(@NotNull DataOutput out, @NotNull byte[] scratch, @NotNull int[] values2, int limit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)scratch, (String)"scratch");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        int readPos = 0;
        while (limit - readPos >= 4) {
            int writePos = 0;
            int n1Minus1 = this.numBytes(values2[readPos]) - 1;
            int n2Minus1 = this.numBytes(values2[readPos + 1]) - 1;
            int n3Minus1 = this.numBytes(values2[readPos + 2]) - 1;
            int n4Minus1 = this.numBytes(values2[readPos + 3]) - 1;
            int flag = n1Minus1 << 6 | n2Minus1 << 4 | n3Minus1 << 2 | n4Minus1;
            scratch[writePos++] = (byte)flag;
            BitUtilKt.putIntLEPartial(scratch, writePos, values2[readPos], n1Minus1 + 1);
            BitUtilKt.putIntLEPartial(scratch, writePos += n1Minus1 + 1, values2[++readPos], n2Minus1 + 1);
            BitUtilKt.putIntLEPartial(scratch, writePos += n2Minus1 + 1, values2[++readPos], n3Minus1 + 1);
            BitUtilKt.putIntLEPartial(scratch, writePos += n3Minus1 + 1, values2[++readPos], n4Minus1 + 1);
            ++readPos;
            out.writeBytes(scratch, writePos += n4Minus1 + 1);
        }
        while (readPos < limit) {
            out.writeVInt(values2[readPos]);
            ++readPos;
        }
    }

    static {
        Object[] objectArray = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL};
        LONG_MASKS = objectArray;
        objectArray = new int[4];
        objectArray[0] = 255;
        objectArray[1] = 65535;
        objectArray[2] = 0xFFFFFF;
        objectArray[3] = -1;
        INT_MASKS = (int[])objectArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/GroupVIntUtil$IntReader;", "", "read", "", "v", "", "core"})
    public static interface IntReader {
        public int read(long var1);
    }
}

