/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0003$%&B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u0006\u0010#\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/util/IntBlockPool;", "", "allocator", "Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;", "<init>", "(Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;)V", "EMPTY", "", "buffers", "", "getBuffers", "()[[I", "setBuffers", "([[I)V", "[[I", "bufferUpto", "", "intUpto", "getIntUpto", "()I", "setIntUpto", "(I)V", "buffer", "getBuffer", "()[I", "setBuffer", "([I)V", "intOffset", "getIntOffset", "setIntOffset", "reset", "", "zeroFillBuffers", "", "reuseFirst", "nextBuffer", "Allocator", "DirectAllocator", "Companion", "core"})
public final class IntBlockPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Allocator allocator;
    @NotNull
    private final int[] EMPTY;
    @NotNull
    private int[][] buffers;
    private int bufferUpto;
    private int intUpto;
    @NotNull
    private int[] buffer;
    private int intOffset;
    public static final int INT_BLOCK_SHIFT = 13;
    private static final int INT_BLOCK_SIZE = 8192;
    private static final int INT_BLOCK_MASK = INT_BLOCK_SIZE - 1;

    @JvmOverloads
    public IntBlockPool(@NotNull Allocator allocator) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        this.allocator = allocator;
        this.EMPTY = new int[0];
        int n = 0;
        int[][] nArrayArray = new int[10][];
        IntBlockPool intBlockPool = this;
        while (n < 10) {
            int n2 = n++;
            nArrayArray[n2] = this.EMPTY;
        }
        intBlockPool.buffers = nArrayArray;
        this.bufferUpto = -1;
        this.intUpto = INT_BLOCK_SIZE;
        this.buffer = this.EMPTY;
        this.intOffset = -INT_BLOCK_SIZE;
    }

    public /* synthetic */ IntBlockPool(Allocator allocator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            allocator = new DirectAllocator();
        }
        this(allocator);
    }

    @NotNull
    public final int[][] getBuffers() {
        return this.buffers;
    }

    public final void setBuffers(@NotNull int[][] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.buffers = nArray;
    }

    public final int getIntUpto() {
        return this.intUpto;
    }

    public final void setIntUpto(int n) {
        this.intUpto = n;
    }

    @NotNull
    public final int[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.buffer = nArray;
    }

    public final int getIntOffset() {
        return this.intOffset;
    }

    public final void setIntOffset(int n) {
        this.intOffset = n;
    }

    public final void reset(boolean zeroFillBuffers, boolean reuseFirst) {
        if (this.bufferUpto != -1) {
            if (zeroFillBuffers) {
                int n = this.bufferUpto;
                for (int i = 0; i < n; ++i) {
                    Arrays.INSTANCE.fill(this.buffers[i], 0);
                }
                Arrays.INSTANCE.fill(this.buffers[this.bufferUpto], 0, this.intUpto, 0);
            }
            if (this.bufferUpto > 0 || !reuseFirst) {
                int offset = reuseFirst ? 1 : 0;
                this.allocator.recycleIntBlocks(this.buffers, offset, 1 + this.bufferUpto);
                Arrays.INSTANCE.fill(this.buffers, offset, this.bufferUpto + 1, this.EMPTY);
            }
            if (reuseFirst) {
                this.bufferUpto = 0;
                this.intUpto = 0;
                this.intOffset = 0;
                this.buffer = this.buffers[0];
            } else {
                this.bufferUpto = -1;
                this.intUpto = INT_BLOCK_SIZE;
                this.intOffset = -INT_BLOCK_SIZE;
                this.buffer = this.EMPTY;
            }
        }
    }

    public final void nextBuffer() {
        if (1 + this.bufferUpto == ((Object[])this.buffers).length) {
            int n = 0;
            int n2 = (int)((double)((Object[])this.buffers).length * 1.5);
            int[][] nArrayArray = new int[n2][];
            while (n < n2) {
                int n3 = n++;
                nArrayArray[n3] = this.EMPTY;
            }
            int[][] newBuffers = nArrayArray;
            System.INSTANCE.arraycopy(this.buffers, 0, newBuffers, 0, ((Object[])this.buffers).length);
            this.buffers = newBuffers;
        }
        this.buffers[1 + this.bufferUpto] = this.allocator.getIntBlock();
        this.buffer = this.buffers[1 + this.bufferUpto];
        int n = this.bufferUpto;
        this.bufferUpto = n + 1;
        this.intUpto = 0;
        this.intOffset = Math.INSTANCE.addExact(this.intOffset, INT_BLOCK_SIZE);
    }

    @JvmOverloads
    public IntBlockPool() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;", "", "blockSize", "", "<init>", "(I)V", "getBlockSize", "()I", "recycleIntBlocks", "", "blocks", "", "", "start", "end", "([[III)V", "intBlock", "getIntBlock", "()[I", "core"})
    public static abstract class Allocator {
        private final int blockSize;

        protected Allocator(int blockSize) {
            this.blockSize = blockSize;
        }

        protected final int getBlockSize() {
            return this.blockSize;
        }

        public abstract void recycleIntBlocks(@NotNull int[][] var1, int var2, int var3);

        @NotNull
        public int[] getIntBlock() {
            return new int[this.blockSize];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/IntBlockPool$Companion;", "", "<init>", "()V", "INT_BLOCK_SHIFT", "", "INT_BLOCK_SIZE", "getINT_BLOCK_SIZE", "()I", "INT_BLOCK_MASK", "getINT_BLOCK_MASK", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getINT_BLOCK_SIZE() {
            return INT_BLOCK_SIZE;
        }

        public final int getINT_BLOCK_MASK() {
            return INT_BLOCK_MASK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/IntBlockPool$DirectAllocator;", "Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;", "<init>", "()V", "recycleIntBlocks", "", "blocks", "", "", "start", "", "end", "([[III)V", "core"})
    public static final class DirectAllocator
    extends Allocator {
        public DirectAllocator() {
            super(Companion.getINT_BLOCK_SIZE());
        }

        @Override
        public void recycleIntBlocks(@NotNull int[][] blocks, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        }
    }
}

