/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\rJ\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/util/LongHeap;", "", "maxSize", "", "<init>", "(I)V", "value", "", "heapArray", "getHeapArray", "()[J", "size", "push", "", "element", "insertWithOverflow", "", "top", "pop", "updateTop", "clear", "", "upHeap", "origPos", "downHeap", "i", "pushAll", "other", "get", "core"})
@SourceDebugExtension(value={"SMAP\nLongHeap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongHeap.kt\norg/gnit/lucenekmp/util/LongHeap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class LongHeap {
    private final int maxSize;
    @NotNull
    private long[] heapArray;
    private int size;

    public LongHeap(int maxSize) {
        int heapSize = 0;
        if (!(maxSize >= 1 && maxSize < ArrayUtil.Companion.getMAX_ARRAY_LENGTH())) {
            boolean bl = false;
            String string = "maxSize must be > 0 and < " + (ArrayUtil.Companion.getMAX_ARRAY_LENGTH() - 1) + "; got: " + maxSize;
            throw new IllegalArgumentException(string.toString());
        }
        heapSize = maxSize + 1;
        this.maxSize = maxSize;
        this.heapArray = new long[heapSize];
    }

    @NotNull
    public final long[] getHeapArray() {
        return this.heapArray;
    }

    public final long push(long element) {
        int n = this.size;
        this.size = n + 1;
        if (this.size == this.heapArray.length) {
            this.heapArray = ArrayUtil.Companion.grow(this.heapArray, (this.size * 3 + 1) / 2);
        }
        this.heapArray[this.size] = element;
        this.upHeap(this.size);
        return this.heapArray[1];
    }

    public final boolean insertWithOverflow(long value) {
        if (this.size >= this.maxSize) {
            if (value < this.heapArray[1]) {
                return false;
            }
            this.updateTop(value);
            return true;
        }
        this.push(value);
        return true;
    }

    public final long top() {
        return this.heapArray[1];
    }

    public final long pop() {
        if (this.size > 0) {
            long result = this.heapArray[1];
            this.heapArray[1] = this.heapArray[this.size];
            int n = this.size;
            this.size = n + -1;
            this.downHeap(1);
            return result;
        }
        throw new IllegalStateException("The heap is empty");
    }

    public final long updateTop(long value) {
        this.heapArray[1] = value;
        this.downHeap(1);
        return this.heapArray[1];
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.size = 0;
    }

    private final void upHeap(int origPos) {
        int i = origPos;
        long value = this.heapArray[i];
        for (int j = i >>> 1; j > 0 && value < this.heapArray[j]; j >>>= 1) {
            this.heapArray[i] = this.heapArray[j];
            i = j;
        }
        this.heapArray[i] = value;
    }

    private final void downHeap(int i) {
        int i2 = i;
        long value = this.heapArray[i2];
        int j = i2 << 1;
        int k = j + 1;
        if (k <= this.size && this.heapArray[k] < this.heapArray[j]) {
            j = k;
        }
        while (j <= this.size && this.heapArray[j] < value) {
            this.heapArray[i2] = this.heapArray[j];
            i2 = j;
            k = (j = i2 << 1) + 1;
            if (k > this.size || this.heapArray[k] >= this.heapArray[j]) continue;
            j = k;
        }
        this.heapArray[i2] = value;
    }

    public final void pushAll(@NotNull LongHeap other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int i = 1;
        int n = other.size;
        if (i <= n) {
            while (true) {
                this.push(other.heapArray[i]);
                if (i == n) break;
                ++i;
            }
        }
    }

    public final long get(int i) {
        return this.heapArray[i];
    }
}

