/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\"B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007B!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\fJ\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0011\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0007R\u0011\u0010 \u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/util/LongsRef;", "", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "<init>", "()V", "capacity", "", "(I)V", "longs", "", "offset", "length", "([JII)V", "getLongs", "()[J", "setLongs", "([J)V", "getOffset", "()I", "setOffset", "getLength", "setLength", "clone", "hashCode", "equals", "", "other", "", "longsEquals", "compareTo", "toString", "", "isValid", "()Z", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLongsRef.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongsRef.kt\norg/gnit/lucenekmp/util/LongsRef\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class LongsRef
implements Comparable<LongsRef>,
Cloneable<LongsRef> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] longs;
    private int offset;
    private int length;
    @NotNull
    private static final long[] EMPTY_LONGS = new long[0];

    @NotNull
    public final long[] getLongs() {
        return this.longs;
    }

    public final void setLongs(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
        this.longs = lArray;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public LongsRef() {
        this.longs = EMPTY_LONGS;
    }

    public LongsRef(int capacity) {
        this.longs = new long[capacity];
    }

    public LongsRef(@NotNull long[] longs, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)longs, (String)"longs");
        this.longs = longs;
        this.offset = offset;
        this.length = length;
        if (!this.isValid()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public LongsRef clone() {
        return new LongsRef(this.longs, this.offset, this.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            result = prime * result + (int)(this.longs[i] ^ this.longs[i] >>> 32);
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof LongsRef) {
            return this.longsEquals((LongsRef)other);
        }
        return false;
    }

    public final boolean longsEquals(@NotNull LongsRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Arrays.INSTANCE.equals(this.longs, this.offset, this.offset + this.length, other.longs, other.offset, other.offset + other.length);
    }

    @Override
    public int compareTo(@NotNull LongsRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Arrays.INSTANCE.compare(this.longs, this.offset, this.offset + this.length, other.longs, other.offset, other.offset + other.length);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(LongExtKt.toHexString(LongCompanionObject.INSTANCE, this.longs[i]));
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean isValid() {
        long[] lArray = this.longs;
        if (this.longs == null) {
            boolean $i$a$-checkNotNull-LongsRef$isValid$22 = false;
            String $i$a$-checkNotNull-LongsRef$isValid$22 = "longs is null";
            throw new IllegalStateException($i$a$-checkNotNull-LongsRef$isValid$22.toString());
        }
        if (!(this.length >= 0)) {
            boolean $i$a$-check-LongsRef$isValid$82 = false;
            String $i$a$-check-LongsRef$isValid$82 = "length is negative: " + this.length;
            throw new IllegalStateException($i$a$-check-LongsRef$isValid$82.toString());
        }
        if (!(this.length <= this.longs.length)) {
            boolean $i$a$-check-LongsRef$isValid$92 = false;
            String $i$a$-check-LongsRef$isValid$92 = "length is out of bounds: " + this.length + ",longs.length=" + this.longs.length;
            throw new IllegalStateException($i$a$-check-LongsRef$isValid$92.toString());
        }
        if (!(this.offset >= 0)) {
            boolean $i$a$-check-LongsRef$isValid$102 = false;
            String $i$a$-check-LongsRef$isValid$102 = "offset is negative: " + this.offset;
            throw new IllegalStateException($i$a$-check-LongsRef$isValid$102.toString());
        }
        if (!(this.offset <= this.longs.length)) {
            boolean $i$a$-check-LongsRef$isValid$112 = false;
            String $i$a$-check-LongsRef$isValid$112 = "offset out of bounds: " + this.offset + ",longs.length=" + this.longs.length;
            throw new IllegalStateException($i$a$-check-LongsRef$isValid$112.toString());
        }
        if (!(this.offset + this.length >= 0)) {
            boolean $i$a$-check-LongsRef$isValid$122 = false;
            String $i$a$-check-LongsRef$isValid$122 = "offset+length is negative: offset=" + this.offset + ",length=" + this.length;
            throw new IllegalStateException($i$a$-check-LongsRef$isValid$122.toString());
        }
        if (!(this.offset + this.length <= this.longs.length)) {
            boolean bl = false;
            String string = "offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",longs.length=" + this.longs.length;
            throw new IllegalStateException(string.toString());
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/LongsRef$Companion;", "", "<init>", "()V", "EMPTY_LONGS", "", "getEMPTY_LONGS", "()[J", "deepCopyOf", "Lorg/gnit/lucenekmp/util/LongsRef;", "other", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final long[] getEMPTY_LONGS() {
            return EMPTY_LONGS;
        }

        @NotNull
        public final LongsRef deepCopyOf(@NotNull LongsRef other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new LongsRef(ArrayUtil.Companion.copyOfSubArray(other.getLongs(), other.getOffset(), other.getOffset() + other.getLength()), 0, other.getLength());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

