/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.IntroSorter;
import org.gnit.lucenekmp.util.Sorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H$J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0004J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J(\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0018\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0004J(\u0010 \u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0018\u0010!\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J0\u0010\"\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J8\u0010#\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J8\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\nH\u0014J0\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/gnit/lucenekmp/util/MSBRadixSorter;", "Lorg/gnit/lucenekmp/util/Sorter;", "maxLength", "", "<init>", "(I)V", "getMaxLength", "()I", "histograms", "", "", "[[I", "endOffsets", "commonPrefix", "byteAt", "i", "k", "getFallbackSorter", "compare", "j", "sort", "", "from", "to", "l", "shouldFallback", "", "radixSort", "assertHistogram", "commonPrefixLength", "histogram", "getBucket", "computeCommonPrefixLengthAndBuildHistogram", "computeInitialCommonPrefixLength", "computeCommonPrefixLengthAndBuildHistogramPart1", "computeCommonPrefixLengthAndBuildHistogramPart2", "buildHistogram", "prefixCommonBucket", "prefixCommonLen", "reorder", "startOffsets", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMSBRadixSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MSBRadixSorter.kt\norg/gnit/lucenekmp/util/MSBRadixSorter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public abstract class MSBRadixSorter
extends Sorter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxLength;
    @NotNull
    private final int[][] histograms;
    @NotNull
    private final int[] endOffsets;
    @NotNull
    private final int[] commonPrefix;
    protected static final int LEVEL_THRESHOLD = 8;
    protected static final int HISTOGRAM_SIZE = 257;
    protected static final int LENGTH_THRESHOLD = 100;

    protected MSBRadixSorter(int maxLength) {
        this.maxLength = maxLength;
        this.histograms = new int[8][];
        this.endOffsets = new int[257];
        this.commonPrefix = new int[Math.min(24, this.maxLength)];
    }

    protected final int getMaxLength() {
        return this.maxLength;
    }

    protected abstract int byteAt(int var1, int var2);

    @Nullable
    protected Sorter getFallbackSorter(int k) {
        return new IntroSorter(this, k){
            private final BytesRefBuilder pivot;
            final /* synthetic */ MSBRadixSorter this$0;
            final /* synthetic */ int $k;
            {
                this.this$0 = $receiver;
                this.$k = $k;
                this.pivot = new BytesRefBuilder();
            }

            protected void swap(int i, int j) {
                this.this$0.swap(i, j);
            }

            protected int compare(int i, int j) {
                int n = this.this$0.getMaxLength();
                for (int o = this.$k; o < n; ++o) {
                    int b2;
                    int b1 = this.this$0.byteAt(i, o);
                    if (b1 != (b2 = this.this$0.byteAt(j, o))) {
                        int ub1 = b1 == -1 ? -1 : b1 & 0xFF;
                        int ub2 = b2 == -1 ? -1 : b2 & 0xFF;
                        return ub1 - ub2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }

            protected void setPivot(int i) {
                int b;
                this.pivot.setLength(0);
                int n = this.this$0.getMaxLength();
                for (int o = this.$k; o < n && (b = this.this$0.byteAt(i, o)) != -1; ++o) {
                    this.pivot.append((byte)(b & 0xFF));
                }
            }

            protected int comparePivot(int j) {
                int n = this.pivot.length();
                for (int o = 0; o < n; ++o) {
                    int ub2;
                    int b1 = this.pivot.byteAt(o) & 0xFF;
                    int b2 = this.this$0.byteAt(j, this.$k + o);
                    int n2 = ub2 = b2 == -1 ? -1 : b2 & 0xFF;
                    if (b1 == ub2) continue;
                    return b1 - ub2;
                }
                if (this.$k + this.pivot.length() == this.this$0.getMaxLength()) {
                    return 0;
                }
                return -1 - this.this$0.byteAt(j, this.$k + this.pivot.length());
            }
        };
    }

    @Override
    protected int compare(int i, int j) {
        throw new UnsupportedOperationException("unused: not a comparison-based sort");
    }

    @Override
    public void sort(int from, int to) {
        this.checkRange(from, to);
        this.sort(from, to, 0, 0);
    }

    protected final void sort(int from, int to, int k, int l) {
        if (this.shouldFallback(from, to, l)) {
            Sorter sorter2 = this.getFallbackSorter(k);
            Intrinsics.checkNotNull((Object)sorter2);
            sorter2.sort(from, to);
        } else {
            this.radixSort(from, to, k, l);
        }
    }

    protected boolean shouldFallback(int from, int to, int l) {
        return to - from <= 100 || l >= 8;
    }

    private final void radixSort(int from, int to, int k, int l) {
        int[] histogram = this.histograms[l];
        if (histogram == null) {
            this.histograms[l] = new int[257];
            histogram = this.histograms[l];
        } else {
            Arrays.INSTANCE.fill(histogram, 0);
        }
        Intrinsics.checkNotNull((Object)histogram);
        int commonPrefixLength = this.computeCommonPrefixLengthAndBuildHistogram(from, to, k, histogram);
        if (commonPrefixLength > 0) {
            if (k + commonPrefixLength < this.maxLength && histogram[0] < to - from) {
                this.radixSort(from, to, k + commonPrefixLength, l);
            }
            return;
        }
        if (!this.assertHistogram(commonPrefixLength, histogram)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] startOffsets = histogram;
        int[] endOffsets = this.endOffsets;
        Intrinsics.checkNotNull((Object)endOffsets);
        MSBRadixSorter.Companion.sumHistogram(histogram, endOffsets);
        this.reorder(from, to, startOffsets, endOffsets, k);
        endOffsets = startOffsets;
        if (k + 1 < this.maxLength) {
            int prev = endOffsets[0];
            for (int i = 1; i < 257; ++i) {
                int h = endOffsets[i];
                int bucketLen = h - prev;
                if (bucketLen > 1) {
                    this.sort(from + prev, from + h, k + 1, l + 1);
                }
                prev = h;
            }
        }
    }

    private final boolean assertHistogram(int commonPrefixLength, int[] histogram) {
        int numberOfUniqueBytes = 0;
        for (int freq : histogram) {
            if (freq <= 0) continue;
            ++numberOfUniqueBytes;
        }
        if (numberOfUniqueBytes == 1) {
            if (!(commonPrefixLength >= 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        } else if (!(commonPrefixLength == 0)) {
            boolean bl = false;
            Integer n = commonPrefixLength;
            throw new IllegalArgumentException(((Object)n).toString());
        }
        return true;
    }

    protected final int getBucket(int i, int k) {
        return this.byteAt(i, k) + 1;
    }

    private final int computeCommonPrefixLengthAndBuildHistogram(int from, int to, int k, int[] histogram) {
        int commonPrefixLength = this.computeInitialCommonPrefixLength(from, k);
        return this.computeCommonPrefixLengthAndBuildHistogramPart1(from, to, k, histogram, commonPrefixLength);
    }

    private final int computeInitialCommonPrefixLength(int from, int k) {
        int[] commonPrefix = this.commonPrefix;
        int commonPrefixLength = Math.min(commonPrefix.length, this.maxLength - k);
        for (int j = 0; j < commonPrefixLength; ++j) {
            int b;
            commonPrefix[j] = b = this.byteAt(from, k + j);
            if (b != -1) continue;
            commonPrefixLength = j + 1;
            break;
        }
        return commonPrefixLength;
    }

    private final int computeCommonPrefixLengthAndBuildHistogramPart1(int from, int to, int k, int[] histogram, int commonPrefixLength) {
        int i;
        int commonPrefixLength2 = commonPrefixLength;
        int[] commonPrefix = this.commonPrefix;
        block0: for (i = from + 1; i < to; ++i) {
            int n = commonPrefixLength2;
            for (int j = 0; j < n; ++j) {
                int b = this.byteAt(i, k + j);
                if (b == commonPrefix[j]) continue;
                commonPrefixLength2 = j;
                if (commonPrefixLength2 != 0) continue block0;
                break block0;
            }
        }
        return this.computeCommonPrefixLengthAndBuildHistogramPart2(from, to, k, histogram, commonPrefixLength2, i);
    }

    private final int computeCommonPrefixLengthAndBuildHistogramPart2(int from, int to, int k, int[] histogram, int commonPrefixLength, int i) {
        if (i < to) {
            if (!(commonPrefixLength == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.buildHistogram(this.commonPrefix[0] + 1, i - from, i, to, k, histogram);
        } else {
            if (!(commonPrefixLength > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            histogram[this.commonPrefix[0] + 1] = to - from;
        }
        return commonPrefixLength;
    }

    protected void buildHistogram(int prefixCommonBucket, int prefixCommonLen, int from, int to, int k, @NotNull int[] histogram) {
        Intrinsics.checkNotNullParameter((Object)histogram, (String)"histogram");
        histogram[prefixCommonBucket] = prefixCommonLen;
        for (int i = from; i < to; ++i) {
            int n = this.getBucket(i, k);
            int n2 = histogram[n];
            histogram[n] = n2 + 1;
        }
    }

    protected void reorder(int from, int to, @NotNull int[] startOffsets, @NotNull int[] endOffsets, int k) {
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        for (int i = 0; i < 257; ++i) {
            int limit = endOffsets[i];
            int h1 = startOffsets[i];
            while (h1 < limit) {
                int b = this.getBucket(from + h1, k);
                int n = startOffsets[b];
                startOffsets[b] = n + 1;
                int h2 = n;
                this.swap(from + h1, from + h2);
                h1 = startOffsets[i];
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/MSBRadixSorter$Companion;", "", "<init>", "()V", "LEVEL_THRESHOLD", "", "HISTOGRAM_SIZE", "LENGTH_THRESHOLD", "sumHistogram", "", "histogram", "", "endOffsets", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void sumHistogram(int[] histogram, int[] endOffsets) {
            int accum = 0;
            for (int i = 0; i < 257; ++i) {
                int count = histogram[i];
                histogram[i] = accum;
                endOffsets[i] = accum += count;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

