/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\u0004\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/util/MathUtil;", "", "<init>", "()V", "log", "", "x", "", "base", "", "gcd", "a", "b", "asinh", "acosh", "atanh", "sumRelativeErrorBound", "numValues", "sumUpperBound", "sum", "core"})
@SourceDebugExtension(value={"SMAP\nMathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathUtil.kt\norg/gnit/lucenekmp/util/MathUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public final class MathUtil {
    @NotNull
    public static final MathUtil INSTANCE = new MathUtil();

    private MathUtil() {
    }

    public final int log(long x, int base) {
        long x2 = x;
        if (base == 2) {
            return x2 <= 0L ? 0 : 63 - Long.numberOfLeadingZeros(x2);
        }
        if (!(base > 1)) {
            boolean bl = false;
            String string = "base must be > 1";
            throw new IllegalArgumentException(string.toString());
        }
        int ret = 0;
        while (x2 >= (long)base) {
            x2 /= (long)base;
            ++ret;
        }
        return ret;
    }

    public final int log(int x, int base) {
        int x2 = x;
        if (base == 2) {
            return x2 <= 0 ? 0 : 31 - Integer.numberOfLeadingZeros(x2);
        }
        if (!(base > 1)) {
            boolean bl = false;
            String string = "base must be > 1";
            throw new IllegalArgumentException(string.toString());
        }
        int ret = 0;
        while (x2 >= base) {
            x2 /= base;
            ++ret;
        }
        return ret;
    }

    public final double log(double base, double x) {
        return Math.log(x) / Math.log(base);
    }

    public final long gcd(long a, long b) {
        long a2 = a;
        long b2 = b;
        a2 = Math.abs(a2);
        b2 = Math.abs(b2);
        if (a2 == 0L) {
            return b2;
        }
        if (b2 == 0L) {
            return a2;
        }
        int commonTrailingZeros = Long.numberOfTrailingZeros(a2 | b2);
        a2 >>>= Long.numberOfTrailingZeros(a2);
        while (a2 != (b2 >>>= Long.numberOfTrailingZeros(b2))) {
            if (a2 > b2 || a2 == Long.MIN_VALUE) {
                long tmp = a2;
                a2 = b2;
                b2 = tmp;
            }
            if (a2 == 1L) break;
            b2 -= a2;
        }
        return a2 << commonTrailingZeros;
    }

    public final double asinh(double a) {
        double a2 = a;
        double sign = 0.0;
        if (Double.doubleToRawLongBits(a2) < 0L) {
            a2 = Math.abs(a2);
            sign = -1.0;
        } else {
            sign = 1.0;
        }
        return sign * Math.log(Math.sqrt(a2 * a2 + 1.0) + a2);
    }

    public final double acosh(double a) {
        return Math.log(Math.sqrt(a * a - 1.0) + a);
    }

    public final double atanh(double a) {
        double a2 = a;
        double mult = 0.0;
        if (Double.doubleToRawLongBits(a2) < 0L) {
            a2 = Math.abs(a2);
            mult = -0.5;
        } else {
            mult = 0.5;
        }
        return mult * Math.log((1.0 + a2) / (1.0 - a2));
    }

    public final double sumRelativeErrorBound(int numValues) {
        if (numValues <= 1) {
            return 0.0;
        }
        double u = 1.0 * Math.pow(2.0, -52);
        return (double)(numValues - 1) * u;
    }

    public final double sumUpperBound(double sum, int numValues) {
        if (numValues <= 2) {
            return sum;
        }
        double b = this.sumRelativeErrorBound(numValues);
        return (1.0 + (double)2 * b) * sum;
    }
}

