/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import org.gnit.lucenekmp.jdkport.ClassLoader;
import org.gnit.lucenekmp.jdkport.MethodHandleKt;
import org.gnit.lucenekmp.jdkport.ServiceLoader;
import org.gnit.lucenekmp.util.ClassLoaderUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010)\n\u0002\b\u0003\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u0016\u0017B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\u0013\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0096\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/util/NamedSPILoader;", "S", "Lorg/gnit/lucenekmp/util/NamedSPILoader$NamedSPI;", "", "clazz", "Lkotlin/reflect/KClass;", "classloader", "Lorg/gnit/lucenekmp/jdkport/ClassLoader;", "<init>", "(Lkotlin/reflect/KClass;Lorg/gnit/lucenekmp/jdkport/ClassLoader;)V", "services", "", "", "reload", "", "lookup", "name", "(Ljava/lang/String;)Lorg/gnit/lucenekmp/util/NamedSPILoader$NamedSPI;", "availableServices", "", "iterator", "", "NamedSPI", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nNamedSPILoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedSPILoader.kt\norg/gnit/lucenekmp/util/NamedSPILoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class NamedSPILoader<S extends NamedSPI>
implements Iterable<S>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile Map<String, S> services;
    @NotNull
    private final KClass<S> clazz;

    public NamedSPILoader(@NotNull KClass<S> clazz, @Nullable ClassLoader classloader) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.services = new LinkedHashMap();
        ClassLoader classloader2 = classloader;
        this.clazz = clazz;
        ClassLoader clazzClassloader = MethodHandleKt.getClassLoader(clazz);
        if (classloader2 == null) {
            classloader2 = clazzClassloader;
        }
        if (clazzClassloader != null && !ClassLoaderUtils.Companion.isParentClassLoader(clazzClassloader, classloader2)) {
            this.reload(clazzClassloader);
        }
        this.reload(classloader2);
    }

    public /* synthetic */ NamedSPILoader(KClass kClass, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            classLoader = null;
        }
        this(kClass, classLoader);
    }

    public final void reload(@NotNull ClassLoader classloader) {
        Intrinsics.checkNotNullParameter((Object)classloader, (String)"classloader");
        LinkedHashMap<String, S> services = new LinkedHashMap<String, S>(this.services);
        for (NamedSPI service : ServiceLoader.Companion.load(this.clazz, classloader)) {
            String name = service.getName();
            if (services.containsKey(name)) continue;
            Companion.checkServiceName(name);
            services.put(name, service);
        }
        this.services = services;
    }

    @NotNull
    public final S lookup(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NamedSPI service = (NamedSPI)this.services.get(name);
        if (service != null) {
            return (S)service;
        }
        throw new IllegalArgumentException("An SPI class of type " + this.clazz.getQualifiedName() + " with name '" + name + "' does not exist.  You need to add the corresponding JAR file supporting this SPI to your classpath.  The current classpath supports the following names: " + this.availableServices());
    }

    @NotNull
    public final Set<String> availableServices() {
        return this.services.keySet();
    }

    @Override
    @NotNull
    public Iterator<S> iterator() {
        return this.services.values().iterator();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/NamedSPILoader$Companion;", "", "<init>", "()V", "checkServiceName", "", "name", "", "isLetterOrDigit", "", "c", "", "core"})
    @SourceDebugExtension(value={"SMAP\nNamedSPILoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedSPILoader.kt\norg/gnit/lucenekmp/util/NamedSPILoader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkServiceName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (!(name.length() < 128)) {
                boolean $i$a$-require-NamedSPILoader$Companion$checkServiceName$32 = false;
                String $i$a$-require-NamedSPILoader$Companion$checkServiceName$32 = "Illegal service name: '" + name + "' is too long (must be < 128 chars).";
                throw new IllegalArgumentException($i$a$-require-NamedSPILoader$Companion$checkServiceName$32.toString());
            }
            int len = name.length();
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (this.isLetterOrDigit(c)) continue;
                boolean bl = false;
                String string = "Illegal service name: '" + name + "' must be simple ascii alphanumeric.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final boolean isLetterOrDigit(char c) {
            return Intrinsics.compare((int)97, (int)c) <= 0 && Intrinsics.compare((int)c, (int)122) <= 0 || Intrinsics.compare((int)65, (int)c) <= 0 && Intrinsics.compare((int)c, (int)90) <= 0 || Intrinsics.compare((int)48, (int)c) <= 0 && Intrinsics.compare((int)c, (int)57) <= 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/NamedSPILoader$NamedSPI;", "", "name", "", "getName", "()Ljava/lang/String;", "core"})
    public static interface NamedSPI {
        @NotNull
        public String getName();
    }
}

