/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import com.ionspin.kotlin.bignum.integer.BigInteger;
import com.ionspin.kotlin.bignum.integer.Sign;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bJ.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J.\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000bJ\u0016\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000bJ\u001e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000bJ\u0016\u0010\u001e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000bJ&\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000bJ\u001e\u0010#\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bJ\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0016H\u0002J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000bH\u0002\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/util/NumericUtils;", "", "<init>", "()V", "doubleToSortableLong", "", "value", "", "sortableLongToDouble", "encoded", "floatToSortableInt", "", "", "sortableIntToFloat", "sortableDoubleBits", "bits", "sortableFloatBits", "subtract", "", "bytesPerDim", "dim", "a", "", "b", "result", "add", "intToSortableBytes", "offset", "sortableBytesToInt", "longToSortableBytes", "sortableBytesToLong", "bigIntToSortableBytes", "bigInt", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "bigIntSize", "sortableBytesToBigInt", "length", "fromTwoComplement", "bytes", "toTwoComplement", "size", "core"})
@SourceDebugExtension(value={"SMAP\nNumericUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumericUtils.kt\norg/gnit/lucenekmp/util/NumericUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
public final class NumericUtils {
    @NotNull
    public static final NumericUtils INSTANCE = new NumericUtils();

    private NumericUtils() {
    }

    public final long doubleToSortableLong(double value) {
        return this.sortableDoubleBits(DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, value));
    }

    public final double sortableLongToDouble(long encoded) {
        return DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, this.sortableDoubleBits(encoded));
    }

    public final int floatToSortableInt(float value) {
        return this.sortableFloatBits(FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, value));
    }

    public final float sortableIntToFloat(int encoded) {
        return FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, this.sortableFloatBits(encoded));
    }

    public final long sortableDoubleBits(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public final int sortableFloatBits(int bits) {
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public final void subtract(int bytesPerDim, int dim, @NotNull byte[] a, @NotNull byte[] b, @NotNull byte[] result) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int borrow = 0;
        int i = end - 1;
        if (start <= i) {
            while (true) {
                int diff;
                if ((diff = (a[i] & 0xFF) - (b[i] & 0xFF) - borrow) < 0) {
                    diff += 256;
                    borrow = 1;
                } else {
                    borrow = 0;
                }
                result[i - start] = (byte)diff;
                if (i == start) break;
                --i;
            }
        }
        if (!(borrow == 0)) {
            boolean bl = false;
            String string = "a < b";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void add(int bytesPerDim, int dim, @NotNull byte[] a, @NotNull byte[] b, @NotNull byte[] result) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int carry = 0;
        int i = end - 1;
        if (start <= i) {
            while (true) {
                int digitSum;
                if ((digitSum = (a[i] & 0xFF) + (b[i] & 0xFF) + carry) > 255) {
                    digitSum -= 256;
                    carry = 1;
                } else {
                    carry = 0;
                }
                result[i - start] = (byte)digitSum;
                if (i == start) break;
                --i;
            }
        }
        if (!(carry == 0)) {
            boolean bl = false;
            String string = "a + b overflows bytesPerDim=" + bytesPerDim;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void intToSortableBytes(int value, @NotNull byte[] result, int offset) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int value2 = value;
        BitUtilKt.setIntBE(result, offset, value2 ^= Integer.MIN_VALUE);
    }

    public final int sortableBytesToInt(@NotNull byte[] encoded, int offset) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        int x = BitUtilKt.getIntBE(encoded, offset);
        return x ^ Integer.MIN_VALUE;
    }

    public final void longToSortableBytes(long value, @NotNull byte[] result, int offset) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        long sortableValue = value ^ Long.MIN_VALUE;
        BitUtilKt.setLongBE(result, offset, sortableValue);
    }

    public final long sortableBytesToLong(@NotNull byte[] encoded, int offset) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        long v = BitUtilKt.getLongBE(encoded, offset);
        return v ^ Long.MIN_VALUE;
    }

    public final void bigIntToSortableBytes(@NotNull BigInteger bigInt, int bigIntSize, @NotNull byte[] result, int offset) {
        Intrinsics.checkNotNullParameter((Object)bigInt, (String)"bigInt");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        byte[] fullBigIntBytes = this.toTwoComplement(bigInt, bigIntSize);
        fullBigIntBytes[0] = (byte)(fullBigIntBytes[0] ^ 0x80);
        ArraysKt.copyInto((byte[])fullBigIntBytes, (byte[])result, (int)offset, (int)0, (int)bigIntSize);
    }

    @NotNull
    public final BigInteger sortableBytesToBigInt(@NotNull byte[] encoded, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        byte[] bigIntBytes = new byte[length];
        ArraysKt.copyInto((byte[])encoded, (byte[])bigIntBytes, (int)0, (int)offset, (int)(offset + length));
        bigIntBytes[0] = (byte)(bigIntBytes[0] ^ 0x80);
        return this.fromTwoComplement(bigIntBytes);
    }

    private final BigInteger fromTwoComplement(byte[] bytes) {
        boolean negative;
        if (bytes.length == 0) {
            return BigInteger.Companion.getZERO();
        }
        boolean bl = negative = bytes[0] < 0;
        if (!negative) {
            return BigInteger.Companion.fromByteArray(bytes, Sign.POSITIVE);
        }
        byte[] inverted = new byte[bytes.length];
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            inverted[i] = (byte)(bytes[i] ^ 0xFF);
        }
        int carry = 1;
        for (int i = inverted.length - 1; -1 < i; --i) {
            int sum = (inverted[i] & 0xFF) + carry;
            inverted[i] = (byte)(sum & 0xFF);
            carry = sum >>> 8;
        }
        BigInteger magnitude = BigInteger.Companion.fromByteArray(inverted, Sign.POSITIVE);
        return magnitude.negate();
    }

    private final byte[] toTwoComplement(BigInteger value, int size2) {
        byte[] result = new byte[size2];
        byte[] mag = value.abs().toByteArray();
        if (!(mag.length <= size2)) {
            boolean $i$a$-require-NumericUtils$toTwoComplement$22 = false;
            String $i$a$-require-NumericUtils$toTwoComplement$22 = "BigInteger too large";
            throw new IllegalArgumentException($i$a$-require-NumericUtils$toTwoComplement$22.toString());
        }
        ArraysKt.copyInto$default((byte[])mag, (byte[])result, (int)(size2 - mag.length), (int)0, (int)0, (int)12, null);
        if (value.signum() < 0) {
            int $i$a$-require-NumericUtils$toTwoComplement$22 = result.length;
            for (int i = 0; i < $i$a$-require-NumericUtils$toTwoComplement$22; ++i) {
                result[i] = (byte)(result[i] ^ 0xFF);
            }
            int carry = 1;
            for (int i = result.length - 1; -1 < i; --i) {
                int sum = (result[i] & 0xFF) + carry;
                result[i] = (byte)(sum & 0xFF);
                carry = sum >>> 8;
            }
        }
        return result;
    }
}

