/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.Analyzer;
import org.gnit.lucenekmp.analysis.CachingTokenFilter;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.analysis.standard.StandardAnalyzer;
import org.gnit.lucenekmp.analysis.tokenattributes.PositionIncrementAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.PositionLengthAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TermToBytesRefAttribute;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BoostAttribute;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.MultiPhraseQuery;
import org.gnit.lucenekmp.search.PhraseQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.SynonymQuery;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.util.AttributeSource;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.graph.GraphTokenStreamFiniteStrings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001GB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J\"\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J\u001e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0002J8\u0010%\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J2\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020(H\u0004J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020(H\u0004J.\u0010,\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J \u00103\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J \u00104\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020(2\u0006\u00105\u001a\u00020\u001eH\u0004J \u00106\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020(2\u0006\u00105\u001a\u00020\u001eH\u0004J \u00107\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J \u00108\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\b\u00109\u001a\u00020/H\u0004J#\u0010:\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010;\u001a\b\u0012\u0004\u0012\u0002020<H\u0004\u00a2\u0006\u0002\u0010=J\u0016\u0010>\u001a\u00020\u00162\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00160@H\u0004J\u0018\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020!H\u0004J\b\u0010E\u001a\u00020FH\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006H"}, d2={"Lorg/gnit/lucenekmp/util/QueryBuilder;", "", "analyzer", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "<init>", "(Lorg/gnit/lucenekmp/analysis/Analyzer;)V", "getAnalyzer", "()Lorg/gnit/lucenekmp/analysis/Analyzer;", "setAnalyzer", "enablePositionIncrements", "", "getEnablePositionIncrements", "()Z", "setEnablePositionIncrements", "(Z)V", "enableGraphQueries", "getEnableGraphQueries", "setEnableGraphQueries", "autoGenerateMultiTermSynonymsPhraseQuery", "getAutoGenerateMultiTermSynonymsPhraseQuery", "setAutoGenerateMultiTermSynonymsPhraseQuery", "createBooleanQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "queryText", "operator", "Lorg/gnit/lucenekmp/search/BooleanClause$Occur;", "createPhraseQuery", "phraseSlop", "", "createMinShouldMatchQuery", "fraction", "", "addMinShouldMatchToBoolean", "Lorg/gnit/lucenekmp/search/BooleanQuery;", "query", "createFieldQuery", "quoted", "source", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "analyzeTerm", "stream", "analyzeBoolean", "add", "", "q", "Lorg/gnit/lucenekmp/search/BooleanQuery$Builder;", "current", "", "Lorg/gnit/lucenekmp/util/QueryBuilder$TermAndBoost;", "analyzeMultiBoolean", "analyzePhrase", "slop", "analyzeMultiPhrase", "analyzeGraphBoolean", "analyzeGraphPhrase", "newBooleanQuery", "newSynonymQuery", "terms", "", "(Ljava/lang/String;[Lorg/gnit/lucenekmp/util/QueryBuilder$TermAndBoost;)Lorg/gnit/lucenekmp/search/Query;", "newGraphSynonymQuery", "queries", "", "newTermQuery", "term", "Lorg/gnit/lucenekmp/index/Term;", "boost", "newMultiPhraseQueryBuilder", "Lorg/gnit/lucenekmp/search/MultiPhraseQuery$Builder;", "TermAndBoost", "core"})
@SourceDebugExtension(value={"SMAP\nQueryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryBuilder.kt\norg/gnit/lucenekmp/util/QueryBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,697:1\n1#2:698\n3#3,8:699\n3#3,8:708\n3#3,8:749\n10#4:707\n10#4:716\n10#4:757\n37#5:717\n36#5,3:718\n37#5:721\n36#5,3:722\n37#5:725\n36#5,3:726\n37#5:729\n36#5,3:730\n37#5:733\n36#5,3:734\n37#5:737\n36#5,3:738\n37#5:745\n36#5,3:746\n1563#6:741\n1634#6,3:742\n*S KotlinDebug\n*F\n+ 1 QueryBuilder.kt\norg/gnit/lucenekmp/util/QueryBuilder\n*L\n241#1:699,8\n270#1:708,8\n580#1:749,8\n241#1:707\n270#1:716\n580#1:757\n382#1:717\n382#1:718,3\n404#1:721\n404#1:722,3\n499#1:725\n499#1:726,3\n501#1:729\n501#1:730,3\n510#1:733\n510#1:734,3\n512#1:737\n512#1:738,3\n579#1:745\n579#1:746,3\n572#1:741\n572#1:742,3\n*E\n"})
public class QueryBuilder {
    @NotNull
    private Analyzer analyzer;
    private boolean enablePositionIncrements;
    private boolean enableGraphQueries;
    private boolean autoGenerateMultiTermSynonymsPhraseQuery;

    public QueryBuilder(@NotNull Analyzer analyzer) {
        Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
        this.analyzer = analyzer;
        this.enablePositionIncrements = true;
        this.enableGraphQueries = true;
    }

    public /* synthetic */ QueryBuilder(Analyzer analyzer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            analyzer = new StandardAnalyzer();
        }
        this(analyzer);
    }

    @NotNull
    public final Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public final void setAnalyzer(@NotNull Analyzer analyzer) {
        Intrinsics.checkNotNullParameter((Object)analyzer, (String)"<set-?>");
        this.analyzer = analyzer;
    }

    public final boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public final void setEnablePositionIncrements(boolean bl) {
        this.enablePositionIncrements = bl;
    }

    public final boolean getEnableGraphQueries() {
        return this.enableGraphQueries;
    }

    public final void setEnableGraphQueries(boolean bl) {
        this.enableGraphQueries = bl;
    }

    public final boolean getAutoGenerateMultiTermSynonymsPhraseQuery() {
        return this.autoGenerateMultiTermSynonymsPhraseQuery;
    }

    public final void setAutoGenerateMultiTermSynonymsPhraseQuery(boolean bl) {
        this.autoGenerateMultiTermSynonymsPhraseQuery = bl;
    }

    @JvmOverloads
    @NotNull
    public final Query createBooleanQuery(@NotNull String field, @NotNull String queryText, @NotNull BooleanClause.Occur operator) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        if (!(operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST)) {
            boolean bl = false;
            String string = "invalid operator: only SHOULD or MUST are allowed";
            throw new IllegalArgumentException(string.toString());
        }
        return this.createFieldQuery(this.analyzer, operator, field, queryText, false, 0);
    }

    public static /* synthetic */ Query createBooleanQuery$default(QueryBuilder queryBuilder, String string, String string2, BooleanClause.Occur occur, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBooleanQuery");
        }
        if ((n & 4) != 0) {
            occur = BooleanClause.Occur.SHOULD;
        }
        return queryBuilder.createBooleanQuery(string, string2, occur);
    }

    @JvmOverloads
    @NotNull
    public final Query createPhraseQuery(@NotNull String field, @NotNull String queryText, int phraseSlop) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        return this.createFieldQuery(this.analyzer, BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
    }

    public static /* synthetic */ Query createPhraseQuery$default(QueryBuilder queryBuilder, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPhraseQuery");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return queryBuilder.createPhraseQuery(string, string2, n);
    }

    @NotNull
    public final Query createMinShouldMatchQuery(@NotNull String field, @NotNull String queryText, float fraction) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        if (!(!FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, fraction) && !(fraction < 0.0f) && !(fraction > 1.0f))) {
            boolean bl = false;
            String string = "fraction should be >= 0 and <= 1";
            throw new IllegalArgumentException(string.toString());
        }
        if (fraction == 1.0f) {
            return this.createBooleanQuery(field, queryText, BooleanClause.Occur.MUST);
        }
        Query query = this.createFieldQuery(this.analyzer, BooleanClause.Occur.SHOULD, field, queryText, false, 0);
        if (query instanceof BooleanQuery) {
            query = this.addMinShouldMatchToBoolean((BooleanQuery)query, fraction);
        }
        return query;
    }

    private final BooleanQuery addMinShouldMatchToBoolean(BooleanQuery query, float fraction) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setMinimumNumberShouldMatch((int)(fraction * (float)query.clauses().size()));
        for (BooleanClause clause : query) {
            builder.add(clause);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final Query createFieldQuery(@NotNull Analyzer analyzer, @NotNull BooleanClause.Occur operator, @NotNull String field, @NotNull String queryText, boolean quoted, int phraseSlop) {
        Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        boolean condition$iv = operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        try {
            AutoCloseable autoCloseable = analyzer.tokenStream(field, queryText);
            Throwable throwable = null;
            try {
                TokenStream source = (TokenStream)autoCloseable;
                boolean bl = false;
                Query query = this.createFieldQuery(source, operator, field, quoted, phraseSlop);
                Intrinsics.checkNotNull((Object)query);
                Query query2 = query;
                return query2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing query text", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final Query createFieldQuery(@NotNull TokenStream source, @NotNull BooleanClause.Occur operator, @NotNull String field, boolean quoted, int phraseSlop) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        boolean condition$iv = operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        try {
            AutoCloseable autoCloseable = new CachingTokenFilter(source);
            Throwable throwable = null;
            try {
                CachingTokenFilter stream = (CachingTokenFilter)autoCloseable;
                boolean bl = false;
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class));
                PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.addAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class));
                PositionLengthAttribute posLenAtt = (PositionLengthAttribute)stream.addAttribute(Reflection.getOrCreateKotlinClass(PositionLengthAttribute.class));
                if (termAtt == null) {
                    Query query = null;
                    return query;
                }
                int numTokens = 0;
                int positionCount = 0;
                boolean hasSynonyms = false;
                boolean isGraph = false;
                stream.reset();
                while (stream.incrementToken()) {
                    ++numTokens;
                    int positionIncrement = posIncAtt.getPositionIncrement();
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                    } else {
                        hasSynonyms = true;
                    }
                    int positionLength = posLenAtt.getPositionLength();
                    if (!this.enableGraphQueries || positionLength <= 1) continue;
                    isGraph = true;
                }
                if (numTokens == 0) {
                    Query query = null;
                    return query;
                }
                if (numTokens == 1) {
                    Query query = this.analyzeTerm(field, stream);
                    return query;
                }
                if (isGraph) {
                    Query query = quoted ? this.analyzeGraphPhrase(stream, field, phraseSlop) : this.analyzeGraphBoolean(field, stream, operator);
                    return query;
                }
                if (quoted && positionCount > 1) {
                    Query query = hasSynonyms ? this.analyzeMultiPhrase(field, stream, phraseSlop) : this.analyzePhrase(field, stream, phraseSlop);
                    return query;
                }
                Query query = positionCount == 1 ? this.analyzeBoolean(field, stream) : this.analyzeMultiBoolean(field, stream, operator);
                return query;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing query text", e);
        }
    }

    @NotNull
    protected final Query analyzeTerm(@NotNull String field, @NotNull TokenStream stream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class));
        BoostAttribute boostAtt = (BoostAttribute)stream.addAttribute(Reflection.getOrCreateKotlinClass(BoostAttribute.class));
        stream.reset();
        if (!stream.incrementToken()) {
            throw new AssertionError();
        }
        return this.newTermQuery(new Term(field, termAtt.getBytesRef()), boostAtt.getBoost());
    }

    @NotNull
    protected final Query analyzeBoolean(@NotNull String field, @NotNull TokenStream stream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class));
        BoostAttribute boostAtt = (BoostAttribute)stream.addAttribute(Reflection.getOrCreateKotlinClass(BoostAttribute.class));
        stream.reset();
        List terms = new ArrayList();
        while (stream.incrementToken()) {
            terms.add(new TermAndBoost(termAtt.getBytesRef(), boostAtt.getBoost()));
        }
        Collection $this$toTypedArray$iv = terms;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.newSynonymQuery(field, thisCollection$iv.toArray(new TermAndBoost[0]));
    }

    protected final void add(@NotNull String field, @NotNull BooleanQuery.Builder q, @NotNull List<TermAndBoost> current, @NotNull BooleanClause.Occur operator) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        if (current.isEmpty()) {
            return;
        }
        if (current.size() == 1) {
            v0 = q.add(this.newTermQuery(new Term(field, current.get(0).getTerm()), current.get(0).getBoost()), operator);
        } else {
            Collection $this$toTypedArray$iv = current;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            v0 = q.add(this.newSynonymQuery(field, thisCollection$iv.toArray(new TermAndBoost[0])), operator);
        }
    }

    @NotNull
    protected final Query analyzeMultiBoolean(@NotNull String field, @NotNull TokenStream stream, @NotNull BooleanClause.Occur operator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        BooleanQuery.Builder q = this.newBooleanQuery();
        List currentQuery = new ArrayList();
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class));
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class));
        BoostAttribute boostAtt = (BoostAttribute)stream.addAttribute(Reflection.getOrCreateKotlinClass(BoostAttribute.class));
        stream.reset();
        while (stream.incrementToken()) {
            if (posIncrAtt.getPositionIncrement() != 0) {
                this.add(field, q, currentQuery, operator);
                currentQuery.clear();
            }
            currentQuery.add(new TermAndBoost(termAtt.getBytesRef(), boostAtt.getBoost()));
        }
        this.add(field, q, currentQuery, operator);
        return q.build();
    }

    @NotNull
    protected final Query analyzePhrase(@NotNull String field, @NotNull TokenStream stream, int slop) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class));
        BoostAttribute boostAtt = (BoostAttribute)stream.addAttribute(Reflection.getOrCreateKotlinClass(BoostAttribute.class));
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class));
        int position = -1;
        float phraseBoost = 1.0f;
        stream.reset();
        while (stream.incrementToken()) {
            builder.add(new Term(field, termAtt.getBytesRef()), position += this.enablePositionIncrements ? posIncrAtt.getPositionIncrement() : 1);
            phraseBoost *= boostAtt.getBoost();
        }
        PhraseQuery query = builder.build();
        if (phraseBoost == 1.0f) {
            return query;
        }
        return new BoostQuery(query, phraseBoost);
    }

    @NotNull
    protected final Query analyzeMultiPhrase(@NotNull String field, @NotNull TokenStream stream, int slop) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        MultiPhraseQuery.Builder mpqb = this.newMultiPhraseQueryBuilder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class));
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class));
        int position = -1;
        List multiTerms = new ArrayList();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && !((Collection)multiTerms).isEmpty()) {
                if (this.enablePositionIncrements) {
                    $this$toTypedArray$iv = multiTerms;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    v0 = mpqb.add(thisCollection$iv.toArray(new Term[0]), position);
                } else {
                    $this$toTypedArray$iv = multiTerms;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    v0 = mpqb.add(thisCollection$iv.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (this.enablePositionIncrements) {
            Collection $this$toTypedArray$iv = multiTerms;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            v1 = mpqb.add(thisCollection$iv.toArray(new Term[0]), position);
        } else {
            Collection $this$toTypedArray$iv = multiTerms;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            v1 = mpqb.add(thisCollection$iv.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Query analyzeGraphBoolean(@NotNull String field, @NotNull TokenStream source, @NotNull BooleanClause.Occur operator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        source.reset();
        GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        int[] articulationPoints = graph.articulationPoints();
        int lastState = 0;
        int i = 0;
        int n = articulationPoints.length;
        if (i <= n) {
            while (true) {
                int start = lastState;
                int end = -1;
                if (i < articulationPoints.length) {
                    end = articulationPoints[i];
                }
                lastState = end;
                Query positionalQuery = null;
                if (graph.hasSidePath(start)) {
                    Iterator<TokenStream> sidePathsIterator = graph.getFiniteStrings(start, end);
                    Iterator queries2 = new Iterator<Query>(sidePathsIterator, this, field){
                        final /* synthetic */ Iterator<TokenStream> $sidePathsIterator;
                        final /* synthetic */ QueryBuilder this$0;
                        final /* synthetic */ String $field;
                        {
                            this.$sidePathsIterator = $sidePathsIterator;
                            this.this$0 = $receiver;
                            this.$field = $field;
                        }

                        public boolean hasNext() {
                            return this.$sidePathsIterator.hasNext();
                        }

                        public Query next() {
                            TokenStream sidePath = this.$sidePathsIterator.next();
                            Query query = this.this$0.createFieldQuery(sidePath, BooleanClause.Occur.MUST, this.$field, this.this$0.getAutoGenerateMultiTermSynonymsPhraseQuery(), 0);
                            Intrinsics.checkNotNull((Object)query);
                            return query;
                        }

                        public void remove() {
                            throw new UnsupportedOperationException("remove() is not supported");
                        }
                    };
                    positionalQuery = this.newGraphSynonymQuery(queries2);
                } else {
                    void condition$iv;
                    void $this$toTypedArray$iv22;
                    void $this$mapTo$iv$iv;
                    Collection $this$map$iv;
                    List<AttributeSource> attributes = graph.getTerms(start);
                    Iterable iterable = attributes;
                    boolean $i$f$map = false;
                    void var17_19 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void s;
                        AttributeSource attributeSource = (AttributeSource)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        TermToBytesRefAttribute t = (TermToBytesRefAttribute)s.addAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class));
                        BoostAttribute b = (BoostAttribute)s.addAttribute(Reflection.getOrCreateKotlinClass(BoostAttribute.class));
                        collection.add(new TermAndBoost(t.getBytesRef(), b.getBoost()));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv22;
                    TermAndBoost[] terms = thisCollection$iv.toArray(new TermAndBoost[0]);
                    boolean $this$toTypedArray$iv22 = !(terms.length == 0);
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && condition$iv == false) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    Query query = positionalQuery = terms.length == 1 ? this.newTermQuery(new Term(field, terms[0].getTerm()), terms[0].getBoost()) : this.newSynonymQuery(field, terms);
                }
                if (positionalQuery != null) {
                    builder.add(positionalQuery, operator);
                }
                if (i == n) break;
                ++i;
            }
        }
        return builder.build();
    }

    @NotNull
    protected final Query analyzeGraphPhrase(@NotNull TokenStream source, @NotNull String field, int phraseSlop) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        source.reset();
        GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        Iterator<TokenStream> it = graph.getFiniteStrings();
        while (it.hasNext()) {
            Query query = this.createFieldQuery(it.next(), BooleanClause.Occur.MUST, field, true, phraseSlop);
            if (query == null) continue;
            builder.add(query, BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    @NotNull
    protected final BooleanQuery.Builder newBooleanQuery() {
        return new BooleanQuery.Builder();
    }

    @NotNull
    protected final Query newSynonymQuery(@NotNull String field, @NotNull TermAndBoost[] terms) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        SynonymQuery.Builder builder = new SynonymQuery.Builder(field);
        for (TermAndBoost t : terms) {
            builder.addTerm(t.getTerm(), t.getBoost());
        }
        return builder.build();
    }

    @NotNull
    protected final Query newGraphSynonymQuery(@NotNull Iterator<? extends Query> queries2) {
        Intrinsics.checkNotNullParameter(queries2, (String)"queries");
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        while (queries2.hasNext()) {
            builder.add(queries2.next(), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery bq = builder.build();
        if (bq.clauses().size() == 1) {
            return bq.clauses().get(0).getQuery();
        }
        return bq;
    }

    @NotNull
    protected final Query newTermQuery(@NotNull Term term, float boost) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Query q = new TermQuery(term);
        if (boost == 1.0f) {
            return q;
        }
        return new BoostQuery(q, boost);
    }

    @NotNull
    protected final MultiPhraseQuery.Builder newMultiPhraseQueryBuilder() {
        return new MultiPhraseQuery.Builder();
    }

    @JvmOverloads
    @NotNull
    public final Query createBooleanQuery(@NotNull String field, @NotNull String queryText) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        return QueryBuilder.createBooleanQuery$default(this, field, queryText, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Query createPhraseQuery(@NotNull String field, @NotNull String queryText) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        return QueryBuilder.createPhraseQuery$default(this, field, queryText, 0, 4, null);
    }

    public QueryBuilder() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/QueryBuilder$TermAndBoost;", "", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "boost", "", "<init>", "(Lorg/gnit/lucenekmp/util/BytesRef;F)V", "getBoost", "()F", "getTerm", "()Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    public static final class TermAndBoost {
        private final float boost;
        @NotNull
        private final BytesRef term;

        public TermAndBoost(@NotNull BytesRef term, float boost) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            this.boost = boost;
            BytesRef term2 = term;
            this.term = term2 = BytesRef.Companion.deepCopyOf(term2);
        }

        public final float getBoost() {
            return this.boost;
        }

        @NotNull
        public final BytesRef getTerm() {
            return this.term;
        }
    }
}

