/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u000e\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0013\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bR\u001e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007X\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\t\u0012\u0004\b\b\u0010\u0005R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/util/RollingBuffer;", "T", "Lorg/gnit/lucenekmp/util/RollingBuffer$Resettable;", "", "<init>", "()V", "buffer", "", "getBuffer$annotations", "[Lorg/gnit/lucenekmp/util/RollingBuffer$Resettable;", "nextWrite", "", "nextPos", "count", "newInstance", "()Lorg/gnit/lucenekmp/util/RollingBuffer$Resettable;", "reset", "", "inBounds", "", "pos", "getIndex", "get", "(I)Lorg/gnit/lucenekmp/util/RollingBuffer$Resettable;", "getMaxPos", "getBufferSize", "freeBefore", "Resettable", "core"})
@SourceDebugExtension(value={"SMAP\nRollingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollingBuffer.kt\norg/gnit/lucenekmp/util/RollingBuffer\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,89:1\n3#2,8:90\n10#3:98\n*S KotlinDebug\n*F\n+ 1 RollingBuffer.kt\norg/gnit/lucenekmp/util/RollingBuffer\n*L\n68#1:90,8\n68#1:98\n*E\n"})
public abstract class RollingBuffer<T extends Resettable> {
    @NotNull
    private T[] buffer = new Resettable[8];
    private int nextWrite;
    private int nextPos;
    private int count;

    public RollingBuffer() {
        int n = this.buffer.length;
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = this.newInstance();
        }
    }

    private static /* synthetic */ void getBuffer$annotations() {
    }

    @NotNull
    protected abstract T newInstance();

    public final void reset() {
        int idx = this.nextWrite - 1;
        while (this.count > 0) {
            if (idx == -1) {
                idx = this.buffer.length - 1;
            }
            T t = this.buffer[idx];
            Intrinsics.checkNotNull(t);
            t.reset();
            --idx;
            int n = this.count;
            this.count = n + -1;
        }
        this.nextWrite = 0;
        this.nextPos = 0;
        this.count = 0;
    }

    private final boolean inBounds(int pos) {
        return pos < this.nextPos && pos >= this.nextPos - this.count;
    }

    private final int getIndex(int pos) {
        int index = this.nextWrite - (this.nextPos - pos);
        if (index < 0) {
            index += this.buffer.length;
        }
        return index;
    }

    @NotNull
    public final T get(int pos) {
        while (pos >= this.nextPos) {
            if (this.count == this.buffer.length) {
                Object[] newBuffer = new Resettable[this.buffer.length * 2];
                ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)0, (int)this.nextWrite, (int)this.buffer.length);
                ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)(this.buffer.length - this.nextWrite), (int)0, (int)this.nextWrite);
                int n = newBuffer.length;
                for (int i = this.buffer.length; i < n; ++i) {
                    newBuffer[i] = this.newInstance();
                }
                this.nextWrite = this.buffer.length;
                this.buffer = newBuffer;
            }
            if (this.nextWrite == this.buffer.length) {
                this.nextWrite = 0;
            }
            int newBuffer = this.nextWrite;
            this.nextWrite = newBuffer + 1;
            newBuffer = this.nextPos;
            this.nextPos = newBuffer + 1;
            newBuffer = this.count;
            this.count = newBuffer + 1;
        }
        boolean condition$iv = this.inBounds(pos);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int index = this.getIndex(pos);
        T t = this.buffer[index];
        Intrinsics.checkNotNull(t);
        return t;
    }

    public final int getMaxPos() {
        return this.nextPos - 1;
    }

    public final int getBufferSize() {
        return this.count;
    }

    public final void freeBefore(int pos) {
        int toFree = this.count - (this.nextPos - pos);
        int index = 0;
        index = this.nextWrite - this.count;
        if (index < 0) {
            index += this.buffer.length;
        }
        for (int i = 0; i < toFree; ++i) {
            int it = i;
            boolean bl = false;
            if (index == this.buffer.length) {
                index = 0;
            }
            T t = this.buffer[index];
            Intrinsics.checkNotNull(t);
            t.reset();
            ++index;
        }
        this.count -= toFree;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/RollingBuffer$Resettable;", "", "reset", "", "core"})
    public static interface Resettable {
        public void reset();
    }
}

