/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.StrictMath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u001a\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J&\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/util/SloppyMath;", "", "<init>", "()V", "haversinMeters", "", "lat1", "lon1", "lat2", "lon2", "sortKey", "haversinSortKey", "cos", "a", "asin", "TO_METERS", "ONE_DIV_F2", "ONE_DIV_F3", "ONE_DIV_F4", "PIO2_HI", "PIO2_LO", "TWOPI_HI", "TWOPI_LO", "SIN_COS_TABS_SIZE", "", "SIN_COS_DELTA_HI", "SIN_COS_DELTA_LO", "SIN_COS_INDEXER", "sinTab", "", "cosTab", "SIN_COS_MAX_VALUE_FOR_INT_MODULO", "getSIN_COS_MAX_VALUE_FOR_INT_MODULO", "()D", "ASIN_MAX_VALUE_FOR_TABS", "ASIN_TABS_SIZE", "ASIN_DELTA", "ASIN_INDEXER", "asinTab", "asinDer1DivF1Tab", "asinDer2DivF2Tab", "asinDer3DivF3Tab", "asinDer4DivF4Tab", "ASIN_PIO2_HI", "ASIN_PIO2_LO", "ASIN_PS0", "ASIN_PS1", "ASIN_PS2", "ASIN_PS3", "ASIN_PS4", "ASIN_PS5", "ASIN_QS1", "ASIN_QS2", "ASIN_QS3", "ASIN_QS4", "core"})
public final class SloppyMath {
    @NotNull
    public static final SloppyMath INSTANCE;
    private static final double TO_METERS = 6371008.7714;
    private static final double ONE_DIV_F2 = 0.5;
    private static final double ONE_DIV_F3 = 0.16666666666666666;
    private static final double ONE_DIV_F4 = 0.041666666666666664;
    private static final double PIO2_HI;
    private static final double PIO2_LO;
    private static final double TWOPI_HI;
    private static final double TWOPI_LO;
    private static final int SIN_COS_TABS_SIZE = 2049;
    private static final double SIN_COS_DELTA_HI;
    private static final double SIN_COS_DELTA_LO;
    private static final double SIN_COS_INDEXER;
    @NotNull
    private static final double[] sinTab;
    @NotNull
    private static final double[] cosTab;
    private static final double SIN_COS_MAX_VALUE_FOR_INT_MODULO;
    private static final double ASIN_MAX_VALUE_FOR_TABS;
    private static final int ASIN_TABS_SIZE = 8193;
    private static final double ASIN_DELTA;
    private static final double ASIN_INDEXER;
    @NotNull
    private static final double[] asinTab;
    @NotNull
    private static final double[] asinDer1DivF1Tab;
    @NotNull
    private static final double[] asinDer2DivF2Tab;
    @NotNull
    private static final double[] asinDer3DivF3Tab;
    @NotNull
    private static final double[] asinDer4DivF4Tab;
    private static final double ASIN_PIO2_HI;
    private static final double ASIN_PIO2_LO;
    private static final double ASIN_PS0;
    private static final double ASIN_PS1;
    private static final double ASIN_PS2;
    private static final double ASIN_PS3;
    private static final double ASIN_PS4;
    private static final double ASIN_PS5;
    private static final double ASIN_QS1;
    private static final double ASIN_QS2;
    private static final double ASIN_QS3;
    private static final double ASIN_QS4;

    private SloppyMath() {
    }

    public final double haversinMeters(double lat1, double lon1, double lat2, double lon2) {
        return this.haversinMeters(this.haversinSortKey(lat1, lon1, lat2, lon2));
    }

    public final double haversinMeters(double sortKey) {
        return 1.27420175428E7 * this.asin(java.lang.Math.min(1.0, java.lang.Math.sqrt(sortKey * 0.5)));
    }

    public final double haversinSortKey(double lat1, double lon1, double lat2, double lon2) {
        double x1 = Math.INSTANCE.toRadians(lat1);
        double x2 = Math.INSTANCE.toRadians(lat2);
        double h1 = 1.0 - this.cos(x1 - x2);
        double h2 = 1.0 - this.cos(Math.INSTANCE.toRadians(lon1 - lon2));
        double h = h1 + this.cos(x1) * this.cos(x2) * h2;
        return DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, DoubleExtKt.doubleToRawLongBits(DoubleCompanionObject.INSTANCE, h) & 0xFFFFFFFFFFFFFFF8L);
    }

    public final double cos(double a) {
        double a2 = a;
        if (a2 < 0.0) {
            a2 = -a2;
        }
        if (a2 > SIN_COS_MAX_VALUE_FOR_INT_MODULO) {
            return java.lang.Math.cos(a2);
        }
        int index = (int)(a2 * SIN_COS_INDEXER + 0.5);
        double delta = a2 - (double)index * SIN_COS_DELTA_HI - (double)index * SIN_COS_DELTA_LO;
        double indexCos = cosTab[index &= 0x7FF];
        double indexSin = sinTab[index];
        return indexCos + delta * (-indexSin + delta * (-indexCos * 0.5 + delta * (indexSin * 0.16666666666666666 + delta * indexCos * 0.041666666666666664)));
    }

    public final double asin(double a) {
        double a2 = a;
        boolean negateResult = false;
        if (a2 < 0.0) {
            a2 = -a2;
            negateResult = true;
        } else {
            negateResult = false;
        }
        if (a2 <= ASIN_MAX_VALUE_FOR_TABS) {
            int index = (int)(a2 * ASIN_INDEXER + 0.5);
            double delta = a2 - (double)index * ASIN_DELTA;
            double result = asinTab[index] + delta * (asinDer1DivF1Tab[index] + delta * (asinDer2DivF2Tab[index] + delta * (asinDer3DivF3Tab[index] + delta * asinDer4DivF4Tab[index])));
            return negateResult ? -result : result;
        }
        if (a2 < 1.0) {
            double t = (1.0 - a2) * 0.5;
            double p = t * (ASIN_PS0 + t * (ASIN_PS1 + t * (ASIN_PS2 + t * (ASIN_PS3 + t * (ASIN_PS4 + t * ASIN_PS5)))));
            double q = 1.0 + t * (ASIN_QS1 + t * (ASIN_QS2 + t * (ASIN_QS3 + t * ASIN_QS4)));
            double s = java.lang.Math.sqrt(t);
            double z = s + s * (p / q);
            double result = ASIN_PIO2_HI - (z + z - ASIN_PIO2_LO);
            return negateResult ? -result : result;
        }
        if (a2 == 1.0) {
            return negateResult ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Double.NaN;
    }

    public final double getSIN_COS_MAX_VALUE_FOR_INT_MODULO() {
        return SIN_COS_MAX_VALUE_FOR_INT_MODULO;
    }

    static {
        int i;
        INSTANCE = new SloppyMath();
        PIO2_HI = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4609753056924401664L);
        PIO2_LO = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4454258360616903473L);
        TWOPI_HI = (double)4 * PIO2_HI;
        TWOPI_LO = (double)4 * PIO2_LO;
        SIN_COS_DELTA_HI = TWOPI_HI / (double)2048;
        SIN_COS_DELTA_LO = TWOPI_LO / (double)2048;
        SIN_COS_INDEXER = 1.0 / (SIN_COS_DELTA_HI + SIN_COS_DELTA_LO);
        sinTab = new double[2049];
        cosTab = new double[2049];
        SIN_COS_MAX_VALUE_FOR_INT_MODULO = (double)0x3FFFFF / SIN_COS_INDEXER * 0.99;
        ASIN_MAX_VALUE_FOR_TABS = StrictMath.INSTANCE.sin(Math.INSTANCE.toRadians(73.0));
        ASIN_DELTA = ASIN_MAX_VALUE_FOR_TABS / (double)8192;
        ASIN_INDEXER = 1.0 / ASIN_DELTA;
        asinTab = new double[8193];
        asinDer1DivF1Tab = new double[8193];
        asinDer2DivF2Tab = new double[8193];
        asinDer3DivF3Tab = new double[8193];
        asinDer4DivF4Tab = new double[8193];
        ASIN_PIO2_HI = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4609753056924675352L);
        ASIN_PIO2_LO = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4364452196894661639L);
        ASIN_PS0 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4595172819793696085L);
        ASIN_PS1 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, -4623835544539140227L);
        ASIN_PS2 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4596417465768494165L);
        ASIN_PS3 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, -4637438604930937029L);
        ASIN_PS4 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4560439845004096136L);
        ASIN_PS5 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4540259411154564873L);
        ASIN_QS1 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, -4610777653840302773L);
        ASIN_QS2 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4611733184086379208L);
        ASIN_QS3 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, -4618997306433404583L);
        ASIN_QS4 = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, 4590215604441354882L);
        int SIN_COS_PI_INDEX = 1024;
        int SIN_COS_PI_MUL_2_INDEX = 2 * SIN_COS_PI_INDEX;
        int SIN_COS_PI_MUL_0_5_INDEX = SIN_COS_PI_INDEX / 2;
        int SIN_COS_PI_MUL_1_5_INDEX = 3 * SIN_COS_PI_INDEX / 2;
        for (i = 0; i < 2049; ++i) {
            double angle = (double)i * SIN_COS_DELTA_HI + (double)i * SIN_COS_DELTA_LO;
            double sinAngle = StrictMath.INSTANCE.sin(angle);
            double cosAngle = StrictMath.INSTANCE.cos(angle);
            if (i == SIN_COS_PI_INDEX) {
                sinAngle = 0.0;
            } else if (i == SIN_COS_PI_MUL_2_INDEX) {
                sinAngle = 0.0;
            } else if (i == SIN_COS_PI_MUL_0_5_INDEX) {
                cosAngle = 0.0;
            } else if (i == SIN_COS_PI_MUL_1_5_INDEX) {
                cosAngle = 0.0;
            }
            SloppyMath.sinTab[i] = sinAngle;
            SloppyMath.cosTab[i] = cosAngle;
        }
        for (i = 0; i < 8193; ++i) {
            double x = (double)i * ASIN_DELTA;
            SloppyMath.asinTab[i] = StrictMath.INSTANCE.asin(x);
            double oneMinusXSqInv = 1.0 / (1.0 - x * x);
            double oneMinusXSqInv0_5 = StrictMath.INSTANCE.sqrt(oneMinusXSqInv);
            double oneMinusXSqInv1_5 = oneMinusXSqInv0_5 * oneMinusXSqInv;
            double oneMinusXSqInv2_5 = oneMinusXSqInv1_5 * oneMinusXSqInv;
            double oneMinusXSqInv3_5 = oneMinusXSqInv2_5 * oneMinusXSqInv;
            SloppyMath.asinDer1DivF1Tab[i] = oneMinusXSqInv0_5;
            SloppyMath.asinDer2DivF2Tab[i] = x * oneMinusXSqInv1_5 * 0.5;
            SloppyMath.asinDer3DivF3Tab[i] = (1.0 + (double)2 * x * x) * oneMinusXSqInv2_5 * 0.16666666666666666;
            SloppyMath.asinDer4DivF4Tab[i] = ((double)5 + (double)2 * x * ((double)2 + x * ((double)5 - (double)2 * x))) * oneMinusXSqInv3_5 * 0.041666666666666664;
        }
    }
}

