/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u001a\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H$J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H$J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0014J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H&J\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u001e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u001e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J \u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\"\u0010\u001d\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010 \u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010!\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/util/Sorter;", "", "<init>", "()V", "compare", "", "i", "j", "swap", "", "pivotIndex", "setPivot", "comparePivot", "sort", "from", "to", "checkRange", "mergeInPlace", "mid", "lower", "val", "upper", "lower2", "upper2", "reverse", "rotate", "lo", "hi", "doRotate", "binarySort", "insertionSort", "heapSort", "heapify", "siftDown", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sorter.kt\norg/gnit/lucenekmp/util/Sorter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
public abstract class Sorter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int pivotIndex;
    public static final int BINARY_SORT_THRESHOLD = 20;
    public static final int INSERTION_SORT_THRESHOLD = 16;

    protected Sorter() {
    }

    protected abstract int compare(int var1, int var2);

    protected abstract void swap(int var1, int var2);

    protected void setPivot(int i) {
        this.pivotIndex = i;
    }

    protected int comparePivot(int j) {
        return this.compare(this.pivotIndex, j);
    }

    public abstract void sort(int var1, int var2);

    public final void checkRange(int from, int to) {
        if (!(to >= from)) {
            boolean bl = false;
            String string = "'to' must be >= 'from', got from=" + from + " and to=" + to;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void mergeInPlace(int from, int mid, int to) {
        int from2 = from;
        int to2 = to;
        if (from2 == mid || mid == to2 || this.compare(mid - 1, mid) <= 0) {
            return;
        }
        if (to2 - from2 == 2) {
            this.swap(mid - 1, mid);
            return;
        }
        while (this.compare(from2, mid) <= 0) {
            ++from2;
        }
        while (this.compare(mid - 1, to2 - 1) <= 0) {
            --to2;
        }
        int first_cut = 0;
        int second_cut = 0;
        int len11 = 0;
        int len22 = 0;
        if (mid - from2 > to2 - mid) {
            len11 = mid - from2 >>> 1;
            first_cut = from2 + len11;
            second_cut = this.lower(mid, to2, first_cut);
            len22 = second_cut - mid;
        } else {
            len22 = to2 - mid >>> 1;
            second_cut = mid + len22;
            first_cut = this.upper(from2, mid, second_cut);
            len11 = first_cut - from2;
        }
        this.rotate(first_cut, mid, second_cut);
        int new_mid = first_cut + len22;
        this.mergeInPlace(from2, first_cut, new_mid);
        this.mergeInPlace(new_mid, second_cut, to2);
    }

    public final int lower(int from, int to, int val) {
        int from2 = from;
        int len = to - from2;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from2 + half;
            if (this.compare(mid, val) < 0) {
                from2 = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from2;
    }

    public final int upper(int from, int to, int val) {
        int from2 = from;
        int len = to - from2;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from2 + half;
            if (this.compare(val, mid) < 0) {
                len = half;
                continue;
            }
            from2 = mid + 1;
            len = len - half - 1;
        }
        return from2;
    }

    public final int lower2(int from, int to, int val) {
        int delta;
        int t = to;
        for (int f = to - 1; f > from; f -= delta << 1) {
            if (this.compare(f, val) < 0) {
                return this.lower(f, t, val);
            }
            delta = t - f;
            t = f;
        }
        return this.lower(from, t, val);
    }

    public final int upper2(int from, int to, int val) {
        int delta;
        int f = from;
        for (int t = f + 1; t < to; t += delta << 1) {
            if (this.compare(t, val) > 0) {
                return this.upper(f, t, val);
            }
            delta = t - f;
            f = t;
        }
        return this.upper(f, to, val);
    }

    public final void reverse(int from, int to) {
        int to2 = to;
        --to2;
        for (int from2 = from; from2 < to2; ++from2, --to2) {
            this.swap(from2, to2);
        }
    }

    public final void rotate(int lo, int mid, int hi) {
        if (!(lo <= mid && mid <= hi)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (lo == mid || mid == hi) {
            return;
        }
        this.doRotate(lo, mid, hi);
    }

    public void doRotate(int lo, int mid, int hi) {
        int mid2 = mid;
        int lo2 = lo;
        if (mid2 - lo2 == hi - mid2) {
            while (mid2 < hi) {
                this.swap(lo2++, mid2++);
            }
        } else {
            this.reverse(lo2, mid2);
            this.reverse(mid2, hi);
            this.reverse(lo2, hi);
        }
    }

    @JvmOverloads
    public final void binarySort(int from, int to, int i) {
        block0: for (int i2 = i; i2 < to; ++i2) {
            this.setPivot(i2);
            int l = from;
            int h = i2 - 1;
            while (l <= h) {
                int mid = l + h >>> 1;
                int cmp = this.comparePivot(mid);
                if (cmp < 0) {
                    h = mid - 1;
                    continue;
                }
                l = mid + 1;
            }
            int n = l + 1;
            int j = i2;
            if (n > j) continue;
            while (true) {
                this.swap(j - 1, j);
                if (j == n) continue block0;
                --j;
            }
        }
    }

    public static /* synthetic */ void binarySort$default(Sorter sorter2, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: binarySort");
        }
        if ((n4 & 4) != 0) {
            n3 = n + 1;
        }
        sorter2.binarySort(n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public final void insertionSort(int from, int to) {
        int i = from + 1;
        block0: while (i < to) {
            int current = i++;
            int previous = 0;
            while (true) {
                void it;
                int n;
                int n2 = n = current - 1;
                Sorter sorter2 = this;
                boolean bl = false;
                previous = it;
                if (sorter2.compare(n, current) <= 0) continue block0;
                this.swap(previous, current);
                if (previous == from) continue block0;
                current = previous;
            }
        }
    }

    public final void heapSort(int from, int to) {
        if (to - from <= 1) {
            return;
        }
        this.heapify(from, to);
        int end = to - 1;
        int n = from + 1;
        if (n <= end) {
            while (true) {
                this.swap(from, end);
                this.siftDown(from, from, end);
                if (end == n) break;
                --end;
            }
        }
    }

    public final void heapify(int from, int to) {
        int i = Companion.heapParent(from, to - 1);
        if (from <= i) {
            while (true) {
                this.siftDown(i, from, to);
                if (i == from) break;
                --i;
            }
        }
    }

    public final void siftDown(int i, int from, int to) {
        int i2 = i;
        int leftChild = Companion.heapChild(from, i2);
        while (leftChild < to) {
            int rightChild = leftChild + 1;
            if (this.compare(i2, leftChild) < 0) {
                if (rightChild < to && this.compare(leftChild, rightChild) < 0) {
                    this.swap(i2, rightChild);
                    i2 = rightChild;
                } else {
                    this.swap(i2, leftChild);
                    i2 = leftChild;
                }
            } else {
                if (rightChild >= to || this.compare(i2, rightChild) >= 0) break;
                this.swap(i2, rightChild);
                i2 = rightChild;
            }
            leftChild = Companion.heapChild(from, i2);
        }
    }

    @JvmOverloads
    public final void binarySort(int from, int to) {
        Sorter.binarySort$default(this, from, to, 0, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/Sorter$Companion;", "", "<init>", "()V", "BINARY_SORT_THRESHOLD", "", "INSERTION_SORT_THRESHOLD", "heapParent", "from", "i", "heapChild", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int heapParent(int from, int i) {
            return (i - 1 - from >>> 1) + from;
        }

        public final int heapChild(int from, int i) {
            return (i - from << 1) + 1 + from;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

