/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0003H\u0016J \u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0003H\u0002J(\u0010(\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0003H\u0016J \u0010)\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0015H\u0002J(\u0010,\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003H\u0016J \u00100\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003H\u0002J\u0018\u00101\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0002J\u0010\u00103\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0002J\u0010\u00107\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0010\u00108\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0016J \u00109\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0003H\u0002J(\u0010:\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u0000H\u0002J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010?\u001a\u00020@H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u0004\b\u0013\u0010\u0005R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006B"}, d2={"Lorg/gnit/lucenekmp/util/SparseFixedBitSet;", "Lorg/gnit/lucenekmp/util/BitSet;", "length", "", "<init>", "(I)V", "indices", "", "getIndices", "()[J", "bits", "", "getBits", "()[[J", "[[J", "getLength", "()I", "nonZeroLongCount", "getNonZeroLongCount", "setNonZeroLongCount", "ramBytesUsed", "", "getRamBytesUsed", "()J", "setRamBytesUsed", "(J)V", "clear", "", "consistent", "", "index", "cardinality", "approximateCardinality", "get", "i", "getAndSet", "set", "insertBlock", "i4096", "i64bit", "insertLong", "and", "i64", "mask", "removeLong", "o", "from", "to", "clearWithinBlock", "firstDoc", "i4096upper", "nextSetBit", "start", "upperBound", "nextSetBitInRange", "lastDoc", "prevSetBit", "longBits", "or", "other", "orDense", "it", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSparseFixedBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SparseFixedBitSet.kt\norg/gnit/lucenekmp/util/SparseFixedBitSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,579:1\n1#2:580\n*E\n"})
public final class SparseFixedBitSet
extends BitSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] indices;
    @NotNull
    private final long[][] bits;
    private final int length;
    private int nonZeroLongCount;
    private long ramBytesUsed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(SparseFixedBitSet.class));
    private static final long SINGLE_ELEMENT_ARRAY_BYTES_USED = RamUsageEstimator.Companion.sizeOf(new long[1]);
    private static final int MASK_4096 = 4095;

    public SparseFixedBitSet(int length) {
        if (!(length >= 1)) {
            boolean bl = false;
            String string = "length needs to be >= 1";
            throw new IllegalArgumentException(string.toString());
        }
        this.length = length;
        int blockCount = SparseFixedBitSet.Companion.blockCount(length);
        this.indices = new long[blockCount];
        this.bits = new long[blockCount][];
        this.ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.indices) + RamUsageEstimator.Companion.shallowSizeOf(this.bits);
    }

    @NotNull
    public final long[] getIndices() {
        return this.indices;
    }

    @NotNull
    public final long[][] getBits() {
        return this.bits;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getNonZeroLongCount() {
        return this.nonZeroLongCount;
    }

    public final void setNonZeroLongCount(int n) {
        this.nonZeroLongCount = n;
    }

    public final long getRamBytesUsed() {
        return this.ramBytesUsed;
    }

    public final void setRamBytesUsed(long l) {
        this.ramBytesUsed = l;
    }

    @Override
    public void clear() {
        ArraysKt.fill$default((Object[])((Object[])this.bits), null, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((long[])this.indices, (long)0L, (int)0, (int)0, (int)6, null);
        this.nonZeroLongCount = 0;
        this.ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.indices) + RamUsageEstimator.Companion.shallowSizeOf(this.bits);
    }

    @Override
    public int length() {
        return this.length;
    }

    private final boolean consistent(int index) {
        if (!(index >= 0 && index < this.length)) {
            boolean bl = false;
            String string = "index=" + index + ",length=" + this.length;
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        long[][] lArray = this.bits;
        int n = ((Object[])lArray).length;
        for (int i = 0; i < n; ++i) {
            long[] bitArray = lArray[i];
            if (bitArray == null) continue;
            for (long bits : bitArray) {
                cardinality += LongExtKt.bitCount(LongCompanionObject.INSTANCE, bits);
            }
        }
        return cardinality;
    }

    @Override
    public int approximateCardinality() {
        int totalLongs = this.length + 63 >>> 6;
        if (!(totalLongs >= this.nonZeroLongCount)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int zeroLongs = totalLongs - this.nonZeroLongCount;
        long estimate = (long)Math.rint((double)totalLongs * Math.log((double)totalLongs / (double)zeroLongs));
        return (int)Math.min((long)this.length, estimate);
    }

    @Override
    public boolean get(int i) {
        if (!this.consistent(i)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int i4096 = i >>> 12;
        long index = this.indices[i4096];
        int i64 = i >>> 6;
        long i64bit = 1L << i64;
        if ((index & i64bit) == 0L) {
            return false;
        }
        long[] lArray = this.bits[i4096];
        Intrinsics.checkNotNull((Object)lArray);
        long bits = lArray[LongExtKt.bitCount(LongCompanionObject.INSTANCE, index & i64bit - 1L)];
        return (bits & 1L << i) != 0L;
    }

    @Override
    public boolean getAndSet(int i) {
        if (!this.consistent(i)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int i4096 = i >>> 12;
        long index = this.indices[i4096];
        int i64 = i >>> 6;
        long i64bit = 1L << i64;
        if ((index & i64bit) != 0L) {
            int location = LongExtKt.bitCount(LongCompanionObject.INSTANCE, index & i64bit - 1L);
            long bit = 1L << i;
            long[] lArray = this.bits[i4096];
            Intrinsics.checkNotNull((Object)lArray);
            boolean v = (lArray[location] & bit) != 0L;
            long[] lArray2 = this.bits[i4096];
            Intrinsics.checkNotNull((Object)lArray2);
            long[] lArray3 = this.bits[i4096];
            Intrinsics.checkNotNull((Object)lArray3);
            lArray2[location] = lArray3[location] | bit;
            return v;
        }
        if (index == 0L) {
            this.insertBlock(i4096, i64bit, i);
            return false;
        }
        this.insertLong(i4096, i64bit, i, index);
        return false;
    }

    @Override
    public void set(int i) {
        if (!this.consistent(i)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int i4096 = i >>> 12;
        long index = this.indices[i4096];
        int i64 = i >>> 6;
        long i64bit = 1L << i64;
        if ((index & i64bit) != 0L) {
            long[] lArray = this.bits[i4096];
            Intrinsics.checkNotNull((Object)lArray);
            int n = LongExtKt.bitCount(LongCompanionObject.INSTANCE, index & i64bit - 1L);
            long[] lArray2 = this.bits[i4096];
            Intrinsics.checkNotNull((Object)lArray2);
            lArray[n] = lArray2[LongExtKt.bitCount(LongCompanionObject.INSTANCE, index & i64bit - 1L)] | 1L << i;
        } else if (index == 0L) {
            this.insertBlock(i4096, i64bit, i);
        } else {
            this.insertLong(i4096, i64bit, i, index);
        }
    }

    private final void insertBlock(int i4096, long i64bit, int i) {
        this.indices[i4096] = i64bit;
        if (!(this.bits[i4096] == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] lArray = new long[]{1L << i};
        this.bits[i4096] = lArray;
        ++this.nonZeroLongCount;
        this.ramBytesUsed += SINGLE_ELEMENT_ARRAY_BYTES_USED;
    }

    private final void insertLong(int i4096, long i64bit, int i, long index) {
        this.indices[i4096] = this.indices[i4096] | i64bit;
        int o = LongExtKt.bitCount(LongCompanionObject.INSTANCE, index & i64bit - 1L);
        long[] bitArray = this.bits[i4096];
        Intrinsics.checkNotNull((Object)bitArray);
        if (bitArray[bitArray.length - 1] == 0L) {
            ArraysKt.copyInto((long[])bitArray, (long[])bitArray, (int)(o + 1), (int)o, (int)(bitArray.length - 1));
            bitArray[o] = 1L << i;
        } else {
            int newSize = SparseFixedBitSet.Companion.oversize(bitArray.length + 1);
            long[] newBitArray = new long[newSize];
            ArraysKt.copyInto((long[])bitArray, (long[])newBitArray, (int)0, (int)0, (int)o);
            newBitArray[o] = 1L << i;
            ArraysKt.copyInto((long[])bitArray, (long[])newBitArray, (int)(o + 1), (int)o, (int)bitArray.length);
            this.bits[i4096] = newBitArray;
            this.ramBytesUsed += (long)(newBitArray.length - bitArray.length << 3);
        }
        ++this.nonZeroLongCount;
    }

    @Override
    public void clear(int i) {
        if (!this.consistent(i)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int i4096 = i >>> 12;
        int i64 = i >>> 6;
        this.and(i4096, i64, 1L << i ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private final void and(int i4096, int i64, long mask) {
        long index = this.indices[i4096];
        if ((index & 1L << i64) != 0L) {
            int o = LongExtKt.bitCount(LongCompanionObject.INSTANCE, index & (1L << i64) - 1L);
            long[] lArray = this.bits[i4096];
            Intrinsics.checkNotNull((Object)lArray);
            long bits = lArray[o] & mask;
            if (bits == 0L) {
                this.removeLong(i4096, i64, index, o);
            } else {
                long[] lArray2 = this.bits[i4096];
                Intrinsics.checkNotNull((Object)lArray2);
                lArray2[o] = bits;
            }
        }
    }

    private final void removeLong(int i4096, int i64, long index, int o) {
        long index2 = index;
        this.indices[i4096] = index2 &= 1L << i64 ^ 0xFFFFFFFFFFFFFFFFL;
        if (index2 == 0L) {
            this.bits[i4096] = null;
        } else {
            int length = LongExtKt.bitCount(LongCompanionObject.INSTANCE, index2);
            long[] lArray = this.bits[i4096];
            Intrinsics.checkNotNull((Object)lArray);
            long[] bitArray = lArray;
            System.INSTANCE.arraycopy(bitArray, o + 1, bitArray, o, length - o);
            bitArray[length] = 0L;
        }
        --this.nonZeroLongCount;
    }

    @Override
    public void clear(int from, int to) {
        if (!(from >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(to <= this.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (from >= to) {
            return;
        }
        int firstBlock = from >>> 12;
        int lastBlock = to - 1 >>> 12;
        if (firstBlock == lastBlock) {
            this.clearWithinBlock(firstBlock, from & 0xFFF, to - 1 & 0xFFF);
        } else {
            this.clearWithinBlock(firstBlock, from & 0xFFF, 4095);
            for (int i = firstBlock + 1; i < lastBlock; ++i) {
                this.nonZeroLongCount -= LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.indices[i]);
                this.indices[i] = 0L;
                this.bits[i] = null;
            }
            this.clearWithinBlock(lastBlock, 0, to - 1 & 0xFFF);
        }
    }

    private final void clearWithinBlock(int i4096, int from, int to) {
        int firstLong = from >>> 6;
        int lastLong = to >>> 6;
        if (firstLong == lastLong) {
            this.and(i4096, firstLong, SparseFixedBitSet.Companion.mask(from, to) ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            if (!(firstLong < lastLong)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.and(i4096, lastLong, SparseFixedBitSet.Companion.mask(0, to) ^ 0xFFFFFFFFFFFFFFFFL);
            int i = lastLong - 1;
            int n = firstLong + 1;
            if (n <= i) {
                while (true) {
                    this.and(i4096, i, 0L);
                    if (i == n) break;
                    --i;
                }
            }
            this.and(i4096, firstLong, SparseFixedBitSet.Companion.mask(from, 63) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private final int firstDoc(int i4096, int i4096upper) {
        int i40962 = 0;
        if (!(i4096upper <= this.indices.length)) {
            boolean bl = false;
            String string = "i4096upper=" + i40962 + ", indices.length=" + this.indices.length;
            throw new IllegalArgumentException(string.toString());
        }
        long index = 0L;
        for (i40962 = i4096; i40962 < i4096upper; ++i40962) {
            index = this.indices[i40962];
            if (index == 0L) continue;
            int i64 = LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, index);
            long[] lArray = this.bits[i40962];
            Intrinsics.checkNotNull((Object)lArray);
            return i40962 << 12 | i64 << 6 | LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, lArray[0]);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int nextSetBit(int i) {
        return this.nextSetBitInRange(i, this.length);
    }

    @Override
    public int nextSetBit(int start, int upperBound) {
        int res = this.nextSetBitInRange(start, upperBound);
        return res < upperBound ? res : Integer.MAX_VALUE;
    }

    private final int nextSetBitInRange(int start, int upperBound) {
        long indexBits;
        if (!(start < this.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(upperBound > start && upperBound <= this.length)) {
            boolean $i$a$-require-SparseFixedBitSet$nextSetBitInRange$22 = false;
            String $i$a$-require-SparseFixedBitSet$nextSetBitInRange$22 = "upperBound=" + upperBound + ", start=" + start + ", length=" + this.length;
            throw new IllegalArgumentException($i$a$-require-SparseFixedBitSet$nextSetBitInRange$22.toString());
        }
        int i4096 = start >>> 12;
        long index = this.indices[i4096];
        long[] bitArray = this.bits[i4096];
        int i64 = start >>> 6;
        long i64bit = 1L << i64;
        int o = LongExtKt.bitCount(LongCompanionObject.INSTANCE, index & i64bit - 1L);
        if ((index & i64bit) != 0L) {
            Intrinsics.checkNotNull((Object)bitArray);
            long bits = bitArray[o] >>> start;
            if (bits != 0L) {
                return start + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, bits);
            }
            ++o;
        }
        if ((indexBits = index >>> i64 >>> 1) == 0L) {
            int i4096upper = upperBound == this.length ? this.indices.length : SparseFixedBitSet.Companion.blockCount(upperBound);
            return this.firstDoc(i4096 + 1, i4096upper);
        }
        Intrinsics.checkNotNull((Object)bitArray);
        long bits = bitArray[o];
        return (i64 += 1 + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, indexBits)) << 6 | LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, bits);
    }

    private final int lastDoc(int i4096) {
        long index = 0L;
        for (int i40962 = i4096; i40962 >= 0; --i40962) {
            index = this.indices[i40962];
            if (index == 0L) continue;
            int i64 = 63 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, index);
            long[] lArray = this.bits[i40962];
            Intrinsics.checkNotNull((Object)lArray);
            long bits = lArray[LongExtKt.bitCount(LongCompanionObject.INSTANCE, index) - 1];
            return i40962 << 12 | i64 << 6 | 63 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, bits);
        }
        return -1;
    }

    @Override
    public int prevSetBit(int i) {
        long bits;
        if (!(i >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int i4096 = i >>> 12;
        long index = this.indices[i4096];
        long[] bitArray = this.bits[i4096];
        int i64 = i >>> 6;
        long indexBits = index & (1L << i64) - 1L;
        int o = LongExtKt.bitCount(LongCompanionObject.INSTANCE, indexBits);
        if ((index & 1L << i64) != 0L) {
            Intrinsics.checkNotNull((Object)bitArray);
            bits = bitArray[o] & (1L << i << 1) - 1L;
            if (bits != 0L) {
                return i64 << 6 | 63 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, bits);
            }
        }
        if (indexBits == 0L) {
            return this.lastDoc(i4096 - 1);
        }
        i64 = 63 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, indexBits);
        Intrinsics.checkNotNull((Object)bitArray);
        bits = bitArray[o - 1];
        return i4096 << 12 | i64 << 6 | 63 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, bits);
    }

    private final long longBits(long index, long[] bits, int i64) {
        return (index & 1L << i64) == 0L ? 0L : bits[LongExtKt.bitCount(LongCompanionObject.INSTANCE, index & (1L << i64) - 1L)];
    }

    private final void or(int i4096, long index, long[] bits, int nonZeroLongCount) {
        if (!(LongExtKt.bitCount(LongCompanionObject.INSTANCE, index) == nonZeroLongCount)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long currentIndex = this.indices[i4096];
        if (currentIndex == 0L) {
            this.indices[i4096] = index;
            long[] newBits = ArrayUtil.Companion.copyOfSubArray(bits, 0, nonZeroLongCount);
            this.bits[i4096] = newBits;
            this.ramBytesUsed += SINGLE_ELEMENT_ARRAY_BYTES_USED + ((long)newBits.length - 1L << 3);
            this.nonZeroLongCount += nonZeroLongCount;
            return;
        }
        long[] currentBits = this.bits[i4096];
        long[] newBits = null;
        long newIndex = currentIndex | index;
        int requiredCapacity = LongExtKt.bitCount(LongCompanionObject.INSTANCE, newIndex);
        Intrinsics.checkNotNull((Object)currentBits);
        if (currentBits.length >= requiredCapacity) {
            newBits = currentBits;
        } else {
            newBits = new long[SparseFixedBitSet.Companion.oversize(requiredCapacity)];
            this.ramBytesUsed += (long)(newBits.length - currentBits.length) << 3;
        }
        int i = LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, newIndex);
        int newO = LongExtKt.bitCount(LongCompanionObject.INSTANCE, newIndex) - 1;
        while (i < 64) {
            int bitIndex = 63 - i;
            if (!(newO == LongExtKt.bitCount(LongCompanionObject.INSTANCE, newIndex & (1L << bitIndex) - 1L))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            newBits[newO] = this.longBits(currentIndex, currentBits, bitIndex) | this.longBits(index, bits, bitIndex);
            i += 1 + LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, newIndex << i + 1);
            --newO;
        }
        this.indices[i4096] = newIndex;
        this.bits[i4096] = newBits;
        this.nonZeroLongCount += nonZeroLongCount - LongExtKt.bitCount(LongCompanionObject.INSTANCE, currentIndex & index);
    }

    private final void or(SparseFixedBitSet other) {
        int n = other.indices.length;
        for (int i = 0; i < n; ++i) {
            long index = other.indices[i];
            if (index == 0L) continue;
            long[] lArray = other.bits[i];
            Intrinsics.checkNotNull((Object)lArray);
            this.or(i, index, lArray, LongExtKt.bitCount(LongCompanionObject.INSTANCE, index));
        }
    }

    private final void orDense(DocIdSetIterator it) throws IOException {
        this.checkUnpositioned(it);
        int firstDoc = it.nextDoc();
        if (firstDoc == Integer.MAX_VALUE) {
            return;
        }
        int i4096 = firstDoc >>> 12;
        int i64 = firstDoc >>> 6;
        long index = 1L << i64;
        long currentLong = 1L << firstDoc;
        long[] longs = new long[64];
        int numLongs = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int doc64 = doc >>> 6;
            if (doc64 == i64) {
                currentLong |= 1L << doc;
            } else {
                longs[numLongs++] = currentLong;
                int doc4096 = doc >>> 12;
                if (doc4096 == i4096) {
                    index |= 1L << doc64;
                } else {
                    this.or(i4096, index, longs, numLongs);
                    i4096 = doc4096;
                    index = 1L << doc64;
                    numLongs = 0;
                }
                i64 = doc64;
                currentLong = 1L << doc;
            }
            doc = it.nextDoc();
        }
        longs[numLongs++] = currentLong;
        this.or(i4096, index, longs, numLongs);
    }

    @Override
    public void or(@NotNull DocIdSetIterator it) throws IOException {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SparseFixedBitSet $this$or_u24lambda_u244 = this;
        boolean bl = false;
        SparseFixedBitSet other = BitSetIterator.Companion.getSparseFixedBitSetOrNull(it);
        if (other != null) {
            $this$or_u24lambda_u244.checkUnpositioned(it);
            $this$or_u24lambda_u244.or(other);
            return;
        }
        if (it.cost() < (long)this.indices.length) {
            super.or(it);
        } else {
            this.orDense(it);
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @NotNull
    public String toString() {
        return "SparseFixedBitSet(size=" + this.length + ",cardinality=~" + this.approximateCardinality();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/SparseFixedBitSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "SINGLE_ELEMENT_ARRAY_BYTES_USED", "MASK_4096", "", "blockCount", "length", "oversize", "s", "mask", "from", "to", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int blockCount(int length) {
            int blockCount = length >>> 12;
            if (blockCount << 12 < length) {
                ++blockCount;
            }
            if (!(blockCount << 12 >= length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return blockCount;
        }

        private final int oversize(int s) {
            int newSize = s + (s >>> 1);
            if (newSize > 50) {
                newSize = 64;
            }
            return newSize;
        }

        private final long mask(int from, int to) {
            return (1L << to - from << 1) - 1L << from;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

