/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.MSBRadixSorter;
import org.gnit.lucenekmp.util.Sorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H$J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H$J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J0\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/StableMSBRadixSorter;", "Lorg/gnit/lucenekmp/util/MSBRadixSorter;", "maxLength", "", "<init>", "(I)V", "fixedStartOffsets", "", "save", "", "i", "j", "restore", "getFallbackSorter", "Lorg/gnit/lucenekmp/util/Sorter;", "k", "reorder", "from", "to", "startOffsets", "endOffsets", "MergeSorter", "core"})
public abstract class StableMSBRadixSorter
extends MSBRadixSorter {
    @NotNull
    private final int[] fixedStartOffsets = new int[257];

    public StableMSBRadixSorter(int maxLength) {
        super(maxLength);
    }

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    @Override
    @Nullable
    protected Sorter getFallbackSorter(int k) {
        return new MergeSorter(this, k){
            final /* synthetic */ StableMSBRadixSorter this$0;
            final /* synthetic */ int $k;
            {
                this.this$0 = $receiver;
                this.$k = $k;
            }

            protected void save(int i, int j) {
                this.this$0.save(i, j);
            }

            protected void restore(int i, int j) {
                this.this$0.restore(i, j);
            }

            protected void swap(int i, int j) {
                this.this$0.swap(i, j);
            }

            protected int compare(int i, int j) {
                int n = this.this$0.getMaxLength();
                for (int o = this.$k; o < n; ++o) {
                    int b2;
                    int b1 = this.this$0.byteAt(i, o);
                    if (b1 != (b2 = this.this$0.byteAt(j, o))) {
                        return b1 - b2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }
        };
    }

    @Override
    protected void reorder(int from, int to, @NotNull int[] startOffsets, @NotNull int[] endOffsets, int k) {
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        ArraysKt.copyInto((int[])startOffsets, (int[])this.fixedStartOffsets, (int)0, (int)0, (int)startOffsets.length);
        for (int i = 0; i < 257; ++i) {
            int limit = endOffsets[i];
            for (int h1 = this.fixedStartOffsets[i]; h1 < limit; ++h1) {
                int b = this.getBucket(from + h1, k);
                int n = startOffsets[b];
                startOffsets[b] = n + 1;
                int h2 = n;
                this.save(from + h1, from + h2);
            }
        }
        this.restore(from, to);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H$J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H$J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/StableMSBRadixSorter$MergeSorter;", "Lorg/gnit/lucenekmp/util/Sorter;", "<init>", "()V", "sort", "", "from", "", "to", "mergeSort", "save", "i", "j", "restore", "bulkSave", "tmpFrom", "len", "merge", "mid", "core"})
    public static abstract class MergeSorter
    extends Sorter {
        @Override
        public void sort(int from, int to) {
            this.checkRange(from, to);
            this.mergeSort(from, to);
        }

        private final void mergeSort(int from, int to) {
            if (to - from < 20) {
                Sorter.binarySort$default(this, from, to, 0, 4, null);
            } else {
                int mid = from + to >>> 1;
                this.mergeSort(from, mid);
                this.mergeSort(mid, to);
                this.merge(from, to, mid);
            }
        }

        protected abstract void save(int var1, int var2);

        protected abstract void restore(int var1, int var2);

        private final void bulkSave(int from, int tmpFrom, int len) {
            for (int i = 0; i < len; ++i) {
                this.save(from + i, tmpFrom + i);
            }
        }

        private final void merge(int from, int to, int mid) {
            block6: {
                if (!(to > mid && mid > from)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.compare(mid - 1, mid) <= 0) {
                    return;
                }
                int left = from;
                int right = mid;
                int index = from;
                while (true) {
                    int cmp;
                    if ((cmp = this.compare(left, right)) <= 0) {
                        this.save(left++, index++);
                        if (left != mid) continue;
                        if (!(index == right)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.bulkSave(right, index, to - right);
                        break block6;
                    }
                    this.save(right++, index++);
                    if (right == to) break;
                }
                if (!(to - index == mid - left)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.bulkSave(left, index, mid - left);
            }
            this.restore(from, to);
        }
    }
}

