/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import com.ionspin.kotlin.bignum.integer.BigInteger;
import com.ionspin.kotlin.bignum.integer.Sign;
import dev.scottpierce.envvar.EnvVar;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.time.Clock;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.BigIntegerExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IntsRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J&\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0005J(\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J*\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\rJ\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\rJ\u0010\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010,\u001a\u00020-R\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/util/StringHelper;", "", "<init>", "()V", "bytesDifference", "", "priorTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "currentTerm", "sortKeyLength", "startsWith", "", "ref", "", "prefix", "endsWith", "suffix", "GOOD_FAST_HASH_SEED", "getGOOD_FAST_HASH_SEED", "()I", "setGOOD_FAST_HASH_SEED", "(I)V", "murmurhash3_x86_32", "data", "offset", "len", "seed", "bytes", "murmurhash3_x64_128", "", "length", "", "fmix64", "hash", "nextId", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "mask128", "idLock", "ID_LENGTH", "randomId", "idToString", "", "id", "intsRefToBytesRef", "ints", "Lorg/gnit/lucenekmp/util/IntsRef;", "core"})
@SourceDebugExtension(value={"SMAP\nStringHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringHelper.kt\norg/gnit/lucenekmp/util/StringHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,753:1\n1#2:754\n*E\n"})
public final class StringHelper {
    @NotNull
    public static final StringHelper INSTANCE = new StringHelper();
    private static int GOOD_FAST_HASH_SEED;
    @Nullable
    private static BigInteger nextId;
    @Nullable
    private static BigInteger mask128;
    @NotNull
    private static final Object idLock;
    public static final int ID_LENGTH = 16;

    private StringHelper() {
    }

    public final int bytesDifference(@NotNull BytesRef priorTerm, @Nullable BytesRef currentTerm) {
        Intrinsics.checkNotNullParameter((Object)priorTerm, (String)"priorTerm");
        byte[] byArray = priorTerm.getBytes();
        int n = priorTerm.getOffset();
        int n2 = priorTerm.getOffset() + priorTerm.getLength();
        BytesRef bytesRef = currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef);
        int mismatch = Arrays.INSTANCE.mismatch(byArray, n, n2, bytesRef.getBytes(), currentTerm.getOffset(), currentTerm.getOffset() + currentTerm.getLength());
        if (!(mismatch >= 0)) {
            boolean bl = false;
            String string = "terms out of order: priorTerm=" + priorTerm + ",currentTerm=" + currentTerm;
            throw new IllegalArgumentException(string.toString());
        }
        return mismatch;
    }

    public final int sortKeyLength(@NotNull BytesRef priorTerm, @NotNull BytesRef currentTerm) {
        Intrinsics.checkNotNullParameter((Object)priorTerm, (String)"priorTerm");
        Intrinsics.checkNotNullParameter((Object)currentTerm, (String)"currentTerm");
        return this.bytesDifference(priorTerm, currentTerm) + 1;
    }

    public final boolean startsWith(@NotNull byte[] ref, @NotNull BytesRef prefix) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (ref.length < prefix.getLength()) {
            return false;
        }
        return Arrays.INSTANCE.equals(ref, 0, prefix.getLength(), prefix.getBytes(), prefix.getOffset(), prefix.getOffset() + prefix.getLength());
    }

    public final boolean startsWith(@NotNull BytesRef ref, @NotNull BytesRef prefix) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (ref.getLength() < prefix.getLength()) {
            return false;
        }
        return Arrays.INSTANCE.equals(ref.getBytes(), ref.getOffset(), ref.getOffset() + prefix.getLength(), prefix.getBytes(), prefix.getOffset(), prefix.getOffset() + prefix.getLength());
    }

    public final boolean endsWith(@NotNull BytesRef ref, @NotNull BytesRef suffix) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        int startAt = ref.getLength() - suffix.getLength();
        if (startAt < 0) {
            return false;
        }
        return Arrays.INSTANCE.equals(ref.getBytes(), ref.getOffset() + startAt, ref.getOffset() + startAt + suffix.getLength(), suffix.getBytes(), suffix.getOffset(), suffix.getOffset() + suffix.getLength());
    }

    public final int getGOOD_FAST_HASH_SEED() {
        return GOOD_FAST_HASH_SEED;
    }

    public final void setGOOD_FAST_HASH_SEED(int n) {
        GOOD_FAST_HASH_SEED = n;
    }

    public final int murmurhash3_x86_32(@NotNull byte[] data, int offset, int len, int seed) {
        int k1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            k1 = BitUtilKt.getIntLE(data, i, 0);
            k1 *= c1;
            k1 = IntExtKt.rotateLeft(IntCompanionObject.INSTANCE, k1, 15);
            h1 ^= (k1 *= c2);
            h1 = IntExtKt.rotateLeft(IntCompanionObject.INSTANCE, h1, 13);
            h1 = h1 * 5 + -430675100;
        }
        k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= c1;
                k1 = IntExtKt.rotateLeft(IntCompanionObject.INSTANCE, k1, 15);
                h1 ^= (k1 *= c2);
                break;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= c1;
                k1 = IntExtKt.rotateLeft(IntCompanionObject.INSTANCE, k1, 15);
                h1 ^= (k1 *= c2);
                break;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= c1;
                k1 = IntExtKt.rotateLeft(IntCompanionObject.INSTANCE, k1, 15);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public final int murmurhash3_x86_32(@NotNull BytesRef bytes, int seed) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.murmurhash3_x86_32(bytes.getBytes(), bytes.getOffset(), bytes.getLength(), seed);
    }

    @Nullable
    public final long[] murmurhash3_x64_128(@NotNull byte[] data, int offset, int length, int seed) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.murmurhash3_x64_128(data, offset, length, (long)seed & 0xFFFFFFFFL);
    }

    private final long[] murmurhash3_x64_128(byte[] data, int offset, int length, long seed) {
        long h1 = seed;
        long h2 = seed;
        int nblocks = length >> 4;
        long C1 = -8663945395140668459L;
        long C2 = 5545529020109919103L;
        int R1 = 31;
        int R2 = 27;
        int R3 = 33;
        int M = 5;
        int N1 = 1390208809;
        int N2 = 944331445;
        for (int i = 0; i < nblocks; ++i) {
            int index = offset + (i << 4);
            long k1 = BitUtilKt.getLongLE(data, index);
            long k2 = BitUtilKt.getLongLE(data, index + 8);
            k1 *= C1;
            k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
            h1 ^= (k1 *= C2);
            h1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, h1, R2);
            h1 += h2;
            h1 = h1 * (long)M + (long)N1;
            k2 *= C2;
            k2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k2, R3);
            h2 ^= (k2 *= C1);
            h2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, h2, R1);
            h2 += h1;
            h2 = h2 * (long)M + (long)N2;
        }
        long k1 = 0L;
        long k2 = 0L;
        int index = offset + (nblocks << 4);
        switch (length & 0xF) {
            case 15: {
                k2 ^= ((long)data[index + 14] & 0xFFL) << 48;
                k2 ^= ((long)data[index + 13] & 0xFFL) << 40;
                k2 ^= ((long)data[index + 12] & 0xFFL) << 32;
                k2 ^= ((long)data[index + 11] & 0xFFL) << 24;
                k2 ^= ((long)data[index + 10] & 0xFFL) << 16;
                k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
                k2 ^= (long)(data[index + 8] & 0xFF);
                k2 *= C2;
                k2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k2, R3);
                h2 ^= (k2 *= C1);
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 14: {
                k2 ^= ((long)data[index + 13] & 0xFFL) << 40;
                k2 ^= ((long)data[index + 12] & 0xFFL) << 32;
                k2 ^= ((long)data[index + 11] & 0xFFL) << 24;
                k2 ^= ((long)data[index + 10] & 0xFFL) << 16;
                k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
                k2 ^= (long)(data[index + 8] & 0xFF);
                k2 *= C2;
                k2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k2, R3);
                h2 ^= (k2 *= C1);
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 13: {
                k2 ^= ((long)data[index + 12] & 0xFFL) << 32;
                k2 ^= ((long)data[index + 11] & 0xFFL) << 24;
                k2 ^= ((long)data[index + 10] & 0xFFL) << 16;
                k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
                k2 ^= (long)(data[index + 8] & 0xFF);
                k2 *= C2;
                k2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k2, R3);
                h2 ^= (k2 *= C1);
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 12: {
                k2 ^= ((long)data[index + 11] & 0xFFL) << 24;
                k2 ^= ((long)data[index + 10] & 0xFFL) << 16;
                k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
                k2 ^= (long)(data[index + 8] & 0xFF);
                k2 *= C2;
                k2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k2, R3);
                h2 ^= (k2 *= C1);
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 11: {
                k2 ^= ((long)data[index + 10] & 0xFFL) << 16;
                k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
                k2 ^= (long)(data[index + 8] & 0xFF);
                k2 *= C2;
                k2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k2, R3);
                h2 ^= (k2 *= C1);
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 10: {
                k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
                k2 ^= (long)(data[index + 8] & 0xFF);
                k2 *= C2;
                k2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k2, R3);
                h2 ^= (k2 *= C1);
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 9: {
                k2 ^= (long)(data[index + 8] & 0xFF);
                k2 *= C2;
                k2 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k2, R3);
                h2 ^= (k2 *= C1);
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 8: {
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 7: {
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 6: {
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 5: {
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 4: {
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 3: {
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 2: {
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
                break;
            }
            case 1: {
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= C1;
                k1 = LongExtKt.rotateLeft(LongCompanionObject.INSTANCE, k1, R1);
                h1 ^= (k1 *= C2);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = this.fmix64(h1);
        h2 = this.fmix64(h2);
        h1 += h2;
        long[] lArray = new long[]{h1, h2 += h1};
        return lArray;
    }

    private final long fmix64(long hash) {
        long hash2 = hash;
        hash2 ^= hash2 >>> 33;
        hash2 *= -49064778989728563L;
        hash2 ^= hash2 >>> 33;
        hash2 *= -4265267296055464877L;
        hash2 ^= hash2 >>> 33;
        return hash2;
    }

    @Nullable
    public final long[] murmurhash3_x64_128(@NotNull BytesRef data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.murmurhash3_x64_128(data.getBytes(), data.getOffset(), data.getLength(), 104729);
    }

    @NotNull
    public final byte[] randomId() {
        Object bits;
        Object object;
        block7: {
            block6: {
                object = nextId;
                if (object == null) break block6;
                byte[] byArray = object.toByteArray();
                object = byArray;
                if (byArray != null) break block7;
            }
            object = new byte[0];
        }
        if (((BigInteger)(bits = object)).length > 16) {
            if (!(((BigInteger)bits).length == 17)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(bits[0] == false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return ArrayUtil.Companion.copyOfSubArray((byte[])bits, 1, ((BigInteger)bits).length);
        }
        byte[] result = new byte[16];
        ArraysKt.copyInto((byte[])bits, (byte[])result, (int)(result.length - ((BigInteger)bits).length), (int)0, (int)((BigInteger)bits).length);
        return result;
    }

    @NotNull
    public final String idToString(@Nullable byte[] id) {
        if (id == null) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)sb.append(BigInteger.Companion.fromByteArray(id, Sign.POSITIVE).toString()));
        if (id.length != 16) {
            sb.append(" (INVALID FORMAT)");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public final BytesRef intsRefToBytesRef(@NotNull IntsRef ints) {
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        byte[] bytes = new byte[ints.getLength()];
        int n = ints.getLength();
        for (int i = 0; i < n; ++i) {
            int x = ints.getInts()[ints.getOffset() + i];
            if (!(x >= 0 && x <= 255)) {
                boolean bl = false;
                String string = "int at pos=" + i + " with value=" + x + " is out-of-bounds for byte";
                throw new IllegalArgumentException(string.toString());
            }
            bytes[i] = (byte)x;
        }
        return new BytesRef(bytes);
    }

    static {
        String prop = EnvVar.INSTANCE.get("tests.seed");
        GOOD_FAST_HASH_SEED = prop != null ? prop.hashCode() : (int)Clock.System.INSTANCE.now().toEpochMilliseconds();
        idLock = new Object();
        byte[] maskBytes128 = new byte[16];
        Arrays.INSTANCE.fill(maskBytes128, (byte)-1);
        mask128 = BigInteger.Companion.fromByteArray(maskBytes128, Sign.POSITIVE);
        String prop2 = EnvVar.INSTANCE.get("tests.seed");
        Long x0 = null;
        Long x1 = null;
        if (prop2 != null) {
            if (prop2.length() > 8) {
                String string = prop2.substring(prop2.length() - 8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                prop2 = string;
            }
            x1 = x0 = Long.valueOf(Long.parseLong(prop2, CharsKt.checkRadix((int)16)));
        } else {
            x0 = Clock.System.INSTANCE.now().toEpochMilliseconds();
            x1 = (long)Reflection.getOrCreateKotlinClass(StringHelper.class).hashCode() << 32;
        }
        for (int i = 0; i < 10; ++i) {
            Long s0;
            Long s1 = x0;
            x0 = s0 = x1;
            s1 = s1 ^ s1 << 23;
            x1 = s1 ^ s0 ^ s1 >>> 17 ^ s0 >>> 26;
        }
        byte[] maskBytes64 = new byte[8];
        Arrays.INSTANCE.fill(maskBytes64, (byte)-1);
        BigInteger mask64 = BigInteger.Companion.fromByteArray(maskBytes64, Sign.POSITIVE);
        BigInteger unsignedX0 = BigIntegerExtKt.valueOf(BigInteger.Companion, x0).and(mask64);
        BigInteger unsignedX1 = BigIntegerExtKt.valueOf(BigInteger.Companion, x1).and(mask64);
        nextId = unsignedX0.shl(64).or(unsignedX1);
    }
}

