/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.BytesRefComparator;
import org.gnit.lucenekmp.util.IntroSorter;
import org.gnit.lucenekmp.util.MSBRadixSorter;
import org.gnit.lucenekmp.util.Sorter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001%B!\b\u0004\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH$J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0014J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020#H\u0014J \u0010$\u001a\u00020\u00012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005H\u0014R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/util/StringSorter;", "Lorg/gnit/lucenekmp/util/Sorter;", "cmp", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/util/BytesRef;", "Lkotlin/Comparator;", "<init>", "(Ljava/util/Comparator;)V", "scratch1", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "getScratch1", "()Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "scratch2", "getScratch2", "pivotBuilder", "getPivotBuilder", "scratchBytes1", "getScratchBytes1", "()Lorg/gnit/lucenekmp/util/BytesRef;", "scratchBytes2", "getScratchBytes2", "pivot", "getPivot", "get", "", "builder", "result", "i", "", "compare", "j", "sort", "from", "to", "radixSorter", "Lorg/gnit/lucenekmp/util/BytesRefComparator;", "fallbackSorter", "MSBStringRadixSorter", "core"})
public abstract class StringSorter
extends Sorter {
    @NotNull
    private final Comparator<BytesRef> cmp;
    @NotNull
    private final BytesRefBuilder scratch1;
    @NotNull
    private final BytesRefBuilder scratch2;
    @NotNull
    private final BytesRefBuilder pivotBuilder;
    @NotNull
    private final BytesRef scratchBytes1;
    @NotNull
    private final BytesRef scratchBytes2;
    @NotNull
    private final BytesRef pivot;

    protected StringSorter(@NotNull Comparator<BytesRef> cmp) {
        Intrinsics.checkNotNullParameter(cmp, (String)"cmp");
        this.cmp = cmp;
        this.scratch1 = new BytesRefBuilder();
        this.scratch2 = new BytesRefBuilder();
        this.pivotBuilder = new BytesRefBuilder();
        this.scratchBytes1 = new BytesRef();
        this.scratchBytes2 = new BytesRef();
        this.pivot = new BytesRef();
    }

    @NotNull
    protected final BytesRefBuilder getScratch1() {
        return this.scratch1;
    }

    @NotNull
    protected final BytesRefBuilder getScratch2() {
        return this.scratch2;
    }

    @NotNull
    protected final BytesRefBuilder getPivotBuilder() {
        return this.pivotBuilder;
    }

    @NotNull
    protected final BytesRef getScratchBytes1() {
        return this.scratchBytes1;
    }

    @NotNull
    protected final BytesRef getScratchBytes2() {
        return this.scratchBytes2;
    }

    @NotNull
    protected final BytesRef getPivot() {
        return this.pivot;
    }

    protected abstract void get(@NotNull BytesRefBuilder var1, @NotNull BytesRef var2, int var3);

    @Override
    protected int compare(int i, int j) {
        this.get(this.scratch1, this.scratchBytes1, i);
        this.get(this.scratch2, this.scratchBytes2, j);
        return this.cmp.compare(this.scratchBytes1, this.scratchBytes2);
    }

    @Override
    public void sort(int from, int to) {
        if (this.cmp instanceof BytesRefComparator) {
            this.radixSorter((BytesRefComparator)this.cmp).sort(from, to);
        } else {
            this.fallbackSorter(this.cmp).sort(from, to);
        }
    }

    @NotNull
    protected Sorter radixSorter(@NotNull BytesRefComparator cmp) {
        Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
        return new MSBStringRadixSorter(cmp);
    }

    @NotNull
    protected Sorter fallbackSorter(@NotNull Comparator<BytesRef> cmp) {
        Intrinsics.checkNotNullParameter(cmp, (String)"cmp");
        return new IntroSorter(this, cmp){
            final /* synthetic */ StringSorter this$0;
            final /* synthetic */ Comparator<BytesRef> $cmp;
            {
                this.this$0 = $receiver;
                this.$cmp = $cmp;
            }

            protected void swap(int i, int j) {
                this.this$0.swap(i, j);
            }

            protected int compare(int i, int j) {
                this.this$0.get(this.this$0.getScratch1(), this.this$0.getScratchBytes1(), i);
                this.this$0.get(this.this$0.getScratch2(), this.this$0.getScratchBytes2(), j);
                return this.$cmp.compare(this.this$0.getScratchBytes1(), this.this$0.getScratchBytes2());
            }

            protected void setPivot(int i) {
                this.this$0.get(this.this$0.getPivotBuilder(), this.this$0.getPivot(), i);
            }

            protected int comparePivot(int j) {
                this.this$0.get(this.this$0.getScratch1(), this.this$0.getScratchBytes1(), j);
                return this.$cmp.compare(this.this$0.getPivot(), this.this$0.getScratchBytes1());
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/util/StringSorter$MSBStringRadixSorter;", "Lorg/gnit/lucenekmp/util/MSBRadixSorter;", "cmp", "Lorg/gnit/lucenekmp/util/BytesRefComparator;", "<init>", "(Lorg/gnit/lucenekmp/util/StringSorter;Lorg/gnit/lucenekmp/util/BytesRefComparator;)V", "swap", "", "i", "", "j", "byteAt", "k", "getFallbackSorter", "Lorg/gnit/lucenekmp/util/Sorter;", "core"})
    protected class MSBStringRadixSorter
    extends MSBRadixSorter {
        @NotNull
        private final BytesRefComparator cmp;

        public MSBStringRadixSorter(BytesRefComparator cmp) {
            Intrinsics.checkNotNullParameter((Object)cmp, (String)"cmp");
            super(cmp.getComparedBytesCount());
            this.cmp = cmp;
        }

        @Override
        protected void swap(int i, int j) {
            StringSorter.this.swap(i, j);
        }

        @Override
        protected int byteAt(int i, int k) {
            StringSorter.this.get(StringSorter.this.getScratch1(), StringSorter.this.getScratchBytes1(), i);
            return this.cmp.byteAt(StringSorter.this.getScratchBytes1(), k);
        }

        @Override
        @NotNull
        protected Sorter getFallbackSorter(int k) {
            return StringSorter.this.fallbackSorter((arg_0, arg_1) -> MSBStringRadixSorter.getFallbackSorter$lambda$0(this, k, arg_0, arg_1));
        }

        private static final int getFallbackSorter$lambda$0(MSBStringRadixSorter this$0, int $k, BytesRef o1, BytesRef o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return this$0.cmp.compare(o1, o2, $k);
        }
    }
}

