/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001EB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"J&\u0010\u001c\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"J.\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020\tJ\u001e\u0010&\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tJ\u000e\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010*\u001a\u00020\tJ\u000e\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0005J\u0016\u00103\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0019J \u00105\u001a\u0002062\u0006\u0010,\u001a\u00020\"2\u0006\u00107\u001a\u00020\t2\b\u00108\u001a\u0004\u0018\u000106J\u001e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tJ\u001e\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tJ\u000e\u0010?\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020:J&\u0010@\u001a\u00020\t2\u0006\u0010,\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020$J\u000e\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020\tJ\u0016\u0010@\u001a\u00020\t2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020$R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010-\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/gnit/lucenekmp/util/UnicodeUtil;", "", "<init>", "()V", "BIG_TERM", "Lorg/gnit/lucenekmp/util/BytesRef;", "getBIG_TERM", "()Lorg/gnit/lucenekmp/util/BytesRef;", "UNI_SUR_HIGH_START", "", "UNI_SUR_HIGH_END", "UNI_SUR_LOW_START", "UNI_SUR_LOW_END", "UNI_REPLACEMENT_CHAR", "UNI_MAX_BMP", "", "HALF_SHIFT", "HALF_MASK", "MIN_SUPPLEMENTARY_CODE_POINT", "SURROGATE_OFFSET", "getSURROGATE_OFFSET", "()I", "MAX_UTF8_BYTES_PER_CHAR", "v", "utf8CodeLength", "", "getUtf8CodeLength", "()[I", "UTF16toUTF8", "s", "", "offset", "length", "out", "", "source", "", "outOffset", "calcUTF16toUTF8Length", "len", "validUTF16String", "", "size", "codePointCount", "utf8", "LEAD_SURROGATE_SHIFT_", "TRAIL_SURROGATE_MASK_", "TRAIL_SURROGATE_MIN_VALUE", "LEAD_SURROGATE_MIN_VALUE", "SUPPLEMENTARY_MIN_VALUE", "LEAD_SURROGATE_OFFSET_", "UTF8toUTF32", "ints", "codePointAt", "Lorg/gnit/lucenekmp/util/UnicodeUtil$UTF8CodePoint;", "pos", "reuse", "newString", "", "codePoints", "count", "createString", "value", "toHexString", "UTF8toUTF16", "maxUTF8Length", "utf16Length", "bytesRef", "chars", "UTF8CodePoint", "core"})
@SourceDebugExtension(value={"SMAP\nUnicodeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnicodeUtil.kt\norg/gnit/lucenekmp/util/UnicodeUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,703:1\n10135#2:704\n10557#2,5:705\n*S KotlinDebug\n*F\n+ 1 UnicodeUtil.kt\norg/gnit/lucenekmp/util/UnicodeUtil\n*L\n139#1:704\n139#1:705,5\n*E\n"})
public final class UnicodeUtil {
    @NotNull
    public static final UnicodeUtil INSTANCE;
    @NotNull
    private static final BytesRef BIG_TERM;
    public static final int UNI_SUR_HIGH_START = 55296;
    public static final int UNI_SUR_HIGH_END = 56319;
    public static final int UNI_SUR_LOW_START = 56320;
    public static final int UNI_SUR_LOW_END = 57343;
    public static final int UNI_REPLACEMENT_CHAR = 65533;
    public static final long UNI_MAX_BMP = 65535L;
    public static final long HALF_SHIFT = 10L;
    public static final long HALF_MASK = 1023L;
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    private static final int SURROGATE_OFFSET;
    public static final int MAX_UTF8_BYTES_PER_CHAR = 3;
    public static final int v = Integer.MIN_VALUE;
    @NotNull
    private static final int[] utf8CodeLength;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int TRAIL_SURROGATE_MASK_ = 1023;
    private static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    private static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    private static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    private static final int LEAD_SURROGATE_OFFSET_ = 55232;

    private UnicodeUtil() {
    }

    @NotNull
    public final BytesRef getBIG_TERM() {
        return BIG_TERM;
    }

    public final int getSURROGATE_OFFSET() {
        return SURROGATE_OFFSET;
    }

    @NotNull
    public final int[] getUtf8CodeLength() {
        return utf8CodeLength;
    }

    public final int UTF16toUTF8(@NotNull CharSequence s, int offset, int length, @NotNull byte[] out) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return this.UTF16toUTF8(s, offset, length, out, 0);
    }

    public final int UTF16toUTF8(@NotNull char[] source, int offset, int length, @NotNull byte[] out) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int upto = 0;
        int i = offset;
        int end = offset + length;
        while (i < end) {
            int utf32;
            char code;
            if ((code = source[i++]) < '\u0080') {
                out[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end && (utf32 = source[i]) >= 56320 && utf32 <= 57343) {
                utf32 = (code << 10) + utf32 + SURROGATE_OFFSET;
                ++i;
                out[upto++] = (byte)(0xF0 | utf32 >> 18);
                out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto++] = -17;
            out[upto++] = -65;
            out[upto++] = -67;
        }
        return upto;
    }

    public final int UTF16toUTF8(@NotNull CharSequence s, int offset, int length, @NotNull byte[] out, int outOffset) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int end = offset + length;
        int upto = outOffset;
        int i = offset;
        while (i < end) {
            char code = s.charAt(i);
            if (code < '\u0080') {
                out[upto++] = (byte)code;
            } else if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
            } else if (code < '\ud800' || code > '\udfff') {
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
            } else {
                int utf32;
                if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= 56320 && utf32 <= 57343) {
                    utf32 = (code << 10) + utf32 + SURROGATE_OFFSET;
                    ++i;
                    out[upto++] = (byte)(0xF0 | utf32 >> 18);
                    out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                    out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                    out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                    ++i;
                    continue;
                }
                out[upto++] = -17;
                out[upto++] = -65;
                out[upto++] = -67;
            }
            ++i;
        }
        return upto;
    }

    public final int calcUTF16toUTF8Length(@NotNull CharSequence s, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int end = offset + len;
        int res = 0;
        int i = offset;
        while (i < end) {
            char code = s.charAt(i);
            if (code < '\u0080') {
                ++res;
            } else if (code < '\u0800') {
                res += 2;
            } else if (code < '\ud800' || code > '\udfff') {
                res += 3;
            } else {
                char utf32;
                if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= '\udc00' && utf32 <= '\udfff') {
                    ++i;
                    res += 4;
                    ++i;
                    continue;
                }
                res += 3;
            }
            ++i;
        }
        return res;
    }

    public final boolean validUTF16String(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int size2 = s.length();
        for (int i = 0; i < size2; ++i) {
            char ch = s.charAt(i);
            if (ch >= '\ud800' && ch <= '\udbff') {
                if (i < size2 - 1) {
                    char nextCH;
                    if ((nextCH = s.charAt(++i)) >= '\udc00' && nextCH <= '\udfff') continue;
                    return false;
                }
                return false;
            }
            if (ch < '\udc00' || ch > '\udfff') continue;
            return false;
        }
        return true;
    }

    public final boolean validUTF16String(@NotNull char[] s, int size2) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        for (int i = 0; i < size2; ++i) {
            char ch = s[i];
            if (ch >= '\ud800' && ch <= '\udbff') {
                if (i < size2 - 1) {
                    char nextCH;
                    if ((nextCH = s[++i]) >= '\udc00' && nextCH <= '\udfff') continue;
                    return false;
                }
                return false;
            }
            if (ch < '\udc00' || ch > '\udfff') continue;
            return false;
        }
        return true;
    }

    public final int codePointCount(@NotNull BytesRef utf8) {
        Intrinsics.checkNotNullParameter((Object)utf8, (String)"utf8");
        int pos = utf8.getOffset();
        int limit = pos + utf8.getLength();
        byte[] bytes = utf8.getBytes();
        int codePointCount = 0;
        while (pos < limit) {
            int v = bytes[pos] & 0xFF;
            if (v < 128) {
                ++pos;
                ++codePointCount;
                continue;
            }
            if (v >= 192) {
                if (v < 224) {
                    pos += 2;
                    ++codePointCount;
                    continue;
                }
                if (v < 240) {
                    pos += 3;
                    ++codePointCount;
                    continue;
                }
                if (v < 248) {
                    pos += 4;
                    ++codePointCount;
                    continue;
                }
            }
            throw new IllegalArgumentException();
        }
        if (!(pos <= limit)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return codePointCount;
    }

    public final int UTF8toUTF32(@NotNull BytesRef utf8, @NotNull int[] ints) {
        Intrinsics.checkNotNullParameter((Object)utf8, (String)"utf8");
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        int utf32Count = 0;
        byte[] bytes = utf8.getBytes();
        int utf8Limit = utf8.getOffset() + utf8.getLength();
        UTF8CodePoint reuse = null;
        for (int utf8Upto = utf8.getOffset(); utf8Upto < utf8Limit; utf8Upto += reuse.getNumBytes()) {
            reuse = this.codePointAt(bytes, utf8Upto, reuse);
            ints[utf32Count++] = reuse.getCodePoint();
        }
        return utf32Count;
    }

    @NotNull
    public final UTF8CodePoint codePointAt(@NotNull byte[] utf8, int pos, @Nullable UTF8CodePoint reuse) {
        Intrinsics.checkNotNullParameter((Object)utf8, (String)"utf8");
        int pos2 = pos;
        UTF8CodePoint reuse2 = reuse;
        if (reuse2 == null) {
            reuse2 = new UTF8CodePoint();
        }
        int leadByte = utf8[pos2] & 0xFF;
        int numBytes = utf8CodeLength[leadByte];
        reuse2.setNumBytes(numBytes);
        int v = 0;
        switch (numBytes) {
            case 1: {
                reuse2.setCodePoint(leadByte);
                return reuse2;
            }
            case 2: {
                v = leadByte & 0x1F;
                break;
            }
            case 3: {
                v = leadByte & 0xF;
                break;
            }
            case 4: {
                v = leadByte & 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid UTF8 header byte: 0x " + HexExtensionsKt.toHexString$default((int)leadByte, null, (int)1, null));
            }
        }
        int limit = pos2 + numBytes;
        ++pos2;
        while (pos2 < limit) {
            v = v << 6 | utf8[pos2++] & 0x3F;
        }
        reuse2.setCodePoint(v);
        return reuse2;
    }

    @NotNull
    public final String newString(@NotNull int[] codePoints, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)codePoints, (String)"codePoints");
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        char[] chars = new char[count];
        int w = 0;
        int e = offset + count;
        block2: for (int r = offset; r < e; ++r) {
            int cp = codePoints[r];
            if (!(cp >= 0 && cp <= 0x10FFFF)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            while (true) {
                try {
                    if (cp < 65536) {
                        chars[w] = (char)cp;
                        ++w;
                        continue block2;
                    }
                    chars[w] = (char)(55232 + (cp >> 10));
                    chars[w + 1] = (char)(56320 + (cp & 0x3FF));
                    w += 2;
                    continue block2;
                }
                catch (IndexOutOfBoundsException ex) {
                    int newlen = (int)Math.ceil((double)codePoints.length * (double)(w + 2) / (double)(r - offset + 1));
                    char[] temp = new char[newlen];
                    ArraysKt.copyInto((char[])chars, (char[])temp, (int)0, (int)0, (int)w);
                    chars = temp;
                    continue;
                }
                break;
            }
        }
        return this.createString(chars, 0, w);
    }

    @NotNull
    public final String createString(@NotNull char[] value, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (offset < 0 || count < 0 || offset > value.length - count) {
            throw new IndexOutOfBoundsException("Invalid range: offset=" + offset + ", count=" + count + ", array size=" + value.length);
        }
        return StringsKt.concatToString((char[])value, (int)offset, (int)(offset + count));
    }

    @NotNull
    public final String toHexString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder;
            char ch = s.charAt(i);
            if (i > 0) {
                sb.append(' ');
            }
            if (ch < '\u0080') {
                stringBuilder = sb.append(ch);
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udbff') {
                sb.append("H:");
            } else if (ch >= '\udc00' && ch <= '\udfff') {
                sb.append("L:");
            } else if (ch > '\udfff') {
                StringBuilder stringBuilder2 = ch == '\uffff' ? sb.append("F:") : sb.append("E:");
            }
            stringBuilder = sb.append("0x").append(HexExtensionsKt.toHexString$default((int)ch, null, (int)1, null));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final int UTF8toUTF16(@NotNull byte[] utf8, int offset, int length, @NotNull char[] out) {
        Intrinsics.checkNotNullParameter((Object)utf8, (String)"utf8");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int offset2 = offset;
        int out_offset = 0;
        int limit = offset2 + length;
        while (offset2 < limit) {
            int b;
            if ((b = utf8[offset2++] & 0xFF) < 192) {
                if (b < 128) {
                    throw new RuntimeException();
                }
                out[out_offset++] = (char)b;
                continue;
            }
            if (b < 224) {
                out[out_offset++] = (char)(((b & 0x1F) << 6) + (utf8[offset2++] & 0x3F));
                continue;
            }
            if (b < 240) {
                out[out_offset++] = (char)(((b & 0xF) << 12) + ((utf8[offset2] & 0x3F) << 6) + (utf8[offset2 + 1] & 0x3F));
                offset2 += 2;
                continue;
            }
            if (b < 248) {
                throw new RuntimeException("b = 0x" + HexExtensionsKt.toHexString$default((int)b, null, (int)1, null));
            }
            int ch = ((b & 7) << 18) + ((utf8[offset2] & 0x3F) << 12) + ((utf8[offset2 + 1] & 0x3F) << 6) + (utf8[offset2 + 2] & 0x3F);
            offset2 += 3;
            if ((long)ch < 65535L) {
                out[out_offset++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[out_offset++] = (char)((chHalf >> 10) + 55296);
            int n = out_offset++;
            out[n] = (char)(UShort.constructor-impl((short)((short)(((long)chHalf & 0x3FFL) + (long)56320))) & 0xFFFF);
        }
        return out_offset;
    }

    public final int maxUTF8Length(int utf16Length) {
        return utf16Length * 3;
    }

    public final int UTF8toUTF16(@NotNull BytesRef bytesRef, @NotNull char[] chars) {
        Intrinsics.checkNotNullParameter((Object)bytesRef, (String)"bytesRef");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.UTF8toUTF16(bytesRef.getBytes(), bytesRef.getOffset(), bytesRef.getLength(), chars);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_4;
        void $this$flatMapTo$iv$iv;
        INSTANCE = new UnicodeUtil();
        Object object = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        BIG_TERM = new BytesRef((byte[])object);
        SURROGATE_OFFSET = -56613888;
        object = new int[16][];
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        object[0] = (byte)nArray;
        nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        object[1] = (byte)nArray;
        nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        object[2] = (byte)nArray;
        nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        object[3] = (byte)nArray;
        nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        object[4] = (byte)nArray;
        nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        object[5] = (byte)nArray;
        nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        object[6] = (byte)nArray;
        nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        object[7] = (byte)nArray;
        nArray = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        object[8] = (byte)nArray;
        nArray = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        object[9] = (byte)nArray;
        nArray = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        object[10] = (byte)nArray;
        nArray = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        object[11] = (byte)nArray;
        nArray = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        object[12] = (byte)nArray;
        nArray = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        object[13] = (byte)nArray;
        nArray = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        object[14] = (byte)nArray;
        nArray = new int[]{4, 4, 4, 4, 4, 4, 4, 4};
        object[15] = (byte)nArray;
        Object[] $this$flatMap$iv = object;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            int[] it = (int[])element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList((int[])it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        utf8CodeLength = CollectionsKt.toIntArray((Collection)((List)var3_4));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/UnicodeUtil$UTF8CodePoint;", "", "<init>", "()V", "codePoint", "", "getCodePoint", "()I", "setCodePoint", "(I)V", "numBytes", "getNumBytes", "setNumBytes", "core"})
    public static final class UTF8CodePoint {
        private int codePoint;
        private int numBytes;

        public final int getCodePoint() {
            return this.codePoint;
        }

        public final void setCodePoint(int n) {
            this.codePoint = n;
        }

        public final int getNumBytes() {
            return this.numBytes;
        }

        public final void setNumBytes(int n) {
            this.numBytes = n;
        }
    }
}

