/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gnit.lucenekmp.internal.vectorization.VectorUtilSupport;
import org.gnit.lucenekmp.internal.vectorization.VectorizationProvider;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.gnit.lucenekmp.util.Constants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0015\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nJ\u0016\u0010\b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rJ\u0016\u0010#\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u0016\u0010$\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u0016\u0010%\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u0016\u0010&\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u000e\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nJ&\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lorg/gnit/lucenekmp/util/VectorUtil;", "", "<init>", "()V", "EPSILON", "", "IMPL", "Lorg/gnit/lucenekmp/internal/vectorization/VectorUtilSupport;", "dotProduct", "a", "", "b", "cosine", "", "squareDistance", "", "l2normalize", "v", "isUnitVector", "", "throwOnZero", "add", "", "u", "int4DotProduct", "int4DotProductPacked", "unpacked", "packed", "int4BitDotProduct", "", "q", "d", "XOR_BIT_COUNT_STRIDE_AS_INT", "getXOR_BIT_COUNT_STRIDE_AS_INT", "()Z", "xorBitCount", "xorBitCountInt", "xorBitCountLong", "dotProductScore", "scaleMaxInnerProductScore", "vectorDotProductSimilarity", "checkFinite", "findNextGEQ", "buffer", "", "target", "from", "to", "core"})
@SourceDebugExtension(value={"SMAP\nVectorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorUtil.kt\norg/gnit/lucenekmp/util/VectorUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n1#2:323\n2746#3,3:324\n*S KotlinDebug\n*F\n+ 1 VectorUtil.kt\norg/gnit/lucenekmp/util/VectorUtil\n*L\n318#1:324,3\n*E\n"})
public final class VectorUtil {
    @NotNull
    public static final VectorUtil INSTANCE = new VectorUtil();
    private static final float EPSILON = 1.0E-4f;
    @NotNull
    private static final VectorUtilSupport IMPL = VectorizationProvider.Companion.getInstance().getVectorUtilSupport();
    private static final boolean XOR_BIT_COUNT_STRIDE_AS_INT = Constants.INSTANCE.getOS_ARCH().equals("aarch64");

    private VectorUtil() {
    }

    public final float dotProduct(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + a.length + "!=" + b.length;
            throw new IllegalArgumentException(string.toString());
        }
        float r = IMPL.dotProduct(a, b);
        if (!FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, r)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return r;
    }

    public final float cosine(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + a.length + "!=" + b.length;
            throw new IllegalArgumentException(string.toString());
        }
        float r = IMPL.cosine(a, b);
        if (!FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, r)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return r;
    }

    public final float cosine(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + a.length + "!=" + b.length;
            throw new IllegalArgumentException(string.toString());
        }
        return IMPL.cosine(a, b);
    }

    public final float squareDistance(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + a.length + "!=" + b.length;
            throw new IllegalArgumentException(string.toString());
        }
        float r = IMPL.squareDistance(a, b);
        if (!FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, r)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return r;
    }

    public final int squareDistance(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + a.length + "!=" + b.length;
            throw new IllegalArgumentException(string.toString());
        }
        return IMPL.squareDistance(a, b);
    }

    @NotNull
    public final float[] l2normalize(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.l2normalize(v, true);
        return v;
    }

    public final boolean isUnitVector(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double l1norm = IMPL.dotProduct(v, v);
        return Math.abs(l1norm - 1.0) <= (double)1.0E-4f;
    }

    @NotNull
    public final float[] l2normalize(@NotNull float[] v, boolean throwOnZero) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double l1norm = IMPL.dotProduct(v, v);
        if (l1norm == 0.0) {
            if (!(!throwOnZero)) {
                boolean $i$a$-require-VectorUtil$l2normalize$22 = false;
                String $i$a$-require-VectorUtil$l2normalize$22 = "Cannot normalize a zero-length vector";
                throw new IllegalArgumentException($i$a$-require-VectorUtil$l2normalize$22.toString());
            }
            return v;
        }
        if (Math.abs(l1norm - 1.0) <= (double)1.0E-4f) {
            return v;
        }
        int dim = v.length;
        double l2norm = Math.sqrt(l1norm);
        int i = 0;
        while (i < dim) {
            int n = i++;
            v[n] = v[n] / (float)l2norm;
        }
        return v;
    }

    public final void add(@NotNull float[] u, @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = u.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            u[n2] = u[n2] + v[i];
        }
    }

    public final int dotProduct(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + a.length + "!=" + b.length;
            throw new IllegalArgumentException(string.toString());
        }
        return IMPL.dotProduct(a, b);
    }

    public final int int4DotProduct(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + a.length + "!=" + b.length;
            throw new IllegalArgumentException(string.toString());
        }
        return IMPL.int4DotProduct(a, false, b, false);
    }

    public final int int4DotProductPacked(@NotNull byte[] unpacked, @NotNull byte[] packed) {
        Intrinsics.checkNotNullParameter((Object)unpacked, (String)"unpacked");
        Intrinsics.checkNotNullParameter((Object)packed, (String)"packed");
        if (!(packed.length == unpacked.length + 1 >> 1)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + unpacked.length + "!= 2 * " + packed.length;
            throw new IllegalArgumentException(string.toString());
        }
        return IMPL.int4DotProduct(unpacked, false, packed, true);
    }

    public final long int4BitDotProduct(@NotNull byte[] q, @NotNull byte[] d) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        if (!(q.length == d.length * 4)) {
            boolean bl = false;
            String string = "vector dimensions incompatible: " + q.length + "!= 4 x " + d.length;
            throw new IllegalArgumentException(string.toString());
        }
        return IMPL.int4BitDotProduct(q, d);
    }

    public final boolean getXOR_BIT_COUNT_STRIDE_AS_INT() {
        return XOR_BIT_COUNT_STRIDE_AS_INT;
    }

    public final int xorBitCount(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean bl = false;
            String string = "vector dimensions differ: " + a.length + "!=" + b.length;
            throw new IllegalArgumentException(string.toString());
        }
        if (XOR_BIT_COUNT_STRIDE_AS_INT) {
            return this.xorBitCountInt(a, b);
        }
        return this.xorBitCountLong(a, b);
    }

    public final int xorBitCountInt(@NotNull byte[] a, @NotNull byte[] b) {
        int i;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int distance = 0;
        int upperBound = a.length & 0xFFFFFFFC;
        for (i = 0; i < upperBound; i += 4) {
            int intA = BitUtilKt.getIntLE(a, i);
            int intB = BitUtilKt.getIntLE(b, i);
            distance += IntExtKt.bitCount(IntCompanionObject.INSTANCE, intA ^ intB);
        }
        while (i < a.length) {
            distance += IntExtKt.bitCount(IntCompanionObject.INSTANCE, (a[i] ^ b[i]) & 0xFF);
            ++i;
        }
        return distance;
    }

    public final int xorBitCountLong(@NotNull byte[] a, @NotNull byte[] b) {
        int i;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int distance = 0;
        int upperBound = a.length & 0xFFFFFFF8;
        for (i = 0; i < upperBound; i += 8) {
            long longA = BitUtilKt.getLongLE(a, i);
            long longB = BitUtilKt.getLongLE(b, i);
            distance += LongExtKt.bitCount(LongCompanionObject.INSTANCE, longA ^ longB);
        }
        while (i < a.length) {
            distance += IntExtKt.bitCount(IntCompanionObject.INSTANCE, (a[i] ^ b[i]) & 0xFF);
            ++i;
        }
        return distance;
    }

    public final float dotProductScore(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        float denom = a.length * 32768;
        return 0.5f + (float)this.dotProduct(a, b) / denom;
    }

    public final float scaleMaxInnerProductScore(float vectorDotProductSimilarity) {
        if (vectorDotProductSimilarity < 0.0f) {
            return 1.0f / (1.0f + (float)-1 * vectorDotProductSimilarity);
        }
        return vectorDotProductSimilarity + 1.0f;
    }

    @NotNull
    public final float[] checkFinite(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = v.length;
        for (int i = 0; i < n; ++i) {
            if (FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, v[i])) continue;
            boolean bl = false;
            String string = "non-finite value at vector[" + i + "]=" + v[i];
            throw new IllegalArgumentException(string.toString());
        }
        return v;
    }

    public final int findNextGEQ(@NotNull int[] buffer, int target, int from, int to) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)(to - 1));
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$none$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(buffer[i] > buffer[i + 1])) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return IMPL.findNextGEQ(buffer, target, from, to);
    }
}

