/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.gnit.lucenekmp.jdkport.ParseException;
import org.gnit.lucenekmp.util.StrictStringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/Version;", "", "major", "", "minor", "bugfix", "prerelease", "<init>", "(IIII)V", "getMajor", "()I", "getMinor", "getBugfix", "getPrerelease", "encodedValue", "onOrAfter", "", "other", "toString", "", "equals", "o", "encodedIsValid", "hashCode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Version.kt\norg/gnit/lucenekmp/util/Version\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,355:1\n1#2:356\n*E\n"})
public final class Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int bugfix;
    private final int prerelease;
    private final int encodedValue;
    @NotNull
    private static final Version LUCENE_10_0_0 = new Version(10, 0, 0, 0, 8, null);
    @NotNull
    private static final Version LUCENE_10_1_0 = new Version(10, 1, 0, 0, 8, null);
    @NotNull
    private static final Version LUCENE_10_2_0 = new Version(10, 2, 0, 0, 8, null);
    @NotNull
    private static final Version LUCENE_11_0_0;
    @NotNull
    private static final Version LATEST;
    @NotNull
    private static final Version LUCENE_CURRENT;
    private static final int MIN_SUPPORTED_MAJOR;
    @Nullable
    private static String implementationVersion;

    private Version(int major, int minor, int bugfix, int prerelease) {
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.prerelease = prerelease;
        if (!(major <= 255 && major >= 0)) {
            boolean $i$a$-require-Version$62 = false;
            String $i$a$-require-Version$62 = "Illegal major version: " + major;
            throw new IllegalArgumentException($i$a$-require-Version$62.toString());
        }
        if (!(minor <= 255 && minor >= 0)) {
            boolean $i$a$-require-Version$72 = false;
            String $i$a$-require-Version$72 = "Illegal minor version: " + minor;
            throw new IllegalArgumentException($i$a$-require-Version$72.toString());
        }
        if (!(bugfix <= 255 && bugfix >= 0)) {
            boolean $i$a$-require-Version$82 = false;
            String $i$a$-require-Version$82 = "Illegal bugfix version: " + bugfix;
            throw new IllegalArgumentException($i$a$-require-Version$82.toString());
        }
        if (!(prerelease <= 2 && prerelease >= 0)) {
            boolean $i$a$-require-Version$92 = false;
            String $i$a$-require-Version$92 = "Illegal prerelease version: " + prerelease;
            throw new IllegalArgumentException($i$a$-require-Version$92.toString());
        }
        if (!(prerelease == 0 || minor == 0 && bugfix == 0)) {
            boolean bl = false;
            String string = "Prerelease version only supported with major release (got prerelease: " + prerelease + ", minor: " + minor + ", bugfix: " + bugfix + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.encodedValue = major << 18 | minor << 10 | bugfix << 2 | prerelease;
        if (!this.encodedIsValid()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /* synthetic */ Version(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getBugfix() {
        return this.bugfix;
    }

    public final int getPrerelease() {
        return this.prerelease;
    }

    public final boolean onOrAfter(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.encodedValue >= other.encodedValue;
    }

    @NotNull
    public String toString() {
        if (this.prerelease == 0) {
            return this.major + "." + this.minor + "." + this.bugfix;
        }
        return this.major + "." + this.minor + "." + this.bugfix + "." + this.prerelease;
    }

    public boolean equals(@Nullable Object o) {
        return o != null && o instanceof Version && ((Version)o).encodedValue == this.encodedValue;
    }

    private final boolean encodedIsValid() {
        if (!(this.major == (this.encodedValue >>> 18 & 0xFF))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.minor == (this.encodedValue >>> 10 & 0xFF))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.bugfix == (this.encodedValue >>> 2 & 0xFF))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.prerelease == (this.encodedValue & 3))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    public int hashCode() {
        return this.encodedValue;
    }

    public /* synthetic */ Version(int major, int minor, int bugfix, int prerelease, DefaultConstructorMarker $constructor_marker) {
        this(major, minor, bugfix, prerelease);
    }

    static {
        LUCENE_CURRENT = LATEST = (LUCENE_11_0_0 = new Version(11, 0, 0, 0, 8, null));
        MIN_SUPPORTED_MAJOR = Version.LATEST.major - 1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001bJ\u001e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u001c\u0010\u0013\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\bR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/util/Version$Companion;", "", "<init>", "()V", "LUCENE_10_0_0", "Lorg/gnit/lucenekmp/util/Version;", "getLUCENE_10_0_0$annotations", "getLUCENE_10_0_0", "()Lorg/gnit/lucenekmp/util/Version;", "LUCENE_10_1_0", "getLUCENE_10_1_0$annotations", "getLUCENE_10_1_0", "LUCENE_10_2_0", "getLUCENE_10_2_0$annotations", "getLUCENE_10_2_0", "LUCENE_11_0_0", "getLUCENE_11_0_0", "LATEST", "getLATEST", "LUCENE_CURRENT", "getLUCENE_CURRENT$annotations", "getLUCENE_CURRENT", "MIN_SUPPORTED_MAJOR", "", "getMIN_SUPPORTED_MAJOR", "()I", "implementationVersion", "", "parse", "version", "parseLeniently", "fromBits", "major", "minor", "bugfix", "packageImplementationVersion", "getPackageImplementationVersion", "()Ljava/lang/String;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getLUCENE_10_0_0() {
            return LUCENE_10_0_0;
        }

        @Deprecated(message="Use latest")
        public static /* synthetic */ void getLUCENE_10_0_0$annotations() {
        }

        @NotNull
        public final Version getLUCENE_10_1_0() {
            return LUCENE_10_1_0;
        }

        @Deprecated(message="Use latest")
        public static /* synthetic */ void getLUCENE_10_1_0$annotations() {
        }

        @NotNull
        public final Version getLUCENE_10_2_0() {
            return LUCENE_10_2_0;
        }

        @Deprecated(message="Use latest")
        public static /* synthetic */ void getLUCENE_10_2_0$annotations() {
        }

        @NotNull
        public final Version getLUCENE_11_0_0() {
            return LUCENE_11_0_0;
        }

        @NotNull
        public final Version getLATEST() {
            return LATEST;
        }

        @NotNull
        public final Version getLUCENE_CURRENT() {
            return LUCENE_CURRENT;
        }

        @Deprecated(message="Use {@link #LATEST}")
        public static /* synthetic */ void getLUCENE_CURRENT$annotations() {
        }

        public final int getMIN_SUPPORTED_MAJOR() {
            return MIN_SUPPORTED_MAJOR;
        }

        @NotNull
        public final Version parse(@NotNull String version) throws ParseException {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            StrictStringTokenizer tokens = new StrictStringTokenizer(version, '.');
            if (!tokens.hasMoreTokens()) {
                throw new ParseException("Version is not in form major.minor.bugfix(.prerelease) (got: " + version + ")", 0);
            }
            int major = 0;
            String token = tokens.nextToken();
            try {
                major = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                ParseException p = new ParseException("Failed to parse major version from \"" + token + "\" (got: " + version + ")", 0);
                p.initCause(nfe);
                throw p;
            }
            if (!tokens.hasMoreTokens()) {
                throw new ParseException("Version is not in form major.minor.bugfix(.prerelease) (got: " + version + ")", 0);
            }
            int minor = 0;
            token = tokens.nextToken();
            try {
                minor = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                ParseException p = new ParseException("Failed to parse minor version from \"" + token + "\" (got: " + version + ")", 0);
                p.initCause(nfe);
                throw p;
            }
            int bugfix = 0;
            int prerelease = 0;
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                try {
                    bugfix = Integer.parseInt(token);
                }
                catch (NumberFormatException nfe) {
                    ParseException p = new ParseException("Failed to parse bugfix version from \"" + token + "\" (got: " + version + ")", 0);
                    p.initCause(nfe);
                    throw p;
                }
                if (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    try {
                        prerelease = Integer.parseInt(token);
                    }
                    catch (NumberFormatException nfe) {
                        ParseException p = new ParseException("Failed to parse prerelease version from \"" + token + "\" (got: " + version + ")", 0);
                        p.initCause(nfe);
                        throw p;
                    }
                    if (prerelease == 0) {
                        throw new ParseException("Invalid value " + prerelease + " for prerelease; should be 1 or 2 (got: " + version + ")", 0);
                    }
                    if (tokens.hasMoreTokens()) {
                        throw new ParseException("Version is not in form major.minor.bugfix(.prerelease) (got: " + version + ")", 0);
                    }
                }
            }
            try {
                return new Version(major, minor, bugfix, prerelease, null);
            }
            catch (IllegalArgumentException iae) {
                ParseException pe = new ParseException("failed to parse version string \"" + version + "\": " + iae.getMessage(), 0);
                pe.initCause(iae);
                throw pe;
            }
        }

        @NotNull
        public final Version parseLeniently(@NotNull String version) throws ParseException {
            String version2;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            String versionOrig = version2 = version;
            String string = version2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String string2 = version2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"LATEST") || Intrinsics.areEqual((Object)string2, (Object)"LUCENE_CURRENT")) {
                return this.getLATEST();
            }
            CharSequence charSequence = version2;
            Regex regex = new Regex("^LUCENE_(\\d+)_(\\d+)_(\\d+)$");
            String string3 = "$1.$2.$3";
            charSequence = regex.replaceFirst(charSequence, string3);
            regex = new Regex("^LUCENE_(\\d+)_(\\d+)$");
            string3 = "$1.$2.0";
            charSequence = regex.replaceFirst(charSequence, string3);
            regex = new Regex("^LUCENE_(\\d)(\\d)$");
            string3 = "$1.$2.0";
            version2 = regex.replaceFirst(charSequence, string3);
            try {
                return this.parse(version2);
            }
            catch (ParseException pe) {
                ParseException pe2 = new ParseException("failed to parse lenient version string \"" + versionOrig + "\": " + pe.getMessage(), 0);
                pe2.initCause(pe);
                throw pe2;
            }
        }

        @NotNull
        public final Version fromBits(int major, int minor, int bugfix) {
            return new Version(major, minor, bugfix, 0, 8, null);
        }

        @NotNull
        public final String getPackageImplementationVersion() {
            if (implementationVersion == null) {
                String version = null;
                version = "unknown";
                implementationVersion = version;
            }
            String string = implementationVersion;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

