/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.ObjectsKt;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefIterator;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.Operations;
import org.gnit.lucenekmp.util.automaton.StringsToAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0002J6\u0010\"\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0002J>\u0010(\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0005H\u0002J*\u0010.\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010,2\u0006\u0010/\u001a\u00020&2\b\u0010\u0015\u001a\u0004\u0018\u00010,2\u0006\u00100\u001a\u00020&J\u001e\u00101\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005J\u000e\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020 J\u000e\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020,J\u001e\u00103\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005J\u0014\u0010:\u001a\u00020\u00072\f\u0010;\u001a\b\u0012\u0004\u0012\u00020,0<J\u0014\u0010=\u001a\u00020\u00072\f\u0010;\u001a\b\u0012\u0004\u0012\u00020,0<J\u000e\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020>J\u000e\u0010=\u001a\u00020\u00072\u0006\u0010;\u001a\u00020>R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/gnit/lucenekmp/util/automaton/Automata;", "", "<init>", "()V", "MAX_STRING_UNION_TERM_LENGTH", "", "makeEmpty", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "makeEmptyString", "makeAnyString", "makeAnyBinary", "makeNonEmptyBinary", "makeAnyChar", "appendAnyChar", "a", "state", "makeChar", "c", "appendChar", "makeCharRange", "min", "max", "makeCharSet", "codepoints", "", "makeCharClass", "starts", "ends", "anyOfRightLength", "builder", "Lorg/gnit/lucenekmp/util/automaton/Automaton$Builder;", "x", "", "n", "atLeast", "initials", "", "zeros", "", "atMost", "between", "y", "suffixIsZeros", "br", "Lorg/gnit/lucenekmp/util/BytesRef;", "len", "makeBinaryInterval", "minInclusive", "maxInclusive", "makeDecimalInterval", "digits", "makeString", "s", "makeBinary", "term", "word", "offset", "length", "makeStringUnion", "utf8Strings", "", "makeBinaryStringUnion", "Lorg/gnit/lucenekmp/util/BytesRefIterator;", "core"})
@SourceDebugExtension(value={"SMAP\nAutomata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Automata.kt\norg/gnit/lucenekmp/util/automaton/Automata\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,625:1\n1#2:626\n*E\n"})
public final class Automata {
    @NotNull
    public static final Automata INSTANCE = new Automata();
    public static final int MAX_STRING_UNION_TERM_LENGTH = 1000;

    private Automata() {
    }

    @NotNull
    public final Automaton makeEmpty() {
        Automaton a = new Automaton(0, 0, 3, null);
        a.finishState();
        return a;
    }

    @NotNull
    public final Automaton makeEmptyString() {
        Automaton a = new Automaton(0, 0, 3, null);
        a.createState();
        a.setAccept(0, true);
        return a;
    }

    @NotNull
    public final Automaton makeAnyString() {
        Automaton a = new Automaton(0, 0, 3, null);
        int s = a.createState();
        a.setAccept(s, true);
        a.addTransition(s, s, 0, 0x10FFFF);
        a.finishState();
        return a;
    }

    @NotNull
    public final Automaton makeAnyBinary() {
        Automaton a = new Automaton(0, 0, 3, null);
        int s = a.createState();
        a.setAccept(s, true);
        a.addTransition(s, s, 0, 255);
        a.finishState();
        return a;
    }

    @NotNull
    public final Automaton makeNonEmptyBinary() {
        Automaton a = new Automaton(0, 0, 3, null);
        int s1 = a.createState();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s1, s2, 0, 255);
        a.addTransition(s2, s2, 0, 255);
        a.finishState();
        return a;
    }

    @NotNull
    public final Automaton makeAnyChar() {
        return this.makeCharRange(0, 0x10FFFF);
    }

    public final int appendAnyChar(@NotNull Automaton a, int state2) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        int newState = a.createState();
        a.addTransition(state2, newState, 0, 0x10FFFF);
        return newState;
    }

    @NotNull
    public final Automaton makeChar(int c) {
        return this.makeCharRange(c, c);
    }

    public final int appendChar(@NotNull Automaton a, int state2, int c) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        int newState = a.createState();
        a.addTransition(state2, newState, c, c);
        return newState;
    }

    @NotNull
    public final Automaton makeCharRange(int min, int max) {
        if (min > max) {
            return this.makeEmpty();
        }
        Automaton a = new Automaton(0, 0, 3, null);
        int s1 = a.createState();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s1, s2, min, max);
        a.finishState();
        return a;
    }

    @NotNull
    public final Automaton makeCharSet(@NotNull int[] codepoints) {
        Intrinsics.checkNotNullParameter((Object)codepoints, (String)"codepoints");
        return this.makeCharClass(codepoints, codepoints);
    }

    @NotNull
    public final Automaton makeCharClass(@NotNull int[] starts, @NotNull int[] ends) {
        Intrinsics.checkNotNullParameter((Object)starts, (String)"starts");
        Intrinsics.checkNotNullParameter((Object)ends, (String)"ends");
        if (!(starts.length == ends.length)) {
            boolean $i$a$-require-Automata$makeCharClass$22 = false;
            String $i$a$-require-Automata$makeCharClass$22 = "starts must match ends";
            throw new IllegalArgumentException($i$a$-require-Automata$makeCharClass$22.toString());
        }
        if (starts.length == 0) {
            return this.makeEmpty();
        }
        Automaton a = new Automaton(0, 0, 3, null);
        int s1 = a.createState();
        int s2 = a.createState();
        a.setAccept(s2, true);
        int n = starts.length;
        for (int i = 0; i < n; ++i) {
            a.addTransition(s1, s2, starts[i], ends[i]);
        }
        a.finishState();
        return a;
    }

    private final int anyOfRightLength(Automaton.Builder builder, String x, int n) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            builder.addTransition(s, this.anyOfRightLength(builder, x, n + 1), 48, 57);
        }
        return s;
    }

    private final int atLeast(Automaton.Builder builder, String x, int n, Collection<Integer> initials, boolean zeros) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            if (zeros) {
                initials.add(s);
            }
            char c = x.charAt(n);
            builder.addTransition(s, this.atLeast(builder, x, n + 1, initials, zeros && c == '0'), c);
            if (Intrinsics.compare((int)c, (int)57) < 0) {
                builder.addTransition(s, this.anyOfRightLength(builder, x, n + 1), (char)(c + '\u0001'), 57);
            }
        }
        return s;
    }

    private final int atMost(Automaton.Builder builder, String x, int n) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            char c = x.charAt(n);
            builder.addTransition(s, this.atMost(builder, x, n + 1), c);
            if (Intrinsics.compare((int)c, (int)48) > 0) {
                builder.addTransition(s, this.anyOfRightLength(builder, x, n + 1), 48, (char)(c - '\u0001'));
            }
        }
        return s;
    }

    private final int between(Automaton.Builder builder, String x, String y, int n, Collection<Integer> initials, boolean zeros) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            char cy;
            char cx;
            if (zeros) {
                initials.add(s);
            }
            if ((cx = x.charAt(n)) == (cy = y.charAt(n))) {
                builder.addTransition(s, this.between(builder, x, y, n + 1, initials, zeros && cx == '0'), cx);
            } else {
                builder.addTransition(s, this.atLeast(builder, x, n + 1, initials, zeros && cx == '0'), cx);
                builder.addTransition(s, this.atMost(builder, y, n + 1), cy);
                if (cx + '\u0001' < cy) {
                    builder.addTransition(s, this.anyOfRightLength(builder, x, n + 1), (char)(cx + '\u0001'), (char)(cy - '\u0001'));
                }
            }
        }
        return s;
    }

    private final boolean suffixIsZeros(BytesRef br, int len) {
        int n = br.getLength();
        for (int i = len; i < n; ++i) {
            if (br.getBytes()[br.getOffset() + i] == 0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Automaton makeBinaryInterval(@Nullable BytesRef min, boolean minInclusive, @Nullable BytesRef max, boolean maxInclusive) {
        int i;
        BytesRef min2 = min;
        boolean minInclusive2 = minInclusive;
        if (!(min2 != null || minInclusive2)) {
            boolean $i$a$-require-Automata$makeBinaryInterval$42 = false;
            String $i$a$-require-Automata$makeBinaryInterval$42 = "minInclusive must be true when min is null (open ended)";
            throw new IllegalArgumentException($i$a$-require-Automata$makeBinaryInterval$42.toString());
        }
        if (!(max != null || maxInclusive)) {
            boolean $i$a$-require-Automata$makeBinaryInterval$52 = false;
            String $i$a$-require-Automata$makeBinaryInterval$52 = "maxInclusive must be true when max is null (open ended)";
            throw new IllegalArgumentException($i$a$-require-Automata$makeBinaryInterval$52.toString());
        }
        if (min2 == null) {
            min2 = new BytesRef();
            minInclusive2 = true;
        }
        int cmp = 0;
        if (max != null) {
            cmp = min2.compareTo(max);
        } else {
            cmp = -1;
            if (min2.getLength() == 0) {
                if (minInclusive2) {
                    return this.makeAnyBinary();
                }
                return this.makeNonEmptyBinary();
            }
        }
        if (cmp == 0) {
            if (!minInclusive2 || !maxInclusive) {
                return this.makeEmpty();
            }
            return this.makeBinary(min2);
        }
        if (cmp > 0) {
            return this.makeEmpty();
        }
        if (max != null && StringHelper.INSTANCE.startsWith(max, min2) && this.suffixIsZeros(max, min2.getLength())) {
            int state2;
            int i2;
            int maxLength = max.getLength();
            if (!(maxLength > min2.getLength())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!maxInclusive) {
                --maxLength;
            }
            if (maxLength == min2.getLength()) {
                if (!minInclusive2) {
                    return this.makeEmpty();
                }
                return this.makeBinary(min2);
            }
            Automaton a = new Automaton(0, 0, 3, null);
            int lastState = a.createState();
            int n = min2.getLength();
            for (i2 = 0; i2 < n; ++i2) {
                state2 = a.createState();
                int label = min2.getBytes()[min2.getOffset() + i2] & 0xFF;
                a.addTransition(lastState, state2, label);
                lastState = state2;
            }
            if (minInclusive2) {
                a.setAccept(lastState, true);
            }
            n = maxLength;
            for (i2 = min2.getLength(); i2 < n; ++i2) {
                state2 = a.createState();
                a.addTransition(lastState, state2, 0);
                a.setAccept(state2, true);
                lastState = state2;
            }
            a.finishState();
            return a;
        }
        Automaton a = new Automaton(0, 0, 3, null);
        int startState = a.createState();
        int sinkState = a.createState();
        a.setAccept(sinkState, true);
        a.addTransition(sinkState, sinkState, 0, 255);
        boolean equalPrefix = true;
        int lastState = startState;
        int firstMaxState = -1;
        int sharedPrefixLength = 0;
        int n = min2.getLength();
        for (i = 0; i < n; ++i) {
            int minLabel = min2.getBytes()[min2.getOffset() + i] & 0xFF;
            int maxLabel = 0;
            maxLabel = max != null && equalPrefix && i < max.getLength() ? max.getBytes()[max.getOffset() + i] & 0xFF : -1;
            int nextState = 0;
            nextState = minInclusive2 && i == min2.getLength() - 1 && (!equalPrefix || minLabel != maxLabel) ? sinkState : a.createState();
            if (equalPrefix) {
                if (minLabel == maxLabel) {
                    a.addTransition(lastState, nextState, minLabel);
                } else if (max == null) {
                    equalPrefix = false;
                    sharedPrefixLength = 0;
                    a.addTransition(lastState, sinkState, minLabel + 1, 255);
                    a.addTransition(lastState, nextState, minLabel);
                } else {
                    if (!(maxLabel > minLabel)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    a.addTransition(lastState, nextState, minLabel);
                    if (maxLabel > minLabel + 1) {
                        a.addTransition(lastState, sinkState, minLabel + 1, maxLabel - 1);
                    }
                    if (maxInclusive || i < max.getLength() - 1) {
                        firstMaxState = a.createState();
                        if (i < max.getLength() - 1) {
                            a.setAccept(firstMaxState, true);
                        }
                        a.addTransition(lastState, firstMaxState, maxLabel);
                    }
                    equalPrefix = false;
                    sharedPrefixLength = i;
                }
            } else {
                a.addTransition(lastState, nextState, minLabel);
                if (minLabel < 255) {
                    a.addTransition(lastState, sinkState, minLabel + 1, 255);
                }
            }
            lastState = nextState;
        }
        if (!equalPrefix && lastState != sinkState && lastState != startState) {
            a.addTransition(lastState, sinkState, 0, 255);
        }
        if (minInclusive2) {
            a.setAccept(lastState, true);
        }
        if (max != null) {
            if (firstMaxState == -1) {
                sharedPrefixLength = min2.getLength();
            } else {
                lastState = firstMaxState;
                ++sharedPrefixLength;
            }
            n = max.getLength();
            for (i = sharedPrefixLength; i < n; ++i) {
                int maxLabel = max.getBytes()[max.getOffset() + i] & 0xFF;
                if (maxLabel > 0) {
                    a.addTransition(lastState, sinkState, 0, maxLabel - 1);
                }
                if (!maxInclusive && i >= max.getLength() - 1) continue;
                int nextState = a.createState();
                if (i < max.getLength() - 1) {
                    a.setAccept(nextState, true);
                }
                a.addTransition(lastState, nextState, maxLabel);
                lastState = nextState;
            }
            if (maxInclusive) {
                a.setAccept(lastState, true);
            }
        }
        a.finishState();
        if (!a.isDeterministic()) {
            boolean bl = false;
            String string = a.toDot();
            throw new IllegalArgumentException(string.toString());
        }
        return a;
    }

    @NotNull
    public final Automaton makeDecimalInterval(int min, int max, int digits) throws IllegalArgumentException {
        String x = String.valueOf(min);
        String y = String.valueOf(max);
        if (!(min <= max && (digits <= 0 || y.length() <= digits))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int d = 0;
        d = digits > 0 ? digits : y.length();
        StringBuilder bx = new StringBuilder();
        for (int i = x.length(); i < d; ++i) {
            bx.append('0');
        }
        bx.append(x);
        String string = bx.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        x = string;
        StringBuilder by = new StringBuilder();
        for (int i = y.length(); i < d; ++i) {
            by.append('0');
        }
        by.append(y);
        String string2 = by.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        y = string2;
        Automaton.Builder builder = new Automaton.Builder(0, 0, 3, null);
        if (digits <= 0) {
            builder.createState();
        }
        Collection initials = new ArrayList();
        this.between(builder, x, y, 0, initials, digits <= 0);
        Automaton a1 = builder.finish();
        if (digits <= 0) {
            a1.addTransition(0, 0, 48);
            Iterator iterator2 = initials.iterator();
            while (iterator2.hasNext()) {
                int p = ((Number)iterator2.next()).intValue();
                a1.addEpsilon(0, p);
            }
            a1.finishState();
        }
        return Operations.INSTANCE.removeDeadStates(a1);
    }

    @NotNull
    public final Automaton makeString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Automaton a = new Automaton(0, 0, 3, null);
        int lastState = a.createState();
        int cp = 0;
        for (int i = 0; i < s.length(); i += Character.Companion.charCount(cp)) {
            int state2 = a.createState();
            cp = ObjectsKt.codePointAt(s, i);
            a.addTransition(lastState, state2, cp);
            lastState = state2;
        }
        a.setAccept(lastState, true);
        a.finishState();
        if (!a.isDeterministic()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!Operations.INSTANCE.hasDeadStates(a))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return a;
    }

    @NotNull
    public final Automaton makeBinary(@NotNull BytesRef term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Automaton a = new Automaton(0, 0, 3, null);
        int lastState = a.createState();
        int n = term.getLength();
        for (int i = 0; i < n; ++i) {
            int state2 = a.createState();
            int label = term.getBytes()[term.getOffset() + i] & 0xFF;
            a.addTransition(lastState, state2, label);
            lastState = state2;
        }
        a.setAccept(lastState, true);
        a.finishState();
        if (!a.isDeterministic()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!Operations.INSTANCE.hasDeadStates(a))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return a;
    }

    @NotNull
    public final Automaton makeString(@NotNull int[] word, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Automaton a = new Automaton(0, 0, 3, null);
        a.createState();
        int s = 0;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            int s2 = a.createState();
            a.addTransition(s, s2, word[i]);
            s = s2;
        }
        a.setAccept(s, true);
        a.finishState();
        return a;
    }

    @NotNull
    public final Automaton makeStringUnion(@NotNull Iterable<BytesRef> utf8Strings) {
        Intrinsics.checkNotNullParameter(utf8Strings, (String)"utf8Strings");
        if (!utf8Strings.iterator().hasNext()) {
            return this.makeEmpty();
        }
        return StringsToAutomaton.Companion.build(utf8Strings, false);
    }

    @NotNull
    public final Automaton makeBinaryStringUnion(@NotNull Iterable<BytesRef> utf8Strings) {
        Intrinsics.checkNotNullParameter(utf8Strings, (String)"utf8Strings");
        if (!utf8Strings.iterator().hasNext()) {
            return this.makeEmpty();
        }
        return StringsToAutomaton.Companion.build(utf8Strings, true);
    }

    @NotNull
    public final Automaton makeStringUnion(@NotNull BytesRefIterator utf8Strings) throws IOException {
        Intrinsics.checkNotNullParameter((Object)utf8Strings, (String)"utf8Strings");
        return StringsToAutomaton.Companion.build(utf8Strings, false);
    }

    @NotNull
    public final Automaton makeBinaryStringUnion(@NotNull BytesRefIterator utf8Strings) throws IOException {
        Intrinsics.checkNotNullParameter((Object)utf8Strings, (String)"utf8Strings");
        return StringsToAutomaton.Companion.build(utf8Strings, true);
    }
}

