/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.index.SingleTermsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.UnicodeUtil;
import org.gnit.lucenekmp.util.automaton.Automata;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.ByteRunAutomaton;
import org.gnit.lucenekmp.util.automaton.ByteRunnable;
import org.gnit.lucenekmp.util.automaton.NFARunAutomaton;
import org.gnit.lucenekmp.util.automaton.Operations;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.gnit.lucenekmp.util.automaton.TransitionAccessor;
import org.gnit.lucenekmp.util.automaton.UTF32ToUTF8;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 U2\u00020\u0001:\u0002TUB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000bJ(\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020/2\u0006\u0010\u0012\u001a\u0002082\u0006\u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020/H\u0002J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u001e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FJ\u0018\u0010G\u001a\u0004\u0018\u00010\u00132\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u000208J\b\u0010J\u001a\u0004\u0018\u00010KJ\b\u0010L\u001a\u0004\u0018\u00010MJ\b\u0010N\u001a\u00020/H\u0016J\u0013\u0010O\u001a\u00020\u00052\b\u0010P\u001a\u0004\u0018\u00010QH\u0096\u0002J\b\u0010R\u001a\u00020SH\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010\nR\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0015\"\u0004\b)\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "Lorg/gnit/lucenekmp/util/Accountable;", "automaton", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "finite", "", "simplify", "isBinary", "<init>", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;ZZZ)V", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;)V", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;ZZ)V", "type", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton$AUTOMATON_TYPE;", "getType", "()Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton$AUTOMATON_TYPE;", "setType", "(Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton$AUTOMATON_TYPE;)V", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "getTerm", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setTerm", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "runAutomaton", "Lorg/gnit/lucenekmp/util/automaton/ByteRunAutomaton;", "getRunAutomaton", "()Lorg/gnit/lucenekmp/util/automaton/ByteRunAutomaton;", "setRunAutomaton", "(Lorg/gnit/lucenekmp/util/automaton/ByteRunAutomaton;)V", "getAutomaton", "()Lorg/gnit/lucenekmp/util/automaton/Automaton;", "setAutomaton", "nfaRunAutomaton", "Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton;", "getNfaRunAutomaton", "()Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton;", "setNfaRunAutomaton", "(Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton;)V", "commonSuffixRef", "getCommonSuffixRef", "setCommonSuffixRef", "getFinite", "()Z", "setFinite", "(Z)V", "sinkState", "", "getSinkState", "()I", "setSinkState", "(I)V", "transition", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "addTail", "state", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "idx", "leadLabel", "getTermsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "parent", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "floor", "input", "output", "getByteRunnable", "Lorg/gnit/lucenekmp/util/automaton/ByteRunnable;", "getTransitionAccessor", "Lorg/gnit/lucenekmp/util/automaton/TransitionAccessor;", "hashCode", "equals", "obj", "", "ramBytesUsed", "", "AUTOMATON_TYPE", "Companion", "core"})
public final class CompiledAutomaton
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AUTOMATON_TYPE type;
    @Nullable
    private BytesRef term;
    @Nullable
    private ByteRunAutomaton runAutomaton;
    @Nullable
    private Automaton automaton;
    @Nullable
    private NFARunAutomaton nfaRunAutomaton;
    @Nullable
    private BytesRef commonSuffixRef;
    private boolean finite;
    private int sinkState;
    @NotNull
    private final Transition transition;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(CompiledAutomaton.class));

    public CompiledAutomaton(@NotNull Automaton automaton, boolean finite, boolean simplify, boolean isBinary) {
        BytesRef suffix;
        Intrinsics.checkNotNullParameter((Object)automaton, (String)"automaton");
        this.type = AUTOMATON_TYPE.NORMAL;
        this.transition = new Transition();
        Automaton automaton2 = automaton;
        if (automaton2.getNumStates() == 0) {
            automaton2 = new Automaton(0, 0, 3, null);
            automaton2.createState();
        }
        boolean simplified = false;
        if (simplify && automaton2.isDeterministic()) {
            if (Operations.INSTANCE.isEmpty(automaton2)) {
                this.type = AUTOMATON_TYPE.NONE;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = true;
                this.sinkState = -1;
                this.nfaRunAutomaton = null;
                simplified = true;
            } else {
                boolean isTotal;
                boolean bl = isTotal = isBinary ? Operations.INSTANCE.isTotal(automaton2, 0, 255) : Operations.INSTANCE.isTotal(automaton2);
                if (isTotal) {
                    this.type = AUTOMATON_TYPE.ALL;
                    this.term = null;
                    this.commonSuffixRef = null;
                    this.runAutomaton = null;
                    this.automaton = null;
                    this.finite = false;
                    this.sinkState = -1;
                    this.nfaRunAutomaton = null;
                    simplified = true;
                } else {
                    IntsRef singleton = Operations.INSTANCE.getSingleton(automaton2);
                    if (singleton != null) {
                        this.type = AUTOMATON_TYPE.SINGLE;
                        this.commonSuffixRef = null;
                        this.runAutomaton = null;
                        this.automaton = null;
                        this.finite = true;
                        this.term = isBinary ? StringHelper.INSTANCE.intsRefToBytesRef(singleton) : new BytesRef(UnicodeUtil.INSTANCE.newString(singleton.getInts(), singleton.getOffset(), singleton.getLength()));
                        this.sinkState = -1;
                        this.nfaRunAutomaton = null;
                        simplified = true;
                    }
                }
            }
        }
        if (!simplified) {
            this.type = AUTOMATON_TYPE.NORMAL;
            this.term = null;
        }
        this.finite = finite;
        Automaton binary = null;
        Automaton automaton3 = binary = isBinary ? automaton2 : new UTF32ToUTF8().convert(automaton2);
        BytesRef bytesRef = this.finite || automaton2.getNumStates() + automaton2.getNumTransitions() > 1000 ? null : (this.commonSuffixRef = (suffix = Operations.INSTANCE.getCommonSuffixBytesRef(binary)).getLength() == 0 ? null : suffix);
        if (!automaton2.isDeterministic() && !binary.isDeterministic()) {
            this.automaton = null;
            this.runAutomaton = null;
            this.sinkState = -1;
            this.nfaRunAutomaton = new NFARunAutomaton(binary, 255);
        } else {
            binary = Operations.INSTANCE.determinize(binary, Integer.MAX_VALUE);
            ByteRunAutomaton byteRunAutomaton = this.runAutomaton = new ByteRunAutomaton(binary, true);
            Intrinsics.checkNotNull((Object)byteRunAutomaton);
            Automaton automaton4 = this.automaton = byteRunAutomaton.getAutomaton();
            Intrinsics.checkNotNull((Object)automaton4);
            this.sinkState = CompiledAutomaton.Companion.findSinkState(automaton4);
            this.nfaRunAutomaton = null;
        }
    }

    @NotNull
    public final AUTOMATON_TYPE getType() {
        return this.type;
    }

    public final void setType(@NotNull AUTOMATON_TYPE aUTOMATON_TYPE) {
        Intrinsics.checkNotNullParameter((Object)((Object)aUTOMATON_TYPE), (String)"<set-?>");
        this.type = aUTOMATON_TYPE;
    }

    @Nullable
    public final BytesRef getTerm() {
        return this.term;
    }

    public final void setTerm(@Nullable BytesRef bytesRef) {
        this.term = bytesRef;
    }

    @Nullable
    public final ByteRunAutomaton getRunAutomaton() {
        return this.runAutomaton;
    }

    public final void setRunAutomaton(@Nullable ByteRunAutomaton byteRunAutomaton) {
        this.runAutomaton = byteRunAutomaton;
    }

    @Nullable
    public final Automaton getAutomaton() {
        return this.automaton;
    }

    public final void setAutomaton(@Nullable Automaton automaton) {
        this.automaton = automaton;
    }

    @Nullable
    public final NFARunAutomaton getNfaRunAutomaton() {
        return this.nfaRunAutomaton;
    }

    public final void setNfaRunAutomaton(@Nullable NFARunAutomaton nFARunAutomaton) {
        this.nfaRunAutomaton = nFARunAutomaton;
    }

    @Nullable
    public final BytesRef getCommonSuffixRef() {
        return this.commonSuffixRef;
    }

    public final void setCommonSuffixRef(@Nullable BytesRef bytesRef) {
        this.commonSuffixRef = bytesRef;
    }

    public final boolean getFinite() {
        return this.finite;
    }

    public final void setFinite(boolean bl) {
        this.finite = bl;
    }

    public final int getSinkState() {
        return this.sinkState;
    }

    public final void setSinkState(int n) {
        this.sinkState = n;
    }

    public CompiledAutomaton(@NotNull Automaton automaton) {
        Intrinsics.checkNotNullParameter((Object)automaton, (String)"automaton");
        this(automaton, false, true);
    }

    public CompiledAutomaton(@NotNull Automaton automaton, boolean finite, boolean simplify) {
        Intrinsics.checkNotNullParameter((Object)automaton, (String)"automaton");
        this(automaton, finite, simplify, false);
    }

    private final BytesRef addTail(int state2, BytesRefBuilder term, int idx, int leadLabel) {
        int state3 = state2;
        int idx2 = idx;
        int maxIndex = -1;
        Automaton automaton = this.automaton;
        Intrinsics.checkNotNull((Object)automaton);
        int numTransitions = automaton.initTransition(state3, this.transition);
        int i = 0;
        int n = numTransitions;
        while (i < n) {
            Automaton automaton2 = this.automaton;
            Intrinsics.checkNotNull((Object)automaton2);
            automaton2.getNextTransition(this.transition);
            if (this.transition.getMin() >= leadLabel) break;
            maxIndex = i++;
        }
        if (!(maxIndex != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Automaton automaton3 = this.automaton;
        Intrinsics.checkNotNull((Object)automaton3);
        automaton3.getTransition(state3, maxIndex, this.transition);
        int floorLabel = this.transition.getMax() > leadLabel - 1 ? leadLabel - 1 : this.transition.getMax();
        term.grow(1 + idx2);
        term.setByteAt(idx2, (byte)floorLabel);
        state3 = this.transition.getDest();
        ++idx2;
        while (true) {
            Automaton automaton4 = this.automaton;
            Intrinsics.checkNotNull((Object)automaton4);
            numTransitions = automaton4.getNumTransitions(state3);
            if (numTransitions == 0) {
                ByteRunAutomaton byteRunAutomaton = this.runAutomaton;
                Intrinsics.checkNotNull((Object)byteRunAutomaton);
                if (!byteRunAutomaton.isAccept(state3)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                term.setLength(idx2);
                return term.get();
            }
            Automaton automaton5 = this.automaton;
            Intrinsics.checkNotNull((Object)automaton5);
            automaton5.getTransition(state3, numTransitions - 1, this.transition);
            term.grow(1 + idx2);
            term.setByteAt(idx2, (byte)this.transition.getMax());
            state3 = this.transition.getDest();
            ++idx2;
        }
    }

    @NotNull
    public final TermsEnum getTermsEnum(@NotNull Terms terms) {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> TermsEnum.Companion.getEMPTY();
            case 2 -> terms.iterator();
            case 3 -> new SingleTermsEnum(terms.iterator(), this.term);
            case 4 -> terms.intersect(this, null);
            default -> throw new RuntimeException("unhandled case");
        };
    }

    public final void visit(@NotNull QueryVisitor visitor2, @NotNull Query parent, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (visitor2.acceptField(field)) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 4: {
                    visitor2.consumeTermsMatching(parent, field, (Function0<ByteRunAutomaton>)((Function0)() -> CompiledAutomaton.visit$lambda$0(this)));
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    visitor2.consumeTermsMatching(parent, field, (Function0<ByteRunAutomaton>)((Function0)CompiledAutomaton::visit$lambda$1));
                    break;
                }
                case 3: {
                    Term[] termArray = new Term[1];
                    BytesRef bytesRef = this.term;
                    Intrinsics.checkNotNull((Object)bytesRef);
                    termArray[0] = new Term(field, bytesRef);
                    visitor2.consumeTerms(parent, termArray);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Nullable
    public final BytesRef floor(@NotNull BytesRef input, @NotNull BytesRefBuilder output) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int state2 = 0;
        if (input.getLength() == 0) {
            ByteRunAutomaton byteRunAutomaton = this.runAutomaton;
            Intrinsics.checkNotNull((Object)byteRunAutomaton);
            if (byteRunAutomaton.isAccept(state2)) {
                output.clear();
                return output.get();
            }
            return null;
        }
        IntArrayList stack = new IntArrayList();
        int idx = 0;
        while (true) {
            int label = input.getBytes()[input.getOffset() + idx] & 0xFF;
            ByteRunAutomaton byteRunAutomaton = this.runAutomaton;
            Intrinsics.checkNotNull((Object)byteRunAutomaton);
            int nextState = byteRunAutomaton.step(state2, label);
            if (idx == input.getLength() - 1) {
                if (nextState != -1) {
                    ByteRunAutomaton byteRunAutomaton2 = this.runAutomaton;
                    Intrinsics.checkNotNull((Object)byteRunAutomaton2);
                    if (byteRunAutomaton2.isAccept(nextState)) {
                        output.grow(1 + idx);
                        output.setByteAt(idx, (byte)label);
                        output.setLength(input.getLength());
                        return output.get();
                    }
                }
                nextState = -1;
            }
            if (nextState == -1) {
                while (true) {
                    Automaton automaton = this.automaton;
                    Intrinsics.checkNotNull((Object)automaton);
                    int numTransitions = automaton.getNumTransitions(state2);
                    if (numTransitions == 0) {
                        ByteRunAutomaton byteRunAutomaton3 = this.runAutomaton;
                        Intrinsics.checkNotNull((Object)byteRunAutomaton3);
                        if (!byteRunAutomaton3.isAccept(state2)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        output.setLength(idx);
                        return output.get();
                    }
                    Automaton automaton2 = this.automaton;
                    Intrinsics.checkNotNull((Object)automaton2);
                    automaton2.getTransition(state2, 0, this.transition);
                    if (label - 1 >= this.transition.getMin()) break;
                    ByteRunAutomaton byteRunAutomaton4 = this.runAutomaton;
                    Intrinsics.checkNotNull((Object)byteRunAutomaton4);
                    if (byteRunAutomaton4.isAccept(state2)) {
                        output.setLength(idx);
                        return output.get();
                    }
                    if (stack.size() == 0) {
                        return null;
                    }
                    state2 = stack.removeLast();
                    label = input.getBytes()[input.getOffset() + --idx] & 0xFF;
                }
                return this.addTail(state2, output, idx, label);
            }
            output.grow(1 + idx);
            output.setByteAt(idx, (byte)label);
            stack.add(state2);
            state2 = nextState;
            ++idx;
        }
    }

    @Nullable
    public final ByteRunnable getByteRunnable() {
        if (!(this.nfaRunAutomaton == null || this.runAutomaton == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.nfaRunAutomaton == null) {
            return this.runAutomaton;
        }
        return this.nfaRunAutomaton;
    }

    @Nullable
    public final TransitionAccessor getTransitionAccessor() {
        if (!(this.nfaRunAutomaton == null || this.automaton == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.nfaRunAutomaton == null ? (TransitionAccessor)this.automaton : (TransitionAccessor)this.nfaRunAutomaton;
    }

    public int hashCode() {
        int n;
        int n2;
        int n3;
        int prime = 31;
        int result = 1;
        if (this.runAutomaton == null) {
            n3 = 0;
        } else {
            ByteRunAutomaton byteRunAutomaton = this.runAutomaton;
            n3 = byteRunAutomaton != null ? ((Object)byteRunAutomaton).hashCode() : 0;
        }
        result = prime * result + n3;
        if (this.nfaRunAutomaton == null) {
            n2 = 0;
        } else {
            NFARunAutomaton nFARunAutomaton = this.nfaRunAutomaton;
            n2 = nFARunAutomaton != null ? nFARunAutomaton.hashCode() : 0;
        }
        result = prime * result + n2;
        if (this.term == null) {
            n = 0;
        } else {
            BytesRef bytesRef = this.term;
            n = bytesRef != null ? ((Object)bytesRef).hashCode() : 0;
        }
        result = prime * result + n;
        result = prime * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (Intrinsics.areEqual((Object)this, (Object)obj)) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompiledAutomaton other = (CompiledAutomaton)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.type == AUTOMATON_TYPE.SINGLE) {
            BytesRef bytesRef = this.term;
            Intrinsics.checkNotNull((Object)bytesRef);
            if (!Intrinsics.areEqual((Object)bytesRef, (Object)other.term)) {
                return false;
            }
        } else if (this.type == AUTOMATON_TYPE.NORMAL) {
            return Intrinsics.areEqual((Object)this.runAutomaton, (Object)other.runAutomaton) && Intrinsics.areEqual((Object)this.nfaRunAutomaton, (Object)other.nfaRunAutomaton);
        }
        return true;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.Companion.sizeOfObject(this.automaton) + RamUsageEstimator.Companion.sizeOfObject(this.commonSuffixRef) + RamUsageEstimator.Companion.sizeOfObject(this.runAutomaton) + RamUsageEstimator.Companion.sizeOfObject(this.nfaRunAutomaton) + RamUsageEstimator.Companion.sizeOfObject(this.term) + RamUsageEstimator.Companion.sizeOfObject(this.transition);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    private static final ByteRunAutomaton visit$lambda$0(CompiledAutomaton this$0) {
        ByteRunAutomaton byteRunAutomaton = this$0.runAutomaton;
        Intrinsics.checkNotNull((Object)byteRunAutomaton);
        return byteRunAutomaton;
    }

    private static final ByteRunAutomaton visit$lambda$1() {
        return new ByteRunAutomaton(Automata.INSTANCE.makeAnyString());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton$AUTOMATON_TYPE;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "ALL", "SINGLE", "NORMAL", "core"})
    public static final class AUTOMATON_TYPE
    extends Enum<AUTOMATON_TYPE> {
        public static final /* enum */ AUTOMATON_TYPE NONE = new AUTOMATON_TYPE();
        public static final /* enum */ AUTOMATON_TYPE ALL = new AUTOMATON_TYPE();
        public static final /* enum */ AUTOMATON_TYPE SINGLE = new AUTOMATON_TYPE();
        public static final /* enum */ AUTOMATON_TYPE NORMAL = new AUTOMATON_TYPE();
        private static final /* synthetic */ AUTOMATON_TYPE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AUTOMATON_TYPE[] values() {
            return (AUTOMATON_TYPE[])$VALUES.clone();
        }

        public static AUTOMATON_TYPE valueOf(String value) {
            return Enum.valueOf(AUTOMATON_TYPE.class, value);
        }

        @NotNull
        public static EnumEntries<AUTOMATON_TYPE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = aUTOMATON_TYPEArray = new AUTOMATON_TYPE[]{AUTOMATON_TYPE.NONE, AUTOMATON_TYPE.ALL, AUTOMATON_TYPE.SINGLE, AUTOMATON_TYPE.NORMAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "findSinkState", "", "automaton", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int findSinkState(Automaton automaton) {
            int numStates = automaton.getNumStates();
            Transition t = new Transition();
            int foundState = -1;
            for (int s = 0; s < numStates; ++s) {
                if (!automaton.isAccept(s)) continue;
                int count = automaton.initTransition(s, t);
                boolean isSinkState = false;
                for (int i = 0; i < count; ++i) {
                    automaton.getNextTransition(t);
                    if (t.getDest() != s || t.getMin() != 0 || t.getMax() != 255) continue;
                    isSinkState = true;
                    break;
                }
                if (!isSinkState) continue;
                foundState = s;
                break;
            }
            return foundState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AUTOMATON_TYPE.values().length];
            try {
                nArray[AUTOMATON_TYPE.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AUTOMATON_TYPE.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AUTOMATON_TYPE.SINGLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AUTOMATON_TYPE.NORMAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

