/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.BitSet;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.IntsRefBuilder;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/automaton/FiniteStringsIterator;", "", "a", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "startState", "", "endState", "<init>", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;II)V", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;)V", "pathStates", "Lorg/gnit/lucenekmp/jdkport/BitSet;", "string", "Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "nodes", "", "Lorg/gnit/lucenekmp/util/automaton/FiniteStringsIterator$PathNode;", "[Lorg/gnit/lucenekmp/util/automaton/FiniteStringsIterator$PathNode;", "emitEmptyString", "", "next", "Lorg/gnit/lucenekmp/util/IntsRef;", "growStack", "", "depth", "PathNode", "Companion", "core"})
public class FiniteStringsIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Automaton a;
    private final int endState;
    @NotNull
    private final BitSet pathStates;
    @NotNull
    private final IntsRefBuilder string;
    @NotNull
    private PathNode[] nodes;
    private boolean emitEmptyString;
    @NotNull
    private static final IntsRef EMPTY = new IntsRef();

    public FiniteStringsIterator(@NotNull Automaton a, int startState, int endState) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this.a = a;
        this.endState = endState;
        int n = 0;
        PathNode[] pathNodeArray = new PathNode[16];
        FiniteStringsIterator finiteStringsIterator = this;
        while (n < 16) {
            int n2 = n++;
            pathNodeArray[n2] = new PathNode();
        }
        finiteStringsIterator.nodes = pathNodeArray;
        this.string = new IntsRefBuilder();
        this.pathStates = new BitSet(this.a.getNumStates());
        this.string.setLength(0);
        this.emitEmptyString = this.a.isAccept(0);
        if (this.a.getNumStates() > startState && this.a.getNumTransitions(startState) > 0) {
            this.pathStates.set(startState);
            this.nodes[0].resetState(this.a, startState);
            this.string.append(startState);
        }
    }

    public FiniteStringsIterator(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this(a, 0, -1);
    }

    @Nullable
    public IntsRef next() {
        if (this.emitEmptyString) {
            this.emitEmptyString = false;
            return EMPTY;
        }
        int depth = this.string.length();
        while (depth > 0) {
            PathNode node = this.nodes[depth - 1];
            int label = node.nextLabel(this.a);
            if (label != -1) {
                this.string.setIntAt(depth - 1, label);
                int to = node.getTo();
                if (this.a.getNumTransitions(to) != 0 && to != this.endState) {
                    if (this.pathStates.get(to)) {
                        throw new IllegalArgumentException("automaton has cycles");
                    }
                    this.pathStates.set(to);
                    this.growStack(depth);
                    this.nodes[depth].resetState(this.a, to);
                    this.string.setLength(++depth);
                    this.string.grow(depth);
                    continue;
                }
                if (this.endState != to && !this.a.isAccept(to)) continue;
                return this.string.get();
            }
            int state2 = node.getState();
            if (!this.pathStates.get(state2)) {
                throw new IllegalStateException("Check failed.");
            }
            this.pathStates.clear(state2);
            this.string.setLength(--depth);
            if (!this.a.isAccept(state2)) continue;
            return this.string.get();
        }
        return null;
    }

    private final void growStack(int depth) {
        if (this.nodes.length == depth) {
            int newSize = ArrayUtil.Companion.oversize(this.nodes.length + 1, 4);
            int n = 0;
            Object[] objectArray = new PathNode[newSize];
            while (n < newSize) {
                int n2 = n++;
                objectArray[n2] = new PathNode();
            }
            Object[] newNodes = objectArray;
            ArraysKt.copyInto$default((Object[])this.nodes, (Object[])newNodes, (int)0, (int)0, (int)this.nodes.length, (int)6, null);
            this.nodes = newNodes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/automaton/FiniteStringsIterator$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/gnit/lucenekmp/util/IntsRef;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/util/automaton/FiniteStringsIterator$PathNode;", "", "<init>", "()V", "state", "", "getState", "()I", "setState", "(I)V", "to", "getTo", "setTo", "transition", "getTransition", "setTransition", "label", "getLabel", "setLabel", "t", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "resetState", "", "a", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "nextLabel", "core"})
    private static final class PathNode {
        private int state;
        private int to;
        private int transition;
        private int label;
        @NotNull
        private final Transition t = new Transition();

        public final int getState() {
            return this.state;
        }

        public final void setState(int n) {
            this.state = n;
        }

        public final int getTo() {
            return this.to;
        }

        public final void setTo(int n) {
            this.to = n;
        }

        public final int getTransition() {
            return this.transition;
        }

        public final void setTransition(int n) {
            this.transition = n;
        }

        public final int getLabel() {
            return this.label;
        }

        public final void setLabel(int n) {
            this.label = n;
        }

        public final void resetState(@NotNull Automaton a, int state2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (!(a.getNumTransitions(state2) != 0)) {
                throw new IllegalStateException("Check failed.");
            }
            this.state = state2;
            this.transition = 0;
            a.getTransition(state2, 0, this.t);
            this.label = this.t.getMin();
            this.to = this.t.getDest();
        }

        public final int nextLabel(@NotNull Automaton a) {
            int n;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (this.label > this.t.getMax()) {
                n = this.transition;
                this.transition = n + 1;
                if (this.transition >= a.getNumTransitions(this.state)) {
                    this.label = -1;
                    return -1;
                }
                a.getTransition(this.state, this.transition, this.t);
                this.label = this.t.getMin();
                this.to = this.t.getDest();
            }
            n = this.label;
            this.label = n + 1;
            return n;
        }
    }
}

