/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.internal.hppc.IntHashSet;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.ObjectsKt;
import org.gnit.lucenekmp.util.UnicodeUtil;
import org.gnit.lucenekmp.util.UnicodeUtilKt;
import org.gnit.lucenekmp.util.automaton.Automata;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.Lev1ParametricDescription;
import org.gnit.lucenekmp.util.automaton.Lev1TParametricDescription;
import org.gnit.lucenekmp.util.automaton.Lev2ParametricDescription;
import org.gnit.lucenekmp.util.automaton.Lev2TParametricDescription;
import org.gnit.lucenekmp.util.automaton.Operations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0005J\u0018\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000bJ\u001e\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata;", "", "word", "", "alphaMax", "", "withTranspositions", "", "<init>", "([IIZ)V", "input", "", "(Ljava/lang/String;Z)V", "getWord", "()[I", "getAlphaMax", "()I", "alphabet", "getAlphabet", "rangeLower", "getRangeLower", "rangeUpper", "getRangeUpper", "numRanges", "getNumRanges", "setNumRanges", "(I)V", "descriptions", "", "Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$ParametricDescription;", "getDescriptions", "()[Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$ParametricDescription;", "setDescriptions", "([Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$ParametricDescription;)V", "[Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$ParametricDescription;", "toAutomaton", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "n", "prefix", "getVector", "x", "pos", "end", "ParametricDescription", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLevenshteinAutomata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevenshteinAutomata.kt\norg/gnit/lucenekmp/util/automaton/LevenshteinAutomata\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,378:1\n1#2:379\n3#3,8:380\n10#4:388\n*S KotlinDebug\n*F\n+ 1 LevenshteinAutomata.kt\norg/gnit/lucenekmp/util/automaton/LevenshteinAutomata\n*L\n203#1:380,8\n203#1:388\n*E\n"})
public final class LevenshteinAutomata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] word;
    private final int alphaMax;
    @NotNull
    private final int[] alphabet;
    @NotNull
    private final int[] rangeLower;
    @NotNull
    private final int[] rangeUpper;
    private int numRanges;
    @NotNull
    private ParametricDescription[] descriptions;
    public static final int MAXIMUM_SUPPORTED_DISTANCE = 2;

    public LevenshteinAutomata(@NotNull int[] word, int alphaMax, boolean withTranspositions) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        this.word = word;
        this.alphaMax = alphaMax;
        IntHashSet set = new IntHashSet();
        for (int v : this.word) {
            if (!(v <= this.alphaMax)) {
                boolean bl = false;
                String string = "alphaMax exceeded by symbol " + v + " in word";
                throw new IllegalArgumentException(string.toString());
            }
            set.add(v);
        }
        this.alphabet = set.toArray();
        Arrays.INSTANCE.sort(this.alphabet);
        this.rangeLower = new int[this.alphabet.length + 2];
        this.rangeUpper = new int[this.alphabet.length + 2];
        int lower = 0;
        for (int higher : this.alphabet) {
            if (higher > lower) {
                this.rangeLower[this.numRanges] = lower;
                this.rangeUpper[this.numRanges] = higher - 1;
                int n = this.numRanges;
                this.numRanges = n + 1;
            }
            lower = higher + 1;
        }
        if (lower <= this.alphaMax) {
            this.rangeLower[this.numRanges] = lower;
            this.rangeUpper[this.numRanges] = this.alphaMax;
            int n = this.numRanges;
            this.numRanges = n + 1;
        }
        ParametricDescription[] parametricDescriptionArray = new ParametricDescription[]{null, withTranspositions ? (ParametricDescription)new Lev1TParametricDescription(this.word.length) : (ParametricDescription)new Lev1ParametricDescription(this.word.length), withTranspositions ? (ParametricDescription)new Lev2TParametricDescription(this.word.length) : (ParametricDescription)new Lev2ParametricDescription(this.word.length)};
        this.descriptions = parametricDescriptionArray;
    }

    @NotNull
    public final int[] getWord() {
        return this.word;
    }

    public final int getAlphaMax() {
        return this.alphaMax;
    }

    @NotNull
    public final int[] getAlphabet() {
        return this.alphabet;
    }

    @NotNull
    public final int[] getRangeLower() {
        return this.rangeLower;
    }

    @NotNull
    public final int[] getRangeUpper() {
        return this.rangeUpper;
    }

    public final int getNumRanges() {
        return this.numRanges;
    }

    public final void setNumRanges(int n) {
        this.numRanges = n;
    }

    @NotNull
    public final ParametricDescription[] getDescriptions() {
        return this.descriptions;
    }

    public final void setDescriptions(@NotNull ParametricDescription[] parametricDescriptionArray) {
        Intrinsics.checkNotNullParameter((Object)parametricDescriptionArray, (String)"<set-?>");
        this.descriptions = parametricDescriptionArray;
    }

    public LevenshteinAutomata(@NotNull String input, boolean withTranspositions) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(LevenshteinAutomata.Companion.codePoints(input), 0x10FFFF, withTranspositions);
    }

    @Nullable
    public final Automaton toAutomaton(int n) {
        return this.toAutomaton(n, "");
    }

    @Nullable
    public final Automaton toAutomaton(int n, @NotNull String prefix) {
        int state2;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (n == 0) {
            return Automata.INSTANCE.makeString(prefix + UnicodeUtil.INSTANCE.newString(this.word, 0, this.word.length));
        }
        if (n >= this.descriptions.length) {
            return null;
        }
        int range2 = 2 * n + 1;
        ParametricDescription parametricDescription = this.descriptions[n];
        Intrinsics.checkNotNull((Object)parametricDescription);
        ParametricDescription description = parametricDescription;
        int numStates = description.size();
        int numTransitions = numStates * Math.min(1 + 2 * n, this.alphabet.length);
        int prefixStates = UnicodeUtilKt.codePointCount(prefix, 0, prefix.length());
        Automaton a = new Automaton(numStates + prefixStates, numTransitions);
        int lastState = 0;
        lastState = a.createState();
        int cp = 0;
        for (int i = 0; i < prefix.length(); i += Character.Companion.charCount(cp)) {
            state2 = a.createState();
            cp = ObjectsKt.codePointAt(prefix, i);
            a.addTransition(lastState, state2, cp, cp);
            lastState = state2;
        }
        int stateOffset = lastState;
        a.setAccept(lastState, description.isAccept(0));
        for (int i = 1; i < numStates; ++i) {
            state2 = a.createState();
            a.setAccept(state2, description.isAccept(i));
        }
        for (int k = 0; k < numStates; ++k) {
            int xpos = description.getPosition(k);
            if (xpos < 0) continue;
            int end = xpos + Math.min(this.word.length - xpos, range2);
            for (int ch : this.alphabet) {
                int cvec = this.getVector(ch, xpos, end);
                int dest = description.transition(k, xpos, cvec);
                if (dest < 0) continue;
                a.addTransition(stateOffset + k, stateOffset + dest, ch);
            }
            int dest = description.transition(k, xpos, 0);
            if (dest < 0) continue;
            int n2 = this.numRanges;
            for (int r = 0; r < n2; ++r) {
                a.addTransition(stateOffset + k, stateOffset + dest, this.rangeLower[r], this.rangeUpper[r]);
            }
        }
        a.finishState();
        Automaton automaton = Operations.INSTANCE.removeDeadStates(a);
        boolean condition$iv = automaton.isDeterministic();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return automaton;
    }

    public final int getVector(int x, int pos, int end) {
        int vector = 0;
        for (int i = pos; i < end; ++i) {
            vector <<= 1;
            if (this.word[i] != x) continue;
            vector |= 1;
        }
        return vector;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$Companion;", "", "<init>", "()V", "MAXIMUM_SUPPORTED_DISTANCE", "", "codePoints", "", "input", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] codePoints(String input) {
            int length = UnicodeUtilKt.codePointCount(input, 0, input.length());
            int[] word = new int[length];
            int j = 0;
            int cp = 0;
            for (int i = 0; i < input.length(); i += Character.Companion.charCount(cp)) {
                cp = ObjectsKt.codePointAt(input, i);
                word[j++] = cp;
            }
            return word;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0016\n\u0002\b\u0004\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J \u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H&J \u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$ParametricDescription;", "", "w", "", "n", "minErrors", "", "<init>", "(II[I)V", "getW", "()I", "getN", "size", "isAccept", "", "absState", "getPosition", "transition", "state", "position", "vector", "unpack", "data", "", "index", "bitsPerValue", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nLevenshteinAutomata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevenshteinAutomata.kt\norg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$ParametricDescription\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,378:1\n3#2,8:379\n10#3:387\n*S KotlinDebug\n*F\n+ 1 LevenshteinAutomata.kt\norg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$ParametricDescription\n*L\n251#1:379,8\n251#1:387\n*E\n"})
    public static abstract class ParametricDescription {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int w;
        private final int n;
        @NotNull
        private final int[] minErrors;
        @NotNull
        private static final long[] MASKS;

        public ParametricDescription(int w, int n, @NotNull int[] minErrors) {
            Intrinsics.checkNotNullParameter((Object)minErrors, (String)"minErrors");
            this.w = w;
            this.n = n;
            this.minErrors = minErrors;
        }

        protected final int getW() {
            return this.w;
        }

        protected final int getN() {
            return this.n;
        }

        public final int size() {
            return this.minErrors.length * (this.w + 1);
        }

        public final boolean isAccept(int absState) {
            int state2 = absState / (this.w + 1);
            int offset = absState % (this.w + 1);
            boolean condition$iv = offset >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return this.w - offset + this.minErrors[state2] <= this.n;
        }

        public final int getPosition(int absState) {
            return absState % (this.w + 1);
        }

        public abstract int transition(int var1, int var2, int var3);

        protected final int unpack(@NotNull long[] data, int index, int bitsPerValue) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            long bitLoc = (long)bitsPerValue * (long)index;
            int dataLoc = (int)(bitLoc >> 6);
            int bitStart = (int)(bitLoc & 0x3FL);
            if (bitStart + bitsPerValue <= 64) {
                return (int)(data[dataLoc] >> bitStart & MASKS[bitsPerValue - 1]);
            }
            int part = 64 - bitStart;
            return (int)((data[dataLoc] >> bitStart & MASKS[part - 1]) + ((data[1 + dataLoc] & MASKS[bitsPerValue - part - 1]) << part));
        }

        static {
            long[] lArray = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};
            MASKS = lArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata$ParametricDescription$Companion;", "", "<init>", "()V", "MASKS", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

