/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.BitSet;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.FiniteStringsIterator;
import org.gnit.lucenekmp.util.automaton.LimitedFiniteStringsIterator;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/automaton/LimitedFiniteStringsIterator;", "Lorg/gnit/lucenekmp/util/automaton/FiniteStringsIterator;", "a", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "limit", "", "<init>", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;I)V", "count", "next", "Lorg/gnit/lucenekmp/util/IntsRef;", "size", "hasReachableCycle", "", "core"})
@SourceDebugExtension(value={"SMAP\nLimitedFiniteStringsIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimitedFiniteStringsIterator.kt\norg/gnit/lucenekmp/util/automaton/LimitedFiniteStringsIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class LimitedFiniteStringsIterator
extends FiniteStringsIterator {
    private final int limit;
    private int count;

    public LimitedFiniteStringsIterator(@NotNull Automaton a, int limit) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        super(a);
        if (!(limit == -1 || limit > 0)) {
            boolean bl = false;
            String string = "limit must be -1 (which means no limit), or > 0; got: " + limit;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.hasReachableCycle(a)) {
            throw new IllegalArgumentException("automaton has cycles");
        }
        this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
    }

    @Override
    @Nullable
    public IntsRef next() {
        if (this.count >= this.limit) {
            return null;
        }
        IntsRef result = super.next();
        if (result != null) {
            int n = this.count;
            this.count = n + 1;
        }
        return result;
    }

    public final int size() {
        return this.count;
    }

    private final boolean hasReachableCycle(Automaton a) {
        if (a.getNumStates() == 0) {
            return false;
        }
        BitSet onPath = new BitSet(a.getNumStates());
        BitSet visited = new BitSet(a.getNumStates());
        ArrayDeque stack = new ArrayDeque();
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J,\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"org/gnit/lucenekmp/util/automaton/LimitedFiniteStringsIterator$hasReachableCycle$Frame", "", "state", "", "nextIdx", "num", "<init>", "(III)V", "getState", "()I", "setState", "(I)V", "getNextIdx", "setNextIdx", "getNum", "setNum", "component1", "component2", "component3", "copy", "(III)Lorg/gnit/lucenekmp/util/automaton/LimitedFiniteStringsIterator$hasReachableCycle$Frame;", "equals", "", "other", "hashCode", "toString", "", "core"})
        public final class Frame {
            private int state;
            private int nextIdx;
            private int num;

            public Frame(int state2, int nextIdx, int num) {
                this.state = state2;
                this.nextIdx = nextIdx;
                this.num = num;
            }

            public final int getState() {
                return this.state;
            }

            public final void setState(int n) {
                this.state = n;
            }

            public final int getNextIdx() {
                return this.nextIdx;
            }

            public final void setNextIdx(int n) {
                this.nextIdx = n;
            }

            public final int getNum() {
                return this.num;
            }

            public final void setNum(int n) {
                this.num = n;
            }

            public final int component1() {
                return this.state;
            }

            public final int component2() {
                return this.nextIdx;
            }

            public final int component3() {
                return this.num;
            }

            public final Frame copy(int state2, int nextIdx, int num) {
                return new Frame(state2, nextIdx, num);
            }

            public static /* synthetic */ Frame copy$default(Frame frame, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = frame.state;
                }
                if ((n4 & 2) != 0) {
                    n2 = frame.nextIdx;
                }
                if ((n4 & 4) != 0) {
                    n3 = frame.num;
                }
                return frame.copy(n, n2, n3);
            }

            public String toString() {
                return "Frame(state=" + this.state + ", nextIdx=" + this.nextIdx + ", num=" + this.num + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.state);
                result = result * 31 + Integer.hashCode(this.nextIdx);
                result = result * 31 + Integer.hashCode(this.num);
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Frame)) {
                    return false;
                }
                Frame frame = (Frame)other;
                if (this.state != frame.state) {
                    return false;
                }
                if (this.nextIdx != frame.nextIdx) {
                    return false;
                }
                return this.num == frame.num;
            }
        }
        stack.addLast((Object)new Frame(0, 0, a.getNumTransitions(0)));
        onPath.set(0);
        Transition t = new Transition();
        while (!((Collection)stack).isEmpty()) {
            Frame f = (Frame)stack.last();
            if (f.getNextIdx() < f.getNum()) {
                a.getTransition(f.getState(), f.getNextIdx(), t);
                int n = f.getNextIdx();
                f.setNextIdx(n + 1);
                int dest = t.getDest();
                if (onPath.get(dest)) {
                    return true;
                }
                if (visited.get(dest)) continue;
                onPath.set(dest);
                stack.addLast((Object)new Frame(dest, 0, a.getNumTransitions(dest)));
                continue;
            }
            visited.set(f.getState());
            onPath.clear(f.getState());
            stack.removeLast();
        }
        return false;
    }
}

