/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.ByteRunnable;
import org.gnit.lucenekmp.util.automaton.Operations;
import org.gnit.lucenekmp.util.automaton.StateSet;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.gnit.lucenekmp.util.automaton.TransitionAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 32\u00020\u00012\u00020\u00022\u00020\u0003:\u000223B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\fJ\u001c\u0010\u001a\u001a\u00020\u00072\n\u0010$\u001a\u00060\u000fR\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0016\u0010%\u001a\u00020\u00072\f\u0010$\u001a\b\u0018\u00010\u000fR\u00020\u0000H\u0002J\u000e\u0010&\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007J\u0018\u0010'\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020+2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J \u0010.\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0016J\b\u00100\u001a\u000201H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u000fR\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u000fR\u00020\u00000\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00064"}, d2={"Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton;", "Lorg/gnit/lucenekmp/util/automaton/ByteRunnable;", "Lorg/gnit/lucenekmp/util/automaton/TransitionAccessor;", "Lorg/gnit/lucenekmp/util/Accountable;", "automaton", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "alphabetSize", "", "<init>", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;I)V", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;)V", "points", "", "dStateToOrd", "", "Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton$DState;", "dStates", "", "[Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton$DState;", "classmap", "getClassmap", "()[I", "transitionSet", "Lorg/gnit/lucenekmp/util/automaton/Operations$PointTransitionSet;", "statesSet", "Lorg/gnit/lucenekmp/util/automaton/StateSet;", "step", "state", "c", "isAccept", "", "size", "getSize", "()I", "run", "s", "dState", "findDState", "getCharClass", "initTransition", "t", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "getNextTransition", "", "setTransitionAccordingly", "getNumTransitions", "getTransition", "index", "ramBytesUsed", "", "DState", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nNFARunAutomaton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NFARunAutomaton.kt\norg/gnit/lucenekmp/util/automaton/NFARunAutomaton\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,436:1\n1#2:437\n217#3,5:438\n189#3,2:443\n222#3:445\n*S KotlinDebug\n*F\n+ 1 NFARunAutomaton.kt\norg/gnit/lucenekmp/util/automaton/NFARunAutomaton\n*L\n126#1:438,5\n126#1:443,2\n126#1:445\n*E\n"})
public final class NFARunAutomaton
implements ByteRunnable,
TransitionAccessor,
Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Automaton automaton;
    private final int alphabetSize;
    @NotNull
    private final int[] points;
    @NotNull
    private final Map<DState, Integer> dStateToOrd;
    @NotNull
    private DState[] dStates;
    @NotNull
    private final int[] classmap;
    @NotNull
    private final Operations.PointTransitionSet transitionSet;
    @NotNull
    private final StateSet statesSet;
    private static final int MISSING = -1;
    private static final int NOT_COMPUTED = -2;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(NFARunAutomaton.class));

    public NFARunAutomaton(@NotNull Automaton automaton, int alphabetSize) {
        Intrinsics.checkNotNullParameter((Object)automaton, (String)"automaton");
        this.automaton = automaton;
        this.alphabetSize = alphabetSize;
        this.dStateToOrd = new LinkedHashMap();
        this.transitionSet = new Operations.PointTransitionSet();
        this.statesSet = new StateSet(5);
        this.points = this.automaton.getStartPoints();
        this.dStates = new DState[10];
        int[] nArray = new int[]{0};
        this.findDState(new DState(nArray));
        this.classmap = new int[Math.min(256, this.alphabetSize)];
        int i = 0;
        int n = this.classmap.length;
        for (int j = 0; j < n; ++j) {
            if (i + 1 >= this.points.length || j == this.points[i + 1]) {
                // empty if block
            }
            this.classmap[j] = ++i;
        }
    }

    @NotNull
    public final int[] getClassmap() {
        return this.classmap;
    }

    public NFARunAutomaton(@NotNull Automaton automaton) {
        Intrinsics.checkNotNullParameter((Object)automaton, (String)"automaton");
        this(automaton, 0x110000);
    }

    @Override
    public int step(int state2, int c) {
        if (this.dStates[state2] == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DState dState = this.dStates[state2];
        Intrinsics.checkNotNull((Object)dState);
        return this.step(dState, c);
    }

    @Override
    public boolean isAccept(int state2) {
        if (this.dStates[state2] == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DState dState = this.dStates[state2];
        Intrinsics.checkNotNull((Object)dState);
        return dState.isAccept$core();
    }

    @Override
    public int getSize() {
        return this.dStates.length;
    }

    public final boolean run(@NotNull int[] s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int p = 0;
        for (int c : s) {
            if ((p = this.step(p, c)) != MISSING) continue;
            return false;
        }
        DState dState = this.dStates[p];
        Intrinsics.checkNotNull((Object)dState);
        return dState.isAccept$core();
    }

    private final int step(DState dState, int c) {
        int charClass = this.getCharClass(c);
        return dState.nextState(charClass);
    }

    /*
     * WARNING - void declaration
     */
    private final int findDState(DState dState) {
        int ord;
        if (dState == null) {
            return MISSING;
        }
        Integer n = this.dStateToOrd.get(dState);
        if (n == null) {
            boolean bl = false;
            n = -1;
        }
        if ((ord = ((Number)n).intValue()) >= 0) {
            return ord;
        }
        ord = this.dStateToOrd.size();
        this.dStateToOrd.put(dState, ord);
        if (!(ord >= this.dStates.length || this.dStates[ord] == null)) {
            String bl = "Failed requirement.";
            throw new IllegalArgumentException(bl.toString());
        }
        if (ord >= this.dStates.length) {
            DState[] dStateArray;
            void array$iv;
            void minSize$iv;
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            DState[] bl = this.dStates;
            int n2 = ord + 1;
            NFARunAutomaton nFARunAutomaton = this;
            boolean $i$f$growNullable = false;
            if (minSize$iv < 0) {
                throw new Exception("size must be positive (got " + (int)minSize$iv + "): likely integer overflow?");
            }
            if (((void)array$iv).length < minSize$iv) {
                void array$iv$iv;
                void this_$iv;
                int newLength$iv = this_$iv.oversize((int)minSize$iv, 4);
                void var8_11 = this_$iv;
                void var9_12 = array$iv;
                int newLength$iv$iv = newLength$iv;
                boolean $i$f$growExactNullable = false;
                if (newLength$iv$iv < ((void)array$iv$iv).length) {
                    throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
                }
                DState[] dStateArray2 = new DState[newLength$iv$iv];
                for (int i = 0; i < newLength$iv$iv; ++i) {
                    int n3 = i;
                    dStateArray2[n3] = n3 < ((void)array$iv$iv).length ? array$iv$iv[n3] : null;
                }
                dStateArray = dStateArray2;
            } else {
                dStateArray = array$iv;
            }
            nFARunAutomaton.dStates = dStateArray;
        }
        this.dStates[ord] = dState;
        return ord;
    }

    public final int getCharClass(int c) {
        if (!(c < this.alphabetSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (c < this.classmap.length) {
            return this.classmap[c];
        }
        int a = 0;
        int b = this.points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (this.points[d] > c) {
                b = d;
                continue;
            }
            if (this.points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    @Override
    public int initTransition(int state2, @NotNull Transition t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        t.setSource(state2);
        t.setTransitionUpto(-1);
        return this.getNumTransitions(state2);
    }

    @Override
    public void getNextTransition(@NotNull Transition t) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!(t.getTransitionUpto() < this.points.length - 1 && t.getTransitionUpto() >= -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        do {
            DState dState = this.dStates[t.getSource()];
            Intrinsics.checkNotNull((Object)dState);
            nArray = dState.getTransitions$core();
            Intrinsics.checkNotNull((Object)nArray);
            t.setTransitionUpto(t.getTransitionUpto() + 1);
        } while (nArray[t.getTransitionUpto()] == MISSING);
        DState dState = this.dStates[t.getSource()];
        Intrinsics.checkNotNull((Object)dState);
        int[] nArray2 = dState.getTransitions$core();
        Intrinsics.checkNotNull((Object)nArray2);
        if (!(nArray2[t.getTransitionUpto()] != NOT_COMPUTED)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setTransitionAccordingly(t);
    }

    private final void setTransitionAccordingly(Transition t) {
        DState dState = this.dStates[t.getSource()];
        Intrinsics.checkNotNull((Object)dState);
        int[] nArray = dState.getTransitions$core();
        Intrinsics.checkNotNull((Object)nArray);
        t.setDest(nArray[t.getTransitionUpto()]);
        t.setMin(this.points[t.getTransitionUpto()]);
        if (t.getTransitionUpto() == this.points.length - 1) {
            t.setMax(this.alphabetSize - 1);
        } else {
            t.setMax(this.points[t.getTransitionUpto() + 1] - 1);
        }
    }

    @Override
    public int getNumTransitions(int state2) {
        DState dState = this.dStates[state2];
        Intrinsics.checkNotNull((Object)dState);
        dState.determinize();
        DState dState2 = this.dStates[state2];
        Intrinsics.checkNotNull((Object)dState2);
        return dState2.getOutgoingTransitions$core();
    }

    @Override
    public void getTransition(int state2, int index, @NotNull Transition t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        DState dState = this.dStates[state2];
        Intrinsics.checkNotNull((Object)dState);
        dState.determinize();
        int outgoingTransitions = -1;
        t.setTransitionUpto(-1);
        t.setSource(state2);
        while (outgoingTransitions < index && t.getTransitionUpto() < this.points.length - 1) {
            DState dState2 = this.dStates[t.getSource()];
            Intrinsics.checkNotNull((Object)dState2);
            int[] nArray = dState2.getTransitions$core();
            Intrinsics.checkNotNull((Object)nArray);
            t.setTransitionUpto(t.getTransitionUpto() + 1);
            if (nArray[t.getTransitionUpto()] == MISSING) continue;
            ++outgoingTransitions;
        }
        if (!(outgoingTransitions == index)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setTransitionAccordingly(t);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.Companion.sizeOfObject(this.automaton) + RamUsageEstimator.Companion.sizeOfObject(this.points) + RamUsageEstimator.Companion.sizeOfMap(this.dStateToOrd) + RamUsageEstimator.Companion.sizeOfObject(this.dStates) + RamUsageEstimator.Companion.sizeOfObject(this.classmap);
    }

    @Override
    public boolean run(@NotNull byte[] s, int offset, int length) {
        return ByteRunnable.super.run(s, offset, length);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    public static final /* synthetic */ int access$findDState(NFARunAutomaton $this, DState dState) {
        return $this.findDState(dState);
    }

    public static final /* synthetic */ Operations.PointTransitionSet access$getTransitionSet$p(NFARunAutomaton $this) {
        return $this.transitionSet;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton$Companion;", "", "<init>", "()V", "MISSING", "", "NOT_COMPUTED", "BASE_RAM_BYTES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fJ\u0014\u0010\u001f\u001a\b\u0018\u00010\u0000R\u00020 2\u0006\u0010!\u001a\u00020\fJ\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dJ\b\u0010$\u001a\u00020\fH\u0016J\u0013\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\b\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton$DState;", "Lorg/gnit/lucenekmp/util/Accountable;", "nfaStates", "", "<init>", "(Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton;[I)V", "transitions", "getTransitions$core", "()[I", "setTransitions$core", "([I)V", "hash", "", "isAccept", "", "isAccept$core", "()Z", "stepTransition", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "minimalTransition", "computedTransitions", "outgoingTransitions", "getOutgoingTransitions$core", "()I", "setOutgoingTransitions$core", "(I)V", "nextState", "charClass", "assignTransition", "", "dest", "step", "Lorg/gnit/lucenekmp/util/automaton/NFARunAutomaton;", "c", "determinize", "initTransitions", "hashCode", "equals", "o", "", "ramBytesUsed", "", "core"})
    private final class DState
    implements Accountable {
        @NotNull
        private final int[] nfaStates;
        @Nullable
        private int[] transitions;
        private final int hash;
        private final boolean isAccept;
        @NotNull
        private final Transition stepTransition;
        @Nullable
        private Transition minimalTransition;
        private int computedTransitions;
        private int outgoingTransitions;

        public DState(int[] nfaStates) {
            Intrinsics.checkNotNullParameter((Object)nfaStates, (String)"nfaStates");
            this.stepTransition = new Transition();
            if (!(nfaStates.length > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.nfaStates = nfaStates;
            int hash = nfaStates.length;
            boolean isAccept = false;
            for (int s : nfaStates) {
                hash += BitMixer.INSTANCE.mix(s);
                if (!NFARunAutomaton.this.automaton.isAccept(s)) continue;
                isAccept = true;
            }
            this.isAccept = isAccept;
            this.hash = hash;
        }

        @Nullable
        public final int[] getTransitions$core() {
            return this.transitions;
        }

        public final void setTransitions$core(@Nullable int[] nArray) {
            this.transitions = nArray;
        }

        public final boolean isAccept$core() {
            return this.isAccept;
        }

        public final int getOutgoingTransitions$core() {
            return this.outgoingTransitions;
        }

        public final void setOutgoingTransitions$core(int n) {
            this.outgoingTransitions = n;
        }

        /*
         * Unable to fully structure code
         */
        public final int nextState(int charClass) {
            block9: {
                this.initTransitions();
                Intrinsics.checkNotNull((Object)this.transitions);
                if (!(charClass < this.transitions.length)) {
                    var3_2 = "Failed requirement.";
                    throw new IllegalArgumentException(var3_2.toString());
                }
                Intrinsics.checkNotNull((Object)this.transitions);
                if (this.transitions[charClass] != NFARunAutomaton.access$getNOT_COMPUTED$cp()) break block9;
                this.assignTransition(charClass, NFARunAutomaton.access$findDState(NFARunAutomaton.this, this.step(NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this)[charClass])));
                if (this.minimalTransition == null) break block9;
                cls = charClass;
                while (cls > 0) {
                    v0 = NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this)[--cls];
                    v1 = this.minimalTransition;
                    Intrinsics.checkNotNull((Object)v1);
                    if (v0 < v1.getMin()) break;
                    Intrinsics.checkNotNull((Object)this.transitions);
                    if (this.transitions[cls] == NFARunAutomaton.access$getNOT_COMPUTED$cp()) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)this.transitions);
                    v2 = this.transitions[cls];
                    Intrinsics.checkNotNull((Object)this.transitions);
                    if (v2 == this.transitions[charClass]) lbl-1000:
                    // 2 sources

                    {
                        v3 = true;
                    } else {
                        v3 = false;
                    }
                    if (!v3) {
                        var4_4 = "Failed requirement.";
                        throw new IllegalArgumentException(var4_4.toString());
                    }
                    Intrinsics.checkNotNull((Object)this.transitions);
                    this.assignTransition(cls, this.transitions[charClass]);
                }
                cls = charClass;
                while (cls < NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this).length - 1) {
                    v4 = NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this)[++cls];
                    v5 = this.minimalTransition;
                    Intrinsics.checkNotNull((Object)v5);
                    if (v4 > v5.getMax()) break;
                    Intrinsics.checkNotNull((Object)this.transitions);
                    if (this.transitions[cls] == NFARunAutomaton.access$getNOT_COMPUTED$cp()) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)this.transitions);
                    v6 = this.transitions[cls];
                    Intrinsics.checkNotNull((Object)this.transitions);
                    if (v6 == this.transitions[charClass]) lbl-1000:
                    // 2 sources

                    {
                        v7 = true;
                    } else {
                        v7 = false;
                    }
                    if (!v7) {
                        var4_5 = "Failed requirement.";
                        throw new IllegalArgumentException(var4_5.toString());
                    }
                    Intrinsics.checkNotNull((Object)this.transitions);
                    this.assignTransition(cls, this.transitions[charClass]);
                }
                this.minimalTransition = null;
            }
            Intrinsics.checkNotNull((Object)this.transitions);
            return this.transitions[charClass];
        }

        public final void assignTransition(int charClass, int dest) {
            Intrinsics.checkNotNull((Object)this.transitions);
            if (this.transitions[charClass] == NOT_COMPUTED) {
                int n = this.computedTransitions;
                this.computedTransitions = n + 1;
                Intrinsics.checkNotNull((Object)this.transitions);
                this.transitions[charClass] = dest;
                Intrinsics.checkNotNull((Object)this.transitions);
                if (this.transitions[charClass] != MISSING) {
                    n = this.outgoingTransitions;
                    this.outgoingTransitions = n + 1;
                }
            }
        }

        @Nullable
        public final DState step(int c) {
            NFARunAutomaton.this.statesSet.reset();
            int numTransitions = 0;
            int left = -1;
            int right = NFARunAutomaton.this.alphabetSize;
            block0: for (int nfaState : this.nfaStates) {
                numTransitions = NFARunAutomaton.this.automaton.initTransition(nfaState, this.stepTransition);
                int n = numTransitions;
                for (int i = 0; i < n; ++i) {
                    NFARunAutomaton.this.automaton.getNextTransition(this.stepTransition);
                    if (this.stepTransition.getMin() <= c && this.stepTransition.getMax() >= c) {
                        NFARunAutomaton.this.statesSet.incr(this.stepTransition.getDest());
                        left = Math.max(this.stepTransition.getMin(), left);
                        right = Math.min(this.stepTransition.getMax(), right);
                    }
                    if (this.stepTransition.getMax() < c) {
                        left = Math.max(this.stepTransition.getMax() + 1, left);
                    }
                    if (this.stepTransition.getMin() <= c) continue;
                    right = Math.min(this.stepTransition.getMin() - 1, right);
                    continue block0;
                }
            }
            if (NFARunAutomaton.this.statesSet.size() == 0) {
                return null;
            }
            Transition transition = this.minimalTransition = new Transition();
            Intrinsics.checkNotNull((Object)transition);
            transition.setMin(left);
            Transition transition2 = this.minimalTransition;
            Intrinsics.checkNotNull((Object)transition2);
            transition2.setMax(right);
            return new DState(NFARunAutomaton.this.statesSet.getArray());
        }

        /*
         * Unable to fully structure code
         */
        public final void determinize() {
            if (this.transitions != null) {
                Intrinsics.checkNotNull((Object)this.transitions);
                if (this.computedTransitions == this.transitions.length) {
                    return;
                }
            }
            this.initTransitions();
            NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).reset();
            for (int nfaState : this.nfaStates) {
                numTransitions = NFARunAutomaton.access$getAutomaton$p(NFARunAutomaton.this).initTransition(nfaState, this.stepTransition);
                for (i = 0; i < numTransitions; ++i) {
                    NFARunAutomaton.access$getAutomaton$p(NFARunAutomaton.this).getNextTransition(this.stepTransition);
                    NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).add(this.stepTransition);
                }
            }
            if (NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getCount() == 0) {
                Intrinsics.checkNotNull((Object)this.transitions);
                ArraysKt.fill$default((int[])this.transitions, (int)NFARunAutomaton.access$getMISSING$cp(), (int)0, (int)0, (int)6, null);
                Intrinsics.checkNotNull((Object)this.transitions);
                this.computedTransitions = this.transitions.length;
                return;
            }
            NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).sort();
            NFARunAutomaton.access$getStatesSet$p(NFARunAutomaton.this).reset();
            lastPoint = -1;
            charClass = 0;
            var4_5 = NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getCount();
            for (i = 0; i < var4_5; ++i) {
                block21: {
                    v0 = NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getPoints()[i];
                    Intrinsics.checkNotNull((Object)v0);
                    point = v0.getPoint();
                    if (NFARunAutomaton.access$getStatesSet$p(NFARunAutomaton.this).size() <= 0) break block21;
                    if (!(lastPoint != -1)) {
                        var7_15 = "Failed requirement.";
                        throw new IllegalArgumentException(var7_15.toString());
                    }
                    ord = NFARunAutomaton.access$findDState(NFARunAutomaton.this, new DState(NFARunAutomaton.access$getStatesSet$p(NFARunAutomaton.this).getArray()));
                    while (NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this)[charClass] < lastPoint) {
                        this.assignTransition(charClass++, NFARunAutomaton.access$getMISSING$cp());
                    }
                    if (!(NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this)[charClass] == lastPoint)) {
                        var8_17 = "Failed requirement.";
                        throw new IllegalArgumentException(var8_17.toString());
                    }
                    while (charClass < NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this).length && NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this)[charClass] < point) {
                        Intrinsics.checkNotNull((Object)this.transitions);
                        if (this.transitions[charClass] == NFARunAutomaton.access$getNOT_COMPUTED$cp()) ** GOTO lbl-1000
                        Intrinsics.checkNotNull((Object)this.transitions);
                        if (this.transitions[charClass] == ord) lbl-1000:
                        // 2 sources

                        {
                            v1 = true;
                        } else {
                            v1 = false;
                        }
                        if (!v1) {
                            var8_18 = "Failed requirement.";
                            throw new IllegalArgumentException(var8_18.toString());
                        }
                        this.assignTransition(charClass++, ord);
                    }
                    if (!(charClass == NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this).length && point == NFARunAutomaton.access$getAlphabetSize$p(NFARunAutomaton.this) || NFARunAutomaton.access$getPoints$p(NFARunAutomaton.this)[charClass] == point)) {
                        var8_19 = "Failed requirement.";
                        throw new IllegalArgumentException(var8_19.toString());
                    }
                }
                transitions = null;
                v2 = NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getPoints()[i];
                Intrinsics.checkNotNull((Object)v2);
                transitions = v2.getEnds().getTransitions();
                limit = 0;
                v3 = NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getPoints()[i];
                Intrinsics.checkNotNull((Object)v3);
                limit = v3.getEnds().getNext();
                var8_20 = this;
                var9_21 = NFARunAutomaton.this;
                $this$determinize_u24lambda_u240 = var8_20;
                $i$a$-run-NFARunAutomaton$DState$determinize$1 = false;
                for (j = 0; j < limit; j += 3) {
                    dest = transitions[j];
                    NFARunAutomaton.access$getStatesSet$p(var9_21).decr(dest);
                }
                v4 = NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getPoints()[i];
                Intrinsics.checkNotNull((Object)v4);
                v4.getEnds().setNext(0);
                v5 = NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getPoints()[i];
                Intrinsics.checkNotNull((Object)v5);
                transitions = v5.getStarts().getTransitions();
                v6 = NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getPoints()[i];
                Intrinsics.checkNotNull((Object)v6);
                limit = v6.getStarts().getNext();
                for (j = 0; j < limit; j += 3) {
                    dest = transitions[j];
                    NFARunAutomaton.access$getStatesSet$p(NFARunAutomaton.this).incr(dest);
                }
                lastPoint = point;
                v7 = NFARunAutomaton.access$getTransitionSet$p(NFARunAutomaton.this).getPoints()[i];
                Intrinsics.checkNotNull((Object)v7);
                v7.getStarts().setNext(0);
            }
            if (!(NFARunAutomaton.access$getStatesSet$p(NFARunAutomaton.this).size() == 0)) {
                var4_6 = "Failed requirement.";
                throw new IllegalArgumentException(var4_6.toString());
            }
            if (!(this.computedTransitions >= charClass)) {
                var4_7 = "Failed requirement.";
                throw new IllegalArgumentException(var4_7.toString());
            }
            Intrinsics.checkNotNull((Object)this.transitions);
            if (charClass == this.transitions.length) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)this.transitions);
            if (this.transitions[charClass] == NFARunAutomaton.access$getMISSING$cp()) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)this.transitions);
            if (this.transitions[charClass] == NFARunAutomaton.access$getNOT_COMPUTED$cp()) lbl-1000:
            // 3 sources

            {
                v8 = true;
            } else {
                v8 = false;
            }
            if (!v8) {
                var4_8 = "Failed requirement.";
                throw new IllegalArgumentException(var4_8.toString());
            }
            Intrinsics.checkNotNull((Object)this.transitions);
            v9 = NFARunAutomaton.access$getMISSING$cp();
            Intrinsics.checkNotNull((Object)this.transitions);
            ArraysKt.fill((int[])this.transitions, (int)v9, (int)charClass, (int)this.transitions.length);
            Intrinsics.checkNotNull((Object)this.transitions);
            this.computedTransitions = this.transitions.length;
        }

        public final void initTransitions() {
            if (this.transitions == null) {
                this.transitions = new int[NFARunAutomaton.this.points.length];
                Intrinsics.checkNotNull((Object)this.transitions);
                ArraysKt.fill$default((int[])this.transitions, (int)NOT_COMPUTED, (int)0, (int)0, (int)6, null);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DState)) {
                return false;
            }
            return this.hash == ((DState)o).hash && Arrays.equals(this.nfaStates, ((DState)o).nfaStates);
        }

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.Companion.alignObjectSize((long)13 + Transition.Companion.getBYTES_USED() * (long)2 + (long)8 + 16L) + RamUsageEstimator.Companion.sizeOfObject(this.nfaStates) + RamUsageEstimator.Companion.sizeOfObject(this.transitions);
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }
    }
}

