/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.IntCursor;
import org.gnit.lucenekmp.internal.hppc.IntHashSet;
import org.gnit.lucenekmp.internal.hppc.IntObjectHashMap;
import org.gnit.lucenekmp.jdkport.ArrayDequeExtKt;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.BitSet;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.ObjectsKt;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.IntsRefBuilder;
import org.gnit.lucenekmp.util.automaton.Automata;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.FrozenIntSet;
import org.gnit.lucenekmp.util.automaton.StatePair;
import org.gnit.lucenekmp.util.automaton.StateSet;
import org.gnit.lucenekmp.util.automaton.TooComplexToDeterminizeException;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003>?@B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0005J\u001e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0005J\u0016\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0007J\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0014\u0010\u001d\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eJ\u0016\u0010\u001f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0007J\u001e\u0010\"\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u0016\u0010%\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'J\u0016\u0010%\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010&\u001a\u00020(J\u0010\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u000e\u0010-\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010.\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u0018\u0010/\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u00103\u001a\u0002042\u0006\u0010\r\u001a\u00020\u0007J\u0010\u00105\u001a\u0004\u0018\u00010(2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u00106\u001a\u0002042\u0006\u0010\r\u001a\u00020\u0007J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u000204H\u0002J\u000e\u0010:\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010;\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010<\u001a\u0002012\u0006\u0010\r\u001a\u00020\u0007J\u0018\u0010<\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010=\u001a\u000201H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/gnit/lucenekmp/util/automaton/Operations;", "", "<init>", "()V", "DEFAULT_DETERMINIZE_WORK_LIMIT", "", "concatenate", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "a1", "a2", "list", "", "optional", "a", "repeat", "count", "min", "max", "toSet", "Lorg/gnit/lucenekmp/internal/hppc/IntHashSet;", "offset", "complement", "determinizeWorkLimit", "minus", "intersection", "hasDeadStates", "", "hasDeadStatesFromInitial", "hasDeadStatesToAccept", "union", "", "determinize", "workLimit", "isEmpty", "isTotal", "minAlphabet", "maxAlphabet", "run", "s", "", "Lorg/gnit/lucenekmp/util/IntsRef;", "getLiveStates", "Lorg/gnit/lucenekmp/jdkport/BitSet;", "getLiveStatesFromInitial", "getLiveStatesToAccept", "removeDeadStates", "mergeAcceptStatesWithNoTransition", "remap", "combinedStates", "", "getCommonPrefix", "getCommonPrefixBytesRef", "Lorg/gnit/lucenekmp/util/BytesRef;", "getSingleton", "getCommonSuffixBytesRef", "reverseBytes", "", "ref", "reverse", "totalize", "topoSortStates", "states", "TransitionList", "PointTransitions", "PointTransitionSet", "core"})
@SourceDebugExtension(value={"SMAP\nOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operations.kt\norg/gnit/lucenekmp/util/automaton/Operations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1474:1\n1#2:1475\n*E\n"})
public final class Operations {
    @NotNull
    public static final Operations INSTANCE = new Operations();
    public static final int DEFAULT_DETERMINIZE_WORK_LIMIT = 10000;

    private Operations() {
    }

    @Deprecated(message="use {@link #concatenate(List)} instead")
    @NotNull
    public final Automaton concatenate(@NotNull Automaton a1, @NotNull Automaton a2) {
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        Object[] objectArray = new Automaton[]{a1, a2};
        return this.concatenate(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    @NotNull
    public final Automaton concatenate(@NotNull List<Automaton> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Automaton result = new Automaton(0, 0, 3, null);
        for (Automaton a : list) {
            if (a.getNumStates() == 0) {
                return Automata.INSTANCE.makeEmpty();
            }
            int numStates = a.getNumStates();
            for (int s = 0; s < numStates; ++s) {
                result.createState();
            }
        }
        int stateOffset = 0;
        Transition t = new Transition();
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            Automaton a = list.get(i);
            int numStates = a.getNumStates();
            Automaton nextA = i == list.size() - 1 ? null : list.get(i + 1);
            block3: for (int s = 0; s < numStates; ++s) {
                int numTransitions = a.initTransition(s, t);
                int n2 = numTransitions;
                for (int j = 0; j < n2; ++j) {
                    a.getNextTransition(t);
                    result.addTransition(stateOffset + s, stateOffset + t.getDest(), t.getMin(), t.getMax());
                }
                if (!a.isAccept(s)) continue;
                Automaton followA = nextA;
                int followOffset = stateOffset;
                int upto = i + 1;
                while (followA != null) {
                    numTransitions = followA.initTransition(0, t);
                    int n3 = numTransitions;
                    for (int j = 0; j < n3; ++j) {
                        followA.getNextTransition(t);
                        result.addTransition(stateOffset + s, followOffset + numStates + t.getDest(), t.getMin(), t.getMax());
                    }
                    if (!followA.isAccept(0)) continue block3;
                    followOffset += followA.getNumStates();
                    followA = upto == list.size() - 1 ? null : list.get(upto + 1);
                    ++upto;
                }
                result.setAccept(stateOffset + s, true);
            }
            stateOffset += numStates;
        }
        if (result.getNumStates() == 0) {
            result.createState();
        }
        result.finishState();
        return this.removeDeadStates(result);
    }

    @NotNull
    public final Automaton optional(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (a.isAccept(0)) {
            return a;
        }
        boolean hasTransitionsToInitialState = false;
        Transition t = new Transition();
        int n = a.getNumStates();
        block0: for (int state2 = 0; state2 < n; ++state2) {
            int count = a.initTransition(state2, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (t.getDest() != 0) continue;
                hasTransitionsToInitialState = true;
                break block0;
            }
        }
        if (!hasTransitionsToInitialState) {
            Automaton result = new Automaton(0, 0, 3, null);
            result.copy(a);
            if (result.getNumStates() == 0) {
                result.createState();
            }
            result.setAccept(0, true);
            return result;
        }
        Automaton result = new Automaton(0, 0, 3, null);
        result.createState();
        result.setAccept(0, true);
        if (a.getNumStates() > 0) {
            result.copy(a);
            result.addEpsilon(0, 1);
        }
        result.finishState();
        return result;
    }

    @NotNull
    public final Automaton repeat(@NotNull Automaton a) {
        int src;
        int state2;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (a.getNumStates() == 0) {
            return a;
        }
        if (a.isAccept(0) && a.getAcceptStates().cardinality() == 1) {
            return a;
        }
        Automaton.Builder builder = new Automaton.Builder(0, 0, 3, null);
        builder.createState();
        builder.setAccept(0, true);
        Transition t = new Transition();
        int[] stateMap = new int[a.getNumStates()];
        int n = a.getNumStates();
        for (state2 = 0; state2 < n; ++state2) {
            int newState;
            if (!a.isAccept(state2)) {
                stateMap[state2] = builder.createState();
                continue;
            }
            if (a.getNumTransitions(state2) == 0) {
                stateMap[state2] = 0;
                continue;
            }
            stateMap[state2] = newState = builder.createState();
            builder.setAccept(newState, true);
        }
        n = a.getNumStates();
        for (state2 = 0; state2 < n; ++state2) {
            src = stateMap[state2];
            int count = a.initTransition(state2, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                int dest = stateMap[t.getDest()];
                builder.addTransition(src, dest, t.getMin(), t.getMax());
            }
        }
        int count = a.initTransition(0, t);
        src = count;
        for (int i = 0; i < src; ++i) {
            a.getNextTransition(t);
            builder.addTransition(0, stateMap[t.getDest()], t.getMin(), t.getMax());
        }
        int s = a.getAcceptStates().nextSetBit(0);
        while (s != -1) {
            if (stateMap[s] != 0) {
                count = a.initTransition(0, t);
                int n2 = count;
                for (int i = 0; i < n2; ++i) {
                    a.getNextTransition(t);
                    builder.addTransition(stateMap[s], stateMap[t.getDest()], t.getMin(), t.getMax());
                }
            }
            s = a.getAcceptStates().nextSetBit(s + 1);
        }
        return this.removeDeadStates(builder.finish());
    }

    @NotNull
    public final Automaton repeat(@NotNull Automaton a, int count) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        int count2 = count;
        if (count2 == 0) {
            return this.repeat(a);
        }
        List as = new ArrayList();
        while (count2-- > 0) {
            as.add(a);
        }
        as.add(this.repeat(a));
        return this.concatenate(as);
    }

    @NotNull
    public final Automaton repeat(@NotNull Automaton a, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (min > max) {
            return Automata.INSTANCE.makeEmpty();
        }
        Automaton b = null;
        switch (min) {
            case 0: {
                b = Automata.INSTANCE.makeEmptyString();
                break;
            }
            case 1: {
                b = new Automaton(0, 0, 3, null);
                b.copy(a);
                break;
            }
            default: {
                List as = new ArrayList();
                for (int i = 0; i < min; ++i) {
                    as.add(a);
                }
                b = this.concatenate(as);
            }
        }
        IntHashSet prevAcceptStates = this.toSet(b, 0);
        Automaton.Builder builder = new Automaton.Builder(0, 0, 3, null);
        builder.copy(b);
        for (int i = min; i < max; ++i) {
            int numStates = builder.getNumStates();
            builder.copy(a);
            Iterator<IntCursor> iterator2 = prevAcceptStates.iterator();
            while (iterator2.hasNext()) {
                IntCursor s;
                IntCursor intCursor = s = iterator2.next();
                Intrinsics.checkNotNull((Object)intCursor);
                builder.addEpsilon(intCursor.getValue(), numStates);
            }
            prevAcceptStates = this.toSet(a, numStates);
        }
        return this.removeDeadStates(builder.finish());
    }

    private final IntHashSet toSet(Automaton a, int offset) {
        int numStates = a.getNumStates();
        BitSet isAccept = a.getAcceptStates();
        IntHashSet result = new IntHashSet();
        int upto = 0;
        while (upto < numStates) {
            int n;
            int it = n = isAccept.nextSetBit(upto);
            boolean bl = false;
            upto = it;
            if (n == -1) break;
            result.add(offset + upto);
            n = upto;
            upto = n + 1;
        }
        return result;
    }

    @NotNull
    public final Automaton complement(@NotNull Automaton a, int determinizeWorkLimit) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Automaton a2 = a;
        a2 = this.totalize(this.determinize(a2, determinizeWorkLimit));
        int numStates = a2.getNumStates();
        for (int p = 0; p < numStates; ++p) {
            a2.setAccept(p, !a2.isAccept(p));
        }
        return this.removeDeadStates(a2);
    }

    @NotNull
    public final Automaton minus(@NotNull Automaton a1, @NotNull Automaton a2, int determinizeWorkLimit) {
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        if (this.isEmpty(a1) || Intrinsics.areEqual((Object)a1, (Object)a2)) {
            return Automata.INSTANCE.makeEmpty();
        }
        if (this.isEmpty(a2)) {
            return a1;
        }
        return this.intersection(a1, this.complement(a2, determinizeWorkLimit));
    }

    @NotNull
    public final Automaton intersection(@NotNull Automaton a1, @NotNull Automaton a2) {
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        if (Intrinsics.areEqual((Object)a1, (Object)a2)) {
            return a1;
        }
        if (a1.getNumStates() == 0) {
            return a1;
        }
        if (a2.getNumStates() == 0) {
            return a2;
        }
        Transition[][] transitions1 = a1.getSortedTransitions();
        Transition[][] transitions2 = a2.getSortedTransitions();
        Automaton c = new Automaton(0, 0, 3, null);
        c.createState();
        ArrayDeque worklist = new ArrayDeque();
        Map newstates = new LinkedHashMap();
        StatePair p = new StatePair(0, 0, 0);
        worklist.add((Object)p);
        newstates.put(p, p);
        while (!((Collection)worklist).isEmpty()) {
            p = (StatePair)worklist.removeFirst();
            c.setAccept(p.getS(), a1.isAccept(p.getS1()) && a2.isAccept(p.getS2()));
            Transition[] t1 = transitions1[p.getS1()];
            Transition[] t2 = transitions2[p.getS2()];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].getMax() < t1[n1].getMin()) {
                    ++b2;
                }
                for (int n2 = b2; n2 < t2.length && t1[n1].getMax() >= t2[n2].getMin(); ++n2) {
                    if (t2[n2].getMax() < t1[n1].getMin()) continue;
                    StatePair q = new StatePair(t1[n1].getDest(), t2[n2].getDest());
                    StatePair r = (StatePair)newstates.get(q);
                    if (r == null) {
                        q.setS(c.createState());
                        worklist.add((Object)q);
                        newstates.put(q, q);
                        r = q;
                    }
                    int min = t1[n1].getMin() > t2[n2].getMin() ? t1[n1].getMin() : t2[n2].getMin();
                    int max = t1[n1].getMax() < t2[n2].getMax() ? t1[n1].getMax() : t2[n2].getMax();
                    c.addTransition(p.getS(), r.getS(), min, max);
                }
            }
        }
        c.finishState();
        return this.removeDeadStates(c);
    }

    public final boolean hasDeadStates(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        BitSet liveStates = this.getLiveStates(a);
        int numLive = liveStates.cardinality();
        int numStates = a.getNumStates();
        if (!(numLive <= numStates)) {
            boolean bl = false;
            String string = "numLive=" + numLive + " numStates=" + numStates + " " + liveStates;
            throw new IllegalArgumentException(string.toString());
        }
        return numLive < numStates;
    }

    public final boolean hasDeadStatesFromInitial(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        BitSet reachableFromInitial = this.getLiveStatesFromInitial(a);
        BitSet reachableFromAccept = this.getLiveStatesToAccept(a);
        reachableFromInitial.andNot(reachableFromAccept);
        return !reachableFromInitial.isEmpty();
    }

    public final boolean hasDeadStatesToAccept(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        BitSet reachableFromInitial = this.getLiveStatesFromInitial(a);
        BitSet reachableFromAccept = this.getLiveStatesToAccept(a);
        reachableFromAccept.andNot(reachableFromInitial);
        return !reachableFromAccept.isEmpty();
    }

    @Deprecated(message="use {@link #union(Collection)} instead")
    @NotNull
    public final Automaton union(@NotNull Automaton a1, @NotNull Automaton a2) {
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        Object[] objectArray = new Automaton[]{a1, a2};
        return this.union(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    @NotNull
    public final Automaton union(@NotNull Collection<Automaton> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Automaton result = new Automaton(0, 0, 3, null);
        result.createState();
        for (Automaton a : list) {
            result.copy(a);
        }
        int stateOffset = 1;
        for (Automaton a : list) {
            if (a.getNumStates() == 0) continue;
            result.addEpsilon(0, stateOffset);
            stateOffset += a.getNumStates();
        }
        result.finishState();
        return this.mergeAcceptStatesWithNoTransition(this.removeDeadStates(result));
    }

    @NotNull
    public final Automaton determinize(@NotNull Automaton a, int workLimit) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (a.isDeterministic()) {
            return a;
        }
        if (a.getNumStates() <= 1) {
            return a;
        }
        Automaton.Builder b = new Automaton.Builder(0, 0, 3, null);
        int[] nArray = new int[]{0};
        FrozenIntSet initialset = new FrozenIntSet(nArray, BitMixer.INSTANCE.mix(0) + 1, 0);
        b.createState();
        ArrayDeque worklist = new ArrayDeque();
        Map newstate = new LinkedHashMap();
        worklist.add((Object)initialset);
        b.setAccept(0, a.isAccept(0));
        newstate.put(initialset, 0);
        PointTransitionSet points2 = new PointTransitionSet();
        StateSet statesSet = new StateSet(5);
        Transition t = new Transition();
        long effortSpent = 0L;
        long effortLimit = (long)workLimit * 10L;
        while (!((Collection)worklist).isEmpty()) {
            int j;
            FrozenIntSet s = (FrozenIntSet)worklist.removeFirst();
            if ((effortSpent += (long)s.getValues().length) >= effortLimit) {
                throw new TooComplexToDeterminizeException(a, workLimit);
            }
            int n = s.getValues().length;
            for (int i = 0; i < n; ++i) {
                int s0 = s.getValues()[i];
                int numTransitions = a.getNumTransitions(s0);
                a.initTransition(s0, t);
                for (j = 0; j < numTransitions; ++j) {
                    a.getNextTransition(t);
                    points2.add(t);
                }
            }
            if (points2.getCount() == 0) continue;
            points2.sort();
            int lastPoint = -1;
            int accCount = 0;
            int r = s.getState();
            j = points2.getCount();
            for (int i = 0; i < j; ++i) {
                PointTransitions pointTransitions = points2.getPoints()[i];
                Intrinsics.checkNotNull((Object)pointTransitions);
                int point = pointTransitions.getPoint();
                if (statesSet.size() > 0) {
                    if (!(lastPoint != -1)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    Integer q = null;
                    q = (Integer)newstate.get(statesSet);
                    if (q == null) {
                        q = b.createState();
                        FrozenIntSet p = statesSet.freeze(((Number)q).intValue());
                        worklist.add((Object)p);
                        b.setAccept(((Number)q).intValue(), accCount > 0);
                        newstate.put(p, q);
                    } else if (!(accCount > 0 == b.isAccept(((Number)q).intValue()))) {
                        boolean $i$a$-require-Operations$determinize$22 = false;
                        String $i$a$-require-Operations$determinize$22 = "accCount=" + accCount + " vs existing accept=" + b.isAccept(((Number)q).intValue()) + " states=" + statesSet;
                        throw new IllegalArgumentException($i$a$-require-Operations$determinize$22.toString());
                    }
                    b.addTransition(r, ((Number)q).intValue(), lastPoint, point - 1);
                }
                int[] transitions = null;
                PointTransitions pointTransitions2 = points2.getPoints()[i];
                Intrinsics.checkNotNull((Object)pointTransitions2);
                transitions = pointTransitions2.getEnds().getTransitions();
                int limit = 0;
                PointTransitions pointTransitions3 = points2.getPoints()[i];
                Intrinsics.checkNotNull((Object)pointTransitions3);
                limit = pointTransitions3.getEnds().getNext();
                Operations $this$determinize_u24lambda_u243 = this;
                boolean bl = false;
                for (int j2 = 0; j2 < limit; j2 += 3) {
                    int dest = transitions[j2];
                    statesSet.decr(dest);
                    accCount -= a.isAccept(dest) ? 1 : 0;
                }
                PointTransitions pointTransitions4 = points2.getPoints()[i];
                Intrinsics.checkNotNull((Object)pointTransitions4);
                pointTransitions4.getEnds().setNext(0);
                PointTransitions pointTransitions5 = points2.getPoints()[i];
                Intrinsics.checkNotNull((Object)pointTransitions5);
                transitions = pointTransitions5.getStarts().getTransitions();
                PointTransitions pointTransitions6 = points2.getPoints()[i];
                Intrinsics.checkNotNull((Object)pointTransitions6);
                limit = pointTransitions6.getStarts().getNext();
                for (int j3 = 0; j3 < limit; j3 += 3) {
                    int dest = transitions[j3];
                    statesSet.incr(dest);
                    accCount += a.isAccept(dest) ? 1 : 0;
                }
                lastPoint = point;
                PointTransitions pointTransitions7 = points2.getPoints()[i];
                Intrinsics.checkNotNull((Object)pointTransitions7);
                pointTransitions7.getStarts().setNext(0);
            }
            points2.reset();
            if (statesSet.size() == 0) continue;
            boolean bl = false;
            String string = "size=" + statesSet.size();
            throw new IllegalArgumentException(string.toString());
        }
        Automaton result = b.finish();
        if (!result.isDeterministic()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return result;
    }

    public final boolean isEmpty(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (a.getNumStates() == 0) {
            return true;
        }
        if (!a.isAccept(0) && a.getNumTransitions(0) == 0) {
            return true;
        }
        if (a.isAccept(0)) {
            return false;
        }
        ArrayDeque workList = new ArrayDeque();
        BitSet seen = new BitSet(a.getNumStates());
        workList.add((Object)0);
        seen.set(0);
        Transition t = new Transition();
        while (!workList.isEmpty()) {
            Object object = workList.removeFirst();
            Intrinsics.checkNotNull((Object)object);
            int state2 = ((Number)object).intValue();
            if (a.isAccept(state2)) {
                return false;
            }
            int count = a.initTransition(state2, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (seen.get(t.getDest())) continue;
                workList.add((Object)t.getDest());
                seen.set(t.getDest());
            }
        }
        return true;
    }

    public final boolean isTotal(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return this.isTotal(a, 0, 0x10FFFF);
    }

    public final boolean isTotal(@NotNull Automaton a, int minAlphabet, int maxAlphabet) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        BitSet states = this.getLiveStates(a);
        Transition spare = new Transition();
        int seenStates = 0;
        int state2 = states.nextSetBit(0);
        while (state2 >= 0) {
            if (!a.isAccept(state2)) {
                return false;
            }
            int previousLabel = minAlphabet - 1;
            int n = a.getNumTransitions(state2);
            for (int transition = 0; transition < n; ++transition) {
                a.getTransition(state2, transition, spare);
                if (spare.getMin() > previousLabel + 1) {
                    return false;
                }
                previousLabel = spare.getMax();
            }
            if (previousLabel < maxAlphabet) {
                return false;
            }
            if (state2 == Integer.MAX_VALUE) break;
            ++seenStates;
            state2 = states.nextSetBit(state2 + 1);
        }
        return seenStates > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean run(@NotNull Automaton a, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (!a.isDeterministic()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int state2 = 0;
        int cp = 0;
        for (int i = 0; i < s.length(); i += Character.Companion.charCount(cp)) {
            void it;
            int n;
            int n2 = n = ObjectsKt.codePointAt(s, i);
            int n3 = state2;
            Automaton automaton = a;
            boolean bl = false;
            cp = it;
            Unit unit = Unit.INSTANCE;
            int nextState = automaton.step(n3, n);
            if (nextState == -1) {
                return false;
            }
            state2 = nextState;
        }
        return a.isAccept(state2);
    }

    public final boolean run(@NotNull Automaton a, @NotNull IntsRef s) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (!a.isDeterministic()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int state2 = 0;
        int n = s.getLength();
        for (int i = 0; i < n; ++i) {
            int nextState = a.step(state2, s.getInts()[s.getOffset() + i]);
            if (nextState == -1) {
                return false;
            }
            state2 = nextState;
        }
        return a.isAccept(state2);
    }

    private final BitSet getLiveStates(Automaton a) {
        BitSet live = this.getLiveStatesFromInitial(a);
        live.and(this.getLiveStatesToAccept(a));
        return live;
    }

    private final BitSet getLiveStatesFromInitial(Automaton a) {
        int numStates = a.getNumStates();
        BitSet live = new BitSet(numStates);
        if (numStates == 0) {
            return live;
        }
        ArrayDeque workList = new ArrayDeque();
        live.set(0);
        workList.add((Object)0);
        Transition t = new Transition();
        while (!workList.isEmpty()) {
            Object object = workList.removeFirst();
            Intrinsics.checkNotNull((Object)object);
            int s = ((Number)object).intValue();
            int count = a.initTransition(s, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (live.get(t.getDest())) continue;
                live.set(t.getDest());
                workList.add((Object)t.getDest());
            }
        }
        return live;
    }

    private final BitSet getLiveStatesToAccept(Automaton a) {
        int s;
        Automaton.Builder builder = new Automaton.Builder(0, 0, 3, null);
        Transition t = new Transition();
        int numStates = a.getNumStates();
        for (s = 0; s < numStates; ++s) {
            builder.createState();
        }
        for (s = 0; s < numStates; ++s) {
            int count = a.initTransition(s, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                builder.addTransition(t.getDest(), s, t.getMin(), t.getMax());
            }
        }
        Automaton a2 = builder.finish();
        ArrayDeque workList = new ArrayDeque();
        BitSet live = new BitSet(numStates);
        BitSet acceptBits = a.getAcceptStates();
        int s2 = 0;
        while (s2 < numStates) {
            int n;
            int it = n = acceptBits.nextSetBit(s2);
            boolean bl = false;
            s2 = it;
            if (n == -1) break;
            live.set(s2);
            workList.add((Object)s2);
            n = s2;
            s2 = n + 1;
        }
        while (!workList.isEmpty()) {
            Object object = workList.removeFirst();
            Intrinsics.checkNotNull((Object)object);
            s2 = ((Number)object).intValue();
            int count = a2.initTransition(s2, t);
            for (int i = 0; i < count; ++i) {
                a2.getNextTransition(t);
                if (live.get(t.getDest())) continue;
                live.set(t.getDest());
                workList.add((Object)t.getDest());
            }
        }
        return live;
    }

    @NotNull
    public final Automaton removeDeadStates(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        int numStates = a.getNumStates();
        BitSet liveSet = this.getLiveStates(a);
        if (liveSet.cardinality() == numStates) {
            return a;
        }
        int[] map2 = new int[numStates];
        Automaton result = new Automaton(0, 0, 3, null);
        for (int i = 0; i < numStates; ++i) {
            if (!liveSet.get(i)) continue;
            map2[i] = result.createState();
            result.setAccept(map2[i], a.isAccept(i));
        }
        Transition t = new Transition();
        for (int i = 0; i < numStates; ++i) {
            if (!liveSet.get(i)) continue;
            int numTransitions = a.initTransition(i, t);
            for (int j = 0; j < numTransitions; ++j) {
                a.getNextTransition(t);
                if (!liveSet.get(t.getDest())) continue;
                result.addTransition(map2[i], map2[t.getDest()], t.getMin(), t.getMax());
            }
        }
        result.finishState();
        if (!(!this.hasDeadStates(result))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return result;
    }

    @NotNull
    public final Automaton mergeAcceptStatesWithNoTransition(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        int numStates = a.getNumStates();
        int numAcceptStatesWithNoTransition = 0;
        int[] acceptStatesWithNoTransition = new int[]{};
        BitSet acceptStates = a.getAcceptStates();
        for (int i = 0; i < numStates; ++i) {
            if (!acceptStates.get(i) || a.getNumTransitions(i) != 0) continue;
            acceptStatesWithNoTransition = ArrayUtil.Companion.grow(acceptStatesWithNoTransition, 1 + numAcceptStatesWithNoTransition);
            acceptStatesWithNoTransition[numAcceptStatesWithNoTransition++] = i;
        }
        if (numAcceptStatesWithNoTransition <= 1) {
            return a;
        }
        acceptStatesWithNoTransition = ArrayUtil.Companion.copyOfSubArray(acceptStatesWithNoTransition, 0, numAcceptStatesWithNoTransition);
        Automaton result = new Automaton(0, 0, 3, null);
        for (int s = 0; s < numStates; ++s) {
            int remappedS = this.remap(s, acceptStatesWithNoTransition);
            while (result.getNumStates() <= remappedS) {
                result.createState();
            }
            if (!acceptStates.get(s)) continue;
            result.setAccept(remappedS, true);
        }
        Transition t = new Transition();
        for (int s = 0; s < numStates; ++s) {
            int remappedSource = this.remap(s, acceptStatesWithNoTransition);
            int numTransitions = a.initTransition(s, t);
            for (int j = 0; j < numTransitions; ++j) {
                a.getNextTransition(t);
                int remappedDest = this.remap(t.getDest(), acceptStatesWithNoTransition);
                result.addTransition(remappedSource, remappedDest, t.getMin(), t.getMax());
            }
        }
        result.finishState();
        return result;
    }

    private final int remap(int s, int[] combinedStates) {
        int idx = Arrays.INSTANCE.binarySearch(combinedStates, s);
        if (idx >= 0) {
            return combinedStates[0];
        }
        if ((idx = -1 - idx) <= 1) {
            return s;
        }
        return s - (idx - 1);
    }

    @NotNull
    public final String getCommonPrefix(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (!(!this.hasDeadStatesFromInitial(a))) {
            boolean $i$a$-require-Operations$getCommonPrefix$32 = false;
            String $i$a$-require-Operations$getCommonPrefix$32 = "input automaton has dead states";
            throw new IllegalArgumentException($i$a$-require-Operations$getCommonPrefix$32.toString());
        }
        if (this.isEmpty(a)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Transition scratch = new Transition();
        FixedBitSet visited = new FixedBitSet(a.getNumStates());
        FixedBitSet current = new FixedBitSet(a.getNumStates());
        FixedBitSet next = new FixedBitSet(a.getNumStates());
        current.set(0);
        block0: while (true) {
            int label = -1;
            int state2 = current.nextSetBit(0);
            while (state2 != Integer.MAX_VALUE) {
                visited.set(state2);
                if (a.isAccept(state2)) break block0;
                int n = a.getNumTransitions(state2);
                for (int transition = 0; transition < n; ++transition) {
                    a.getTransition(state2, transition, scratch);
                    if (label == -1) {
                        label = scratch.getMin();
                    }
                    if (scratch.getMin() != scratch.getMax() || scratch.getMin() != label) break block0;
                    next.set(scratch.getDest());
                }
                state2 = state2 + 1 >= current.length() ? Integer.MAX_VALUE : current.nextSetBit(state2 + 1);
            }
            if (!(label != -1)) {
                boolean bl = false;
                String string = "we should not get here since we checked no dead-end states up front!?";
                throw new IllegalArgumentException(string.toString());
            }
            builder.appendCodePoint(label);
            FixedBitSet tmp = current;
            current = next;
            next = tmp;
            next.clear();
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final BytesRef getCommonPrefixBytesRef(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        String prefix = this.getCommonPrefix(a);
        BytesRefBuilder builder = new BytesRefBuilder();
        int n = prefix.length();
        for (int i = 0; i < n; ++i) {
            char ch = prefix.charAt(i);
            if (!(ch <= '\u00ff')) {
                boolean bl = false;
                String string = "automaton is not binary";
                throw new IllegalStateException(string.toString());
            }
            builder.append((byte)ch);
        }
        return builder.get();
    }

    @Nullable
    public final IntsRef getSingleton(@NotNull Automaton a) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (!a.isDeterministic()) {
                boolean $i$a$-require-Operations$getSingleton$22 = false;
                String $i$a$-require-Operations$getSingleton$22 = "input automaton must be deterministic";
                throw new IllegalArgumentException($i$a$-require-Operations$getSingleton$22.toString());
            }
            IntsRefBuilder builder = new IntsRefBuilder();
            IntHashSet visited = new IntHashSet();
            int s = 0;
            Transition t = new Transition();
            while (true) {
                visited.add(s);
                if (a.isAccept(s)) break;
                if (a.getNumTransitions(s) == 1) {
                    a.getTransition(s, 0, t);
                    if (t.getMin() == t.getMax() && !visited.contains(t.getDest())) {
                        builder.append(t.getMin());
                        s = t.getDest();
                        continue;
                    }
                }
                break block5;
                break;
            }
            if (a.getNumTransitions(s) == 0) {
                return builder.get();
            }
        }
        return null;
    }

    @NotNull
    public final BytesRef getCommonSuffixBytesRef(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Automaton r = this.reverse(a);
        BytesRef ref = this.getCommonPrefixBytesRef(r);
        this.reverseBytes(ref);
        return ref;
    }

    private final void reverseBytes(BytesRef ref) {
        if (ref.getLength() <= 1) {
            return;
        }
        int num = ref.getLength() >> 1;
        int n = ref.getOffset() + num;
        for (int i = ref.getOffset(); i < n; ++i) {
            byte b = ref.getBytes()[i];
            ref.getBytes()[i] = ref.getBytes()[ref.getOffset() * 2 + ref.getLength() - i - 1];
            ref.getBytes()[ref.getOffset() * 2 + ref.getLength() - i - 1] = b;
        }
    }

    @NotNull
    public final Automaton reverse(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (this.isEmpty(a)) {
            return new Automaton(0, 0, 3, null);
        }
        int numStates = a.getNumStates();
        Automaton.Builder builder = new Automaton.Builder(0, 0, 3, null);
        builder.createState();
        for (int s = 0; s < numStates; ++s) {
            builder.createState();
        }
        builder.setAccept(1, true);
        Transition t = new Transition();
        for (int s = 0; s < numStates; ++s) {
            int numTransitions = a.getNumTransitions(s);
            a.initTransition(s, t);
            for (int i = 0; i < numTransitions; ++i) {
                a.getNextTransition(t);
                builder.addTransition(t.getDest() + 1, s + 1, t.getMin(), t.getMax());
            }
        }
        Automaton result = builder.finish();
        int s = 0;
        BitSet acceptStates = a.getAcceptStates();
        while (s < numStates) {
            int n;
            int it = n = acceptStates.nextSetBit(s);
            boolean bl = false;
            s = it;
            if (n == -1) break;
            result.addEpsilon(0, s + 1);
            n = s;
            s = n + 1;
        }
        result.finishState();
        return this.removeDeadStates(result);
    }

    @NotNull
    public final Automaton totalize(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Automaton result = new Automaton(0, 0, 3, null);
        int numStates = a.getNumStates();
        for (int i = 0; i < numStates; ++i) {
            result.createState();
            result.setAccept(i, a.isAccept(i));
        }
        int deadState = result.createState();
        result.addTransition(deadState, deadState, 0, 0x10FFFF);
        Transition t = new Transition();
        for (int i = 0; i < numStates; ++i) {
            int maxi = 0;
            int count = a.initTransition(i, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                result.addTransition(i, t.getDest(), t.getMin(), t.getMax());
                if (t.getMin() > maxi) {
                    result.addTransition(i, deadState, maxi, t.getMin() - 1);
                }
                if (t.getMax() + 1 <= maxi) continue;
                maxi = t.getMax() + 1;
            }
            if (maxi > 0x10FFFF) continue;
            result.addTransition(i, deadState, maxi, 0x10FFFF);
        }
        result.finishState();
        return result;
    }

    @NotNull
    public final int[] topoSortStates(@NotNull Automaton a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (a.getNumStates() == 0) {
            return new int[0];
        }
        int numStates = a.getNumStates();
        int[] states = new int[numStates];
        int upto = this.topoSortStates(a, states);
        if (upto < states.length) {
            int[] newStates = new int[upto];
            ArraysKt.copyInto((int[])states, (int[])newStates, (int)0, (int)0, (int)upto);
            states = newStates;
        }
        int n = states.length / 2;
        for (int i = 0; i < n; ++i) {
            int s = states[i];
            states[i] = states[states.length - 1 - i];
            states[states.length - 1 - i] = s;
        }
        return states;
    }

    private final int topoSortStates(Automaton a, int[] states) {
        BitSet onStack = new BitSet(a.getNumStates());
        BitSet visited = new BitSet(a.getNumStates());
        ArrayDeque stack = new ArrayDeque();
        ArrayDequeExtKt.push(stack, 0);
        int upto = 0;
        Transition t = new Transition();
        while (!stack.isEmpty()) {
            Object e = ArrayDequeExtKt.peek(stack);
            Intrinsics.checkNotNull(e);
            int state2 = ((Number)e).intValue();
            int count = a.initTransition(state2, t);
            boolean pushed = false;
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (!visited.get(t.getDest())) {
                    visited.set(t.getDest());
                    ArrayDequeExtKt.push(stack, t.getDest());
                    onStack.set(state2);
                    pushed = true;
                    break;
                }
                if (!onStack.get(t.getDest())) continue;
                boolean bl = false;
                String string = "Input automaton has a cycle.";
                throw new IllegalArgumentException(string.toString());
            }
            if (pushed) continue;
            onStack.clear(state2);
            ArrayDequeExtKt.pop(stack);
            states[upto] = state2;
            ++upto;
        }
        return upto;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/util/automaton/Operations$PointTransitionSet;", "", "<init>", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "points", "", "Lorg/gnit/lucenekmp/util/automaton/Operations$PointTransitions;", "getPoints", "()[Lorg/gnit/lucenekmp/util/automaton/Operations$PointTransitions;", "setPoints", "([Lorg/gnit/lucenekmp/util/automaton/Operations$PointTransitions;)V", "[Lorg/gnit/lucenekmp/util/automaton/Operations$PointTransitions;", "map", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "useHash", "", "next", "point", "find", "reset", "", "sort", "add", "t", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "toString", "", "Companion", "core"})
    public static final class PointTransitionSet {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int count;
        @NotNull
        private PointTransitions[] points = new PointTransitions[5];
        @NotNull
        private final IntObjectHashMap<PointTransitions> map = new IntObjectHashMap();
        private boolean useHash;
        private static final int HASHMAP_CUTOVER = 30;

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @NotNull
        public final PointTransitions[] getPoints() {
            return this.points;
        }

        public final void setPoints(@NotNull PointTransitions[] pointTransitionsArray) {
            Intrinsics.checkNotNullParameter((Object)pointTransitionsArray, (String)"<set-?>");
            this.points = pointTransitionsArray;
        }

        private final PointTransitions next(int point) {
            PointTransitions points0;
            if (this.count == this.points.length) {
                Object[] newArray = new PointTransitions[ArrayUtil.Companion.oversize(1 + this.count, 4)];
                ArraysKt.copyInto((Object[])this.points, (Object[])newArray, (int)0, (int)0, (int)this.count);
                this.points = newArray;
            }
            if ((points0 = this.points[this.count]) == null) {
                this.points[this.count] = new PointTransitions();
                points0 = this.points[this.count];
            }
            PointTransitions pointTransitions = points0;
            Intrinsics.checkNotNull((Object)pointTransitions);
            pointTransitions.reset(point);
            int n = this.count;
            this.count = n + 1;
            return points0;
        }

        private final PointTransitions find(int point) {
            if (this.useHash) {
                int pi = point;
                PointTransitions p = this.map.get(pi);
                if (p == null) {
                    p = this.next(point);
                    this.map.put(pi, p);
                }
                return p;
            }
            int p = this.count;
            for (int i = 0; i < p; ++i) {
                PointTransitions pointTransitions = this.points[i];
                Intrinsics.checkNotNull((Object)pointTransitions);
                if (pointTransitions.getPoint() != point) continue;
                return this.points[i];
            }
            PointTransitions p2 = this.next(point);
            if (this.count == 30) {
                if (!(this.map.size() == 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int n = this.count;
                for (int i = 0; i < n; ++i) {
                    PointTransitions pointTransitions = this.points[i];
                    Intrinsics.checkNotNull((Object)pointTransitions);
                    this.map.put(pointTransitions.getPoint(), this.points[i]);
                }
                this.useHash = true;
            }
            return p2;
        }

        public final void reset() {
            if (this.useHash) {
                this.map.clear();
                this.useHash = false;
            }
            this.count = 0;
        }

        public final void sort() {
            if (this.count > 1) {
                ArrayUtil.Companion.timSort(this.points, 0, this.count);
            }
        }

        public final void add(@NotNull Transition t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            PointTransitions pointTransitions = this.find(t.getMin());
            Intrinsics.checkNotNull((Object)pointTransitions);
            pointTransitions.getStarts().add(t);
            PointTransitions pointTransitions2 = this.find(1 + t.getMax());
            Intrinsics.checkNotNull((Object)pointTransitions2);
            pointTransitions2.getEnds().add(t);
        }

        @NotNull
        public String toString() {
            StringBuilder s = new StringBuilder();
            int n = this.count;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    s.append(' ');
                }
                PointTransitions pointTransitions = this.points[i];
                Intrinsics.checkNotNull((Object)pointTransitions);
                StringBuilder stringBuilder = s.append(pointTransitions.getPoint()).append(':');
                PointTransitions pointTransitions2 = this.points[i];
                Intrinsics.checkNotNull((Object)pointTransitions2);
                StringBuilder stringBuilder2 = stringBuilder.append(pointTransitions2.getStarts().getNext() / 3).append(',');
                PointTransitions pointTransitions3 = this.points[i];
                Intrinsics.checkNotNull((Object)pointTransitions3);
                stringBuilder2.append(pointTransitions3.getEnds().getNext() / 3);
            }
            String string = s.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/automaton/Operations$PointTransitionSet$Companion;", "", "<init>", "()V", "HASHMAP_CUTOVER", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/util/automaton/Operations$PointTransitions;", "", "<init>", "()V", "point", "", "getPoint", "()I", "setPoint", "(I)V", "ends", "Lorg/gnit/lucenekmp/util/automaton/Operations$TransitionList;", "getEnds", "()Lorg/gnit/lucenekmp/util/automaton/Operations$TransitionList;", "starts", "getStarts", "compareTo", "other", "reset", "", "equals", "", "", "hashCode", "core"})
    public static final class PointTransitions
    implements Comparable<PointTransitions> {
        private int point;
        @NotNull
        private final TransitionList ends = new TransitionList();
        @NotNull
        private final TransitionList starts = new TransitionList();

        public final int getPoint() {
            return this.point;
        }

        public final void setPoint(int n) {
            this.point = n;
        }

        @NotNull
        public final TransitionList getEnds() {
            return this.ends;
        }

        @NotNull
        public final TransitionList getStarts() {
            return this.starts;
        }

        @Override
        public int compareTo(@NotNull PointTransitions other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.point - other.point;
        }

        public final void reset(int point) {
            this.point = point;
            this.ends.setNext(0);
            this.starts.setNext(0);
        }

        public boolean equals(@Nullable Object other) {
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.automaton.Operations.PointTransitions");
            return ((PointTransitions)other).point == this.point;
        }

        public int hashCode() {
            return this.point;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/util/automaton/Operations$TransitionList;", "", "<init>", "()V", "transitions", "", "getTransitions", "()[I", "setTransitions", "([I)V", "next", "", "getNext", "()I", "setNext", "(I)V", "add", "", "t", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "core"})
    public static final class TransitionList {
        @NotNull
        private int[] transitions = new int[3];
        private int next;

        @NotNull
        public final int[] getTransitions() {
            return this.transitions;
        }

        public final void setTransitions(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.transitions = nArray;
        }

        public final int getNext() {
            return this.next;
        }

        public final void setNext(int n) {
            this.next = n;
        }

        public final void add(@NotNull Transition t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (this.transitions.length < this.next + 3) {
                this.transitions = ArrayUtil.Companion.grow(this.transitions, this.next + 3);
            }
            this.transitions[this.next] = t.getDest();
            this.transitions[this.next + 1] = t.getMin();
            this.transitions[this.next + 2] = t.getMax();
            this.next += 3;
        }
    }
}

